<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;

/**
 * Script file of ui/Theme-Builder Lite Component
 *
 * @since  0.0.1
 */
class Com_UiThemeBuilderLiteInstallerScript
{
	/**
	 * Minimum Joomla version to check
	 *
	 * @var    string
	 * @since  1.0.0
	 */
	private string $minimumJoomlaVersion = '5.0';

	/**
	 * Minimum PHP version to check
	 *
	 * @var    string
	 * @since  1.0.0
	 */
	private string $minimumPHPVersion = JOOMLA_MINIMUM_PHP;

	/**
	 * Method to install the extension
	 *
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 *
	 * @since  1.0.0
	 */
	public function install($parent): bool
	{
		// echo Text::_('COM_UITHEMEBUILDERLITE_INSTALLERSCRIPT_INSTALL');
		return true;
	}

	/**
	 * Method to uninstall the extension
	 *
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 *
	 * @since  1.0.0
	 */
	public function uninstall(InstallerAdapter $parent): bool
	{
		// echo Text::_('COM_UITHEMEBUILDERLITE_INSTALLERSCRIPT_UNINSTALL');
		return true;
	}

	/**
	 * Method to update the extension
	 *
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 *
	 * @since  1.0.0
	 *
	 */
	public function update(InstallerAdapter $parent): bool
	{
		// echo Text::_('COM_UITHEMEBUILDERLITE_INSTALLERSCRIPT_UPDATE');

		return true;
	}

	/**
	 * Function called before extension installation/update/removal procedure commences
	 *
	 * @param   string            $type    The type of change (install, update or discover_install, not uninstall)
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 *
	 * @throws Exception
	 *
	 * @since  1.0.0
	 *
	 */
	public function preflight(string $type, InstallerAdapter $parent): bool
	{
		if ($type !== 'uninstall')
		{
			// Check for the minimum PHP version before continuing
			if (!empty($this->minimumPHPVersion) && version_compare(PHP_VERSION, $this->minimumPHPVersion, '<'))
			{
				Log::add(
					Text::sprintf('JLIB_INSTALLER_MINIMUM_PHP', $this->minimumPHPVersion),
					Log::WARNING,
					'jerror'
				);

				return false;
			}

			// Check for the minimum Joomla version before continuing
			if (!empty($this->minimumJoomlaVersion) && version_compare(JVERSION, $this->minimumJoomlaVersion, '<'))
			{
				Log::add(
					Text::sprintf('JLIB_INSTALLER_MINIMUM_JOOMLA', $this->minimumJoomlaVersion),
					Log::WARNING,
					'jerror'
				);

				return false;
			}
		}
		else
		{
			$js_files = glob(JPATH_ROOT . '/media/com_uithemebuilderlite/js/*'); //get all js files
			foreach ($js_files as $file)
			{
				if (is_file($file))
					File::delete($file); //delete file
			}

			$css_files = glob(JPATH_ROOT . '/media/com_uithemebuilderlite/css/*'); //get all css files
			foreach ($css_files as $file)
			{
				if (is_file($file))
					File::delete($file); //delete file
			}

			$export_files = glob(JPATH_ROOT . '/administrator/components/com_uithemebuilderlite/exports/*'); //get all old export files
			foreach ($export_files as $file)
			{
				if (is_file($file))
					File::delete($file); //delete file
			}

			return true;
		}

		// echo Text::_('COM_UITHEMEBUILDERLITE_INSTALLERSCRIPT_PREFLIGHT');

		return true;
	}

	/**
	 * Function called after extension installation/update/removal procedure commences
	 *
	 * @param   string            $type    The type of change (install, update or discover_install, not uninstall)
	 * @param   InstallerAdapter  $parent  The class calling this method
	 *
	 * @return  boolean  True on success
	 *
	 * @since  1.0.0
	 *
	 */
	public function postflight(string $type, InstallerAdapter $parent): bool
	{
		// echo Text::_('COM_UITHEMEBUILDERLITE_INSTALLERSCRIPT_POSTFLIGHT');
		switch ($type) {
			case 'update':
				self::removeCacheFolder(false);
				break;
			case 'install':  // runs after installation is complete
				// self::check();
				break;
		}

		return true;
	}


	/**
	* Cleans a cache folder.
	* @param {string} $folder The name of the folder whose contents to remove from the cache.
	 *
	 * @since  1.0.0
	*/
	private static function removeCacheFolder($complete = true): void
	{
		$folder = JPATH_ROOT.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'com_uithemebuilderlite';  // use site cache folder, not administrator cache folder
		if (file_exists($folder)) {
			$files = scandir($folder);
			if ($files !== false) {
				foreach ($files as $file) {
					if ($file[0] != '.') {  // skip parent directory entries and hidden files
						unlink($folder.DIRECTORY_SEPARATOR.$file);
					}
				}
				if ($complete) {
					rmdir($folder);
				}
			}
		}
	}

}
