<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\ComponentParser;

$app = Factory::getApplication();
$user = Factory::getApplication()->getIdentity();

if ($this->page->access === 2 && $user->get('guest')) {
    $return = base64_encode(Uri::getInstance());
    $login_url_with_return = Route::_('index.php?option=com_users&view=login&return=' . $return);
    $app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'notice');
    $app->redirect($login_url_with_return, 403);
} else {
    try {
        $PageContent    = trim($this->page->content);
        $PageId         = md5($this->page->id);
        $PageCache      = $this->page->page_cache;
        $currentUrl     = Uri::getInstance();

        if ($currentUrl->getVar('jooa11y') === '1' && PluginHelper::isEnabled('system', 'jooa11y')) {
            echo '<main>';
        }
        if ($PageCache === 1) {
            echo ComponentParser::viewPage(json_decode($PageContent, false, 512, JSON_THROW_ON_ERROR), $PageId, true);
        } else {
            echo ComponentParser::viewPage(json_decode($PageContent, false, 512, JSON_THROW_ON_ERROR), $PageId, false);
        }
        if ($currentUrl->getVar('jooa11y') === '1' && PluginHelper::isEnabled('system', 'jooa11y')) {
            echo '</main>';
        }
    } catch (Exception $e) {
    }
}
