<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\AssociationHelper;
use SW\Component\uiThemeBuilderLite\Site\Helper\ComponentParser;
use SW\Component\uiThemeBuilderLite\Site\Helper\RouteHelper;
use SW\Component\uiThemeBuilderLite\Site\Helper\sortGridHelper;

HTMLHelper::_('behavior.core');

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
/* $this->document->getWebAssetManager()
    ->registerAndUseScript('com_uithemebuilderlite.pages-list', 'com_uithemebuilderlite/pages-list.js', [], ['defer' => true]);
 */

// Create some shortcuts.
$n = count($this->items);
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));

if (($this->params->def('show_pagination', 2) === 1 || ($this->params->get('show_pagination') === 2)) && ($this->pagination->pagesTotal > 1)) :
    $doc = Factory::getApplication()->getDocument();
    $doc->setTitle($doc->getTitle() . ' | ' . Text::sprintf('JLIB_HTML_PAGE_CURRENT_OF_TOTAL', $this->pagination->pagesCurrent, $this->pagination->pagesTotal));
    $doc->setDescription($doc->getMetaData('description') . ' - ' . Text::sprintf('JLIB_HTML_PAGE_CURRENT_OF_TOTAL', $this->pagination->pagesCurrent, $this->pagination->pagesTotal));
endif;

?>

<form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post" name="adminForm"
      id="adminForm">

    <?php if ($this->params->get('list_show_title', 1) || $this->params->get('list_show_date') || (Associations::isEnabled() && $this->params->get('show_associations')) || $this->params->get('list_show_hits', 1) || $this->params->get('show_pagination_limit')) : ?>
        <section class="uk-section uk-position-relative uk-section-small uk-section-primary">
            <div class="uk-container uk-container-large">
                <div class="uk-grid-small uk-grid-match uk-flex-middle" uk-grid="">
                    <?php if (!empty($this->items)) : ?>
                        <div class="uk-width-auto">
                            <?php foreach ($this->items as $i => $item) : ?>
                                <div class="uk-grid-small uk-grid-divider uk-child-width-auto" uk-grid="">
                                    <?php if ($date = $this->params->get('list_show_title')) : ?>
                                        <div class="list-title small uk-text-small">
                                            <?php if ($this->params->get('show_headings')) : ?>
                                                <?php echo $this->escape($item->title); ?>
                                            <?php else : ?>
                                                <?php echo sortGridHelper::sort('JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder, null, 'asc', '', 'adminForm'); ?>: <?php echo $this->escape($item->title); ?>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if ($date = $this->params->get('list_show_date')) : ?>
                                        <div class="list-date small uk-text-small">
                                            <span>
                                                <?php if ($date === 'created') : ?>
                                                    <?php if ($this->params->get('show_headings')) : ?>
                                                        <?php echo Text::_('COM_UITHEMEBUILDERLITE_CREATED_DATE'); ?>:
                                                    <?php else : ?>
                                                        <?php echo sortGridHelper::sort('COM_UITHEMEBUILDERLITE_' . strtoupper($date) . '_DATE', 'a.created', $listDirn, $listOrder, null, 'asc', ' ', 'adminForm'); ?>:
                                                    <?php endif; ?>
                                                <?php elseif ($date === 'modified') : ?>
                                                    <?php if ($this->params->get('show_headings')) : ?>
                                                        <?php echo Text::_('COM_UITHEMEBUILDERLITE_MODIFIED_DATE'); ?>:
                                                    <?php else : ?>
                                                        <?php echo sortGridHelper::sort('COM_UITHEMEBUILDERLITE_' . strtoupper($date) . '_DATE', 'a.modified', $listDirn, $listOrder, null, 'asc', ' ', 'adminForm'); ?>:
                                                    <?php endif; ?>
                                                <?php elseif ($date === 'published') : ?>
                                                    <?php if ($this->params->get('show_headings')) : ?>
                                                        <?php echo Text::_('COM_UITHEMEBUILDERLITE_PUBLISHED_DATE'); ?>:
                                                    <?php else : ?>
                                                        <?php echo sortGridHelper::sort('COM_UITHEMEBUILDERLITE_' . strtoupper($date) . '_DATE', 'a.publish_up', $listDirn, $listOrder, null, 'asc', ' ', 'adminForm'); ?>:
                                                    <?php endif; ?>
                                                <?php endif; ?>

                                                <?php
                                                echo HTMLHelper::_(
                                                    'date',
                                                    $item->displayDate,
                                                    $this->escape($this->params->get('date_format', Text::_('DATE_FORMAT_LC3')))
                                                ); ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (Associations::isEnabled() && $this->params->get('show_associations')) : ?>
                                        <div class="cat-list-association small uk-text-small">
                                            <?php $associations = AssociationHelper::displayAssociations($item->id); ?>
                                            <?php foreach ($associations as $association) : ?>
                                                <?php if ($this->params->get('flags', 1) && $association['language']->image) : ?>
                                                    <?php $flag = HTMLHelper::_('image', 'mod_languages/' . $association['language']->image . '.gif', $association['language']->title_native, array('title' => $association['language']->title_native), true); ?>
                                                    <a href="<?php echo Route::_($association['item']); ?>"><?php echo $flag; ?></a>
                                                <?php else : ?>
                                                    <?php $class = 'btn btn-secondary btn-sm btn-' . strtolower($association['language']->lang_code); ?>
                                                    <a class="<?php echo $class; ?>"
                                                       title="<?php echo $association['language']->title_native; ?>"
                                                       href="<?php echo Route::_($association['item']); ?>"><?php echo $association['language']->lang_code; ?>
                                                        <span
                                                            class="visually-hidden"><?php echo $association['language']->title_native; ?></span>
                                                    </a>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if ($this->params->get('list_show_hits', 1)) : ?>
                                        <div class="list-hits uk-text-small small">
                                            <?php if ($this->params->get('show_headings')) : ?>
                                                <?php echo Text::sprintf('JGLOBAL_HITS', $item->hits); ?>: <?php echo $item->hits; ?>
                                            <?php else : ?>
                                                <?php echo sortGridHelper::sort('JGLOBAL_HITS', 'a.hits', $listDirn, $listOrder); ?>: <?php echo $item->hits; ?>
                                            <?php endif; ?>

                                            <?php // echo HTMLHelper::_('grid.sort', 'JGLOBAL_HITS', 'a.hits', $listDirn, $listOrder); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if (empty($this->items)) : ?>
        <p>
            <?php echo Text::_('JGLOBAL_SELECT_NO_RESULTS_MATCH'); ?>
        </p>
    <?php else : ?>
        <div class="com-uithemebuilderlite-category__view category">
            <?php foreach ($this->items as $i => $item) : ?>
                <div>
                    <?php if (in_array($item->access, $this->user->getAuthorisedViewLevels(), true)) :
                        $PageContent = trim($item->content);
                        $PageId      = md5($item->id);
                        $PageCache   = $item->page_cache;

                        if ($PageCache === 1) {
                            echo ComponentParser::viewPage(json_decode($PageContent, false, 512, JSON_THROW_ON_ERROR), $PageId, true);
                        } else {
                            echo ComponentParser::viewPage(json_decode($PageContent, false, 512, JSON_THROW_ON_ERROR), $PageId, false);
                        }
                    else :
                        echo $this->escape($item->title) . ' : ';
                        $itemId = Factory::getApplication()->getMenu()->getActive()->id;
                        $link = new Uri(Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false));
                        $link->setVar('return', base64_encode(RouteHelper::getPageRoute($item->slug, $item->catid, $item->language)));
                        ?>
                        <a href="<?php echo $link; ?>" class="register">
                            <?php echo Text::_('COM_UITHEMEBUILDERLITE_REGISTER_TO_READ_MORE'); ?>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($this->link_items)) : ?>
        <section class="uk-section uk-position-relative uk-section-small uk-section-secondary">
            <div class="uk-container uk-container-large">
                <?php echo $this->loadTemplate('links'); ?>
            </div>
        </section>
    <?php endif; ?>

    <?php if (!empty($this->items)) : ?>
        <?php if ($this->params->get('show_pagination', 2)) : ?>
            <section
                class="com-uithemebuilderlite-category__counter uk-section uk-position-relative uk-section-small uk-section-secondary">
                <div class="uk-container uk-container-medium">
                    <hr class="uk-divider-small">
                    <?php if ($this->params->def('show_pagination_results', 1)) : ?>
                        <p class="counter uk-text-small">
                            <?php echo $this->pagination->getPagesCounter(); ?>
                        </p>
                    <?php endif; ?>

                    <?php echo $this->pagination->getPagesLinks(); ?>
                </div>
            </section>
        <?php endif; ?>
    <?php endif; ?>

    <input type="hidden" name="filter_order" value="">
    <input type="hidden" name="filter_order_Dir" value="">
    <input type="hidden" name="limitstart" value="">
    <input type="hidden" name="task" value="">
</form>
