<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
namespace SW\Component\uiThemeBuilderLite\Site\View\Featured;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;

/**
 * Featured View class
 *
 * @since  v1.0.0
 */
class HtmlView extends BaseHtmlView
{
    /**
     * The item model state
     *
     * @var    \Joomla\Registry\Registry
     *
     * @since  v1.0.0
     */
    protected $state;

    /**
     * The item details
     *
     * @var    \JObject
     * @since  v1.0.0
     */
    protected $items;

    /**
     * The pagination object
     *
     * @var    \JPagination
     * @since  v1.0.0
     */
    protected \JPagination $pagination;

    /**
     * The page parameters
     *
     * @var    \Joomla\Registry\Registry|null
     * @since  v1.0.0
     */
    public $params = null;

    /**
     * The page class suffix
     *
     * @var    string
     * @since  v1.0.0
     */
    protected string $pageclass_sfx = '';

    /**
     * Method to display the view.
     *
     * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
     *
     * @return  mixed  \Exception on failure, void on success.
     *
     * @throws \Exception
     *
     * @since   v1.0.0
     */
    public function display($tpl = null): mixed
    {
        $app = Factory::getApplication();
        $params = $app->getParams();

        // Get some data from the models
        $state = $this->get('State');
        $items = $this->get('Items');
        $category = $this->get('Category');
        $children = $this->get('Children');
        $parent = $this->get('Parent');
        $pagination = $this->get('Pagination');

        // Flag indicates to not add limitstart=0 to URL
        $pagination->hideEmptyLimitstart = true;

        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
            throw new GenericDataException(implode("\n", $errors), 500);
        }


        // Prepare the data.
        for ($i = 0, $n = count($items); $i < $n; $i++) {
            $item = &$items[$i];
            $item->slug = $item->alias ? ($item->id . ':' . $item->alias) : $item->id;
            /*          $temp       = $item->params;
                        $item->params = clone $params;
                        $item->params->merge($temp); */
        }

        // Escape strings for HTML output
        $this->pageclass_sfx = htmlspecialchars((string) $params->get('pageclass_sfx'), ENT_COMPAT, 'UTF-8');

        $maxLevel = $params->get('maxLevel', -1);
        $this->maxLevel = &$maxLevel;
        $this->state = &$state;
        $this->items = &$items;
        $this->category = &$category;
        $this->children = &$children;
        $this->params = &$params;
        $this->parent = &$parent;
        $this->pagination = &$pagination;

        $this->_prepareDocument();

        return parent::display($tpl);
    }

    /**
     * Prepares the document
     *
     * @return  void
     *
     * @throws \Exception
     *
     * @since   v1.0.0
     */
    protected function _prepareDocument(): void
    {
        $app = Factory::getApplication();
        $menus = $app->getMenu();

        // Because the application sets a default page title,
        // we need to get it from the menu item itself
        $menu = $menus->getActive();

        if ($menu) {
            $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
        } else {
            $this->params->def('page_heading', Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_PAGE_TITLE'));
        }

        $title = $this->params->get('page_title', '');

        if (empty($title)) {
            $title = $app->get('sitename');
        } elseif ($app->get('sitename_pagetitles', 0) == 1) {
            $title = Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
        } elseif ($app->get('sitename_pagetitles', 0) == 2) {
            $title = Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
        }

        $this->document->setTitle($title);

        if ($this->params->get('menu-meta_description')) {
            $this->document->setDescription($this->params->get('menu-meta_description'));
        }

        if ($this->params->get('menu-meta_keywords')) {
            $this->document->setMetaData('keywords', $this->params->get('menu-meta_keywords'));
        }

        if ($this->params->get('robots')) {
            $this->document->setMetaData('robots', $this->params->get('robots'));
        }
    }
}
