<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Site\View\Category;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\CategoryView;
use Joomla\Registry\Registry;
use SW\Component\uiThemeBuilderLite\Site\Helper\RouteHelper;

/**
 * HTML View class for the ui/Theme-Builder Lite component
 *
 * @since  v1.0.0
 */
class HtmlView extends CategoryView
{
    /**
     * @var    string  The name of the extension for the category
     * @since  v1.0.0
     */
    protected $extension = 'com_uithemebuilderlite';

    /**
     * @var    string  Default title to use for page title
     * @since  v1.0.0
     */
    protected $defaultPageTitle = 'COM_UITHEMEBUILDERLITE_DEFAULT_PAGE_TITLE';

    /**
     * @var    string  The name of the view to link individual items to
     * @since  v1.0.0
     */
    protected $viewName = 'page';

    /**
     * Run the standard Joomla plugins
     *
     * @var    boolean
     * @since  v1.0.0
     */
    protected $runPlugins = true;

    /**
     * The pagination object
     *
     * @var  \JPagination
     *
     * @since   v1.0.0
     */
    protected $pagination;

    /**
     * Execute and display a template script.
     *
     * @param   null  $tpl  The name of the template file to parse; automatically searches through the template paths.
     *
     * @return void A string if successful, otherwise an Error object.
     *
     * @throws \Exception
     * @since   v1.0.0
     */
    public function display($tpl = null): void
    {
        parent::commonCategoryDisplay();

        // Get some data from the models
        // $state = $this->get('State');
        $items = $this->get('Items');
        // $category = $this->get('Category');
        // $children = $this->get('Children');
        // $parent = $this->get('Parent');
        $pagination = $this->get('Pagination');

        // Flag indicates to not add limitstart=0 to URL
        $pagination->hideEmptyLimitstart = true;

        // Load UiKit files for non uikit templates without uithemebuilder Template
        $uikit_template_css = JPATH_ROOT . '/templates/uithemebuilder/css/theme.css';
        $uikit_css = JPATH_ROOT . '/media/com_uithemebuilderlite/css/uikit.min.css';
        if (File::exists($uikit_css) && !File::exists($uikit_template_css)) {
            HTMLHelper::_('stylesheet', 'com_uithemebuilderlite/uikit.min.css', array('version' => 'auto', 'relative' => true));
        }

        $uikit_template_js = JPATH_ROOT . '/templates/uithemebuilder/js/uikit.min.js';
        $uikit = JPATH_ROOT . '/media/com_uithemebuilderlite/js/uikit.min.js';
        if (File::exists($uikit) && !File::exists($uikit_template_js)) {
            HTMLHelper::_('script', 'com_uithemebuilderlite/uikit.min.js', array('version' => 'auto', 'relative' => true));
        }

        $uikit_icons_template_js = JPATH_ROOT . '/templates/uithemebuilder/js/uikit-icons.min.js';
        $uikit_icons = JPATH_ROOT . '/media/com_uithemebuilderlite/js/uikit-icons.min.js';
        if (File::exists($uikit_icons) && !File::exists($uikit_icons_template_js)) {
            HTMLHelper::_('script', 'com_uithemebuilderlite/uikit-icons.min.js', array('version' => 'auto', 'relative' => true));
        }

        Text::script('COM_UITHEMEBUILDERLITE_WARNING');

        // Category view
        Text::script('COM_UITHEMEBUILDERLITE_CREATED_DATE');
        Text::script('COM_UITHEMEBUILDERLITE_MODIFIED_DATE');
        Text::script('COM_UITHEMEBUILDERLITE_PUBLISHED_DATE');

        Text::script('COM_UITHEMEBUILDERLITE_REGISTER_TO_READ_MORE');

        // Component translations
        Text::script('COM_UITHEMEBUILDERLITE_DAYS');
        Text::script('COM_UITHEMEBUILDERLITE_HOURS');
        Text::script('COM_UITHEMEBUILDERLITE_MINUTES');
        Text::script('COM_UITHEMEBUILDERLITE_SECONDS');
        Text::script('COM_UITHEMEBUILDERLITE_HITS');
        Text::script('COM_UITHEMEBUILDERLITE_NO_ARTICLES_FOUND');
        Text::script('COM_UITHEMEBUILDERLITE_POSTED_IN');
        Text::script('COM_UITHEMEBUILDERLITE_WRITTEN_BY');

        Text::script('COM_UITHEMEBUILDERLITE_LOAD_MORE');
        Text::script('COM_UITHEMEBUILDERLITE_LOAD_MORE_RESET');

        // Component Gallery Pro
        Text::script('COM_UITHEMEBUILDERLITE_NEXT_PAGE');
        Text::script('COM_UITHEMEBUILDERLITE_PREVIOUS_PAGE');

        // Component Ajax Contact Form Pro
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_GENDER');
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_MALE');
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_FEMALE');
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_NAME');
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_EMAIL');
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_TEL');
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_SUBJECT');
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_MESSAGE');
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_MESSAGE_PLACEHOLDER');
        Text::script('COM_UITHEMEBUILDERLITE_LABEL_DEFAULT_CAPTCHA');

        if (count($errors = $this->get('Errors'))) {
            throw new GenericDataException(implode("\n", $errors), 500);
        }


        foreach ($items as $item) {
            $item->slug = $item->alias ? ($item->id . ':' . $item->alias) : $item->id;
            // $params = $this->params;
            // $temp = $item->params;
            $params = clone $this->params;
            $params->merge($params);

            $app = Factory::getApplication();

            $app->triggerEvent('onContentPrepare', array('com_uithemebuilderlite.category', &$item, &$item->content, 0));


            // Because the application sets a default page title,
            // we need to get it from the menu item itself
            $active = $app->getMenu()->getActive();

            if ($this->menuItemMatchCategory) {
                $this->params->def('page_heading', $this->params->get('page_title', $active->title));
                $title = $this->params->get('page_title', $active->title);
            } else {
                $this->params->def('page_heading', $this->category->title);
                $title = $this->category->title;
                $this->params->set('page_title', $title);
            }

            if (empty($title)) {
                $title = $this->category->title;
            }

            $this->setDocumentTitle($title);

            if ($this->category->metadesc) {
                $this->document->setDescription($this->category->metadesc);
            } elseif ($this->params->get('menu-meta_description')) {
                $this->document->setDescription($this->params->get('menu-meta_description'));
            }

            if ($this->params->get('robots')) {
                $this->document->setMetaData('robots', $this->params->get('robots'));
            }

            if (!is_object($this->category->metadata)) {
                $this->category->metadata = new Registry($this->category->metadata);
            }

            if (($app->get('MetaAuthor') == '1') && $this->category->get('author', '')) {
                $this->document->setMetaData('author', $this->category->get('author', ''));
            }

            $mdata = $this->category->metadata->toArray();

            foreach ($mdata as $k => $v) {
                if ($v) {
                    $this->document->setMetaData($k, $v);
                }
            }
        }

        $this->_prepareDocument();

        parent::display($tpl);
    }

    /**
     * Prepares the document
     *
     * @return  void
     *
     * @since   v1.0.0
     */
    protected function _prepareDocument(): void
    {

        parent::prepareDocument();

        if ($this->menuItemMatchCategory) {
            // If the active menu item is linked directly to the category to be displayed, no further process is needed.
            return;
        }

        $menu = $this->menu;

        if ($menu && $menu->component == 'com_uithemebuilderlite' && isset($menu->query['view'])
            && in_array($menu->query['view'], ['categories', 'category'])) {
            $id = (int)@$menu->query['id'];
        } else {
            $id = 0;
        }

        $path       = [['title' => $this->category->title, 'link' => '']];
        $category   = $this->category->getParent();

        while ($category !== null && $category->id !== 'root' && $category->id != $id) {
            $path[] = ['title' => $category->title, 'link' => RouteHelper::getCategoryRoute($category->id, $category->language)];
            $category = $category->getParent();
        }

        $path = array_reverse($path);
        foreach ($path as $item) {
            $this->pathway->addItem($item['title'], $item['link']);
        }

        parent::addFeed();
    }
}
