<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Categories\CategoryNode;
use Joomla\CMS\Language\Multilanguage;

/**
 * uiThemeBuilderLite Component Route Helper.
 *
 * @since  1.0.0
 */
abstract class RouteHelper
{
    /**
     * Get the page route.
     *
     * @param   string       $id        The route of the content item.
     * @param   integer      $catid     The category ID.
     * @param   integer      $language  The language code.
     * @param   string|null  $layout    The layout value.
     *
     * @return  string  The page route.
     *
     * @since   1.0.0
     */
    public static function getPageRoute($id, $catid = 0, $language = 0, $layout = null)
    {
        // Create the link
        $link = 'index.php?option=com_uithemebuilderlite&view=page&id=' . $id;

        if ((int)$catid > 1) {
            $link .= '&catid=' . $catid;
        }

        if ($language && $language !== '*' && Multilanguage::isEnabled()) {
            $link .= '&lang=' . $language;
        }

        if ($layout) {
            $link .= '&layout=' . $layout;
        }

        return $link;
    }

    /**
     * Get the category route.
     *
     * @param   integer  $catid     The category ID.
     * @param   integer  $language  The language code.
     *
     * @return  string  The article route.
     *
     * @since   v1.0.0
     */
    public static function getCategoryRoute($catid, $language = 0)
    {
        if ($catid instanceof CategoryNode) {
            $id = $catid->id;
        } else {
            $id = (int)$catid;
        }

        if ($id < 1) {
            return '';
        }

        $link = 'index.php?option=com_uithemebuilderlite&view=category&id=' . $id;

        if ($language && $language !== '*' && Multilanguage::isEnabled()) {
            $link .= '&lang=' . $language;
        }

        return $link;
    }
}
