<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;

/**
 * ui/Theme-Builder Lite Component Query Helper
 *
 * @since  1.0.0
 */
class QueryHelper
{
    /**
     * Translate an order code to a field for primary category ordering.
     *
     * @param string $orderby The ordering code.
     *
     * @return  string  The SQL field(s) to order by.
     *
     * @since   1.0.7
     */
    public static function orderbyPrimary($orderby)
    {
        switch ($orderby) {
            case 'alpha':
                $orderby = 'c.path, ';
                break;

            case 'ralpha':
                $orderby = 'c.path DESC, ';
                break;

            case 'order':
                $orderby = 'c.lft, ';
                break;

            default:
                $orderby = '';
                break;
        }

        return $orderby;
    }

    /**
     * Translate an order code to a field for secondary category ordering.
     *
     * @param   string                                   $orderby    The ordering code.
     * @param   string                                   $orderDate  The ordering code for the date.
     * @param   \Joomla\Database\DatabaseInterface|null  $db         The database
     *
     * @return  string  The SQL field(s) to order by.
     *
     * @since   1.0.7
     */
    public static function orderbySecondary(string $orderby, string $orderDate = 'created', DatabaseInterface $db = null): string
    {
        $db = $db ?: Factory::getContainer()->get('DatabaseDriver');

        $queryDate = self::getQueryDate($orderDate, $db);

        $orderby = match ($orderby) {
            'date' => $queryDate,
            'rdate' => $queryDate . ' DESC ',
            'alpha' => 'a.title',
            'ralpha' => 'a.title DESC',
            'hits' => 'a.hits DESC',
            'rhits' => 'a.hits',
            'rorder' => 'a.ordering DESC',
            'author' => 'author',
            'rauthor' => 'author DESC',
            'front' => 'a.featured DESC, fp.ordering, ' . $queryDate . ' DESC ',
            'random' => $db->getQuery(true)->rand(),
            default => 'a.ordering',
        };

        return $orderby;
    }


    /**
     * Translate an order code to a field for primary category ordering.
     *
     * @param   string                                   $orderDate  The ordering code.
     * @param   \Joomla\Database\DatabaseInterface|null  $db         The database
     *
     * @return  string  The SQL field(s) to order by.
     *
     * @since   1.0.7
     */
    public static function getQueryDate(string $orderDate, DatabaseInterface $db = null): string
    {
        // $db = $db ?: Factory::getDbo();

        $queryDate = match ($orderDate) {
            'modified' => ' CASE WHEN a.modified IS NULL THEN a.created ELSE a.modified END',
            'published' => ' CASE WHEN a.publish_up IS NULL THEN a.created ELSE a.publish_up END ',
            'unpublished' => ' CASE WHEN a.publish_down IS NULL THEN a.created ELSE a.publish_down END ',
            default => ' a.created ',
        };

        return $queryDate;
    }
}
