<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\LanguageHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\Component\Categories\Administrator\Helper\CategoryAssociationHelper;
use SW\Component\uiThemeBuilderLite\Site\Helper\RouteHelper as uiThemeBuilderLiteRoute;

/**
 * ui/Theme-Builder Lite Component Association Helper
 *
 * @since  v1.0.0
 */
abstract class AssociationHelper extends CategoryAssociationHelper
{
    /**
     * Method to display in frontend the associations for a given article
     *
     * @param   integer  $id  Id of the article
     *
     * @return  array  An array containing the association URL and the related language object
     *
     * @throws \Exception
     *
     * @since  1.0.0
     */
    public static function displayAssociations(int $id): array
    {
        $return = array();

        if ($associations = self::getAssociations($id, 'page')) {
            $levels = Factory::getApplication()->getIdentity()->getAuthorisedViewLevels();
            $languages = LanguageHelper::getLanguages();

            foreach ($languages as $language) {
                // Do not display language when no association
                if (empty($associations[$language->lang_code])) {
                    continue;
                }

                // Do not display language without frontend UI
                if (!array_key_exists($language->lang_code, LanguageHelper::getInstalledLanguages(0))) {
                    continue;
                }

                // Do not display language without specific home menu
                if (!array_key_exists($language->lang_code, Multilanguage::getSiteHomePages())) {
                    continue;
                }

                // Do not display language without authorized access level
                if (isset($language->access) && $language->access && !in_array($language->access, $levels, true)) {
                    continue;
                }

                $return[$language->lang_code] = array('item' => $associations[$language->lang_code], 'language' => $language);
            }
        }

        return $return;
    }

    /**
     * Method to get the associations for a given item
     *
     * @param   integer      $id    Id of the item
     * @param   string|null  $view  Name of the view
     *
     * @return  array   Array of associations for the item
     *
     * @throws \Exception
     *
     * @since  v1.0.0
     */
    public static function getAssociations(int $id = 0, string $view = null): array
    {
        $jinput = Factory::getApplication()->input;
        $view = $view ?? $jinput->get('view');
        $id = empty($id) ? $jinput->getInt('id') : $id;

        if (($view === 'page') && $id) {
            $associations = Associations::getAssociations('com_uithemebuilderlite', '#__uithemebuilderlite', 'com_uithemebuilderlite.item', $id);

            $return = [];

            foreach ($associations as $tag => $item) {
                $return[$tag] = uiThemeBuilderLiteRoute::getPageRoute($item->id, (int)$item->catid, $item->language);
            }

            return $return;
        }

        if ($view === 'category' || $view === 'categories') {
            return self::getCategoryAssociations($id, 'com_uithemebuilderlite');
        }

        return [];
    }
}
