<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                    = '';
$doc                     = Factory::getApplication()->getDocument();
$options                 = SitePageHelper::escapeHtmlArray($displayData['options']);
$custom_id               = SitePageHelper::randomNumber();
$component_id            = 'ui-video-' . $custom_id;
$css                     = '';
$class                   = '';
$inline_css              = '';
$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$content_class         = '';
$video_class           = '';
$video_params          = '';
$video_source          = '';
$video_height_viewport = '';
$video_height          = '';
$video_extensions      = ['asf', 'avi', 'flv', 'm4v', 'mp4', 'ogg', 'ogv', 'webm'];
$video_url             = [];
$position_style        = [];
$style                 = [];
$buildStyle            = '';

$custom_box_background = ($options['custom_box_background'] ?? 0);

$video_cover_height_viewport = ($options['video_cover_height_viewport'] ?? 0);
$video_auto_play             = ($options['video_auto_play'] ?? 1);
$video_show_controls         = ($options['video_show_controls'] ?? 1);
$video_show_suggestions      = ($options['video_show_suggestions'] ?? 1);
$video_loop                  = ($options['video_loop'] ?? 1);
$video_show_info             = ($options['video_show_info'] ?? 1);
$video_muted                 = ($options['video_muted'] ?? 1);
$video_cover                 = ($options['video_cover'] ?? 1);
$video_url_tmp               = ($options['video_url'] ?? 'https://www.youtube-nocookie.com/embed/YE7VzlLtp-4');

// Custom Box Background
if ($custom_box_background === "1") {
    if ((!empty($options['box_background_image'])) || (!empty($options['box_background_image_size']))) {
        $style['background-image'] = Uri::root() . $options['box_background_image'];
        if ($options['box_background_image_repeat'] === "1") {
            $content_class .= ' uk-background-norepeat';
        }
        if (!empty($options['box_background_image_size'])) {
            $content_class .= ' ' . $options['box_background_image_size'];
        }
    }
    if (!empty($options['box_background_color'])) {
        $style['background-color'] = $options['box_background_color'];
    }
    if (((!empty($options['box_background_image'])) && (!empty($options['box_background_color']))) && !empty($options['box_background_image_blend_modes'])) {
        $content_class .= ' ' . $options['box_background_image_blend_modes'];
    }
    if ((!empty($options['box_background_image'])) && (!empty($options['box_background_image_attachment']))) {
        $content_class .= ' ' . $options['box_background_image_attachment'];
    }
    if ((!empty($options['box_background_image'])) && (!empty($options['box_background_image_position']))) {
        $content_class .= ' ' . $options['box_background_image_position'];
    }
// SVG Background
} elseif ($custom_box_background === "2") {
    if (!empty($options['box_svg_list'])) {
        $svg_path                   = Uri::root() . $options['box_svg_list'];
        $color_placeholder_1        = $options['box_svg_background_color_fallback'];
        $color_placeholder_2        = $options['box_svg_background_color_2'];
        $color_placeholder_3        = $options['box_svg_background_color_3'];
        $text_placeholder           = $options['box_svg_background_text'];
        $text_font_size_placeholder = $options['box_svg_background_text_font_size'] . 'px';
        $opacity_placeholder        = $options['box_svg_background_image_opacity'];

        // CSS output
        $css = '.' . $component_id . '{';
        if (!empty($options['box_svg_background_color_fallback'])) {
            $css .= 'background: ' . $options['box_svg_background_color_fallback'] . ';';
            $css .= 'background-color: ' . $options['box_svg_background_color_fallback'] . ';';
        }
        if (!empty($options['box_svg_background_attachment'])) {
            $css .= 'background-attachment: ' . $options['box_svg_background_attachment'] . ';';
        }
        if (!empty($options['box_svg_background_image_size'])) {
            $css .= 'background-size: ' . $options['box_svg_background_image_size'] . ';';
        }
        if (!empty($options['box_svg_background_image_repeat'])) {
            $css .= 'background-repeat: ' . $options['box_svg_background_image_repeat'] . ';';
        }
        if (!empty($options['box_svg_background_position_x']) && !empty($options['box_svg_background_position_y'])) {
            $css .= 'background-position: ' . $options['box_svg_background_position_x'] . ' ' . $options['box_svg_background_position_y'] . ';';
        }
            $css .= 'background-image: url("data:image/svg+xml,' . SitePageHelper::convertSVGtoURI($svg_path, $color_placeholder_1, $color_placeholder_2, $color_placeholder_3, $text_placeholder, $text_font_size_placeholder, $opacity_placeholder) . '");';
        $css .= '}';
        if (Factory::getApplication()->isClient('site')) {
            $doc->addStyleDeclaration(trim(str_replace(array ("\r\n", "\r", "\n", '  '), ' ', $css)));
        } else {
            $inline_css = '<style>' . $css . '</style>';
        }
    }

// Default Background
} elseif (($custom_box_background === "0") && !empty($options['box_icon_background'])) {
    $content_class .= ' ' . $options['box_icon_background'];
}
// Build all inline styles
if ($custom_box_background === "1") {
    $buildStyle = SitePageHelper::buildStyle($style);
}
// Video Cover height options
if (!empty($options['video_viewport_offset_top'])) {
    $height_viewport_offset_top = 'offset-top:' . $options['video_viewport_offset_top'] . ';';
} else {
    $height_viewport_offset_top = '';
}
if (!empty($options['video_viewport_offset_bottom'])) {
    $height_viewport_offset_bottom = ' offset-bottom:' . $options['video_viewport_offset_bottom'] . ';';
} else {
    $height_viewport_offset_bottom = '';
}
if ($video_cover_height_viewport === "1") {
    if (Factory::getApplication()->isClient('site')) {
        $video_height_viewport = ' uk-height-viewport="' . $height_viewport_offset_top . $height_viewport_offset_bottom . '"';
    } else {
        $video_height = ' uk-height-large';
    }
} else {
    $video_height          = ' ' . $options['video_cover_height'];
}
// Video Content Padding
if (!empty($options['video_content_padding'])) {
    $content_class .= ' ' . $options['video_content_padding'];
}
// Video Content Box Padding
if (!empty($options['video_content_box_padding'])) {
    $content_box_class = ' ' . $options['video_content_box_padding'];
} else {
    $content_box_class = '';
}
// Video Content Position margin
if (!empty($options['video_content_position_margin'])) {
    $content_position_margin_class = ' uk-position-' . $options['video_content_position_margin'];
} else {
    $content_position_margin_class = '';
}
// Video Content overlay
if (!empty($options['video_content_overlay'])) {
    $video_content_overlay_class = ' uk-overlay uk-overlay-' . $options['video_content_overlay'];
} else {
    $video_content_overlay_class = '';
}
// Modul Color Style
if (!empty($options['box_color_style'])) {
    $content_class .= ' ' . $options['box_color_style'];
}
if ($custom_box_background === "2") {
    $content_class .= ' ' . $component_id;
}

// Video iframe
if ($video_url_tmp) {
    $video_url = parse_url($video_url_tmp);
    // Video class
    if (!empty($options['class'])) {
        $class = ' ' . $options['class'];
    }
    // Video autoplay params
    if ($video_auto_play === "1") {
        $video_params_autoplay = 'autoplay=1&amp;';
    } else {
        $video_params_autoplay = '';
    }
    // Video controls
    if ($video_show_controls === "1") {
        $video_params_controls = 'controls=1';
    } else {
        $video_params_controls = 'controls=0';
    }
    // Video suggestions
    if ($video_show_suggestions === "1") {
        $video_params_rel = 'rel=1';
    } else {
        $video_params_rel = 'rel=0';
    }
    // Video loop
    if ($video_loop === "1") {
        $video_params_loop = 'loop=1';
    } else {
        $video_params_loop = 'loop=0';
    }
    // Video info
    if ($video_show_info === "1") {
        $video_params_show_info = 'showinfo=1';
    } else {
        $video_params_show_info = 'showinfo=0';
    }
    // Video muted
    if ($video_muted === "1") {
        $muted           = 'automute: true';
        $video_muted_url = '&amp;mute=1';
    } else {
        $video_muted_url = '&amp;mute=0';
        $muted           = '&amp;mute=0';
    }
    // Video start at
    if (!empty($options['video_start'])) {
        $video_start = '&amp;start=' . $options['video_start'];
    } else {
        $video_start = '';
    }
    // Video iframe source
    if (!empty($video_url_tmp)) {
        switch ($video_url['host']) {
            case 'www.youtube-nocookie.com':
            case 'youtube.com':
            case 'www.youtube.com':
                $video_class = ' ui-youtube-video';
                if ($video_cover === "1") {
                    // Video source cover
                    $video_source = '<div itemprop="video" itemscope="" itemtype="https://schema.org/VideoObject">';
                    if (!empty($options['thumbnail_image'])) {
                        $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $options['thumbnail_image'] . '" />';
                    }
                        $video_source .= '<meta itemprop="embedURL" content="' . $video_url_tmp . '" />';
                        $video_source .= '<div class="uk-cover-container' . $video_height . '"' . $video_height_viewport . '>';
                    if (!empty($options['video_content'])) {
                        $video_source .= '<div class="uk-position-' . $options['video_content_position'] . ' uk-flex uk-flex-middle uk-position-z-index' . $content_box_class . '">';
                            $video_source .= '<div class="' . $content_class . '"' . $buildStyle . '>';
                                $video_source .= $options['video_content'];
                            $video_source .= '</div>';
                        $video_source .= '</div>';
                    }
                            $video_source .= '<canvas width="500" height="400"></canvas>';
                            $video_source .= '<iframe src="' . $video_url_tmp . '?' . $video_params_autoplay . $video_params_controls . '&amp;' . $video_params_loop . '&amp;' . $video_params_show_info . '&amp;' . $video_params_rel . '&amp;iv_load_policy=3&amp;showsearch=0&amp;modestbranding=1' . $video_muted_url . '&amp;origin=' . Uri::root() . '&amp;playsinline=1' . $video_start . '" frameborder="0" allow="accelerometer; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="" uk-responsive="" uk-cover="" uk-video="' . $muted . '"></iframe>';
                        $video_source .= '</div>';
                    $video_source .= '</div>';
                } else {
                    // Video source default
                    $video_source = '<div itemprop="video" itemscope="" itemtype="https://schema.org/VideoObject">';
                    if (!empty($options['thumbnail_image'])) {
                        $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $options['thumbnail_image'] . '" />';
                    }
                        $video_source .= '<meta itemprop="embedURL" content="' . $video_url_tmp . '" />';
                        $video_source .= '<iframe src="' . $video_url_tmp . '?' . $video_params_autoplay . $video_params_controls . '&amp;' . $video_params_loop . '&amp;' . $video_params_show_info . '&amp;' . $video_params_rel . '&amp;iv_load_policy=3&amp;showsearch=0&amp;modestbranding=1' . $video_muted_url . '&amp;origin=' . Uri::root() . '&amp;playsinline=1' . $video_start . '" width="' . $options['video_width'] . '" height="' . $options['video_height'] . '" frameborder="0" allow="accelerometer; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="" uk-responsive="" uk-video="' . $muted . '"></iframe>';
                    $video_source .= '</div>';
                }
                break;

            case 'vimeo.com':
            case 'www.vimeo.com':
                $video_class = ' ui-vimeo-video';
                if ($video_cover === "1") {
                    // Video source cover
                    $video_source = '<div itemprop="video" itemscope="" itemtype="https://schema.org/VideoObject">';
                    if (!empty($options['thumbnail_image'])) {
                        $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $options['thumbnail_image'] . '" />';
                    }
                        $video_source .= '<meta itemprop="embedURL" content="' . $video_url_tmp . '" />';
                        $video_source .= '<div class="uk-cover-container' . $video_height . '"' . $video_height_viewport . '>';
                    if (!empty($options['video_content'])) {
                        $video_source .= '<div class="uk-position-' . $options['video_content_position'] . ' uk-flex uk-flex-middle uk-position-z-index' . $content_box_class . '">';
                            $video_source .= '<div class="' . $content_class . '"' . $buildStyle . '>';
                                $video_source .= $options['video_content'];
                            $video_source .= '</div>';
                        $video_source .= '</div>';
                    }
                            $video_source .= '<canvas width="500" height="400"></canvas>';
                            $video_source .= '<iframe src="https://player.vimeo.com/video/' . basename($video_url['path']) . '?' . $video_params_autoplay . $video_params_loop . '&amp;title=0&amp;byline=0&amp;portrait=0" allow="fullscreen" uk-responsive uk-cover uk-video="' . $muted . '"></iframe>';
                        $video_source .= '</div>';
                    $video_source .= '</div>';
                } else {
                    // Video source default
                    $video_source = '<div itemprop="video" itemscope="" itemtype="https://schema.org/VideoObject">';
                    if (!empty($options['thumbnail_image'])) {
                        $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $options['thumbnail_image'] . '" />';
                    }
                        $video_source .= '<meta itemprop="embedURL" content="' . $video_url_tmp . '" />';
                        $video_source .= '<iframe src="https://player.vimeo.com/video/' . basename($video_url['path']) . '?' . $video_params_autoplay . $video_params_loop . '&amp;title=0&amp;byline=0&amp;portrait=0" width="' . $options['video_width'] . '" height="' . $options['video_height'] . '" allow="fullscreen" uk-responsive uk-video="' . $muted . '"></iframe>';
                    $video_source .= '</div>';
                }
                break;

            default:
                if (in_array(File::getExt($video_url_tmp), $video_extensions)) {
                    $video_class = ' default-video-player';
                    // Video autoplay params
                    if ($video_auto_play === "1") {
                        $video_params_autoplay = ' autoplay ';
                    } else {
                        $video_params_autoplay = ' ';
                    }
                    // Video controls
                    if ($video_show_controls === "1") {
                        $video_params_controls = 'controls ';
                    } else {
                        $video_params_controls = '';
                    }
                    // Video loop
                    if ($video_loop === "1") {
                        $video_params_loop = 'loop ';
                    } else {
                        $video_params_loop = '';
                    }
                    // Video muted
                    if ($video_muted === "1") {
                        $muted = 'muted';
                    } else {
                        $muted = '';
                    }
                    if ($video_cover === "1") {
                        // Video source cover
                        $video_source = '<div itemprop="video" itemscope="" itemtype="https://schema.org/VideoObject">';
                        if (!empty($options['thumbnail_image'])) {
                            $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $options['thumbnail_image'] . '" />';
                        }
                            $video_source .= '<meta itemprop="contentUrl" content="' . $video_url_tmp . '" />';
                            $video_source .= '<div class="uk-cover-container' . $video_height . '"' . $video_height_viewport . '>';
                        if (!empty($options['video_content'])) {
                            if ($options['video_content_position'] === 'cover') {
                                $video_source .= '<div class="uk-position-cover' . $content_position_margin_class . $video_content_overlay_class . ' uk-flex uk-flex-center uk-flex-middle uk-position-z-index' . $content_box_class . $content_class . '"' . $buildStyle . '>';
                                    $video_source .= '<div>';
                                        $video_source .= $options['video_content'];
                                    $video_source .= '</div>';
                                $video_source .= '</div>';
                            } else {
                                $video_source .= '<div class="uk-position-' . $options['video_content_position'] . $content_position_margin_class . $video_content_overlay_class . ' uk-flex uk-flex-middle uk-position-z-index' . $content_box_class . '">';
                                    $video_source .= '<div class="' . $content_class . '"' . $buildStyle . '>';
                                        $video_source .= $options['video_content'];
                                    $video_source .= '</div>';
                                $video_source .= '</div>';
                            }
                        }
                                $video_source .= '<video ' . $video_params_controls . $video_params_loop . $muted . ' playsinline' . $video_params_autoplay . 'uk-cover uk-video="autoplay: inview">';
                                    $video_source .= '<source src="' . $video_url_tmp . '" type="video/' . File::getExt($video_url_tmp) . '">';
                                $video_source .= '</video>';
                            $video_source .= '</div>';
                        $video_source .= '</div>';
                    } else {
                        // Video source default
                        $video_source = '<div itemprop="video" itemscope="" itemtype="https://schema.org/VideoObject">';
                        if (!empty($options['thumbnail_image'])) {
                            $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $options['thumbnail_image'] . '" />';
                        }
                        $video_source .= '<meta itemprop="contentUrl" content="' . $video_url_tmp . '" />';
                        $video_source .= '<video ' . $video_params_controls . $video_params_loop . $muted . ' playsinline' . $video_params_autoplay . ' uk-video="autoplay: inview">';
                                $video_source .= '<source src="' . $video_url_tmp . '" type="video/' . File::getExt($video_url_tmp) . '">';
                            $video_source .= '</video>';
                        $video_source .= '</div>';
                    }
                }
                break;
        }
    }
}

// Build Video HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-video-title');
}
if (!empty($video_url_tmp)) {
    $html .= '<div class="ui-video-container' . $video_class . $class . '">';
        $html .= $video_source;
    $html .= '</div>';
}

$html .= $inline_css; // Administrator SVG Background Preview

echo $html;
