<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html = '';
$options = SitePageHelper::escapeHtmlArray($displayData['options']);
$button_class = 'uk-button';
$title_show = ($options['title_show'] ?? 1);
$title_position = ($options['title_position'] ?? 0);
$subtitle_show = ($options['subtitle_show'] ?? 0);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];
$subtitle_class = ($titleAndSubtitleClasses['subtitle'] === '') ? '' : ' ' . $titleAndSubtitleClasses['subtitle'];

$box_width = '';
$image_root = Uri::root(true) . '/';
$content_padding = '';
$id = $options['button_menulist'];

$text_block_content_width = '';
$text_block_image_width = '';
$use_text_block_with_image = ($options['use_text_block_with_image'] ?? 1);
$use_positions_component = ($options['use_positions_component'] ?? 1);

$text_block_image = ($options['text_block_image'] ?? 'first');

$box_scrollspy_animation = ($options['box_scrollspy_animation'] ?? 0);

$component = SitePageHelper::toArray($displayData['type']);
$folder = str_replace('_', '-', $component);
$thumbnail_folder = 'media' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'ui-themebuilder-thumb' . DIRECTORY_SEPARATOR . $folder;

$srcsets = [];
$srcset = '';
$alt_attr = '';
$imgUrl = '';
$use_svg_custom_mask_size = ($options['use_svg_custom_mask_size'] ?? 0);
$style = [];

$doc = Factory::getApplication()->getDocument();

// unsplash.com search
$unsplash_search_query = (isset($options['unsplash_search_query']) && !empty($options['unsplash_search_query']) ? $options['unsplash_search_query'] : '');
$unsplash_custom_search_query = (isset($options['unsplash_custom_search_query']) ? str_replace(' ', '', strtolower(trim($options['unsplash_custom_search_query']))) : '');

// Mask Settings
if (!empty($options['svg_mask_list'])) {
    $style['-webkit-mask'] = Uri::root() . '/media/com_uithemebuilderlite/images/svg-masks/' . $options['svg_mask_list'];
    if ($use_svg_custom_mask_size === "0") {
        $style['-webkit-mask-size'] = $options['svg_mask_size'] ?? 'auto';
    } else {
        $style['-webkit-mask-size'] = $options['svg_custom_mask_size'] ?? '100%';
    }
    $style['-webkit-mask-repeat'] = $options['svg_mask_repeat'] ?? 'inherit';
    $style['-webkit-mask-position'] = $options['svg_mask_position'] ?? 'center';
    $style['mask'] = Uri::root() . '/media/com_uithemebuilderlite/images/svg-masks/' . $options['svg_mask_list'];
    if ($use_svg_custom_mask_size === "0") {
        $style['mask-size'] = $options['svg_mask_size'] ?? 'auto';
    } else {
        $style['mask-size'] = $options['svg_custom_mask_size'] ?? '100%';
    }
    $style['mask-repeat'] = $options['svg_mask_repeat'] ?? 'inherit';
    $style['mask-position'] = $options['svg_mask_position'] ?? 'center';
    $style['mask-mode'] = $options['svg_mask_mode'] ?? 'unset';
}

// Mask Style
if (!empty($style)) {
    $buildStyle = SitePageHelper::buildStyle($style);
} else {
    $buildStyle = '';
}

// Generate srcset images for Text block image / Inline Image
if (!empty($options['image_text_block']) || !empty($options['image'])) {
    if (!empty($options['image_text_block'])) {
        [$width, $height] = getimagesize(Uri::root() . $options['image_text_block']);
    } else {
        [$width, $height] = getimagesize(Uri::root() . $options['image']);
    }

    if (($use_text_block_with_image === "1" && !empty($options['image_text_block_width_srcset'])) || ($use_positions_component === "1" && !empty($options['image_positions_component_width_srcset']))) {
        if ($use_text_block_with_image === "1" && !empty($options['image_text_block_width_srcset'])) {
            $ex = '.' . pathinfo($options['image_text_block'], PATHINFO_EXTENSION);
            $file_name = 'th_' . pathinfo($options['image_text_block'], PATHINFO_FILENAME);
        } elseif ($use_positions_component === "1" && !empty($options['image_positions_component_width_srcset'])) {
            $ex = '.' . pathinfo($options['image'], PATHINFO_EXTENSION);
            $file_name = 'th_' . pathinfo($options['image'], PATHINFO_FILENAME);
        }
        // ratio
        $ratio = round($width / $height * 100);

        if ($use_text_block_with_image === "1" && !empty($options['image_text_block_width_srcset'])) {
            $tmp_srcset = explode(',', $options['image_text_block_width_srcset']);
        } elseif ($use_positions_component === "1" && !empty($options['image_positions_component_width_srcset'])) {
            $tmp_srcset = explode(',', $options['image_positions_component_width_srcset']);
        }
        $merge_srcsets = array_merge($srcsets, $tmp_srcset);
        $srcsets = array_map('trim', $merge_srcsets);
        $srcsets = array_unique($srcsets);

        $min_val = min($srcsets);

        $srcset .= ' data-sizes="';
        $srcset .= '(min-width: ' . $min_val . 'px) 90vw, ';
        $srcset .= '(max-width: ' . $width . 'px) 100vw, ';
        $srcset .= '(max-aspect-ratio: ' . $width . '/' . $height . ') ' . $ratio . 'vh" ';
        $srcset .= 'data-srcset="';
        foreach ($srcsets as $i => $val) {
            if (is_numeric($val) && $val < 4000) {
                unset($srcsets[$i]);
                $srcset .= Uri::root() . $thumbnail_folder . '/' . $file_name . '_' . $val . $ex . ' ' . $val . 'w, ';
            }
        }
        if ($use_text_block_with_image === "1" && !empty($options['image_text_block_width_srcset']) && empty($options['image_url'])) {
            $srcset .= Uri::root() . $options['image_text_block'] . ' ' . $width . 'w" ';
        } elseif ($use_positions_component === "1" && !empty($options['image_positions_component_width_srcset'])) {
            $srcset .= Uri::root() . $options['image'] . ' ' . $width . 'w" ';
        }

        if ($use_text_block_with_image === "1" && !empty($options['image_text_block_width_srcset']) && empty($options['image_url'])) {
            $srcset .= 'data-src="' . Uri::root() . $options['image_text_block'] . '" width="' . $width . '" height="' . $height . '"';
        } elseif ($use_positions_component === "1" && !empty($options['image_positions_component_width_srcset']) && empty($options['image_url'])) {
            $srcset .= 'data-src="' . Uri::root() . $options['image'] . '"';
        }
    }
} elseif ((($use_positions_component === "1" && empty($options['image_positions_component_width_srcset'])) || ($use_text_block_with_image === "1" && empty($options['image_text_block_width_srcset']))) && !empty($options['image_url'])) {
    [$width, $height] = getimagesize($options['image_url']);
    $imgUrl = $options['image_url'];
} elseif (!empty($unsplash_custom_search_query)) {
//  [$width, $height] = getimagesize('https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg');
    $width = '';
    $height = '';
    $imgUrl = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time();
} elseif (!empty($unsplash_search_query)) {
    // list($width, $height) = getimagesize('https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_'.$unsplash_search_query.'.jpg');
    $width = '';
    $height = '';
    $imgUrl = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_' . $unsplash_search_query . '.jpg?' . time();
} else {
    $width = '';
    $height = '';
    $imgUrl = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time();
}

// Text Block button
if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
    if (!empty($options['button_type'])) {
        $button_class .= ' uk-button-' . $options['button_type'];
    }
    if (!empty($options['button_size'])) {
        $button_class .= ' uk-button-' . $options['button_size'];
    }
}

// Text Block Image/Content Width
if (!empty($options['text_block_image_width'])) {
    $text_block_image_width = $options['text_block_image_width'];
}
if (!empty($options['text_block_content_width'])) {
    $text_block_content_width = $options['text_block_content_width'];
}
// Text Block class
if (!empty($options['content_padding'])) {
    $remove_padding = ' ' . $options['remove_padding'];
    $content_padding = ' class="' . trim($options['content_padding'] . $remove_padding) . '"';
}

// Inline Image ALT attribute
if ((!empty($options['image'])) && $use_positions_component === "1" && !empty($options['alt_text'])) {
    $alt_attr = ' alt="' . $options['alt_text'] . '"';
}
// Text Block Image ALT attribute
if (($use_text_block_with_image === "1") && !empty($options['image_text_block']) && !empty($options['text_block_image_alt_text'])) {
    $alt_attr = ' alt="' . $options['text_block_image_alt_text'] . '"';
}
// Position / Box Padding / Background / Width
if (!empty($options['box_padding']) || (!empty($options['box_background']) && $use_positions_component === "1")) {
    // Box padding
    if (!empty($options['box_padding'])) {
        $box_padding = ' uk-padding-' . $options['box_padding'];
    } else {
        $box_padding = '';
    }
    // Box background
    if (!empty($options['box_background'])) {
        $box_background = ' uk-tile-' . $options['box_background'];
    } else {
        $box_background = '';
    }
    // Box width
    if (!empty($options['grid_m'])) {
        $box_width .= ' uk-width-' . $options['grid_m'] . '@m';
    }
    if (!empty($options['grid_l'])) {
        $box_width .= ' uk-width-' . $options['grid_l'] . '@l';
    }
    if (!empty($options['grid_xl'])) {
        $box_width .= ' uk-width-' . $options['grid_xl'] . '@xl';
    }
    // Box Animation
    if ($box_scrollspy_animation === "1") {
        $delay = '';
        $cls = '';
        if (!empty($options['box_scrollspy_animation_type'])) {
            $cls = 'cls: ' . $options['box_scrollspy_animation_type'] . ';';
        }
        if ($options['box_scrollspy_animation_repeat'] === "1") {
            $repeat = ' repeat: true';
        } else {
            $repeat = '';
        }
        if (!empty($options['box_scrollspy_animation_delay'])) {
            $delay = ' delay: ' . $options['box_scrollspy_animation_delay'] . ';';
        } else {
            $delay = ' delay: 500;';
        }
        $box_scrollspy_animation_attr = ' uk-scrollspy="' . $cls . $delay . $repeat . '"';
    } else {
        $box_scrollspy_animation_attr = '';
    }
}

// Build Text Block Lite HTML
if ($title_position === "0" && ($subtitle_show === "1" || $title_show === "1")) {
    $html .= '<div>';
    if (!empty($options['title']) && $title_show === "1") {
        $subtitleMargin = (!empty($options['subtitle']) && $subtitle_show === "1" ? ' uk-margin-small-bottom'. $title_class : $title_class);
        $html .= SitePageHelper::setTitle($options['title_heading'], trim($subtitleMargin), $options['title'], 'ui-text-block-title');
    }
    if (!empty($options['subtitle']) && $subtitle_show === "1") {
        $titleMargin = (!empty($options['title']) && $title_show === "1" ? ' uk-margin-remove-top'. $subtitle_class : $subtitle_class);
        $html .= SitePageHelper::setTitle($options['subtitle_heading'], trim($titleMargin), $options['subtitle'], 'ui-text-block-subtitle');
    }
    $html .= '</div>';
}

if ($use_positions_component === "0" && $use_text_block_with_image === "1") {
    $html .= '<div class="uk-flex-middle" uk-grid="">';
    $html .= '<div class="' . $text_block_content_width . '@m">';
    if ($title_position === "1") {
        if (!empty($options['title']) && $title_show === "1") {
            $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-text-block-title');
        }
        if (!empty($options['subtitle']) && $subtitle_show === "1") {
            $html .= SitePageHelper::setTitle($options['subtitle_heading'], trim($subtitle_class), $options['subtitle'], 'ui-text-block-subtitle');
        }
    }
    if (!empty($options['content'])) {
        $html .= '<' . $options['content_html_tag'] . $content_padding . '>';
        $html .= $options['content'];
        $html .= '</' . $options['content_html_tag'] . '>';
    }
    if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
        if (!empty($options['button_url'])) {
            $html .= '<a title="' . $options['button_text'] . '" href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
        } else {
            $html .= '<a title="' . $options['button_text'] . '" href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
        }
        if (!empty($options['button_icon'])) {
            $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
        }
        if (!empty($options['button_text'])) {
            $html .= $options['button_text'];
        }
        $html .= '</a>';
    }
    $html .= '</div>';
    $html .= '<div class="' . $text_block_image_width . '@m uk-flex-' . $text_block_image . '">';
    if (!empty($options['image_text_block_width_srcset'])) {
        $html .= '<img' . $alt_attr . $srcset . $buildStyle . ' uk-img="" />';
    } elseif (!empty($options['image_text_block'])) {
        $html .= '<img' . $alt_attr . ' data-src="' . $image_root . $options['image_text_block'] . '" width="' . $width . '" height="' . $height . '"' . $buildStyle . ' uk-img="" />';
    } else {
        $html .= '<img' . $alt_attr . ' data-src="' . $imgUrl . '" width="' . $width . '" height="' . $height . '"' . $buildStyle . ' uk-img="" />';
    }
    $html .= '</div>';
    $html .= '</div>';
} else {
    if ($use_positions_component === "1") {
        $html .= '<div class="uk-inline">';

        if (!empty($options['image_positions_component_width_srcset']) && !empty($options['image'])) {
            $html .= '<img' . $alt_attr . $srcset . $buildStyle . ' uk-img="" />';
        } elseif (!empty($options['image'])) {
            $html .= '<img'. $alt_attr . ' data-src="' . $image_root . $options['image'] . '"' . $buildStyle . ' uk-img="" />';
        } else {
            $html .= '<img' . $alt_attr . ' data-src="' . $imgUrl . '" width="' . $width . '" height="' . $height . '"' . $buildStyle . ' uk-img="" />';
        }

        $html .= '<div class="uk-width-1-1' . $box_width . ' uk-position-' . $options['position_modifier'] . ' uk-position-' . $options['position'] . ' uk-tile' . $box_background . $box_padding . '"' . $box_scrollspy_animation_attr . '>'; // Position Box
    }

    if ($title_position === "1") {
        if (!empty($options['title']) && $title_show === "1") {
            $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-text-block-title');
        }
        if (!empty($options['subtitle']) && $subtitle_show === "1") {
            $html .= SitePageHelper::setTitle($options['subtitle_heading'], trim($subtitle_class), $options['subtitle'], 'ui-text-block-subtitle');
        }
    }
    if (!empty($options['content'])) {
        $html .= '<' . $options['content_html_tag'] . $content_padding . '>';
        $html .= $options['content'];
        $html .= '</' . $options['content_html_tag'] . '>';
    }
    if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
        if (!empty($options['button_url'])) {
            $html .= '<a title="' . $options['button_text'] . '" href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
        } else {
            $html .= '<a title="' . $options['button_text'] . '" href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
        }
        if (!empty($options['button_icon'])) {
            $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
        }
        if (!empty($options['button_text'])) {
            $html .= $options['button_text'];
        }
        $html .= '</a>';
    }

    if ($use_positions_component === "1") {
        $html .= '</div>'; // END Position Box
        $html .= '</div>'; // END Inline
    }
}

echo $html;
