<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                    = '';
$options                 = SitePageHelper::escapeHtmlArray($displayData['options']);
$component               = SitePageHelper::toArray($displayData['type']);
$button_class            = 'uk-button';
$class                   = '';
$card_class              = '';
$title_show              = ($options['title_show'] ?? 1);
$subtitle_show           = ($options['subtitle_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];
$subtitle_class          = ($titleAndSubtitleClasses['subtitle'] === '') ? '' : ' ' . $titleAndSubtitleClasses['subtitle'];

$card_style = '';
$id         = $options['button_menulist'];
$image_root = Uri::root(true) . '/';
$alt_attr   = '';

$grid_match       = ($options['grid_match'] ?? 0);
$card_style_hover = ($options['card_style_hover'] ?? 0);

$doc = Factory::getApplication()->getDocument();

// unsplash.com search
$unsplash_search_query        = (isset($options['unsplash_search_query']) && !empty($options['unsplash_search_query']) ? $options['unsplash_search_query'] : '');
$unsplash_custom_search_query = (isset($options['unsplash_custom_search_query']) ? str_replace(' ', '', strtolower(trim($options['unsplash_custom_search_query']))) : '');

// Personal Card image
if (!empty($options['image']) && Uri::root() . $options['image']) {
    $img_full_path = ' data-src="' . $image_root . $options['image'] . '"';
    if (!empty($options['image_alt_text'])) {
        $alt_attr = ' alt="' . $options['image_alt_text'] . '"';
    }
} elseif (!empty($unsplash_custom_search_query)) {
    $img_full_path = ' data-src="https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time() . '"';
    $alt_attr      = ' alt="unsplash.com Demo image"';
} elseif (!empty($unsplash_search_query)) {
    $img_full_path = ' data-src="https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_' . $unsplash_search_query . '.jpg?' . time() . '"';
    $alt_attr      = ' alt="unsplash.com Demo image"';
} else {
    $img_full_path = ' data-src="https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time() . '"';
    $alt_attr      = ' alt="unsplash.com Demo image"';
}

// Personal Card social icons
if (!empty($options['social_icons_font_size'])) {
    $socials_class = ' ' . $options['social_icons_font_size'];
} else {
    $socials_class = '';
}

if (!empty($options['social_facebook'])) {
    $socials['facebook'] = $options['social_facebook'];
}
if (!empty($options['social_twitter'])) {
    $socials['twitter'] = $options['social_twitter'];
}
if (!empty($options['social_instagram'])) {
    $socials['instagram'] = $options['social_instagram'];
}
if (!empty($options['social_linkedin'])) {
    $socials['linkedin'] = $options['social_linkedin'];
}
if (!empty($options['social_youtube'])) {
    $socials['youtube'] = $options['social_youtube'];
}
if (!empty($options['social_tumblr'])) {
    $socials['tumblr'] = $options['social_tumblr'];
}
if (!empty($options['social_vimeo'])) {
    $socials['vimeo'] = $options['social_vimeo'];
}
if (!empty($options['social_flickr'])) {
    $socials['flickr'] = $options['social_flickr'];
}
if (!empty($options['social_pinterest'])) {
    $socials['pinterest'] = $options['social_pinterest'];
}

if ($grid_match === "1") {
    $grid_match_class = ' uk-flex-middle';
} else {
    $grid_match_class = '';
}

// Personal Card custom class
if (!empty($options['class'])) {
    $class = ' ' . $options['class'];
}
// Personal Card footer button
if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
    if (!empty($options['button_type'])) {
        $button_class .= ' uk-button-' . $options['button_type'];
    }
    if (!empty($options['button_size'])) {
        $button_class .= ' uk-button-' . $options['button_size'];
    }
}
// Card Style
if (!empty($options['card_style'])) {
    $card_class .= ' ' . $options['card_style'];
}
// Card Style Hover
if ($card_style_hover === "1") {
    $card_class .= ' uk-card-hover';
}
// Card size
if (!empty($options['card_size'])) {
    $card_class .= ' ' . $options['card_size'];
}
// Personal Card HTML
if (!empty($options['image_position'])) {
    switch ($options['image_position']) {
        // Image Top Position
        case 'top':
            $html .= '<div class="uk-card' . $card_class . '">';
            $html .= '<div class="uk-card-media-top uk-cover-container uk-height-medium">';
            $html .= '<img' . $img_full_path . $alt_attr . ' uk-cover="" uk-img="" />';
            $html .= '</div>';
            if ((!empty($options['title']) && $title_show === "1") || (!empty($options['subtitle']) && $subtitle_show === "1") || !empty($options['content'])) {
                $html .= '<div class="uk-card-body">';
                if (!empty($options['badge_text'])) {
                    $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                }
                if (!empty($options['title']) && $title_show === "1") {
                    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title ui-personal-card-title');
                }
                if (!empty($options['subtitle']) && $subtitle_show === "1") {
                    $html .= SitePageHelper::setTitle($options['subtitle_heading'], trim($subtitle_class), $options['subtitle'], 'uk-card-title ui-personal-card-subtitle');
                }
                if (!empty($socials)) {
                    $html .= '<div class="uk-grid-small' . $grid_match_class . '" uk-grid="">';
                    switch ($options['social_icons_position']) {
                        // Icon Top Position
                        case 'top':
                            $html .= '<div class="uk-width-1-1">';
                                $html .= '<div class="uk-child-width-auto uk-flex-middle" uk-grid="">';
                            foreach ($socials as $key => $val) {
                                $html .= '<div>';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</div>';
                            }
                                $html .= '</div>';
                            $html .= '</div>';

                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';
                            break;

                        case 'left':
                            $html .= '<div class="uk-width-auto">';
                                $html .= '<ul class="uk-list">';
                            foreach ($socials as $key => $val) {
                                $html .= '<li class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</li>';
                            }
                                $html .= '</ul>';
                            $html .= '</div>';

                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';
                            break;

                        case 'right':
                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';

                            $html .= '<div class="uk-width-auto">';
                                $html .= '<ul class="uk-list">';
                            foreach ($socials as $key => $val) {
                                $html .= '<li class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</li>';
                            }
                                $html .= '</ul>';
                            $html .= '</div>';

                            break;
                        case 'bottom':
                            $html .= '<div class="uk-width-1-1">';
                                $html .= $options['content'];
                            $html .= '</div>';

                            $html .= '<div class="uk-width-1-1">';
                                $html .= '<div class="uk-child-width-auto uk-grid-small uk-flex-middle" uk-grid="">';
                            foreach ($socials as $key => $val) {
                                $html .= '<div class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</div>';
                            }
                                $html .= '</div>';
                            $html .= '</div>';

                            break;
                    }
                    $html .= '</div>';
                } else {
                    $html .= $options['content'];
                }
                $html .= '</div>';
            }
            if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
                $html .= '<div class="uk-card-footer">';
                if (!empty($options['button_url'])) {
                    $html .= '<a href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                } else {
                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                }
                if (!empty($options['button_icon'])) {
                    $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
                }
                if (!empty($options['button_text'])) {
                    $html .= $options['button_text'];
                }
                $html .= '</a>';
                $html .= '</div>';
            }
            $html .= '</div>';
            break;

        // Image Bottom Position
        case 'bottom':
            $html .= '<div class="uk-card' . $card_class . '">';
            if ((!empty($options['title']) && $title_show === "1") || (!empty($options['subtitle']) && $subtitle_show === "1") || !empty($options['content'])) {
                $html .= '<div class="uk-card-body">';
                if (!empty($options['badge_text'])) {
                    $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                }
                if (!empty($options['title']) && $title_show === "1") {
                    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title ui-personal-card-title');
                }
                if (!empty($options['subtitle']) && $subtitle_show === "1") {
                    $html .= SitePageHelper::setTitle($options['subtitle_heading'], trim($subtitle_class), $options['subtitle'], 'uk-card-title ui-personal-card-subtitle');
                }
                if (!empty($socials)) {
                    $html .= '<div class="uk-grid-small' . $grid_match_class . '" uk-grid="">';
                    switch ($options['social_icons_position']) {
                        case 'top':
                            $html .= '<div class="uk-width-1-1">';
                                $html .= '<div class="uk-child-width-auto uk-flex-middle" uk-grid="">';
                            foreach ($socials as $key => $val) {
                                $html .= '<div>';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</div>';
                            }
                                $html .= '</div>';
                            $html .= '</div>';

                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';
                            break;

                        case 'left':
                            $html .= '<div class="uk-width-auto">';
                                $html .= '<ul class="uk-list">';
                            foreach ($socials as $key => $val) {
                                $html .= '<li class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</li>';
                            }
                                $html .= '</ul>';
                            $html .= '</div>';

                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';
                            break;
                        case 'right':
                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';

                            $html .= '<div class="uk-width-auto">';
                                $html .= '<ul class="uk-list">';
                            foreach ($socials as $key => $val) {
                                $html .= '<li class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</li>';
                            }
                                $html .= '</ul>';
                            $html .= '</div>';

                            break;
                        case 'bottom':
                            $html .= '<div class="uk-width-1-1">';
                                $html .= $options['content'];
                            $html .= '</div>';

                            $html .= '<div class="uk-width-1-1">';
                                $html .= '<div class="uk-child-width-auto uk-grid-small uk-flex-middle" uk-grid="">';
                            foreach ($socials as $key => $val) {
                                $html .= '<div class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</div>';
                            }
                                $html .= '</div>';
                            $html .= '</div>';

                            break;
                    }
                    $html .= '</div>';
                } else {
                    $html .= $options['content'];
                }
                $html .= '</div>';
            }
            if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
                $html .= '<div class="uk-card-footer">';
                if (!empty($options['button_url'])) {
                    $html .= '<a href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                } else {
                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                }
                if (!empty($options['button_icon'])) {
                    $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
                }
                if (!empty($options['button_text'])) {
                    $html .= $options['button_text'];
                }
                $html .= '</a>';
                $html .= '</div>';
            }
                $html .= '<div class="uk-card-media-bottom uk-cover-container uk-height-medium">';
                    $html .= '<img' . $img_full_path . $alt_attr . ' uk-cover="" uk-img="" />';
                $html .= '</div>';
            $html .= '</div>';
            break;

        // Image Left Position
        case 'left':
            $html .= '<div class="uk-card' . $card_class . ' uk-grid-collapse uk-child-width-1-2@s uk-grid-match" uk-grid="">';
            $html .= '<div class="uk-card-media-left uk-cover-container">';
            $html .= '<img' . $img_full_path . $alt_attr . ' uk-img="" uk-cover="" />';
            $html .= '<canvas width="300" height="200"></canvas>';
            $html .= '</div>';
            $html .= '<div>';
            if ((!empty($options['title']) && $title_show === "1") || (!empty($options['subtitle']) && $subtitle_show === "1") || !empty($options['content'])) {
                $html .= '<div class="uk-card-body">';
                if (!empty($options['badge_text'])) {
                    $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                }
                if (!empty($options['title']) && $title_show === "1") {
                    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title ui-personal-card-title');
                }
                if (!empty($options['subtitle']) && $subtitle_show === "1") {
                    $html .= SitePageHelper::setTitle($options['subtitle_heading'], trim($subtitle_class), $options['subtitle'], 'uk-card-title ui-personal-card-subtitle');
                }
                if (!empty($socials)) {
                    $html .= '<div class="uk-grid-small' . $grid_match_class . '" uk-grid="">';
                    switch ($options['social_icons_position']) {
                        case 'top':
                            $html .= '<div class="uk-width-1-1">';
                                $html .= '<div class="uk-child-width-auto uk-flex-middle" uk-grid="">';
                            foreach ($socials as $key => $val) {
                                $html .= '<div>';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</div>';
                            }
                                $html .= '</div>';
                            $html .= '</div>';

                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';
                            break;
                        case 'left':
                            $html .= '<div class="uk-width-auto">';
                                $html .= '<ul class="uk-list">';
                            foreach ($socials as $key => $val) {
                                $html .= '<li class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</li>';
                            }
                                $html .= '</ul>';
                            $html .= '</div>';

                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';
                            break;
                        case 'right':
                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';

                            $html .= '<div class="uk-width-auto">';
                                $html .= '<ul class="uk-list">';
                            foreach ($socials as $key => $val) {
                                $html .= '<li class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</li>';
                            }
                                $html .= '</ul>';
                            $html .= '</div>';

                            break;
                        case 'bottom':
                            $html .= '<div class="uk-width-1-1">';
                                $html .= $options['content'];
                            $html .= '</div>';

                            $html .= '<div class="uk-width-1-1">';
                                $html .= '<div class="uk-child-width-auto uk-grid-small uk-flex-middle" uk-grid="">';
                            foreach ($socials as $key => $val) {
                                $html .= '<div class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</div>';
                            }
                                $html .= '</div>';
                            $html .= '</div>';

                            break;
                    }
                    $html .= '</div>';
                } else {
                    $html .= $options['content'];
                }
                $html .= '</div>';
            }
            if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
                $html .= '<div class="uk-card-footer">';
                if (!empty($options['button_url'])) {
                    $html .= '<a href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                } else {
                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                }
                if (!empty($options['button_icon'])) {
                    $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
                }
                if (!empty($options['button_text'])) {
                    $html .= $options['button_text'];
                }
                $html .= '</a>';
                $html .= '</div>';
            }
            $html .= '</div>';
            $html .= '</div>';
            break;

        case 'right':
            $html .= '<div class="uk-card' . $card_class . ' uk-grid-collapse uk-child-width-1-2@s uk-grid-match" uk-grid="">';
            $html .= '<div class="uk-flex-last@s uk-card-media-right uk-cover-container">';
            $html .= '<img' . $img_full_path . $alt_attr . ' uk-img="" uk-cover="" />';
            $html .= '<canvas width="300" height="200"></canvas>';
            $html .= '</div>';
            $html .= '<div>';
            if ((!empty($options['title']) && $title_show === "1") || (!empty($options['subtitle']) && $subtitle_show === "1") || !empty($options['content'])) {
                $html .= '<div class="uk-card-body">';
                if (!empty($options['badge_text'])) {
                    $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                }
                if (!empty($options['title']) && $title_show === "1") {
                    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title ui-personal-card-title');
                }
                if (!empty($options['subtitle']) && $subtitle_show === "1") {
                    $html .= SitePageHelper::setTitle($options['subtitle_heading'], trim($subtitle_class), $options['subtitle'], 'uk-card-title ui-personal-card-subtitle');
                }
                if (!empty($socials)) {
                    $html .= '<div class="uk-grid-small' . $grid_match_class . '" uk-grid="">';
                    switch ($options['social_icons_position']) {
                        case 'top':
                            $html .= '<div class="uk-width-1-1">';
                                $html .= '<div class="uk-child-width-auto uk-flex-middle" uk-grid="">';
                            foreach ($socials as $key => $val) {
                                $html .= '<div>';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</div>';
                            }
                                $html .= '</div>';
                            $html .= '</div>';

                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';
                            break;
                        case 'left':
                            $html .= '<div class="uk-width-auto">';
                                $html .= '<ul class="uk-list">';
                            foreach ($socials as $key => $val) {
                                $html .= '<li class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</li>';
                            }
                                $html .= '</ul>';
                            $html .= '</div>';

                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';
                            break;
                        case 'right':
                            $html .= '<div class="uk-width-expand">';
                                $html .= $options['content'];
                            $html .= '</div>';

                            $html .= '<div class="uk-width-auto">';
                                $html .= '<ul class="uk-list">';
                            foreach ($socials as $key => $val) {
                                $html .= '<li class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</li>';
                            }
                                $html .= '</ul>';
                            $html .= '</div>';

                            break;
                        case 'bottom':
                            $html .= '<div class="uk-width-1-1">';
                                $html .= $options['content'];
                            $html .= '</div>';

                            $html .= '<div class="uk-width-1-1">';
                                $html .= '<div class="uk-child-width-auto uk-grid-small uk-flex-middle" uk-grid="">';
                            foreach ($socials as $key => $val) {
                                $html .= '<div class="uk-text-center">';
                                    $html .= '<a href="' . $val . '" target="' . $options['social_icons_target'] . '">';
                                        $html .= '<i class="fab fa-' . $key . $socials_class . '"></i>';
                                    $html .= '</a>';
                                $html .= '</div>';
                            }
                                $html .= '</div>';
                            $html .= '</div>';

                            break;
                    }
                    $html .= '</div>';
                } else {
                    $html .= $options['content'];
                }
                $html .= '</div>';
            }
            if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
                $html .= '<div class="uk-card-footer">';
                if (!empty($options['button_url'])) {
                    $html .= '<a href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                } else {
                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                }
                if (!empty($options['button_icon'])) {
                    $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
                }
                if (!empty($options['button_text'])) {
                    $html .= $options['button_text'];
                }
                $html .= '</a>';
                $html .= '</div>';
            }
            $html .= '</div>';
            $html .= '</div>';
            break;
    }
}


echo $html;
