<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html    = '';
$options = SitePageHelper::escapeHtmlArray($displayData['options']);

$button_class     = 'uk-button';
$button_alignment = (isset($options['button_alignment']) ? ' ' . $options['button_alignment'] : '');

$title_show              = ($options['title_show'] ?? 1);
$title_position          = ($options['title_position'] ?? 0);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$card_style        = '';
$card_class        = '';
$id                = $options['button_menulist'];
$card_image_height = isset($options['image_height']) ? ' ' . $options['image_height'] : ' uk-height-medium';

$image_root = Uri::root(true) . '/';

$component        = SitePageHelper::toArray($displayData['type']);
$folder           = str_replace('_', '-', $component);
$thumbnail_folder = 'media' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'ui-themebuilder-thumb' . DIRECTORY_SEPARATOR . $folder;

$srcsets = array ();

$card_style_hover = ($options['card_style_hover'] ?? 0);

$image_output    = '';
$image_creator   = (isset($options['image_creator']) && !empty($options['image_creator']) ? $options['image_creator'] : '');

$doc = Factory::getApplication()->getDocument();

// unsplash.com search
$unsplash_search_query        = (isset($options['unsplash_search_query']) && !empty($options['unsplash_search_query']) ? $options['unsplash_search_query'] : '');
$unsplash_custom_search_query = (isset($options['unsplash_custom_search_query']) ? str_replace(' ', '', strtolower(trim($options['unsplash_custom_search_query']))) : '');

// Media Card image
if (!empty($options['image']) && !empty($options['image_width_srcset_bg']) && Uri::root() . $options['image']) {
    [$width, $height] = getimagesize(Uri::root() . $options['image']);

    $ex        = '.' . pathinfo($options['image'], PATHINFO_EXTENSION);
    $file_name = 'th_' . pathinfo($options['image'], PATHINFO_FILENAME);
    // ratio
    $ratio = round($width / $height * 100);

    $tmp_srcset    = explode(',', $options['image_width_srcset_bg']);
    $merge_srcsets = array_merge($srcsets, $tmp_srcset);
    $srcsets       = array_map('trim', $merge_srcsets);
    $srcsets       = array_unique($srcsets);

    $min_val = min($srcsets);

    $image_output .= ' data-sizes="';
    $image_output .= '(min-width: ' . $min_val . 'px) 90vw, ';
    $image_output .= '(max-width: ' . $width . 'px) 100vw, ';
    $image_output .= '(max-aspect-ratio: ' . $width . '/' . $height . ') ' . $ratio . 'vh" ';
    $image_output .= 'data-srcset="';
    foreach ($srcsets as $i => $val) {
        if (is_numeric($val) && $val < 4000) {
            unset($srcsets[$i]);
            $image_output .= Uri::root() . $thumbnail_folder . '/' . $file_name . '_' . $val . $ex . ' ' . $val . 'w, ';
        }
    }

    $image_output .= Uri::root() . $options['image'] . ' ' . $width . 'w" ';

    $image_output .= 'data-src="' . Uri::root() . $options['image'] . '"';

    if (!empty($options['image_alt_text'])) {
        $options['image_alt_text'] = ' alt="' . $options['image_alt_text'] . '"';
    }
} elseif (!empty($options['image']) && empty($options['image_width_srcset_bg'])) {
    $image_output = ' data-src="' . $image_root . $options['image'] . '"';

    if (!empty($options['image_alt_text'])) {
        $options['image_alt_text'] = ' alt="' . $options['image_alt_text'] . '"';
    }
} elseif (!empty($unsplash_custom_search_query)) {
    $image_output = ' data-src="https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time() . '"';
} elseif (!empty($unsplash_search_query)) {
    $image_output = ' data-src="https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_' . $unsplash_search_query . '.jpg?' . time() . '"';
} else {
    $image_output = ' data-src="https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time() . '"';
}

// Media Card footer button
if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
    if (!empty($options['button_type'])) {
        $button_class .= ' uk-button-' . $options['button_type'];
    }
    if (!empty($options['button_size'])) {
        $button_class .= ' uk-button-' . $options['button_size'];
    }
}
// Card Style
if (!empty($options['card_style'])) {
    $card_class .= ' ' . $options['card_style'];
}
// Card Style Hover
if ($card_style_hover == 1) {
    $card_class .= ' uk-card-hover';
}
// Card size
if (!empty($options['card_size'])) {
    $card_class .= ' ' . $options['card_size'];
}


if (!empty($options['class'])) {
    $custom_class = ' ' . $options['class'];
} else {
    $custom_class = '';
}

// Media Card HTML
if ((!empty($options['title']) && $title_show === "1") || !empty($options['image']) || !empty($options['content'])) {
    if (!empty($options['image_position'])) {
        switch ($options['image_position']) {
            case 'top':
                $html .= '<div class="uk-card' . $card_class . $custom_class . '">';
                if ($card_image_height !== ' ') {
                    $html .= '<div class="uk-card-media-top uk-cover-container' . $card_image_height . '" itemscope itemtype="https://schema.org/ImageObject" >';
                        $html .= '<img itemprop="contentUrl"' . $image_output . $options['image_alt_text'] . ' uk-cover="" uk-img="" />';

                    if (!empty($image_creator) && !empty($options['image'])) {
                        $html .= '<span itemprop="creator" itemtype="https://schema.org/Person" itemscope>';
                            $html .= '<meta itemprop="name" content="' . $image_creator . '" />';
                        $html .= '</span>';
                    }

                    $html .= '</div>';
                }

                if ($title_position === "0") {
                    if (!empty($options['badge_text'])) {
                        $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                    }
                    $html .= '<div class="uk-card-body' . $card_body_class . '">';
                    if (!empty($options['title']) && $title_show === "1") {
                        $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title');
                    }
                    if (!empty($options['content'])) {
                        $html .= $options['content'];
                    }
                    $html .= '</div>';
                } else {
                    if (!empty($options['title']) && $title_show === "1" && $title_position === "1") {
                        $html .= '<div class="uk-card-header">';
                            $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title');
                        $html .= '</div>';
                    }
                    if (!empty($options['badge_text'])) {
                        $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                    }
                    if (!empty($options['content'])) {
                        $html .= '<div class="uk-card-body' . $card_body_class . '">';
                        $html .= $options['content'];
                        $html .= '</div>';
                    }
                }
                if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
                    $html .= '<div class="uk-card-footer' . $button_alignment . '">';
                    if (!empty($options['button_url'])) {
                        $html .= '<a href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                    } else {
                        $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                    }
                    if (!empty($options['button_icon'])) {
                        $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
                    }
                    if (!empty($options['button_text'])) {
                        $html .= $options['button_text'];
                    }
                    $html .= '</a>';
                    $html .= '</div>';
                }
                $html .= '</div>';
                break;

            case 'bottom':
                $html .= '<div class="uk-card' . $card_class . $custom_class . '">';
                if ($title_position === "0") {
                    if (!empty($options['badge_text'])) {
                        $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                    }
                    $html .= '<div class="uk-card-body' . $card_body_class . '">';
                    if (!empty($options['title']) && $title_show === "1") {
                        $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title');
                    }
                    if (!empty($options['content'])) {
                        $html .= $options['content'];
                    }
                    $html .= '</div>';
                } else {
                    if (!empty($options['title']) && $title_show === "1" && $title_position === "1") {
                        $html .= '<div class="uk-card-header">';
                            $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title');
                        $html .= '</div>';
                    }
                    if (!empty($options['badge_text'])) {
                        $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                    }
                    if (!empty($options['content'])) {
                        $html .= '<div class="uk-card-body' . $card_body_class . '">';
                        $html .= $options['content'];
                        $html .= '</div>';
                    }
                }
                if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
                    $html .= '<div class="uk-card-footer' . $button_alignment . '">';
                    if (!empty($options['button_url'])) {
                        $html .= '<a href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                    } else {
                        $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                    }
                    if (!empty($options['button_icon'])) {
                        $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
                    }
                    if (!empty($options['button_text'])) {
                        $html .= $options['button_text'];
                    }
                    $html .= '</a>';
                    $html .= '</div>';
                }

                if ($card_image_height !== ' ') {
                    $html .= '<div class="uk-card-media-bottom uk-cover-container' . $card_image_height . '" itemscope itemtype="https://schema.org/ImageObject" >';
                        $html .= '<img itemprop="contentUrl"' . $image_output . $options['image_alt_text'] . ' uk-cover="" uk-img="" />';

                    if (!empty($image_creator) && !empty($options['image'])) {
                        $html .= '<span itemprop="creator" itemtype="https://schema.org/Person" itemscope>';
                        $html .= '<meta itemprop="name" content="' . $image_creator . '" />';
                        $html .= '</span>';
                    }

                    $html .= '</div>';
                }
                $html .= '</div>';
                break;

            case 'left':
                $html .= '<div class="uk-card' . $card_class . $custom_class . ' uk-grid-collapse uk-child-width-1-2@s uk-grid-match" uk-grid="">';
                if ($card_image_height !== '') {
                    $html .= '<div class="uk-card-media-left uk-cover-container" itemscope itemtype="https://schema.org/ImageObject" >';
                        $html .= '<img itemprop="contentUrl"' . $image_output . $options['image_alt_text'] . ' uk-img="" uk-cover="" />';

                    if (!empty($image_creator) && !empty($options['image'])) {
                        $html .= '<span itemprop="creator" itemtype="https://schema.org/Person" itemscope>';
                            $html .= '<meta itemprop="name" content="' . $image_creator . '" />';
                        $html .= '</span>';
                    }

                        $html .= '<canvas width="300" height="200"></canvas>';
                        $html .= '</div>';
                }
                $html .= '<div>';
                if ($title_position === "0") {
                    if (!empty($options['badge_text'])) {
                        $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                    }
                    $html .= '<div class="uk-card-body' . $card_body_class . '">';
                    if (!empty($options['title']) && $title_show === "1") {
                        $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title');
                    }
                    if (!empty($options['content'])) {
                        $html .= $options['content'];
                    }
                    $html .= '</div>';
                } else {
                    if (!empty($options['title']) && $title_show === "1" && $title_position === "1") {
                        $html .= '<div class="uk-card-header">';
                            $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title');
                        $html .= '</div>';
                    }
                    if (!empty($options['badge_text'])) {
                        $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                    }
                    if (!empty($options['content'])) {
                        $html .= '<div class="uk-card-body' . $card_body_class . '">';
                        $html .= $options['content'];
                        $html .= '</div>';
                    }
                }
                if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
                    $html .= '<div class="uk-card-footer' . $button_alignment . '">';
                    if (!empty($options['button_url'])) {
                        $html .= '<a href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                    } else {
                        $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                    }
                    if (!empty($options['button_icon'])) {
                        $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
                    }
                    if (!empty($options['button_text'])) {
                        $html .= $options['button_text'];
                    }
                    $html .= '</a>';
                    $html .= '</div>';
                }
                $html .= '</div>';
                $html .= '</div>';
                break;
            case 'right':
                $html .= '<div class="uk-card' . $card_class . $custom_class . ' uk-grid-collapse uk-child-width-1-2@s uk-grid-match" uk-grid="">';

                if ($card_image_height !== '') {
                    $html .= '<div class="uk-flex-last@s uk-card-media-right uk-cover-container" itemscope itemtype="https://schema.org/ImageObject" >';
                        $html .= '<img itemprop="contentUrl"' . $image_output . $options['image_alt_text'] . ' uk-img="" uk-cover="" />';

                    if (!empty($image_creator) && !empty($options['image'])) {
                            $html .= '<span itemprop="creator" itemtype="https://schema.org/Person" itemscope>';
                                $html .= '<meta itemprop="name" content="' . $image_creator . '" />';
                            $html .= '</span>';
                    }

                        $html .= '<canvas width="300" height="200"></canvas>';
                    $html .= '</div>';
                }

                $html .= '<div>';
                if ($title_position === "0") {
                    if (!empty($options['badge_text'])) {
                        $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                    }
                    $html .= '<div class="uk-card-body' . $card_body_class . '">';
                    if (!empty($options['title']) && $title_show === "1") {
                        $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title');
                    }
                    if (!empty($options['content'])) {
                        $html .= $options['content'];
                    }
                    $html .= '</div>';
                } else {
                    if (!empty($options['title']) && $title_show === "1" && $title_position === "1") {
                        $html .= '<div class="uk-card-header">';
                            $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'uk-card-title');
                        $html .= '</div>';
                    }
                    if (!empty($options['badge_text'])) {
                        $html .= '<div class="uk-card-badge uk-label">' . $options['badge_text'] . '</div>';
                    }
                    if (!empty($options['content'])) {
                        $html .= '<div class="uk-card-body' . $card_body_class . '">';
                            $html .= $options['content'];
                        $html .= '</div>';
                    }
                }
                if ((!empty($options['button_text']) || !empty($options['button_icon'])) && (!empty($options['button_url']) || !empty($options['button_menulist']))) {
                    $html .= '<div class="uk-card-footer' . $button_alignment . '">';
                    if (!empty($options['button_url'])) {
                        $html .= '<a href="' . $options['button_url'] . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                    } else {
                        $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['button_target'] . '" class="' . $button_class . '">';
                    }
                    if (!empty($options['button_icon'])) {
                        $html .= '<i class="uk-margin-small-right ' . $options['button_icon'] . '"></i>';
                    }
                    if (!empty($options['button_text'])) {
                        $html .= $options['button_text'];
                    }
                    $html .= '</a>';
                    $html .= '</div>';
                }
                $html .= '</div>';
                $html .= '</div>';
                break;
        }
    }
}

echo $html;
