<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');

use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                    = '';
$options                 = SitePageHelper::escapeHtmlArray($displayData['options']);
$items                   = $displayData['items'];
$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$list_style_class = '';
$leader_attr      = '';

$list_styles = ($options['list_styles'] ?? 0);

// List large-modifier
if (!empty($options['list_style_large'])) {
    $list_style_class = ' ' . $options['list_style_large'];
}
// List Bullet/Disc, Divider, Striped, Square, Decimal or Hyphen modifier
if (!empty($options['list_style'])) {
    $list_style_class .= ' ' . $options['list_style'];
}// List color modifier
if (!empty($options['list_style_color_modifiers'])) {
    $list_style_class .= ' ' . $options['list_style_color_modifiers'];
}
// Description List Divider
if (!empty($options['description_list_style'])) {
    $description_list_style_class = ' ' . $options['description_list_style'];
} else {
    $description_list_style_class = '';
}
// Leader options
if (!empty($options['leader_style'])) {
    $leader_attr .= 'fill: ' . $options['leader_style'] . ';';
}
if (!empty($options['leader_style_media'])) {
    $leader_attr .= 'media: ' . $options['leader_style_media'] . ';';
}

$leader = ' uk-leader="' . $leader_attr . '"';

// Build List HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-list-title');
}

switch ($list_styles) {
    // Default List
    case '0':
        $html .= '<ul class="uk-list' . $list_style_class . '">';
        if (count($items)) {
            foreach ($items as $item_index => $item) {
                $item_options = SitePageHelper::escapeHtmlArray($item['options']);

                // List item style
                if (!empty($item_options['item_content'])) {
                    // Build List item HTML
                    $html .= '<li>' . $item_options['item_content'] . '</li>';
                }
            }
        }
        $html .= '</ul>';
        break;
    // Description List
    case '1':
        $html .= '<dl class="uk-description-list' . $description_list_style_class . '">';
        if (count($items)) {
            foreach ($items as $item_index => $item) {
                $item_options = SitePageHelper::escapeHtmlArray($item['options']);

                // List item style
                if (!empty($item_options['item_content'])) {
                    // Build List item HTML
                    $html .= '<dt>' . $item_options['item_content'] . '</dt>';
                }
                if (!empty($item_options['item_description_content'])) {
                    // Build List item HTML
                    $html .= '<dd>' . $item_options['item_description_content'] . '</dd>';
                }
            }
        }
        $html .= '</dl>';
        break;
    // Leader List
    case '2':
        if (count($items)) {
            foreach ($items as $item_index => $item) {
                $item_options = SitePageHelper::escapeHtmlArray($item['options']);

                $html .= '<div class="' . $options['grid_gutter'] . '" uk-grid="">';

                // Leader item style
                if (!empty($item_options['item_content'])) {
                    // Build List item HTML
                    $html .= '<div class="uk-width-expand"' . $leader . '>' . $item_options['item_content'] . '</div>';
                }
                if (!empty($item_options['item_description_content'])) {
                    // Build List item HTML
                    $html .= '<div>' . $item_options['item_description_content'] . '</div>';
                }

                $html .= '</div>';
            }
        }
        break;
}

echo $html;
