<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html        = '';
$options     = SitePageHelper::escapeHtmlArray($displayData['options']);
$child_width = '';

$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$id     = (isset($options['flickr-id']) && $options['flickr-id']) ? $options['flickr-id'] : '92369075@N07';
$count  = $options['flickr-image-count'];
$images = SitePageHelper::getFlickrImages($id, $count);

$masonry_grid_style = ($options['masonry_grid_style'] ?? 0);
$description_show   = ($options['description_show'] ?? 0);


// Responsive Grid Settings
if (!empty($options['grid_m'])) {
    $child_width .= ' uk-child-width-' . $options['grid_m'] . '@m';
}
if (!empty($options['grid_l'])) {
    $child_width .= ' uk-child-width-' . $options['grid_l'] . '@l';
}
if (!empty($options['grid_xl'])) {
    $child_width .= ' uk-child-width-' . $options['grid_xl'] . '@xl';
}

// Masonry Grid
if ($masonry_grid_style == 1) {
    $grid = ' uk-grid="masonry: true"';
} else {
    $grid = ' uk-grid=""';
}

// Overlay style
if (!empty($options['image_overlay_style'])) {
    $overlay_class = ' ' . $options['image_overlay_style'];
} else {
    $overlay_class = '';
}
if (!empty($options['image_overlay_position'])) {
    $overlay_position = ' ' . $options['image_overlay_position'];
} else {
    $overlay_position = '';
}

// Build Flickr HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-flickr-title');
}

if (Factory::getApplication()->isClient('site')) {
    if ($description_show == 1) {
        $html .= '<ul class="' . $options['grid_gutter'] . ' uk-child-width-1-1' . $child_width . '"' . $grid . '>';
    } else {
        $html .= '<ul class="' . $options['grid_gutter'] . ' uk-child-width-1-1' . $child_width . '"' . $grid . ' uk-lightbox="animation: slide">';
    }
} else {
    $html .= '<ul class="' . $options['grid_gutter'] . ' uk-child-width-1-1' . $child_width . '"' . $grid . '>';
}
for ($i = 0; $i < $count; $i++) {
    [$width, $height] = getimagesize(str_replace('_m', '_q', $images[$i]->media->m));
    $description = $images[$i]->description;

    $html .= '<li>';
    if ($description_show == 1) {
        $html .= '<div>' . $description . '</div>';
    } else {
        $html .= '<div class="uk-inline">';
            $html .= '<picture itemscope itemtype="https://schema.org/ImageObject">';
                $html .= '<img itemprop="contentUrl" data-src="' . str_replace('_m', '_q', $images[$i]->media->m) . '" alt="' . $images[$i]->title . '" width="' . $width . '" height="' . $height . '" uk-img="" />';
                $html .= '<span itemprop="acquireLicensePage" class="uk-hidden" hidden="">' . htmlspecialchars($images[$i]->link, ENT_QUOTES) . '</span>';
                $html .= '<span itemprop="creator" itemtype="https://schema.org/Person" itemscope>';
                    $html .= '<meta itemprop="name" content="' . htmlspecialchars($images[$i]->author, ENT_QUOTES) . ', ID: ' . htmlspecialchars($images[$i]->author_id, ENT_QUOTES) . '" />';
                $html .= '</span>';
            $html .= '</picture>';
            $html .= '<div class="uk-overlay' . $overlay_position . $overlay_class . ' uk-text-truncate uk-padding-small">';
        if (Factory::getApplication()->isClient('site')) {
            $html .= '<a class="uk-link-text uk-text-small" href="' . str_replace('_m', '_b', $images[$i]->media->m) . '" data-caption="' . $images[$i]->title . ', Flickr Author ID: ' . htmlspecialchars($images[$i]->author_id, ENT_QUOTES) . '">' . $images[$i]->title . '</a>';
        } else {
            $html .= '<a class="uk-link-text uk-text-small" href="javascript:void(0)" target="_blank">' . $images[$i]->title . '</a>';
        }
                $html .= '</div>';
                $html .= '</div>';
    }
    $html .= '</li>';
}
$html .= '</ul>';

echo $html;
