<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Language\Text;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html    = '';
$options = SitePageHelper::escapeHtmlArray($displayData['options']);

$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$countdown_label_show     = ($options['countdown_label_show'] ?? 1);
$countdown_separator_show = ($options['countdown_separator_show'] ?? 1);
$countdown_height         = (isset($options['countdown_height']) ? ' uk-height' . $options['countdown_height'] : '');


// Build Countdown HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-countdown-title');
}

if (!empty($options['countdown_time'])) {
    $countdown_time = new JDate($options['countdown_time']);

    $html .= '<div class="uk-flex' . $countdown_height . '">';

    $html .= '<div class="uk-margin-auto' . $options['countdown_alignment'] . ' uk-margin-auto-vertical uk-width-auto">';

    $html .= '<div class="uk-grid-small uk-child-width-auto" uk-grid="" uk-countdown="date: ' . $countdown_time . '">';
    $html .= '<div>';
    $html .= '<div class="uk-countdown-number uk-countdown-days"></div>';
    if ($countdown_label_show === "1") {
        $html .= '<div class="uk-countdown-label uk-margin-small uk-text-center uk-visible@s">' . Text::_('COM_UITHEMEBUILDERLITE_DAYS') . '</div>';
    }
    $html .= '</div>';
    if ($countdown_separator_show === "1" && (!empty($options['countdown_separator']))) {
        $html .= '<div class="uk-countdown-separator">' . $options['countdown_separator'] . '</div>';
    }
    $html .= '<div>';
    $html .= '<div class="uk-countdown-number uk-countdown-hours"></div>';
    if ($countdown_label_show === "1") {
        $html .= '<div class="uk-countdown-label uk-margin-small uk-text-center uk-visible@s">' . Text::_('COM_UITHEMEBUILDERLITE_HOURS') . '</div>';
    }
    $html .= '</div>';
    if ($countdown_separator_show === "1" && (!empty($options['countdown_separator']))) {
        $html .= '<div class="uk-countdown-separator">' . $options['countdown_separator'] . '</div>';
    }
    $html .= '<div>';
    $html .= '<div class="uk-countdown-number uk-countdown-minutes"></div>';
    if ($countdown_label_show === "1") {
        $html .= '<div class="uk-countdown-label uk-margin-small uk-text-center uk-visible@s">' . Text::_('COM_UITHEMEBUILDERLITE_MINUTES') . '</div>';
    }
    $html .= '</div>';
    if ($countdown_separator_show === "1" && (!empty($options['countdown_separator']))) {
        $html .= '<div class="uk-countdown-separator">' . $options['countdown_separator'] . '</div>';
    }
    $html .= '<div>';
    $html .= '<div class="uk-countdown-number uk-countdown-seconds"></div>';
    if ($countdown_label_show === "1") {
        $html .= '<div class="uk-countdown-label uk-margin-small uk-text-center uk-visible@s">' . Text::_('COM_UITHEMEBUILDERLITE_SECONDS') . '</div>';
    }
    $html .= '</div>';
    $html .= '</div>';
    $html .= '</div>';
    $html .= '</div>';
} else {
    // Preview no Date
    $html .= '<div class="uk-flex uk-height' . $options['countdown_height'] . '">';

    $html .= '<div class="uk-margin-auto' . $options['countdown_alignment'] . ' uk-margin-auto-vertical uk-width-auto">';

    $html .= '<div class="uk-grid-small uk-child-width-auto" uk-grid="" ui-countdown="">';
    $html .= '<div>';
    $html .= '<div class="uk-countdown-number uk-countdown-days"></div>';
    if ($countdown_label_show === "1") {
        $html .= '<div class="uk-countdown-label uk-margin-small uk-text-center uk-visible@s">' . Text::_('COM_UITHEMEBUILDERLITE_DAYS') . '</div>';
    }
    $html .= '</div>';
    if ($countdown_separator_show === "1" && (!empty($options['countdown_separator']))) {
        $html .= '<div class="uk-countdown-separator">' . $options['countdown_separator'] . '</div>';
    }
    $html .= '<div>';
    $html .= '<div class="uk-countdown-number uk-countdown-hours"></div>';
    if ($countdown_label_show === "1") {
        $html .= '<div class="uk-countdown-label uk-margin-small uk-text-center uk-visible@s">' . Text::_('COM_UITHEMEBUILDERLITE_HOURS') . '</div>';
    }
    $html .= '</div>';
    if ($countdown_separator_show === "1" && (!empty($options['countdown_separator']))) {
        $html .= '<div class="uk-countdown-separator">' . $options['countdown_separator'] . '</div>';
    }
    $html .= '<div>';
    $html .= '<div class="uk-countdown-number uk-countdown-minutes"></div>';
    if ($countdown_label_show === "1") {
        $html .= '<div class="uk-countdown-label uk-margin-small uk-text-center uk-visible@s">' . Text::_('COM_UITHEMEBUILDERLITE_MINUTES') . '</div>';
    }
    $html .= '</div>';
    if ($countdown_separator_show === "1" && (!empty($options['countdown_separator']))) {
        $html .= '<div class="uk-countdown-separator">' . $options['countdown_separator'] . '</div>';
    }
    $html .= '<div>';
    $html .= '<div class="uk-countdown-number uk-countdown-seconds"></div>';
    if ($countdown_label_show === "1") {
        $html .= '<div class="uk-countdown-label uk-margin-small uk-text-center uk-visible@s">' . Text::_('COM_UITHEMEBUILDERLITE_SECONDS') . '</div>';
    }
    $html .= '</div>';
    $html .= '</div>';
    $html .= '</div>';
    $html .= '</div>';
    $html .= '<script>';
    $html .= 'UIkit.countdown("[ui-countdown]", {date: (new Date(Date.now() + 864e5 * 7)).toISOString()});';
    $html .= '</script>';
}

echo $html;
