<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Router\Route;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html         = '';
$options      = SitePageHelper::escapeHtmlArray($displayData['options']);
$button_class = 'uk-button';
$id           = $options['button_menulist'];

$title_show              = ($options['title_show'] ?? 1);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];
$button_full_width       = ($options['button_full_width'] ?? 0);

$button_title = (!empty($options['button_text']) ? ' title="' . $options['button_text'] . '"' : '');


// Button settings
if (!empty($options['text_font_weight'])) {
    $button_class .= ' ' . $options['text_font_weight'];
}
if (!empty($options['button_size'])) {
    $button_class .= ' uk-button-' . $options['button_size'];
}
if (!empty($options['button_type'])) {
    $button_class .= ' uk-button-' . $options['button_type'];
}
if ($button_full_width === "1") {
    $button_class .= ' uk-width-1-1';
}
// Build Button HTML
if (!empty($options['title']) && $title_show === "1") {
    $html .= SitePageHelper::setTitle($options['title_heading'], trim($title_class), $options['title'], 'ui-button-title');
}

if ($options['alignment'] === 'uk-text-center') {
    $html .= '<div class="uk-flex uk-flex-center">';
} elseif ($options['alignment'] === 'uk-text-right') {
    $html .= '<div class="uk-flex uk-flex-right">';
}

// Default Button
$html .= '<a' . $button_title . ' class="' . $button_class . '"';
if (!empty($options['button_url'])) {
    $html .= ' href="' . $options['button_url'] . '"';
} else {
    $html .= ' href="' . Route::_("index.php?Itemid={$id}") . '"';
}
if (!empty($options['button_target'])) {
    $html .= 'target="' . $options['button_target'] . '"';
}
$html .= '>';
if (!empty($options['icon'])) {
    $html .= '<i class="uk-margin-small-right ' . $options['icon'] . '"></i>';
}
if (!empty($options['button_text'])) {
    $html .= $options['button_text'];
}
$html .= '</a>';

if ($options['alignment'] === 'uk-text-center' || $options['alignment'] === 'uk-text-right') {
    $html .= '</div>';
}

echo $html;
