<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\UserFactoryInterface;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$html                        = '';
$options                     = SitePageHelper::escapeHtmlArray($displayData['options']);
$button_class                = 'uk-button';
$child_width                 = '';
$id                          = $options['article_button_menulist'];
$article_catid               = $options['article_catid'];
$article_limit               = $options['article_limit'];
$article_ordering            = $options['article_ordering'];
$tagid                       = $options['article_tag_list'];
$filter_tags                 = array ();
$article_sub_nav_color_style = '';

$title_show              = ($options['title_show'] ?? 0);
$titleAndSubtitleClasses = SitePageHelper::getTitleAndSubtitleClasses($options);
$title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];

$include_subcat        = ($options['include_subcat'] ?? 0);
$article_post_format   = ($options['article_post_format'] ?? 2);
$article_use_filter    = ($options['article_use_filter'] ?? 0);
$article_sub_nav_style = ($options['article_sub_nav_style'] ?? 1);
$article_resource      = ($options['article_resource'] ?? 1);

$article_slider_center         = ($options['article_slider_center'] ?? 1);
$article_slider_autoplay       = ($options['article_slider_autoplay'] ?? 1);
$article_slider_pause_on_hover = ($options['article_slider_pause_on_hover'] ?? 1);

$article_grid_match       = ($options['article_grid_match'] ?? 0);
$article_controls_outside = ($options['article_controls_outside'] ?? 0);

$article_autor_show    = ($options['article_autor_show'] ?? 0);
$article_date_show     = ($options['article_date_show'] ?? 1);
$article_category_show = ($options['article_category_show'] ?? 1);
$article_use_autor_img = ($options['article_use_autor_img'] ?? 0);
$article_intro_show    = ($options['article_intro_show'] ?? 1);
$article_tag_show      = ($options['article_tag_show'] ?? 0);
$article_read_more     = ($options['article_read_more'] ?? 0);
$article_link          = ($options['article_link'] ?? 1);


// Read more button
if ((!empty($options['article_button_text']) || !empty($options['article_button_icon'])) && (!empty($options['article_button_url']) || !empty($options['article_button_menulist']))) {
    if (!empty($options['article_button_type'])) {
        $button_class .= ' uk-button-' . $options['article_button_type'];
    }
    if (!empty($options['article_button_size'])) {
        $button_class .= ' uk-button-' . $options['article_button_size'];
    }
}
// Responsive Grid Settings
if (!empty($options['article_grid_settings_m'])) {
    $child_width .= ' uk-child-width-' . $options['article_grid_settings_m'] . '@m';
}
if (!empty($options['article_grid_settings_l'])) {
    $child_width .= ' uk-child-width-' . $options['article_grid_settings_l'] . '@l';
}
if (!empty($options['article_grid_settings_xl'])) {
    $child_width .= ' uk-child-width-' . $options['article_grid_settings_xl'] . '@xl';
}
// Filter by Tags
if (!empty($options['article_filter_tags']) && $article_use_filter === "1") {
    $tmp_tags    = explode(',', $options['article_filter_tags']);
    $filter_tags = array_merge($filter_tags, $tmp_tags);
    $filter_tags = array_map('trim', $filter_tags);
    $filter_tags = array_unique($filter_tags);
    ksort($filter_tags);
    $filter_tags = array_combine(range(1, count($filter_tags)), $filter_tags);
    // Filter Nav Color Style
    if (!empty($options['article_sub_nav_color_style'])) {
        $article_sub_nav_color_style = ' ' . $options['article_sub_nav_color_style'];
    }
}
// Filter Subnav Style
if ($article_sub_nav_style) {
    $subnav_style = ' uk-subnav-divider';
} else {
    $subnav_style = ' uk-subnav-pill';
}
// Site view
if (Factory::getApplication()->isClient('site')) {
    $items = SitePageHelper::getArticles($article_limit, $article_ordering, $article_catid, $include_subcat, $tagid);

    if (!empty($options['title']) && $title_show === "1") {
        $html .= '<' . $options['title_heading'] . ' class="ui-article-title' . $title_class . '">';
            $html .= '<span>' . $options['title'] . '</span>';
        $html .= '</' . $options['title_heading'] . '>';
    }

    if (!count($items)) {
        $html .= '<div class="uk-alert-danger" uk-alert=""><a class="uk-alert-close" uk-close></a><p>' . Text::_('COM_UITHEMEBUILDERLITE_NO_ARTICLES_FOUND') . '</p></div>';
    } else {
        switch ($article_post_format) {
            // Article Card Post
            case '0':
                if ($article_use_filter === "1" && $article_resource === "1") {
                    $html .= '<div uk-filter="target: .ui-article-filter">';
                    if (!empty($filter_tags)) {
                        $html .= '<div class="uk-flex uk-flex-' . $options['article_nav_alignment'] . ' uk-flex-middle uk-height-small' . $article_sub_nav_color_style . '">';
                            $html .= '<ul class="uk-subnav' . $subnav_style . '">'; // Filter SubNav
                                $html .= '<li class="uk-active" uk-filter-control><a href="#">' . Text::_('COM_UITHEMEBUILDERLITE_ALL') . '</a></li>';
                        foreach ($filter_tags as $i => $tag) {
                            $html .= '<li uk-filter-control="[data-tags*=\'' . $tag . '\']"><a href="#">' . $tag . '</a></li>';
                        }
                            $html .= '</ul>';
                        $html .= '</div>';
                    }
                }
                if ($article_use_filter === "1" && $article_resource === "1") {
                    $html .= '<div class="ui-article-filter uk-child-width-1-1' . $child_width . ' ' . $options['article_grid_gutter'] . ' uk-flex-' . $options['article_alignment'] . '" uk-grid="">';
                } else {
                    $html .= '<div class="uk-child-width-1-1' . $child_width . ' ' . $options['article_grid_gutter'] . ' uk-flex-' . $options['article_alignment'] . '" uk-grid="">';
                }
                if ($article_use_autor_img === "1") {
                    $image_root                     = Uri::root(true) . '/';
                    $options['article_autor_image'] = ' data-src="' . $image_root . $options['article_autor_image'] . '"';
                }
                foreach ($items as $key => $item) {
                    $JHelper        = new JHelperTags();
                    $itemTags       = $JHelper->getItemTags('com_content.article', $item->id);
                    $tagLayout      = new FileLayout('joomla.content.tags_vertical');
                    $data_taglayout = new FileLayout('joomla.content.tags_class');
                    $user   = Factory::getContainer()->get(UserFactoryInterface::class)->loadUserById($item->created_by);


                    // Joomla Tags
                    if (!empty($itemTags)) {
                        $tags      = $tagLayout->render($itemTags);
                        $data_tags = ' data-tags="' . $data_taglayout->render($itemTags) . '"';
                    } else {
                        $tags      = '';
                        $data_tags = '';
                    }
                    $html .= '<div' . $data_tags . '>';
                    $html .= '<div itemprop="blogPost" itemscope="" itemtype="https://schema.org/BlogPosting" class="uk-card uk-card-' . $options['article_card_style'] . '">';
                    if ($article_autor_show === "1" || $article_date_show === "1" || $article_category_show === "1") {
                        $author = ($item->created_by_alias ?: $user->username);
                        $html   .= '<div class="uk-card-header">';
                        $html   .= '<div class="uk-grid-small uk-flex-middle" uk-grid="">';
                        $html   .= '<div class="uk-width-auto">';
                        if ($article_use_autor_img === "1") {
                            $html .= '<img class="uk-border-circle" uk-tooltip="title:' . $author . '; pos: bottom;" width="40" height="40" ' . $options['article_autor_image'] . ' uk-img="">';
                        } else {
                            $html .= '<span uk-icon="icon: user; ratio: 2.5" uk-tooltip="title:' . $author . '; pos: bottom;"></span>';
                        }
                        $html .= '</div>';
                        $html .= '<div class="uk-width-expand">';
                        if ($article_date_show === "1" || $article_category_show === "1") {
                            $html .= '<h3 itemprop="headline" class="uk-card-title uk-margin-remove-bottom">' . $item->title . '</h3>';
                        } else {
                            $html .= '<h3 itemprop="headline" class="uk-card-title">' . $item->title . '</h3>';
                        }
                        if ($article_date_show === "1" || $article_category_show === "1") {
                            $html .= '<p class="uk-text-meta uk-margin-remove-top">';
                            if ($article_date_show === "1" && $article_category_show === "1") {
                                $html .= '<time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>,';
                                $html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="' . $item->category_link . '">' . $item->category . '</a>.';
                            } else {
                                if ($article_date_show === "1") {
                                    $html .= '<time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>';
                                }
                                if ($article_category_show === "1") {
                                    $html .= Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="' . $item->category_link . '">' . $item->category . '</a>.';
                                }
                            }
                            $html .= '</p>';
                        }
                        $html .= '</div>';
                        $html .= '</div>';
                    } else {
                        $html .= '<div class="uk-card-header">';
                        if ($article_date_show === "1" || $article_category_show === "1") {
                            $html .= '<h3 itemprop="headline" class="uk-card-title uk-margin-remove-bottom">' . $item->title . '</h3>';
                        } else {
                            $html .= '<h3 itemprop="headline" class="uk-card-title">' . $item->title . '</h3>';
                        }
                        if ($article_date_show === "1" || $article_category_show === "1") {
                            $html .= '<p class="uk-text-meta uk-margin-remove-top">';
                            if ($article_date_show === "1" && $article_category_show === "1") {
                                $html .= '<time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>,';
                                $html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="' . $item->category_link . '">' . $item->category . '</a>.';
                            } else {
                                if ($article_date_show === "1") {
                                    $html .= '<time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>';
                                }
                                if ($article_category_show === "1") {
                                    $html .= Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="' . $item->category_link . '">' . $item->category . '</a>.';
                                }
                            }
                            $html .= '</p>';
                        }
                    }
                    $html .= '</div>';
                    // Joomla Article
                    if (isset($item->image_thumbnail) && $item->image_thumbnail) {
                        $html .= '<div class="uk-card-media-top uk-cover-container uk-height-medium">';
                        $html .= '<meta itemprop="image" content="' . $item->image_thumbnail . '" />';
                        $html .= '<img data-src="' . $item->image_thumbnail . '" alt="' . $item->imageAlt . '" itemprop="thumbnailUrl" uk-img="" uk-cover="">';
                        $html .= '</div>';
                    }
                    // Content with tags... only Joomla! Articles
                    if ($article_intro_show === "1") {
                        $html .= '<div class="uk-card-body">';
                        if ($article_tag_show === "1" && $tags && $article_resource === "1") {
                            $html .= '<div class="uk-grid-small" uk-grid="">';
                            $html .= '<div class="uk-width-auto uk-position-relative">';
                            $html .= '<span class="rotate-tm-tags rotate-up-tm-tags uk-position-absolute uk-flex">' . $tags . '</span>';
                            $html .= '</div>';
                            $html .= '<div class="uk-width-expand">';
                            if ($options['article_intro_limit'] === "0") {
                                $html .= $item->introtext;
                            } else {
                                // $html .= SitePageHelper::limit_item_introtext($item->introtext, $options['article_intro_limit']) . '[...]';
                                $html .= mb_substr($item->introtext, 0, $options['article_intro_limit'], 'UTF-8') . '...';
                            }
                            $html .= '</div>';
                            $html .= '</div>';
                        } elseif ($options['article_intro_limit'] === "0") {
                            $html .= $item->introtext;
                        } else {
                            // $html .= SitePageHelper::limit_item_introtext($item->introtext, $options['article_intro_limit']) . '[...]';
                            $html .= mb_substr($item->introtext, 0, $options['article_intro_limit'], 'UTF-8') . '...';
                        }
                        $html .= '</div>';
                    }
                    if ($article_read_more === "1") {
                        $html .= '<div class="uk-card-footer">';
                        if ((!empty($options['article_button_text']) || !empty($options['article_button_icon'])) && (!empty($options['article_button_url']) || !empty($options['article_button_menulist']))) {
                            if ($options['article_button_target'] === 'lightbox') {
                                // Link open in Lightbox
                                $html .= '<div uk-lightbox>';
                                if ($article_link === "1") {
                                    $html .= '<a href="' . $item->link . '" class="' . $button_class . '" data-type="iframe" data-caption="' . $item->title . '">';
                                } else {
                                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" class="' . $button_class . '" data-type="iframe" data-caption="' . $item->title . '">';
                                }
                                if (!empty($options['article_button_icon'])) {
                                    $html .= '<i class="uk-margin-small-right ' . $options['article_button_icon'] . '"></i>';
                                }
                                if (!empty($options['article_button_text'])) {
                                    $html .= $options['article_button_text'];
                                }
                                $html .= '</a>';
                                $html .= '</div>';
                            } else {
                                if ($article_link === "1") {
                                    $html .= '<a href="' . $item->link . '" target="' . $options['article_button_target'] . '" class="' . $button_class . '">';
                                } else {
                                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['article_button_target'] . '" class="' . $button_class . '">';
                                }
                                if (!empty($options['article_button_icon'])) {
                                    $html .= '<i class="uk-margin-small-right ' . $options['article_button_icon'] . '"></i>';
                                }
                                if (!empty($options['article_button_text'])) {
                                    $html .= $options['article_button_text'];
                                }
                                $html .= '</a>';
                            }
                        }
                        $html .= '</div>';
                    }
                    $html .= '</div>';
                    $html .= '</div>';
                }
                $html .= '</div>';
                if ($article_use_filter === "1" && $article_resource === "1") {
                    $html .= '</div>';
                }
                break;
            // Slider Content (Cards) Post
            case '1':
                // Slider center options
                // $options['article_slider_center'] === "1"
                if ($article_slider_center) {
                    $center = ' center: true;';
                } else {
                    $center = '';
                }
                // Slider autoplay options
                // $options['article_slider_autoplay'] === "1"
                if ($article_slider_autoplay) {
                    $autoplay = ' autoplay: true;';
                } else {
                    $autoplay = '';
                }
                // Slider autoplay interval options
                // $options['article_slider_autoplay'] === "1"
                if ($article_slider_autoplay && !empty($options['article_slider_autoplay_interval'])) {
                    $autoplay_interval = ' autoplay-interval: ' . $options['article_slider_autoplay_interval'] . ';';
                } else {
                    $autoplay_interval = '';
                }
                // Slider autoplay pause on hover
                // $options['article_slider_autoplay'] === "1"
                // $options['article_slider_pause_on_hover'] === "1"
                if ($article_slider_autoplay && $article_slider_pause_on_hover) {
                    $autoplay_pause_on_hover = ' pause-on-hover: true;';
                } else {
                    $autoplay_pause_on_hover = '';
                }
                // item color style
                if (!empty($options['article_slider_color_style'])) {
                    $color_style = ' ' . $options['article_slider_color_style'];
                } else {
                    $color_style = '';
                }
                // $options['article_grid_match'] === "1"
                if ($article_grid_match) {
                    $grid_match_class = ' uk-grid-match';
                } else {
                    $grid_match_class = '';
                }
                $html .= '<div uk-slider="' . $center . $autoplay . $autoplay_pause_on_hover . '">';
                $html .= '<div class="uk-position-relative uk-visible-toggle' . $color_style . '">';
                // $options['article_controls_outside'] === "1"
                if ($article_controls_outside === "1") {
                    $html .= '<div class="uk-slider-container uk-padding-small uk-padding-remove-horizontal">';
                } else {
                    $html .= '<div class="uk-padding-small uk-padding-remove-horizontal">';
                }
                $html .= '<ul class="uk-slider-items uk-margin uk-child-width-1-1' . $child_width . ' ' . $options['article_grid_gutter'] . $grid_match_class . '" uk-grid="">';
                foreach ($items as $key => $item) {
                    $JHelper   = new JHelperTags();
                    $itemTags  = $JHelper->getItemTags('com_content.article', $item->id);
                    $tagLayout = new FileLayout('joomla.content.tags');
                    $user   = Factory::getContainer()->get(UserFactoryInterface::class)->loadUserById($item->created_by);


                    // Joomla Tags
                    if (!empty($itemTags)) {
                        $tags = $tagLayout->render($itemTags);
                    } else {
                        $tags = '';
                    }
                    $html .= '<li>';
                    $html .= '<div itemprop="blogPost" itemscope="" itemtype="https://schema.org/BlogPosting" class="uk-card uk-card-' . $options['article_card_style'] . '">';
                    if ($article_autor_show === "1") {
                        $author = ($item->created_by_alias ?: $user->username);

                        $html .= '<div class="uk-card-header">';
                        $html .= '<div class="uk-grid-small uk-flex-middle" uk-grid="">';
                        $html .= '<div class="uk-width-auto">';
                        if ($article_use_autor_img === "1") {
                            $html .= '<img class="uk-border-circle" uk-tooltip="title:' . $author . '; pos: bottom;" width="40" height="40" ' . $options['article_autor_image'] . ' uk-img="">';
                        } else {
                            $html .= '<span uk-icon="icon: user; ratio: 2.5" uk-tooltip="title:' . $author . '; pos: bottom;"></span>';
                        }
                        $html .= '</div>';
                        $html .= '<div class="uk-width-expand">';
                        if ($article_date_show === "1") {
                            $html .= '<h3 itemprop="headline" class="uk-card-title uk-margin-remove-bottom">' . $item->title . '</h3>';
                        } else {
                            $html .= '<h3 itemprop="headline" class="uk-card-title">' . $item->title . '</h3>';
                        }
                        if ($article_date_show === "1" || $article_category_show === "1") {
                            $html .= '<p class="uk-text-meta uk-margin-remove-top">';
                            if ($article_date_show === "1" && $article_category_show === "1") {
                                $html .= '<time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>,';
                                $html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="' . $item->category_link . '">' . $item->category . '</a>.';
                            } else {
                                if ($article_date_show === "1") {
                                    $html .= '<time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>';
                                }
                                if ($article_category_show === "1") {
                                    $html .= Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="' . $item->category_link . '">' . $item->category . '</a>.';
                                }
                            }
                            $html .= '</p>';
                        }
                        $html .= '</div>';
                        $html .= '</div>';
                        $html .= '</div>';
                    } else {
                        $html .= '<div class="uk-card-header">';
                        if ($article_date_show === "1") {
                            $html .= '<h3 itemprop="headline" class="uk-card-title uk-margin-remove-bottom">' . $item->title . '</h3>';
                        } else {
                            $html .= '<h3 itemprop="headline" class="uk-card-title">' . $item->title . '</h3>';
                        }
                        if ($article_date_show === "1" || $article_category_show === "1") {
                            $html .= '<p class="uk-text-meta uk-margin-remove-top">';
                            if ($article_date_show === "1" && $article_category_show === "1") {
                                $html .= '<time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>,';
                                $html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="' . $item->category_link . '">' . $item->category . '</a>.';
                            } else {
                                if ($article_date_show === "1") {
                                    $html .= '<time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>';
                                }
                                if ($article_category_show === "1") {
                                    $html .= Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="' . $item->category_link . '">' . $item->category . '</a>.';
                                }
                            }
                            $html .= '</p>';
                        }
                        $html .= '</div>';
                    }
                    // Joomla Article Image
                    if (isset($item->image_thumbnail) && $item->image_thumbnail) {
                        $html .= '<div class="uk-card-media-top uk-cover-container uk-height-medium">';
                        $html .= '<meta itemprop="image" content="' . $item->image_thumbnail . '" />';
                        $html .= '<img data-src="' . $item->image_thumbnail . '" alt="' . $item->imageAlt . '" itemprop="thumbnailUrl" uk-img="" uk-cover="">';
                        $html .= '</div>';
                    }
                    // Content with tags... only Joomla! Articles
                    if ($article_intro_show === "1") {
                        $html .= '<div class="uk-card-body">';
                        if ($article_tag_show === "1" && $tags && $article_resource === "1") {
                            $html .= '<div class="uk-grid-small" uk-grid="">';
                            $html .= '<div class="uk-width-auto uk-position-relative">';
                            $html .= '<span class="rotate-tm-tags rotate-up-tm-tags uk-position-absolute uk-flex">' . $tags . '</span>';
                            $html .= '</div>';
                            $html .= '<div class="uk-width-expand">';
                            if ($options['article_intro_limit'] === "0") {
                                $html .= $item->introtext;
                            } else {
                                // $html .= SitePageHelper::limit_item_introtext($item->introtext, $options['article_intro_limit']) . '[...]';
                                $html .= mb_substr($item->introtext, 0, $options['article_intro_limit'], 'UTF-8') . '...';
                            }
                            $html .= '</div>';
                            $html .= '</div>';
                        } else {
                            if ($options['article_intro_limit'] === "0") {
                                $html .= $item->introtext;
                            } else {
                                // $html .= SitePageHelper::limit_item_introtext($item->introtext, $options['article_intro_limit']) . '[...]';
                                $html .= mb_substr($item->introtext, 0, $options['article_intro_limit'], 'UTF-8') . '...';
                            }
                        }
                        $html .= '</div>';
                    }
                    if ($article_read_more === "1") {
                        $html .= '<div class="uk-card-footer">';
                        if ((!empty($options['article_button_text']) || !empty($options['article_button_icon'])) && (!empty($options['article_button_url']) || !empty($options['article_button_menulist']))) {
                            if ($options['article_button_target'] === 'lightbox') {
                                // Link open in Lightbox
                                $html .= '<div uk-lightbox>';
                                if ($article_link === "1") {
                                    $html .= '<a href="' . $item->link . '" class="' . $button_class . '" data-type="iframe" data-caption="' . $item->title . '">';
                                } else {
                                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" class="' . $button_class . '" data-type="iframe" data-caption="' . $item->title . '">';
                                }
                                if (!empty($options['article_button_icon'])) {
                                    $html .= '<i class="uk-margin-small-right ' . $options['article_button_icon'] . '"></i>';
                                }
                                if (!empty($options['article_button_text'])) {
                                    $html .= $options['article_button_text'];
                                }
                                $html .= '</a>';
                                $html .= '</div>';
                            } else {
                                if ($article_link === "1") {
                                    $html .= '<a href="' . $item->link . '" target="' . $options['article_button_target'] . '" class="' . $button_class . '">';
                                } else {
                                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['article_button_target'] . '" class="' . $button_class . '">';
                                }
                                if (!empty($options['article_button_icon'])) {
                                    $html .= '<i class="uk-margin-small-right ' . $options['article_button_icon'] . '"></i>';
                                }
                                if (!empty($options['article_button_text'])) {
                                    $html .= $options['article_button_text'];
                                }
                                $html .= '</a>';
                            }
                        }
                        $html .= '</div>';
                    }
                    $html .= '</div>';
                    $html .= '</li>';
                }
                $html .= '</ul>';

                $html .= '</div>';

                if (!empty($options['article_show_controls']) && $options['article_show_controls'] === "1") {
                    if (!empty($options['article_controls_color_style'])) {
                        $color_style = ' ' . $options['article_controls_color_style'];
                    } else {
                        $color_style = '';
                    }
                    if ($options['article_nav_controls_large'] === "1") {
                        $slidenav_large = ' uk-slidenav-large';
                    } else {
                        $slidenav_large = '';
                    }
                    if ($article_controls_outside === "1") {
                        $html .= '<a class="uk-position-center-left-out uk-position-small' . $color_style . $slidenav_large . '" href="#" uk-slidenav-previous uk-slider-item="previous"></a>';
                        $html .= '<a class="uk-position-center-right-out uk-position-small' . $color_style . $slidenav_large . '" href="#" uk-slidenav-next uk-slider-item="next"></a>';
                    } else {
                        $html .= '<a class="uk-position-center-left uk-position-small uk-hidden-hover' . $color_style . $slidenav_large . '" href="#" uk-slidenav-previous uk-slider-item="previous"></a>';
                        $html .= '<a class="uk-position-center-right uk-position-small uk-hidden-hover' . $color_style . $slidenav_large . '" href="#" uk-slidenav-next uk-slider-item="next"></a>';
                    }
                }
                $html .= '</div>';
                if (!empty($options['article_show_indicators']) && $options['article_show_indicators'] === "1") {
                    if (!empty($options['article_indicators_color_style'])) {
                        $color_style = ' ' . $options['article_indicators_color_style'];
                    } else {
                        $color_style = '';
                    }
                    $html .= '<ul class="uk-slider-nav uk-dotnav uk-flex-' . $options['article_indicators_position'] . ' uk-margin' . $color_style . '"></ul>';
                }
                $html .= '</div>';
                break;
            // Article Standard Post
            case '2':
                if ($article_use_filter === "1" && $article_resource === "1") {
                    $html .= '<div uk-filter="target: .ui-article-filter">';
                    if (!empty($filter_tags)) {
                        $html .= '<div class="uk-flex uk-flex-' . $options['article_nav_alignment'] . ' uk-flex-middle uk-height-small' . $article_sub_nav_color_style . '">';
                        $html .= '<ul class="uk-subnav' . $subnav_style . '">'; // Filter SubNav
                        $html .= '<li class="uk-active" uk-filter-control><a href="#">' . Text::_('COM_UITHEMEBUILDERLITE_ALL') . '</a></li>';
                        foreach ($filter_tags as $i => $tag) {
                            $html .= '<li uk-filter-control="[data-tags*=\'' . $tag . '\']"><a href="#">' . $tag . '</a></li>';
                        }
                        $html .= '</ul>';
                        $html .= '</div>';
                    }
                }
                if ($article_use_filter === "1" && $article_resource === "1") {
                    $html .= '<div class="ui-article-filter uk-child-width-1-1' . $child_width . ' ' . $options['article_grid_gutter'] . ' uk-flex-' . $options['article_alignment'] . '" uk-grid="">';
                } else {
                    $html .= '<div class="uk-child-width-1-1' . $child_width . ' ' . $options['article_grid_gutter'] . ' uk-flex-' . $options['article_alignment'] . '" uk-grid="">';
                }
                foreach ($items as $key => $item) {
                    $JHelper        = new JHelperTags;
                    $itemTags       = $JHelper->getItemTags('com_content.article', $item->id);
                    $tagLayout      = new FileLayout('joomla.content.tags');
                    $data_taglayout = new FileLayout('joomla.content.tags_class');
                    $user   = Factory::getContainer()->get(UserFactoryInterface::class)->loadUserById($item->created_by);


                    // Joomla Tags
                    if (!empty($itemTags)) {
                        $tags      = $tagLayout->render($itemTags);
                        $data_tags = ' data-tags="' . $data_taglayout->render($itemTags) . '"';
                    } else {
                        $tags      = '';
                        $data_tags = '';
                    }
                    $html .= '<article itemprop="blogPost" itemscope="" itemtype="https://schema.org/BlogPosting" class="uk-article"' . $data_tags . '>';

                    if (empty($options['title']) && $title_show === "1") {
                        if (empty(trim($title_class))) {
                            $titleClass = 'uk-article-title';
                        } else {
                            $titleClass = trim($title_class);
                        }

                        $html .= '<' . $options['title_heading'] . ' class="' . $titleClass . '">';
                        $html .= '<span itemprop="headline">' . $item->title . '</span>';
                        $html .= '</' . $options['title_heading'] . '>';

                        if ($options['title_style'] === '') {
                            $html .= '<hr class="uk-divider-small">';
                        }
                    }

                    if ($article_autor_show === "1" || $article_date_show === "1" || $article_category_show === "1") {
                        $author = '<span itemprop="author" itemscope itemtype="https://schema.org/Person"><span itemprop="name">'.($item->created_by_alias ?: $user->username).'</span></span>';

                        $html .= '<p class="uk-article-meta">';
                        if ($article_autor_show === "1" && $article_date_show === "1") {
                            $html .= Text::_('COM_UITHEMEBUILDERLITE_WRITTEN_BY') . $author;
                            $html .= ' on <time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>.';
                        } else {
                            if ($article_autor_show === "1") {
                                $html .= Text::_('COM_UITHEMEBUILDERLITE_WRITTEN_BY') . $author . '.';
                            }
                            if ($article_date_show === "1") {
                                $html .= '<time itemprop="datePublished" content="' . $item->publish_up . '" datetime="' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', $item->publish_up, 'DATE_FORMAT_LC3') . '</time>.';
                            }
                        }
                        if ($article_category_show === "1") {
                            $html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="' . $item->category_link . '">' . $item->category . '</a>.';
                        }
                        $html .= '</p>';
                    }
                    if ($article_intro_show === "1") {
                        $html .= '<div>';
                        if ($options['article_intro_limit'] === "0") {
                            $html .= $item->introtext;
                        } else {
                            // $html .= SitePageHelper::limit_item_introtext($item->introtext, $options['article_intro_limit']) . '[...]';
                            $html .= mb_substr($item->introtext, 0, $options['article_intro_limit'], 'UTF-8') . '...';
                        }
                        $html .= '</div>';
                    }
                    if ($article_read_more === "1") {
                        if (((!empty($options['article_button_text']) || !empty($options['article_button_icon'])) && (!empty($options['article_button_url']) || !empty($options['article_button_menulist']))) || $article_tag_show === "1") {
                            $html .= '<div class="uk-grid-small uk-child-width-auto" uk-grid="">';
                            $html .= '<div>';
                            if ($options['article_button_target'] === 'lightbox') {
                                // Link open in Lightbox
                                $html .= '<div uk-lightbox>';
                                if ($article_link === "1") {
                                    $html .= '<a href="' . $item->link . '" class="' . $button_class . '" data-type="iframe" data-caption="' . $item->title . '">';
                                } else {
                                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" class="' . $button_class . '" data-type="iframe" data-caption="' . $item->title . '">';
                                }
                                if (!empty($options['article_button_icon'])) {
                                    $html .= '<i class="uk-margin-small-right ' . $options['article_button_icon'] . '"></i>';
                                }
                                if (!empty($options['article_button_text'])) {
                                    $html .= $options['article_button_text'];
                                }
                                $html .= '</a>';
                                $html .= '</div>';
                            } else {
                                if ($article_link === "1") {
                                    $html .= '<a href="' . $item->link . '" target="' . $options['article_button_target'] . '" class="' . $button_class . '">';
                                } else {
                                    $html .= '<a href="' . Route::_("index.php?Itemid={$id}") . '" target="' . $options['article_button_target'] . '" class="' . $button_class . '">';
                                }
                                if (!empty($options['article_button_icon'])) {
                                    $html .= '<i class="uk-margin-small-right ' . $options['article_button_icon'] . '"></i>';
                                }
                                if (!empty($options['article_button_text'])) {
                                    $html .= $options['article_button_text'];
                                }
                                $html .= '</a>';
                            }
                            $html .= '</div>';
                            // Joomla Tags
                            if ($article_tag_show === "1" && $article_resource === "1") {
                                $html .= '<div class="uk-margin-auto-left">';
                                $html .= $tags;
                                $html .= '</div>';
                            }
                            $html .= '</div>';
                        }
                    }

                    $html .= '</article>';
                }
                $html .= '</div>';
                if ($article_use_filter === "1" && $article_resource === "1") {
                    $html .= '</div>';
                }
                break;
        }
    }
}
// Administrator preview
else {
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    // Joomla Tags
    $tags = '<div><a class="tm-tags" href="javascript:void(0)">lorem</a></div> <div><a class="tm-tags" href="javascript:void(0)" itemprop="keywords">ipsum</a></div>';


    if (!empty($options['title']) && $title_show === "1") {
        $html .= '<' . $options['title_heading'] . ' class="ui-article-title' . $title_class . '">';
        $html .= '<span>' . $options['title'] . '</span>';
        $html .= '</' . $options['title_heading'] . '>';
    }
    switch ($article_post_format) {
        // Article Card Post
        case '0':
            if (!empty($filter_tags) && $article_use_filter === "1" && $article_resource === "1") {
                $html .= '<div class="uk-flex uk-flex-' . $options['article_nav_alignment'] . ' uk-flex-middle uk-height-small' . $article_sub_nav_color_style . '">';
                $html .= '<ul class="uk-subnav' . $subnav_style . '">'; // Filter SubNav
                $html .= '<li class="uk-active" uk-filter-control><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_ALL') . '</a></li>';
                foreach ($filter_tags as $i => $tag) {
                    $html .= '<li uk-filter-control="[data-tags*=\'' . $tag . '\']"><a href="javascript:void(0)">' . $tag . '</a></li>';
                }
                $html .= '</ul>';
                $html .= '</div>';
            }
            $html .= '<div class="uk-child-width-1-1' . $child_width . ' uk-grid-default" uk-grid="">';
            $html .= '<div>';
            $html .= '<div class="uk-card uk-card-' . $options['article_card_style'] . '">';
            if ($article_autor_show === "1") {
                $image_root                     = Uri::root(true) . '/';
                $author                         = 'Demo Author name';
                $options['article_autor_image'] = ' data-src="' . $image_root . $options['article_autor_image'] . '"';
                $html                           .= '<div class="uk-card-header">';
                $html                           .= '<div class="uk-grid-small uk-flex-middle" uk-grid="">';
                $html                           .= '<div class="uk-width-auto">';
                if ($article_use_autor_img === "1") {
                    $html .= '<img class="uk-border-circle" uk-tooltip="title:' . $author . '; pos: bottom;" width="40" height="40" ' . $options['article_autor_image'] . ' uk-img="" />';
                } else {
                    $html .= '<span uk-icon="icon: user; ratio: 2.5" uk-tooltip="title:' . $author . '; pos: bottom;"></span>';
                }
                $html .= '</div>';
                $html .= '<div class="uk-width-expand">';
                if ($article_date_show === "1" || $article_category_show === "1") {
                    $html .= '<h3 class="uk-card-title uk-margin-remove-bottom">' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_ARTICLE_TITLE') . '</h3>';
                } else {
                    $html .= '<h3 class="uk-card-title">' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_ARTICLE_TITLE') . '</h3>';
                }
                if ($article_date_show === "1" || $article_category_show === "1") {
                    $html .= '<p class="uk-text-meta uk-margin-remove-top">';
                    if ($article_date_show === "1") {
                        $html .= '<time datetime="' . HTMLHelper::_('date', '31 August 2019', 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', '31 August 2019', 'DATE_FORMAT_LC3') . '</time>.';
                    }
                    if ($article_category_show === "1") {
                        $html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="javascript:void(0)">Demo Category</a>.';
                    }
                    $html .= '</p>';
                }
                $html .= '</div>';
                $html .= '</div>';
            } else {
                $html .= '<div class="uk-card-header">';
                if ($article_date_show === "1" || $article_category_show === "1") {
                    $html .= '<h3 class="uk-card-title uk-margin-remove-bottom">' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_ARTICLE_TITLE') . '</h3>';
                } else {
                    $html .= '<h3 class="uk-card-title">' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_ARTICLE_TITLE') . '</h3>';
                }
                if ($article_date_show === "1" || $article_category_show === "1") {
                    $html .= '<p class="uk-text-meta uk-margin-remove-top">';
                    if ($article_date_show === "1") {
                        $html .= '<time datetime="' . HTMLHelper::_('date', '31 August 2019', 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', '31 August 2019', 'DATE_FORMAT_LC3') . '</time>.';
                    }
                    if ($article_category_show === "1") {
                        $html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="javascript:void(0)">Demo Category</a>.';
                    }
                    $html .= '</p>';
                }
            }
            $html .= '</div>';
            // Content with tags... only Joomla! Articles
            if ($article_intro_show === "1") {
                $html .= '<div class="uk-card-body">';
                if ($article_tag_show === "1" && $article_resource === "1") {
                    $html .= '<div class="uk-grid-small" uk-grid="">';
                    $html .= '<div class="uk-width-auto uk-position-relative">';
                    $html .= '<span class="rotate-tm-tags rotate-up-tm-tags uk-position-absolute uk-flex">' . $tags . '</span>';
                    $html .= '</div>';
                    $html .= '<div class="uk-width-expand">';
                    $html .= '<div class="uk-alert-danger uk-padding-small uk-text-small" uk-alert>';
                    $html .= '<h3 class="alert-heading">' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW') . '</h3>';
                    $html .= '<p>' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW_DESC') . '</p>';
                    $html .= '</div>';
                    $html .= '<p>Minions ipsum tatata bala tu butt tulaliloo. Ti aamoo! belloo! Poopayee para tú pepete gelatooo bappleees jiji aaaaaah aaaaaah. Chasy la bodaaa hana dul sae hahaha. La bodaaa tulaliloo tulaliloo wiiiii chasy tank yuuu! Jeje chasy tank yuuu! Hana dul sae. Para tú bappleees bee do bee do bee do pepete baboiii la bodaaa chasy tank yuuu! Jiji ti aamoo! Jeje butt me want bananaaa! Hahaha underweaaar hana dul sae bappleees para tú. </p><p>Bananaaaa ti aamoo! Me want bananaaa! Chasy underweaaar bappleees poopayee daa butt. Jiji poulet tikka masala la bodaaa jiji gelatooo para tú. Tulaliloo la bodaaa tulaliloo chasy poopayee belloo! Ti aamoo! Gelatooo. Me want bananaaa! uuuhhh baboiii bananaaaa tank yuuu! Bappleees bananaaaa aaaaaah aaaaaah tank yuuu! Tulaliloo jeje aaaaaah poulet tikka masala bappleees tatata bala tu jiji pepete tulaliloo.</p>';
                    $html .= '</div>';
                    $html .= '</div>';
                } else {
                    $html .= '<div class="uk-alert-danger uk-padding-small uk-text-small" uk-alert>';
                    $html .= '<h3 class="alert-heading">' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW') . '</h3>';
                    $html .= '<p>' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW_DESC') . '</p>';
                    $html .= '</div>';
                    $html .= '<p>Minions ipsum tatata bala tu butt tulaliloo. Ti aamoo! belloo! Poopayee para tú pepete gelatooo bappleees jiji aaaaaah aaaaaah. Chasy la bodaaa hana dul sae hahaha. La bodaaa tulaliloo tulaliloo wiiiii chasy tank yuuu! Jeje chasy tank yuuu! Hana dul sae. Para tú bappleees bee do bee do bee do pepete baboiii la bodaaa chasy tank yuuu! Jiji ti aamoo! Jeje butt me want bananaaa! Hahaha underweaaar hana dul sae bappleees para tú. </p><p>Bananaaaa ti aamoo! Me want bananaaa! Chasy underweaaar bappleees poopayee daa butt. Jiji poulet tikka masala la bodaaa jiji gelatooo para tú. Tulaliloo la bodaaa tulaliloo chasy poopayee belloo! Ti aamoo! Gelatooo. Me want bananaaa! uuuhhh baboiii bananaaaa tank yuuu! Bappleees bananaaaa aaaaaah aaaaaah tank yuuu! Tulaliloo jeje aaaaaah poulet tikka masala bappleees tatata bala tu jiji pepete tulaliloo.</p>';
                }
                $html .= '</div>';
            }
            // Read more
            if ($article_read_more === "1") {
                $html .= '<div class="uk-card-footer">';
                if ((!empty($options['article_button_text']) || !empty($options['article_button_icon'])) && (!empty($options['article_button_url']) || !empty($options['article_button_menulist']))) {
                    // (Admin Preview)
                    if ($article_link === "1") {
                        $html .= '<a href="javascript:void(0)" class="' . $button_class . '">';
                    } else {
                        $html .= '<a href="javascript:void(0)" target="' . $options['article_button_target'] . '" class="' . $button_class . '">';
                    }
                    if (!empty($options['article_button_icon'])) {
                        $html .= '<i class="uk-margin-small-right ' . $options['article_button_icon'] . '"></i>';
                    }
                    if (!empty($options['article_button_text'])) {
                        $html .= $options['article_button_text'];
                    }
                    $html .= '</a>';
                }
                $html .= '</div>';
            }
            $html .= '</div>';
            $html .= '</div>';
            $html .= '</div>';
            break;
        // Slider Content (Cards) Post
        case '1':
            // Slider center options
            // $options['article_slider_center'] === "1"
            if ($article_slider_center) {
                $center = ' center: true;';
            } else {
                $center = '';
            }
            // Slider autoplay options
            // $options['article_slider_autoplay'] === "1"
            if ($article_slider_autoplay) {
                $autoplay = ' autoplay: true;';
            } else {
                $autoplay = '';
            }
            // Slider autoplay interval options
            // $options['article_slider_autoplay'] === "1"
            if ($article_slider_autoplay && !empty($options['article_slider_autoplay_interval'])) {
                $autoplay_interval = ' autoplay-interval: ' . $options['article_slider_autoplay_interval'] . ';';
            } else {
                $autoplay_interval = '';
            }
            // Slider autoplay pause on hover
            // $options['article_slider_autoplay'] === "1"
            // $options['article_slider_pause_on_hover'] === "1"
            if ($article_slider_autoplay && $article_slider_pause_on_hover) {
                $autoplay_pause_on_hover = ' pause-on-hover: true;';
            } else {
                $autoplay_pause_on_hover = '';
            }
            // item color style
            if (!empty($options['article_slider_color_style'])) {
                $color_style = ' ' . $options['article_slider_color_style'];
            } else {
                $color_style = '';
            }
            // $options['article_grid_match'] === "1"
            if ($article_grid_match === "1") {
                $grid_match_class = ' uk-grid-match';
            } else {
                $grid_match_class = '';
            }
            $html .= '<div uk-slider="' . $center . $autoplay . $autoplay_pause_on_hover . '">';
            $html .= '<div class="uk-position-relative uk-visible-toggle' . $color_style . '">';
            if ($article_controls_outside === "1") {
                $html .= '<div class="uk-slider-container uk-padding-small uk-padding-remove-horizontal">';
            } else {
                $html .= '<div class="uk-padding-small uk-padding-remove-horizontal">';
            }
            $html .= '<ul class="uk-slider-items uk-margin uk-child-width-1-1' . $child_width . ' ' . $options['article_grid_gutter'] . $grid_match_class . '" uk-grid="">';
            // Dummy Card items for preview
            $dummy_html = '<li>';
            $dummy_html .= '<div class="uk-card uk-card-' . $options['article_card_style'] . '">';
            if ($article_autor_show === "1") {
                $image_root                     = Uri::root(true) . '/';
                $author                         = 'author name';
                $options['article_autor_image'] = ' data-src="' . $image_root . $options['article_autor_image'] . '"';
                $dummy_html                     .= '<div class="uk-card-header">';
                $dummy_html                     .= '<div class="uk-grid-small uk-flex-middle" uk-grid="">';
                $dummy_html                     .= '<div class="uk-width-auto">';
                if ($article_use_autor_img === "1") {
                    $dummy_html .= '<img class="uk-border-circle" uk-tooltip="title:' . $author . '; pos: bottom;" width="40" height="40" ' . $options['article_autor_image'] . ' uk-img="" />';
                } else {
                    $dummy_html .= '<span uk-icon="icon: user; ratio: 2.5" uk-tooltip="title:' . $author . '; pos: bottom;"></span>';
                }
                $dummy_html .= '</div>';
                $dummy_html .= '<div class="uk-width-expand">';
                if ($article_date_show === "1" || $article_category_show === "1") {
                    $dummy_html .= '<h3 class="uk-card-title uk-margin-remove-bottom">' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_ARTICLE_TITLE') . '</h3>';
                } else {
                    $dummy_html .= '<h3 class="uk-card-title">' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_ARTICLE_TITLE') . '</h3>';
                }
                if ($article_date_show === "1" || $article_category_show === "1") {
                    $dummy_html .= '<p class="uk-text-meta uk-margin-remove-top">';
                    if ($article_date_show === "1") {
                        $dummy_html .= '<time datetime="' . HTMLHelper::_('date', '31 August 2019', 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', '31 August 2019', 'DATE_FORMAT_LC3') . '</time>.';
                    }
                    if ($article_category_show === "1") {
                        $dummy_html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="javascript:void(0)">Demo Category</a>.';
                    }
                    $dummy_html .= '</p>';
                }
                $dummy_html .= '</div>';
                $dummy_html .= '</div>';
            } else {
                $dummy_html .= '<div class="uk-card-header">';
                if ($article_date_show === "1" || $article_category_show === "1") {
                    $dummy_html .= '<h3 class="uk-card-title uk-margin-remove-bottom">' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_ARTICLE_TITLE') . '</h3>';
                } else {
                    $dummy_html .= '<h3 class="uk-card-title">' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_ARTICLE_TITLE') . '</h3>';
                }
                if ($article_date_show === "1" || $article_category_show === "1") {
                    $dummy_html .= '<p class="uk-text-meta uk-margin-remove-top">';
                    if ($article_date_show === "1") {
                        $dummy_html .= '<time datetime="' . HTMLHelper::_('date', '31 August 2019', 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', '31 August 2019', 'DATE_FORMAT_LC3') . '</time>.';
                    }
                    if ($article_category_show === "1") {
                        $dummy_html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="javascript:void(0)">Demo Category</a>.';
                    }
                    $dummy_html .= '</p>';
                }
            }
            $dummy_html .= '</div>';
            // Content with tags... only Joomla! Articles
            if ($article_intro_show === "1") {
                $dummy_html .= '<div class="uk-card-body">';
                if ($article_tag_show === "1" && $article_resource === "1") {
                    $dummy_html .= '<div class="uk-grid-small" uk-grid="">';
                    $dummy_html .= '<div class="uk-width-auto uk-position-relative">';
                    $dummy_html .= '<span class="rotate-tm-tags rotate-up-tm-tags uk-position-absolute uk-flex">' . $tags . '</span>';
                    $dummy_html .= '</div>';
                    $dummy_html .= '<div class="uk-width-expand">';
                    $dummy_html .= '<div class="uk-alert-danger uk-padding-small uk-text-small" uk-alert>';
                    $dummy_html .= '<h3 class="alert-heading">' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW') . '</h3>';
                    $dummy_html .= '<p>' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW_DESC') . '</p>';
                    $dummy_html .= '</div>';
                    $dummy_html .= '<p>Minions ipsum tatata bala tu butt tulaliloo. Ti aamoo! belloo! Poopayee para tú pepete gelatooo bappleees jiji aaaaaah aaaaaah. Chasy la bodaaa hana dul sae hahaha. La bodaaa tulaliloo tulaliloo wiiiii chasy tank yuuu! Jeje chasy tank yuuu! Hana dul sae. Para tú bappleees bee do bee do bee do pepete baboiii la bodaaa chasy tank yuuu! Jiji ti aamoo! Jeje butt me want bananaaa! Hahaha underweaaar hana dul sae bappleees para tú. </p><p>Bananaaaa ti aamoo! Me want bananaaa! Chasy underweaaar bappleees poopayee daa butt. Jiji poulet tikka masala la bodaaa jiji gelatooo para tú. Tulaliloo la bodaaa tulaliloo chasy poopayee belloo! Ti aamoo! Gelatooo. Me want bananaaa! uuuhhh baboiii bananaaaa tank yuuu! Bappleees bananaaaa aaaaaah aaaaaah tank yuuu! Tulaliloo jeje aaaaaah poulet tikka masala bappleees tatata bala tu jiji pepete tulaliloo.</p>';
                    $dummy_html .= '</div>';
                    $dummy_html .= '</div>';
                } else {
                    $dummy_html .= '<div class="uk-alert-danger uk-padding-small uk-text-small" uk-alert>';
                    $dummy_html .= '<h3 class="alert-heading">' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW') . '</h3>';
                    $dummy_html .= '<p>' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW_DESC') . '</p>';
                    $dummy_html .= '</div>';
                    $dummy_html .= '<p>Minions ipsum tatata bala tu butt tulaliloo. Ti aamoo! belloo! Poopayee para tú pepete gelatooo bappleees jiji aaaaaah aaaaaah. Chasy la bodaaa hana dul sae hahaha. La bodaaa tulaliloo tulaliloo wiiiii chasy tank yuuu! Jeje chasy tank yuuu! Hana dul sae. Para tú bappleees bee do bee do bee do pepete baboiii la bodaaa chasy tank yuuu! Jiji ti aamoo! Jeje butt me want bananaaa! Hahaha underweaaar hana dul sae bappleees para tú. </p><p>Bananaaaa ti aamoo! Me want bananaaa! Chasy underweaaar bappleees poopayee daa butt. Jiji poulet tikka masala la bodaaa jiji gelatooo para tú. Tulaliloo la bodaaa tulaliloo chasy poopayee belloo! Ti aamoo! Gelatooo. Me want bananaaa! uuuhhh baboiii bananaaaa tank yuuu! Bappleees bananaaaa aaaaaah aaaaaah tank yuuu! Tulaliloo jeje aaaaaah poulet tikka masala bappleees tatata bala tu jiji pepete tulaliloo.</p>';
                }
                $dummy_html .= '</div>';
            }
            // Read more
            if ($article_read_more === "1") {
                $dummy_html .= '<div class="uk-card-footer">';
                if ((!empty($options['article_button_text']) || !empty($options['article_button_icon'])) && (!empty($options['article_button_url']) || !empty($options['article_button_menulist']))) {
                    // Admin Preview view
                    if ($article_link === "1") {
                        $dummy_html .= '<a href="javascript:void(0)" class="' . $button_class . '">';
                    } else {
                        $dummy_html .= '<a href="javascript:void(0)" target="' . $options['article_button_target'] . '" class="' . $button_class . '">';
                    }
                    if (!empty($options['article_button_icon'])) {
                        $dummy_html .= '<i class="uk-margin-small-right ' . $options['article_button_icon'] . '"></i>';
                    }
                    if (!empty($options['article_button_text'])) {
                        $dummy_html .= $options['article_button_text'];
                    }
                    $dummy_html .= '</a>';
                }
                $dummy_html .= '</div>';
            }
            $dummy_html .= '</div>';
            $dummy_html .= '</li>';
            // Repeat Dummy Articles
            $html .= str_repeat($dummy_html, $options['article_limit']);
            $html .= '</ul>';

            $html .= '</div>';

            if (!empty($options['article_show_controls']) && $options['article_show_controls'] === "1") {
                if (!empty($options['article_controls_color_style'])) {
                    $color_style = ' ' . $options['article_controls_color_style'];
                } else {
                    $color_style = '';
                }
                if ($options['article_nav_controls_large'] === "1") {
                    $slidenav_large = ' uk-slidenav-large';
                } else {
                    $slidenav_large = '';
                }
                if ($article_controls_outside === "1") {
                    $html .= '<a class="uk-position-center-left-out uk-position-small' . $color_style . $slidenav_large . '" href="#" uk-slidenav-previous uk-slider-item="previous"></a>';
                    $html .= '<a class="uk-position-center-right-out uk-position-small' . $color_style . $slidenav_large . '" href="#" uk-slidenav-next uk-slider-item="next"></a>';
                } else {
                    $html .= '<a class="uk-position-center-left uk-position-small uk-hidden-hover' . $color_style . $slidenav_large . '" href="#" uk-slidenav-previous uk-slider-item="previous"></a>';
                    $html .= '<a class="uk-position-center-right uk-position-small uk-hidden-hover' . $color_style . $slidenav_large . '" href="#" uk-slidenav-next uk-slider-item="next"></a>';
                }
            }
            $html .= '</div>';
            if (!empty($options['article_show_indicators']) && $options['article_show_indicators'] === "1") {
                if (!empty($options['article_indicators_color_style'])) {
                    $color_style = ' ' . $options['article_indicators_color_style'];
                } else {
                    $color_style = '';
                }
                $html .= '<ul class="uk-slider-nav uk-dotnav uk-flex-' . $options['article_indicators_position'] . ' uk-margin' . $color_style . '"></ul>';
            }
            $html .= '</div>';
            break;

        // Article Standard Post
        case '2':
            // $options['article_resource'] === "1"
            if (!empty($filter_tags) && $article_use_filter === "1" && $article_resource === "1") {
                $html .= '<div class="uk-flex uk-flex-' . $options['article_nav_alignment'] . ' uk-flex-middle uk-height-small' . $article_sub_nav_color_style . '">';
                $html .= '<ul class="uk-subnav' . $subnav_style . '">'; // Filter SubNav
                $html .= '<li class="uk-active" uk-filter-control><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_ALL') . '</a></li>';
                foreach ($filter_tags as $i => $tag) {
                    $html .= '<li uk-filter-control="[data-tags*=\'' . $tag . '\']"><a href="javascript:void(0)">' . $tag . '</a></li>';
                }
                $html .= '</ul>';
                $html .= '</div>';
            }

            $html .= '<article class="uk-article">';

            if (empty($options['title']) && $title_show === "1") {
                if (empty(trim($title_class))) {
                    $titleClass = 'uk-article-title';
                } else {
                    $titleClass = trim($title_class);
                }

                $html .= '<' . $options['title_heading'] . ' class="' . $titleClass . '">';
                $html .= '<span itemprop="headline">' . Text::_('COM_UITHEMEBUILDERLITE_DEFAULT_ARTICLE_TITLE') . '</span>';
                $html .= '</' . $options['title_heading'] . '>';
                if ($options['title_style'] === '') {
                    $html .= '<hr class="uk-divider-small">';
                }
            }


            if ($article_autor_show === "1" || $article_date_show === "1" || $article_category_show === "1") {
                $author = 'Demo Author name';
                $html   .= '<p class="uk-article-meta">';
                if ($article_autor_show === "1" && $article_date_show === "1") {
                    $html .= Text::_('COM_UITHEMEBUILDERLITE_WRITTEN_BY') . $author;
                    $html .= ' on <time datetime="' . HTMLHelper::_('date', '25 November 2019', 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', '25 November 2019', 'DATE_FORMAT_LC3') . '</time>.';
                } else {
                    if ($article_autor_show === "1") {
                        $html .= Text::_('COM_UITHEMEBUILDERLITE_WRITTEN_BY') . $author . '.';
                    }
                    if ($article_date_show === "1") {
                        $html .= '<time datetime="' . HTMLHelper::_('date', '25 November 2019', 'DATE_FORMAT_LC3') . '">' . HTMLHelper::_('date', '25 November 2019', 'DATE_FORMAT_LC3') . '</time>.';
                    }
                }
                if ($article_category_show === "1") {
                    $html .= ' ' . Text::_('COM_UITHEMEBUILDERLITE_POSTED_IN') . '<a href="javascript:void(0)">Demo Category</a>.';
                }
                $html .= '</p>';
            }
            $html .= '<div class="uk-alert-danger uk-padding-small uk-text-small" uk-alert>';
            $html .= '<h3 class="alert-heading">' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW') . '</h3>';
            $html .= '<p>' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_NO_PREVIEW_DESC') . '</p>';
            $html .= '</div>';
            $html .= '<p>Minions ipsum tatata bala tu butt tulaliloo. Ti aamoo! belloo! Poopayee para tú pepete gelatooo bappleees jiji aaaaaah aaaaaah. Chasy la bodaaa hana dul sae hahaha. La bodaaa tulaliloo tulaliloo wiiiii chasy tank yuuu! Jeje chasy tank yuuu! Hana dul sae. Para tú bappleees bee do bee do bee do pepete baboiii la bodaaa chasy tank yuuu! Jiji ti aamoo! Jeje butt me want bananaaa! Hahaha underweaaar hana dul sae bappleees para tú. </p><p>Bananaaaa ti aamoo! Me want bananaaa! Chasy underweaaar bappleees poopayee daa butt. Jiji poulet tikka masala la bodaaa jiji gelatooo para tú. Tulaliloo la bodaaa tulaliloo chasy poopayee belloo! Ti aamoo! Gelatooo. Me want bananaaa! uuuhhh baboiii bananaaaa tank yuuu! Bappleees bananaaaa aaaaaah aaaaaah tank yuuu! Tulaliloo jeje aaaaaah poulet tikka masala bappleees tatata bala tu jiji pepete tulaliloo.</p>';
            if (($article_read_more === "1") && (!empty($options['article_button_text']) || !empty($options['article_button_icon'])) && (!empty($options['article_button_url']) || !empty($options['article_button_menulist']))) {
                $html .= '<div class="uk-grid-small uk-child-width-auto" uk-grid="">';
                $html .= '<div>';
                $html .= '<a href="javascript:void(0)" class="' . $button_class . '">';
                if (!empty($options['article_button_icon'])) {
                    $html .= '<i class="uk-margin-small-right ' . $options['article_button_icon'] . '"></i>';
                }
                if (!empty($options['article_button_text'])) {
                    $html .= $options['article_button_text'];
                }
                $html .= '</a>';
                $html .= '</div>';
                if ($article_tag_show === "1" && $article_resource === "1") {
                    $html .= '<div class="uk-margin-auto-left">';
                    $html .= '<a class="tm-tags" href="javascript:void(0)">joomla tag</a>, <a class="tm-tags" href="javascript:void(0)" itemprop="keywords">joomla</a>, <a class="tm-tags" href="javascript:void(0)" itemprop="keywords">lorem</a>';
                    $html .= '</div>';
                }
                $html .= '</div>';
            }
            $html .= '</article>';
            break;
    }
}

echo $html;
