<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

$app = Factory::getApplication();

HTMLHelper::_('script', 'com_uithemebuilderlite/admin-pages-modal.min.js', array('version' => 'auto', 'relative' => true));

$function = $app->input->getCmd('function', 'jSelectPage');
$onclick = $this->escape($function);
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));

?>
<div class="container-popup">

    <form
        action="<?php echo Route::_('index.php?option=com_uithemebuilderlite&view=pages&layout=modal&tmpl=component&function=' . $function . '&' . Session::getFormToken() . '=1'); ?>"
        method="post" name="adminForm" id="adminForm" class="form-inline">

        <?php if (empty($this->items)) : ?>
            <div class="alert alert-warning">
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php else : ?>
            <div class="ui-toolbar uk-background-primary uk-padding-small"
                 style="margin-left:-20px;margin-right:-20px;margin-top:-20px;">
                <div class="uk-panel">
                    <?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
                </div>
            </div>

            <table class="table table-sm">
                <thead>
                <tr>
                    <caption id="captionTable" class="sr-only">
                        <?php echo Text::_('COM_UITHEMEBUILDERLITE_TABLE_CAPTION'); ?>
                        , <?php echo Text::_('JGLOBAL_SORTED_BY'); ?>
                    </caption>
                    <th scope="col" style="width:10%" class="d-none d-md-table-cell">
                        <?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'p.title', $listDirn, $listOrder); ?>
                    </th>
                    <th scope="col" style="width:1%">
                        <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_LANGUAGE', 'p.language', $this->state->get('list.direction'), $this->state->get('list.ordering')); ?>
                    </th>
                    <th scope="col" style="width:1%">
                        <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'p.id', $listDirn, $listOrder); ?>
                    </th>
                </tr>
                </thead>
                <tbody>
                <?php
                $iconStates = array(
                    -2 => 'icon-trash',
                    0 => 'icon-unpublish',
                    1 => 'icon-publish',
                    2 => 'icon-archive',
                );

                foreach ($this->items as $i => $item) :
                    if ($item->language && Multilanguage::isEnabled()) {
                        $tag = strlen($item->language);
                        if ($tag == 5) {
                            $lang = substr($item->language, 0, 2);
                        } elseif ($tag == 6) {
                            $lang = substr($item->language, 0, 3);
                        } else {
                            $lang = '';
                        }
                    } elseif (!Multilanguage::isEnabled()) {
                        $lang = '';
                    } ?>
                    <tr class="row<?php echo $i % 2; ?>">
                        <th scope="row">
                            <a class="uk-link-heading ui-select" href="javascript:void(0)"
                               data-function="<?php echo $this->escape($onclick); ?>" data-id="<?php echo $item->id; ?>"
                               data-language="<?php echo $lang; ?>"
                               data-title="<?php echo $this->escape($item->title); ?>">
                                <?php echo $this->escape($item->title); ?>
                            </a>
                        </th>
                        <td>
                            <?php if ($item->language === '*') {
                                echo Text::alt('JALL', 'language');
                            } else {
                                echo $item->language_title ? $this->escape($item->language_title) : Text::_('JUNDEFINED');
                            } ?>
                        </td>
                        <td>
                            <?php echo (int)$item->id; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>

        <?php endif; ?>

        <input type="hidden" name="task" value="">
        <input type="hidden" name="forcedLanguage" value="<?php echo $app->input->get('forcedLanguage', '', 'CMD'); ?>">
        <?php echo HTMLHelper::_('form.token'); ?>

    </form>
</div>
