<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\View\Page;

// No direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;
use SW\Component\uiThemeBuilderLite\Administrator\Helper\PageHelper;
use SW\Component\uiThemeBuilderLite\Site\Helper\RouteHelper;

class HtmlView extends BaseHtmlView
{

    /**
     * Display the view
     *
     * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
     *
     * @throws \Exception
     *
     * @since   v1.0.0
     */
    public function display($tpl = null): void
    {

        $this->pagination = $this->get('Pagination');

        // Access check.
        if (!Factory::getApplication()->getIdentity()->authorise('core.admin')) {
            throw new NotAllowed(Text::_('JERROR_ALERTNOAUTHOR'), 403);
        }

        $doc = Factory::getApplication()->getDocument();
        $wa = $doc->getWebAssetManager();
        HTMLHelper::_('jquery.framework');
        $wa->useScript('form.validate');

        HTMLHelper::_('stylesheet', 'com_uithemebuilderlite/admin-media.min.css', array('version' => 'auto', 'relative' => true));

        // Load JS files
//      HTMLHelper::_('script', 'com_uithemebuilderlite/admin-media-uithemebuilder.min.js', array('version' => 'auto', 'relative' => true));
        HTMLHelper::_('script', 'com_uithemebuilderlite/admin-uithemebuilder.min.js', array('version' => 'auto', 'relative' => true), ['type' => 'module']);
        HTMLHelper::_('script', 'com_uithemebuilderlite/uivimeoplayer.js', array('version' => 'auto', 'relative' => true));
        HTMLHelper::_('script', 'com_uithemebuilderlite/btn-actions_min.js', array('version' => 'auto', 'relative' => true));

        // Load editor
        $editor_type    = Factory::getApplication()->get('editor');
        $editor         = Editor::getInstance($editor_type);
        switch ($editor_type) {
            case 'codemirror':
                // Initialize CodeMirror
                $editor->display('codemirror', '', 0, 250, 0, 0, false);
                break;

            case 'none':
                $editor->display('none', '', 0, 250, 0, 0, false);
                break;
                
            case 'tinymce':
                $editor->display('tinymce', '', 0, 250, 0, 0, false);
                break;

            default:
                // Initialize none Editor
                $editor->display('none', '', 0, 250, 0, 0, false);
        }

        $js = 'var style_root="' . URI::base(true) . '";';
        $wa->addInlineScript($js);

        $form = $this->get('Form');
        $item = $this->get('Item');

        if (count($errors = $this->get('Errors'))) {
            throw new GenericDataException(implode("\n", $errors), 500);
        }

        $this->form = $form;
        $this->item = $item;

        // Export Class
        if (PageHelper::getProParams() && $exportClass = PageHelper::getProParams('export')) {
            $exportClass->loadModal();
        }

        // Save Class
        if (PageHelper::getProParams() && $saveClass = PageHelper::getProParams('save')) {
            $saveClass->loadSaveModal();
        }

        // Load language
        $db    = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true)
            ->select('template')
            ->from($db->quoteName('#__template_styles'))
            ->where($db->quoteName('client_id') . ' = 0')
            ->where($db->quoteName('home') . ' = 1');

        $db->setQuery($query);
        $defaultemplate = $db->loadResult();

        $lang = Factory::getApplication()->getLanguage();
        $lang->load('tpl_' . $defaultemplate, JPATH_SITE, $lang->getName(), true);

        // Messages translations
        Text::script('COM_UITHEMEBUILDERLITE_PAGE_TITLE');
        Text::script('COM_UITHEMEBUILDERLITE_PAGE_TITLE_DESC');

        Text::script('COM_UITHEMEBUILDERLITE_USE_UIKIT_DEFAULT');

        Text::script('COM_UITHEMEBUILDERLITE_ERROR');
        Text::script('COM_UITHEMEBUILDERLITE_INVALID_FIELD');
        Text::script('COM_UITHEMEBUILDERLITE_SURE_REMOVE_ELEMENT');
        Text::script('COM_UITHEMEBUILDERLITE_CANCEL');
        Text::script('COM_UITHEMEBUILDERLITE_OK');
        Text::script('COM_UITHEMEBUILDERLITE_RESET');
        Text::script('COM_UITHEMEBUILDERLITE_SURE_REMOVE_ITEM');
        Text::script('COM_UITHEMEBUILDERLITE_REMOVE_LAST_ITEM');
        Text::script('COM_UITHEMEBUILDERLITE_GRID_CHANGE');

        Text::script('COM_UITHEMEBUILDERLITE_LOAD_MORE');
        Text::script('COM_UITHEMEBUILDERLITE_LOAD_MORE_RESET');

        Text::script('WARNING');

        Text::script('JGLOBAL_PREVIEW');
        Text::script('JTOOLBAR_EXPORT');

        Text::script('COM_UITHEMEBUILDERLITE_SECTION');
        Text::script('COM_UITHEMEBUILDERLITE_COLUMN');

        Text::script('COM_UITHEMEBUILDERLITE_EXPORT_PAGE');
        Text::script('COM_UITHEMEBUILDERLITE_IMPORT_FAILED');
        Text::script('COM_UITHEMEBUILDERLITE_MY_SECTIONS');
        Text::script('COM_UITHEMEBUILDERLITE_SAVE_SECTION');
        Text::script('COM_UITHEMEBUILDERLITE_SAVE_SECTION_DIALOG');
        Text::script('COM_UITHEMEBUILDERLITE_SAVE_FAILED');
        Text::script('COM_UITHEMEBUILDERLITE_ERROR_FILE_EXISTS');
        Text::script('COM_UITHEMEBUILDERLITE_LIBRARY_LIST');

        // Actions
        Text::script('COM_UITHEMEBUILDERLITE_ADD_ROW');
        Text::script('COM_UITHEMEBUILDERLITE_ADD_LIBRARY');
        Text::script('COM_UITHEMEBUILDERLITE_DELETE_ROW');
        Text::script('COM_UITHEMEBUILDERLITE_SURE_DELETE_ROW');
        Text::script('COM_UITHEMEBUILDERLITE_DUPLICATE_ROW');
        Text::script('COM_UITHEMEBUILDERLITE_CONFIGURE_ROW');
        Text::script('COM_UITHEMEBUILDERLITE_CONFIGURE_COLUMN');
        Text::script('COM_UITHEMEBUILDERLITE_TOGGLE_COLUMN_OPTIONS');
        Text::script('COM_UITHEMEBUILDERLITE_TOGGLE_COMPONENT_OPTIONS');
        Text::script('COM_UITHEMEBUILDERLITE_ADD_COMPONENT');
        Text::script('COM_UITHEMEBUILDERLITE_RESET_RESPONSIVE_SETTINGS');

        // Components
        Text::script('COM_UITHEMEBUILDERLITE_ACCORDION');
        Text::script('COM_UITHEMEBUILDERLITE_ALERTS');
        Text::script('COM_UITHEMEBUILDERLITE_ARTICLES');
        Text::script('COM_UITHEMEBUILDERLITE_ARTICLES_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_BUTTON');
        Text::script('COM_UITHEMEBUILDERLITE_BUTTON_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_COUNTDOWN');
        Text::script('COM_UITHEMEBUILDERLITE_DIVIDER');
        Text::script('COM_UITHEMEBUILDERLITE_FILTERING');
        Text::script('COM_UITHEMEBUILDERLITE_FLICKR');
        Text::script('COM_UITHEMEBUILDERLITE_ICON_BOX_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_IMAGE');
        Text::script('COM_UITHEMEBUILDERLITE_IMAGE_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_LIGHTBOX');
        Text::script('COM_UITHEMEBUILDERLITE_LIGHTBOX_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_LIST');
        Text::script('COM_UITHEMEBUILDERLITE_MEDIA_CARD');
        Text::script('COM_UITHEMEBUILDERLITE_MEDIA_CARD_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_MODULE');
        Text::script('COM_UITHEMEBUILDERLITE_MODULE_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_NAVBAR_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_NUM_SCROLLER_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_PERSONAL_CARD');
        Text::script('COM_UITHEMEBUILDERLITE_PRICE_TABLE');
        Text::script('COM_UITHEMEBUILDERLITE_PROGRESS_BARS');
        Text::script('COM_UITHEMEBUILDERLITE_SLIDER');
        Text::script('COM_UITHEMEBUILDERLITE_SLIDER_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_SPACER');
        Text::script('COM_UITHEMEBUILDERLITE_TAB');
        Text::script('COM_UITHEMEBUILDERLITE_TEXT_BLOCK');
        Text::script('COM_UITHEMEBUILDERLITE_TEXT_BLOCK_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_TIMELINE_PRO');
        Text::script('COM_UITHEMEBUILDERLITE_VIDEO');

        Text::script('COM_UITHEMEBUILDERLITE_VISIBILITY');

        $this->addToolBar();

        parent::display($tpl);
    }

    /**
     * Add the page title and toolbar.
     *
     * @return  void
     *
     * @throws \Exception
     *
     * @since   v1.0.0
     */
    protected function addToolbar(): void
    {
        Factory::getApplication()->input->set('hidemainmenu', true);

        $config_params               = ComponentHelper::getParams('com_uithemebuilderlite');
        $save_history_uithemebuilder = $config_params->get('save_history');
        $config                      = Factory::getApplication();
        $save_history                = $config->get('save_history', true);
        $toolbar                     = Toolbar::getInstance();

        $toolbar->cancel('page.cancel', 'JTOOLBAR_CLOSE');

        $isNew = ($this->item->id === 0);
        if (!$isNew) {
            if ($save_history && $save_history_uithemebuilder === "1" && ComponentHelper::isEnabled('com_contenthistory')) {
                ToolbarHelper::versions('com_uithemebuilderlite.page', $this->item->id);
            }

            $url = RouteHelper::getPageRoute($this->item->id . ':' . $this->item->alias, $this->item->catid, $this->item->language);
            $toolbar->preview(Route::link('site', $url, true), 'JGLOBAL_PREVIEW')
                ->bodyHeight(80)
                ->modalWidth(90);

            if (PluginHelper::isEnabled('system', 'jooa11y')) {
                $toolbar->jooa11y(Route::link('site', $url . '&jooa11y=1', true), 'JGLOBAL_JOOA11Y')
                    ->bodyHeight(80)
                    ->modalWidth(90);
            }
        }

        // Set title
        ToolbarHelper::title($isNew ? '<strong>' . Text::_('COM_UITHEMEBUILDERLITE') . '</strong>: ' . Text::_('COM_UITHEMEBUILDERLITE_ADD_PAGE') : '<strong>' . Text::_('COM_UITHEMEBUILDERLITE') . '</strong>: ' . Text::_('COM_UITHEMEBUILDERLITE_EDIT_PAGE'));
    }
}
