<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
namespace SW\Component\uiThemeBuilderLite\Administrator\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\Filesystem\Folder;
use Joomla\CMS\Filesystem\Path;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Uri\Uri;

/**
 * ui/Theme-Builder Lite page helper.
 *
 * @since  v1.0.0
 */
class PageHelper extends ContentHelper
{

    public static array $forms = array();

    /**
     * @param   array  $options
     *
     * @return string[]
     *
     * @since v1.2.0
     */
    public static function getSectionDividers(array $options): array
    {
        $svg_paths_top = '';
        $svg_paths_bottom = '';

        // Section Dividers Top
        if ($options['section_divider_top_flip'] === "1") {
            $svg_flip = ' transform="scale(-1,1) translate(-200,0)"';
        } else {
            $svg_flip = '';
        }

        switch ($options['section_divider_top']) {
            case 'default_seperator':
                $svg_paths_top = '<path id="default-seperator" d="M0 0C0 0 0.05 12 0.05 12 0.05 12 152.8 29.13 152.8 29.13 152.8 29.13 200 12 200 12 200 12 200 0 200 0 200 0 0 0 0 0Z"' . $svg_flip . ' />';
                break;
            case 'arrow_up':
                $svg_paths_top = '<path class="bg" fill-opacity=".8" d="M0 22C0 22 100 10 100 10 100 10 200 22 200 22 200 22 200 0 200 0 200 0 0 0 0 0 0 0 0 22 0 22Z"/><path id="arrow_up" d="M0 20C0 20 100 10 100 10 100 10 200 20 200 20 200 20 200 0 200 0 200 0 0 0 0 0 0 0 0 20 0 20Z"/>';
                break;
            case 'tilt_small_top':
                $svg_paths_top = '<path id="tilt-small-top" d="M200 0C200 0 0 0 0 0 0 0 200 10 200 10 200 10 200 0 200 0Z"' . $svg_flip . ' />';
                break;
            case 'tilt_large_top':
                $svg_paths_top = '<path id="tilt-large-top" d="M200 0C200 0 0 0 0 0 0 0 200 30 200 30 200 30 200 0 200 0Z"' . $svg_flip . ' />';
                break;
            case 'abstract_top':
                $svg_paths_top = '<path id="abstract-top" d="M192.89 22C193.26 22.01 193.64 21.87 194 21.79 194.57 21.66 194.69 21.75 195.11 21.33 195.11 21.33 200 21.33 200 21.33 200 21.33 200 0 200 0 200 0 0 0 0 0 0 0 0 5.11 0 5.11 0 5.11 0.89 4.89 0.89 4.89 1.95 6.3 3.88 5.75 5.11 6.06 6.07 6.3 6.38 6.87 7.15 7.11 7.87 7.34 8.24 7.26 8.67 6.67 11.48 7.47 11.49 6.53 12.67 7.78 14.53 7.25 13.76 8.44 17.33 8.44 17.33 8.44 22.89 8.58 22.89 8.58 22.89 8.58 27.2 9.92 27.2 9.92 28.62 10.1 30.85 11.88 32 10.22 32 10.22 34.89 10.67 34.89 10.67 35.81 12.34 37.96 11.68 39.56 11.75 39.56 11.75 41.78 11.75 41.78 11.75 41.78 11.75 45.79 11.75 45.79 11.75 45.79 11.75 49.3 12.51 49.3 12.51 50 12.5 50.86 12.1 51.33 12.01 52.06 11.92 53.63 12.51 55.78 12.01 56.25 12.82 57.7 13.72 58.67 13.77 59.04 13.79 59.42 13.65 59.77 13.56 60.34 13.43 60.47 13.53 60.89 13.11 62.45 13.35 63.45 12.79 64.67 12.9 66.18 13.05 69.87 13.88 71.11 13.56 71.11 13.56 71.33 14.22 71.33 14.22 72.4 13.96 72.91 14.2 73.56 13.33 75.28 14.24 77.31 13.44 79.11 13.09 79.11 13.09 81.56 12.83 81.56 12.83 81.56 12.83 86.44 11.38 86.44 11.38 86.44 11.38 92.22 8.22 92.22 8.22 93.06 9.74 94.95 9.35 96.44 9.3 96.44 9.3 103.12 9.3 103.12 9.3 103.12 9.3 107.61 10.41 107.61 10.41 107.61 10.41 107.78 9.78 107.78 9.78 107.78 9.78 108.22 9.78 108.22 9.78 108.22 9.78 108.22 10.44 108.22 10.44 108.22 10.44 109.56 9.56 109.56 9.56 111.1 11.09 111.92 10.42 113.74 10.75 115.52 11.08 114.78 11.66 117.11 11.12 117.68 10.99 117.8 11.09 118.22 10.67 118.22 10.67 123.33 10.67 123.33 10.67 123.33 10.67 128.44 11.11 128.44 11.11 128.44 11.11 128.67 11.78 128.67 11.78 129.58 11.56 130.8 11.13 131.56 11.78 133.88 11.72 133.37 13.4 135.11 13.11 136.17 14.52 138.1 13.97 139.34 14.28 140.29 14.52 140.6 15.09 141.37 15.34 142.09 15.57 142.47 15.49 142.89 14.89 145.7 15.69 145.71 14.76 146.89 16 148.75 15.47 147.99 16.66 151.56 16.67 151.56 16.67 157.11 16.8 157.11 16.8 157.11 16.8 161.43 18.14 161.43 18.14 162.85 18.32 165.07 20.1 166.22 18.44 166.22 18.44 169.11 18.89 169.11 18.89 170.03 20.57 172.19 19.9 173.78 19.97 173.78 19.97 176 19.97 176 19.97 176 19.97 180.01 19.97 180.01 19.97 180.01 19.97 183.52 20.73 183.52 20.73 184.22 20.72 185.08 20.32 185.56 20.24 186.28 20.14 187.85 20.73 190 20.24 190.48 21.04 191.92 21.95 192.89 22ZM104.48 9.24C104.48 9.24 107.71 9.33 107.71 9.33 107.71 9.33 107.49 10.14 107.49 10.14 107.49 10.14 104.48 9.24 104.48 9.24Z"' . $svg_flip . ' />';
                break;
            case 'wave_large_top':
                $svg_paths_top = '<path id="wave-large-top" d="M200 0C200 0 0 0 0 0 0 0 0 3 0 3 0 3 16.36 3 54.37 7.05 81.97 9.64 111.73 13.41 121.68 18.25 162.55 34.55 200 20 200 20 200 20 200 0 200 0Z"' . $svg_flip . ' />';
                break;
            case 'ripped_paper_top':
                $svg_paths_top = '<path id="ripped-paper" d="M200 0C200 0 200 8 200 8 200 8 199.83 8.56 199.71 8.89 199.55 9.31 199.06 9.64 198.77 9.81 197.81 10.39 197.1 10.56 196.07 10.53 195.28 10.51 195.48 10.2 194.93 9.49 194.59 9.06 193.8 8.53 193.48 8.25 192.66 7.92 192.59 8.99 192.32 9.2 192.07 9.41 190.34 9.04 189.95 7.96 189.13 8.31 187.91 7.68 187.14 7.16 187.14 7.16 187.25 6.68 187.25 6.68 186.46 6.74 185.65 6.01 185.17 6.06 184.66 6.11 184.67 6.48 183.93 6.69 183.11 6.97 182.78 6.8 182.01 6.69 181.54 6.52 180.09 6.95 179.46 5.23 179.03 5.63 177.7 7.12 177.3 7.08 177.12 7.07 177.09 6.97 176.97 6.84 176.66 7.89 175.64 9.61 174.8 8.9 174.52 8.66 174.39 8 174.24 7.92 173.63 7.1 172.87 6.7 172.3 5.23 172.3 5.23 171.97 4.11 171.97 4.11 171.72 3.34 171.02 2.28 170.43 2.24 169.41 2.16 169.76 3.96 169.17 4.41 169.17 4.41 167.83 5.11 167.83 5.11 167.51 5.32 167.07 5.8 166.79 5.88 166.52 5.96 165.55 5.75 165.03 6 164.25 6.39 164.5 7.27 163.88 7.19 163.25 7.11 162.24 5.79 161.7 5.21 161.31 5.92 160.45 5.27 159.94 5.21 159.51 5.1 159.37 5.27 159 5.56 158.81 4.93 158.68 4.63 158.37 4.11 158.11 3.67 157.34 2.52 156.91 2.7 156.53 2.86 156.58 3.52 156.18 4.27 155.67 5.22 154.61 6.59 153.81 6.84 153.48 4.85 152.21 4.52 151.11 3.95 150.98 6.17 149.97 5.76 148.93 5.47 147.99 5.21 147.91 5.21 146.96 4.76 146.67 4.62 146.21 4.37 145.92 4.45 145.92 4.45 145.3 4.82 145.3 4.82 145.03 4.97 143.44 5.58 143.22 5.54 143.22 5.54 141.66 4.7 141.66 4.7 140.46 4.26 140.56 4.71 140 4.43 140 4.43 138.34 3.28 138.34 3.28 137.91 3.14 137.84 3.48 137.49 3.54 137.24 3.66 136.85 3.52 136.58 3.54 136.24 3.44 135.64 3.35 135.34 3.54 135 3.78 134.93 4.18 134.68 4.53 134.33 5.03 133.11 5.59 132.66 5.28 132.5 5.17 132.51 5.1 132.42 4.91 131.63 5.79 131.11 7.03 130.59 8.28 130.42 8.69 130.22 9.58 129.92 9.66 129.61 9.74 129.23 9.33 129 9.06 129 9.06 127.23 6.68 127.23 6.68 126.68 7.94 125.38 6.38 124.64 6.89 123.94 7.37 122.77 9.4 122.35 9.61 122.03 9.81 121.64 9.61 121.31 9.61 120.8 9.54 120.35 9.69 120.04 10.38 119.86 10.79 119.88 11.18 119.62 11.45 119.28 11.8 117.4 12.09 116.95 12.07 116.04 12.02 114.93 10 114.36 9.96 114 9.93 112.8 10.53 112.49 10.85 111.98 11.38 112.11 11.77 111.45 11.81 110.71 11.86 109.73 11.79 109.48 10.53 108.44 10.66 107.69 11.23 106.78 10.21 106.11 11.23 104.96 11.42 104.08 11.17 103.89 12.51 103.15 12.67 102.41 12.22 101.73 11.8 101.41 11.16 101.27 10.02 100.51 10.67 99.79 10.21 98.99 10.02 97.67 9.63 97.96 9.47 96.81 8.66 95.12 7.46 94.45 7 93.07 4.91 92.98 7.44 91.49 6.4 90.47 5.88 90.1 6.72 89.18 5.8 88.6 5.75 87.75 5.66 88.03 6.63 87.55 6.77 87.01 6.94 85.79 5.51 85.28 5.07 84.91 6.13 84.21 7.1 83.62 7.87 83.38 8.18 83.12 8.62 82.79 8.63 82.2 8.66 81.44 7.51 80.4 7.9 78.98 8.42 77.66 10.12 76.87 10.48 76.55 10.59 75.97 10.81 75.68 10.48 75.44 10.26 75.44 9.78 75.07 9.73 74.63 9.66 73.85 10.43 73.35 10.11 72.99 9.88 73.04 9.28 72.61 9.12 71.99 8.97 71.38 9.76 70.43 9.12 70.2 9.84 69.04 11.72 68.42 11.01 68.26 10.83 68.2 10.34 68.15 10.05 67.21 11.65 67.14 12.67 66.9 14.71 65.64 13.95 65.24 14.17 64 14.09 64 14.09 63.37 14.09 63.37 14.09 63.01 14.11 62.83 14.24 62.44 14.18 62.2 14.17 61.95 14.05 61.71 14.18 61.4 14.32 61.01 14.98 60.78 15.35 59.97 16.59 59.69 17.47 58.49 17.43 57.71 17.4 56.81 17.08 56.52 15.83 55.73 16.17 55.12 15.84 54.34 15.64 53.52 15.43 53.49 15.94 52.68 14.7 52.44 14.33 52.01 13.54 51.83 13.1 51.83 13.1 51.46 11.98 51.46 11.98 51.17 11.34 50.36 10.52 49.87 10.29 49.21 9.99 49.34 10.84 48.98 11.41 48.72 11.83 48.37 11.94 48 11.97 47.64 12 47.1 11.99 46.8 11.64 46.56 11.37 46.53 10.97 46.3 10.56 46 10.02 45.46 9.6 44.99 9.59 44.2 9.57 44.2 10.46 43.73 10.64 43.41 10.77 42.42 10.32 41.88 10.64 41.32 11 41.45 11.83 40.84 11.77 40.31 11.72 39.64 11 39.33 10.37 39.09 9.9 39.06 9.45 38.84 9.28 38.35 8.91 36.94 10.49 36.48 10.55 35.91 10.62 35.22 9.12 34.51 9.12 34.23 9.11 34.01 9.36 33.78 9.57 33.33 8.11 32.43 8.08 31.71 9.12 31.35 9.65 31.32 10.12 31.05 10.25 30.56 10.49 29.34 9.29 29.02 8.75 28.84 8.45 28.8 8.32 28.69 7.96 27.93 8.25 27.32 8.04 26.62 7.54 26.09 7.17 26.1 6.74 25.68 6.75 25.1 6.78 24.41 7.82 23.91 8.25 23.47 8.64 23.36 8.35 22.88 8.6 22.52 8.78 21.96 9.34 21.63 9.42 21.31 9.49 21.09 9.25 20.8 9.11 20.24 8.84 19.03 8.21 18.52 8.28 18.52 8.28 18.62 8.77 18.62 8.77 18.62 8.77 16.54 9.63 16.54 9.63 16.54 9.63 16 10.39 16 10.39 16 10.39 16.23 11.17 16.23 11.17 15.08 11.01 14.58 10.23 13.64 9.41 13.38 10.21 12.64 12.08 12.08 12.32 11.82 12.43 11.5 12.2 11.25 12.08 10.2 11.61 10.24 11.46 9.38 10.89 8.48 10.29 7.46 10.49 6.57 11.01 6.57 11.01 6.99 11.85 6.99 11.85 6.11 12.2 4.73 11.81 4.51 11.85 4.06 12.01 0.92 12.45 0 13 0 13 0 0 0 0 0 0 200 0 200 0ZM200-6"' . $svg_flip . ' />';
                break;
            case 'drip_top':
                $svg_paths_top = '<path id="drip-top" d="M200 27.26C199.67 28.09 199.41 29.13 200 29.91 200 29.91 200 27.26 200 27.26ZM0 0C0 0 0 14.24 0 14.24 0.45 15.82 0.07 17.49 0.33 19.1 0.32 20.2 0.4 21.31 0.24 22.4 0.23 23.9 0.24 25.4 0.24 26.91 0.25 27.24 0.1 27.54 0 27.85 0 27.85 0 29.31 0 29.31 0.1 29.48 0.22 29.65 0.38 29.76 0.65 29.79 1.02 29.86 1.19 29.58 1.62 29.07 1.48 28.35 1.33 27.76 1.09 26.76 1.08 25.72 0.98 24.7 0.99 22.23 0.98 19.77 0.98 17.3 1.01 16.77 1.11 16.26 1.22 15.74 1.35 14.96 1.58 14.14 2.17 13.57 2.43 13.33 2.77 13.07 3.15 13.19 4.01 13.75 4.39 14.77 5.16 15.44 5.91 16.28 6.87 16.89 7.78 17.54 8.11 17.77 8.33 18.12 8.45 18.49 8.9 19.78 8.82 21.16 8.81 22.5 8.72 23.53 8.42 24.54 8.56 25.58 8.7 25.97 9.16 26.09 9.5 25.92 9.72 25.79 9.68 25.52 9.69 25.31 9.68 24.68 9.7 24.05 9.63 23.42 9.53 22.89 9.45 22.34 9.48 21.8 9.51 20.74 9.42 19.68 9.55 18.62 9.57 17.88 9.69 17.15 9.68 16.41 9.63 15.43 9.93 14.47 9.96 13.5 9.96 12.92 10.13 12.37 10.17 11.79 10.33 10.66 10.52 9.51 10.89 8.42 11.28 7.24 12.17 6.31 13.11 5.53 13.73 5.06 14.46 4.54 15.28 4.68 15.88 4.83 16.32 5.33 16.62 5.85 17.01 6.64 17.11 7.53 17.23 8.4 17.21 9.1 17.32 9.85 17.76 10.43 18.26 11.01 19.13 11.34 19.25 12.18 19.63 13.55 19.49 14.99 19.52 16.4 19.54 18 18.79 19.51 18.92 21.11 18.91 21.51 19.19 21.85 19.5 22.06 19.8 22.11 20.11 22.1 20.4 22.05 20.57 21.91 20.76 21.73 20.77 21.5 20.81 21.03 20.78 20.57 20.79 20.1 20.8 19.39 20.63 18.7 20.56 18 20.5 17.37 20.3 16.74 20.42 16.1 20.5 15.44 20.49 14.77 20.48 14.1 20.51 13.46 20.7 12.84 20.67 12.2 20.79 11.31 21 10.44 21.25 9.58 21.71 8.27 22.03 6.92 22.45 5.59 22.64 5.06 22.73 4.5 22.92 3.97 23.18 3.29 23.93 2.97 24.6 2.86 25.03 2.86 25.47 2.98 25.85 3.18 26.55 3.6 26.79 4.43 27.16 5.11 27.83 6.37 28.21 7.78 28.32 9.2 28.32 10.9 28.31 12.6 28.32 14.3 28.34 14.94 28.17 15.56 28.12 16.2 28.06 16.82 27.73 17.43 27.86 18.08 28.02 18.61 28.89 18.66 29.09 18.13 29.28 17.64 29.08 17.11 29.07 16.6 29.08 16.03 28.9 15.47 28.88 14.9 28.89 13.8 28.89 12.7 28.88 11.6 28.87 11.12 28.95 10.64 29.03 10.17 29.14 9.08 29.25 7.97 29.71 6.97 30 6.29 30.66 5.83 31.36 5.64 31.83 5.47 32.4 5.59 32.77 5.93 33.18 6.43 33.28 7.1 33.39 7.73 33.5 8.26 33.38 8.81 33.48 9.35 33.57 9.83 33.64 10.31 33.62 10.8 33.59 11.47 33.66 12.14 33.72 12.8 33.69 14.08 33.78 15.37 33.64 16.65 33.64 17.37 33.54 18.08 33.52 18.8 33.41 19.93 33.18 21.05 32.89 22.16 32.71 22.81 32.7 23.49 32.77 24.16 32.95 24.66 33.43 25.16 34 25.08 34.46 25.08 34.91 24.78 35.12 24.38 35.33 24.02 35.26 23.59 35.28 23.2 35.31 22.18 34.88 21.22 34.86 20.21 34.83 19.26 34.53 18.35 34.59 17.4 34.6 16.8 34.56 16.2 34.49 15.6 34.48 14.3 34.48 13 34.49 11.7 34.57 11.05 34.57 10.38 34.65 9.73 34.89 8.25 35.08 6.68 35.93 5.41 36.19 4.99 36.71 4.81 37.18 4.87 37.76 5.02 38.17 5.51 38.52 5.96 39.12 6.82 39.79 7.62 40.48 8.4 40.85 8.95 41.27 9.52 41.33 10.2 41.34 11.07 41.2 11.93 40.99 12.78 40.92 13.1 40.89 13.51 41.19 13.74 41.42 13.95 41.84 13.92 41.96 13.6 42.13 12.45 41.57 11.29 41.93 10.16 42.07 9.63 42.46 9.21 42.79 8.78 43.12 8.35 43.52 7.98 43.87 7.55 44.27 7.06 44.78 6.67 45.24 6.25 45.73 5.78 46.51 5.75 47.09 6.04 47.56 6.27 47.86 6.72 48.12 7.15 48.74 8.38 48.53 9.83 49.07 11.09 49.27 11.58 49.76 11.98 50.31 11.97 50.99 12.04 51.59 11.59 52.03 11.12 52.41 10.68 52.88 10.21 53.5 10.16 53.82 10.2 54.2 10.3 54.37 10.59 54.56 11.14 54.51 11.74 54.61 12.3 54.67 12.93 54.74 13.54 54.77 14.17 55.01 15.2 54.85 16.26 55.02 17.3 55.02 18.8 55.01 20.3 55.02 21.8 54.96 22.63 54.85 23.45 54.75 24.28 54.7 25.02 54.71 25.76 54.72 26.5 54.72 26.87 54.94 27.19 55.19 27.45 55.52 27.5 55.88 27.53 56.21 27.44 56.48 27.13 56.7 26.73 56.68 26.31 56.68 25.52 56.74 24.72 56.56 23.94 56.43 23.27 56.52 22.57 56.44 21.89 56.33 21.03 56.4 20.16 56.39 19.3 56.52 18.27 56.48 17.23 56.48 16.2 56.52 15.5 56.74 14.81 56.66 14.1 56.78 13.35 56.79 12.58 57.01 11.84 57.14 11.08 57.25 10.32 57.43 9.56 57.68 8.52 57.81 7.42 58.4 6.5 58.24 6.94 58.02 7.35 57.9 7.8 57.44 9.57 57.11 11.37 56.87 13.18 56.8 13.5 56.72 13.83 56.81 14.15 56.84 13.77 56.85 13.38 56.98 13.01 57.09 12.73 57.01 12.43 57.07 12.14 57.23 11.24 57.35 10.33 57.57 9.44 57.79 8.54 57.91 7.61 58.36 6.79 58.68 6.26 59.15 5.78 59.74 5.57 60.35 5.48 61.09 5.49 61.49 6.03 61.89 6.49 61.75 7.13 61.76 7.69 61.64 8.5 61.48 9.29 61.37 10.1 61.38 10.51 61.2 10.92 61.34 11.33 61.41 11.79 61.73 12.23 62.21 12.33 62.47 12.34 62.69 12.15 62.86 11.97 63.19 11.6 63.16 11.06 63.13 10.6 63 9.69 62.94 8.77 62.76 7.86 62.72 6.9 62.68 5.93 62.91 4.98 63.05 4.12 63.46 3.28 64.17 2.74 64.51 2.46 64.98 2.49 65.39 2.55 65.76 2.73 66.06 3.05 66.22 3.43 66.5 4.11 66.63 4.84 66.71 5.57 66.82 6.21 66.7 6.86 66.81 7.5 66.93 8.46 66.8 9.44 66.91 10.4 66.83 11.2 66.88 12 66.86 12.8 66.84 13.57 67.05 14.33 67.04 15.1 66.98 15.93 66.84 16.76 66.86 17.6 66.88 18.41 66.62 19.19 66.64 20 66.65 20.42 66.55 20.91 66.84 21.26 67.03 21.56 67.38 21.75 67.73 21.64 68.11 21.44 68.38 21.02 68.36 20.59 68.4 19.49 68.13 18.41 68.14 17.3 68.17 16.73 67.95 16.18 67.96 15.61 67.97 14.54 67.96 13.47 67.97 12.4 68.05 11.52 68.2 10.65 68.27 9.77 68.42 9.27 68.83 8.71 69.4 8.74 69.76 8.71 70.02 9.04 70.17 9.33 70.59 10.27 70.73 11.3 71.16 12.24 71.41 12.79 71.97 13.24 72.6 13.17 73.28 13.25 73.91 12.77 74.16 12.17 74.45 11.49 74.59 10.75 74.87 10.07 75.03 9.66 75.35 9.35 75.72 9.12 76.08 8.87 76.54 8.93 76.96 8.96 77.43 9.07 77.84 9.41 78.05 9.85 78.49 10.7 78.52 11.7 78.94 12.57 79.41 13.59 80.02 14.57 80.83 15.37 81.46 15.98 81.99 16.74 82.19 17.61 82.41 18.55 82.53 19.5 82.64 20.46 82.69 21 82.79 21.55 82.71 22.1 82.63 22.63 82.68 23.17 82.61 23.7 82.5 24.38 82.62 25.09 82.44 25.77 82.33 26.08 82.14 26.38 82.14 26.72 82.14 27.33 82.11 27.94 82.16 28.54 82.3 28.8 82.59 28.95 82.87 29.04 83.27 29.09 83.79 29.12 84.05 28.75 84.43 28.24 84.33 27.58 84.34 27 84.35 26.43 84.09 25.9 84.06 25.33 84.04 24.82 83.94 24.31 83.94 23.8 83.92 23.1 83.99 22.4 83.88 21.71 83.81 21.14 83.83 20.57 83.91 20 84 18.33 84.16 16.66 84.4 15 84.6 14.12 84.71 13.14 85.33 12.43 85.75 11.95 86.29 11.56 86.91 11.37 87.62 11.27 88.36 11.4 89.08 11.31 90.38 11.05 91.08 9.73 92.33 9.36 92.73 9.32 93.15 9.31 93.55 9.37 94.44 9.63 95.11 10.4 95.39 11.26 95.87 12.61 96.06 14.07 95.88 15.5 95.81 17.06 95.95 18.64 95.77 20.2 95.75 21.1 95.54 21.99 95.46 22.89 95.42 23.42 95.46 24.04 95.87 24.43 96.3 24.48 96.88 24.58 97.13 24.13 97.53 23.43 97.33 22.57 97.18 21.82 96.97 21.01 97.09 20.16 96.95 19.34 96.92 17.6 96.94 15.85 96.94 14.1 97.03 13.26 97.09 12.41 97.17 11.56 97.26 11.09 97.48 10.65 97.61 10.18 98 8.73 99.13 7.53 100.49 6.93 101.13 6.67 101.95 6.61 102.52 7.07 103.03 7.49 103.32 8.15 103.39 8.8 103.57 9.96 103.38 11.14 103.24 12.3 103.27 12.76 103.08 13.36 103.54 13.66 103.83 13.92 104.24 13.62 104.27 13.28 104.5 12.55 104.1 11.84 104.13 11.11 104.14 10.37 104.13 9.64 104.14 8.9 104.22 7.79 104.43 6.63 105.09 5.71 105.68 4.95 106.6 4.35 107.6 4.43 108.18 4.41 108.63 4.88 108.88 5.36 109.84 7.09 109.98 9.1 110.27 11.02 110.38 11.54 110.31 12.08 110.37 12.62 110.55 13.83 110.33 15.08 110.52 16.3 110.59 17.26 110.53 18.22 110.37 19.17 110.3 20.11 110.35 21.06 110.34 22 110.3 22.44 110.81 22.81 111.21 22.61 111.38 22.47 111.5 22.28 111.54 22.06 111.63 21.07 111.4 20.09 111.44 19.1 111.44 17.6 111.42 16.1 111.44 14.6 111.56 13.84 112.03 13.02 112.83 12.85 113.11 12.84 113.48 12.75 113.68 13.02 114.1 13.51 114.2 14.18 114.17 14.8 114.15 17.87 114.19 20.93 114.14 24 114.12 24.54 114 25.06 113.98 25.6 114.05 26.13 114.04 26.67 114.04 27.2 114 27.72 114.47 28.33 115.03 28.15 115.42 27.93 115.62 27.5 115.67 27.08 115.86 26.29 115.58 25.5 115.64 24.7 115.68 24 115.51 23.31 115.54 22.6 115.5 21.2 115.61 19.79 115.47 18.4 115.51 17.83 115.65 17.27 115.63 16.7 115.63 16.2 115.63 15.7 115.71 15.21 115.82 12.49 116.06 9.79 116.27 7.08 116.34 6.29 116.58 5.49 117.08 4.86 117.26 4.83 117.45 4.82 117.64 4.85 117.8 4.97 117.8 5.21 117.83 5.39 117.85 6 117.84 6.6 117.83 7.2 117.72 8.16 117.76 9.13 117.71 10.1 117.65 10.53 117.63 10.98 117.81 11.4 117.94 11.71 118.23 12.04 118.6 11.97 118.98 12.02 119.19 11.63 119.22 11.3 119.3 10.56 119.21 9.81 119.14 9.07 119.13 7.48 119.14 5.9 119.14 4.31 119.11 4.01 119.27 3.67 119.56 3.56 120.39 3.49 121.24 3.6 122.06 3.74 122.82 4 123.09 4.85 123.63 5.37 124.23 5.79 125.06 5.86 125.5 6.5 126.09 7.23 125.95 8.23 125.9 9.1 125.78 9.63 125.99 10.17 125.9 10.7 125.83 11.3 125.88 11.9 125.86 12.5 125.88 13.17 125.82 13.84 125.91 14.5 125.99 15.03 125.78 15.57 125.89 16.1 125.98 16.53 125.9 16.97 125.86 17.4 125.84 18.91 125.91 20.44 125.75 21.94 125.73 22.46 125.75 22.98 125.66 23.49 125.57 24.08 125.72 24.72 126.18 25.13 126.38 25.18 126.62 25.2 126.82 25.12 127.2 24.88 127.33 24.41 127.39 23.99 127.55 23.23 127.28 22.47 127.34 21.7 127.39 21.03 127.22 20.37 127.24 19.7 127.24 18.97 127.24 18.24 127.24 17.5 127.26 16.9 127.1 16.31 127.14 15.7 127.16 14.47 127.06 13.23 127.23 12 127.26 11.19 127.21 10.37 127.25 9.56 127.37 8.57 127.33 7.55 127.59 6.58 127.71 6.32 127.93 6.13 128.11 5.91 128.31 5.68 128.45 5.39 128.67 5.17 128.9 4.96 129.23 4.88 129.45 4.65 129.63 4.47 129.79 4.24 130.04 4.15 130.41 4.04 130.79 3.93 131.17 3.86 131.69 3.77 132.17 4.05 132.61 4.3 132.96 4.49 133 4.92 133.15 5.26 133.34 5.8 133.84 6.2 133.91 6.79 134.05 7.67 134.37 8.52 134.5 9.4 134.58 10 134.94 10.5 135.15 11.06 135.45 11.73 135.48 12.48 135.54 13.2 135.58 13.9 135.42 14.6 135.43 15.3 135.29 16.32 135.16 17.34 135.04 18.36 134.96 18.99 134.77 19.63 134.89 20.27 134.98 20.72 135.41 21.01 135.82 21.13 136.17 21.19 136.48 20.94 136.72 20.72 137.19 20.21 137.29 19.47 137.26 18.8 137.24 17.95 137.32 17.08 137.17 16.23 137.05 15.15 136.72 14.1 136.74 13 136.75 12.65 136.67 12.3 136.65 11.94 136.59 11.24 136.77 10.54 136.75 9.84 136.92 8.26 137.14 6.66 137.63 5.13 137.8 4.54 138.27 4.09 138.8 3.81 139.37 3.54 140.19 3.57 140.56 4.14 140.8 4.57 140.79 5.08 140.85 5.56 141.06 7.31 140.9 9.1 140.56 10.83 140.52 11.46 140.44 12.19 140.89 12.71 141.11 13.05 141.58 12.99 141.93 12.93 142.23 12.7 142.39 12.31 142.45 11.95 142.58 10.91 142.08 9.93 142.14 8.9 142.2 8.17 141.85 7.46 141.99 6.73 142.1 6.22 142.17 5.71 142.14 5.2 142.08 4.28 142.42 3.33 143.13 2.73 143.41 2.45 143.97 2.44 144.21 2.79 144.67 3.4 144.77 4.19 144.88 4.93 145.09 6.14 145.08 7.38 145.23 8.6 145.24 8.9 145.14 9.2 145.2 9.5 145.31 10.16 145.21 10.84 145.32 11.5 145.35 11.77 145.29 12.03 145.27 12.3 145.22 12.9 145.34 13.5 145.39 14.1 145.44 14.73 145.74 15.38 146.32 15.68 146.94 16.03 147.82 15.75 148.11 15.11 148.55 14.28 148.51 13.31 148.63 12.4 148.67 11.37 148.58 10.33 148.68 9.3 148.79 8.6 148.7 7.89 148.76 7.18 148.88 6.15 148.94 5.11 149.2 4.1 149.43 3.36 149.8 2.6 150.46 2.16 150.88 1.85 151.44 1.92 151.92 1.98 152.36 2.21 152.7 2.62 152.96 3.04 153.37 3.79 153.3 4.67 153.42 5.5 153.5 6.1 153.42 6.7 153.51 7.3 153.59 7.77 153.46 8.23 153.46 8.7 153.46 9.2 153.44 9.7 153.52 10.2 153.59 10.7 153.48 11.2 153.46 11.7 153.48 12.63 153.26 13.53 153.15 14.44 153.12 14.92 153.13 15.41 153.14 15.89 153.13 16.25 153.38 16.57 153.68 16.74 153.95 16.79 154.27 16.79 154.46 16.56 154.96 16.08 154.83 15.32 154.83 14.7 154.65 13.47 154.5 12.24 154.54 11 154.56 9.9 154.5 8.79 154.57 7.68 154.69 7.05 154.6 6.4 154.66 5.75 154.76 5.01 155.04 4.22 155.7 3.8 156.08 3.52 156.64 3.62 156.97 3.93 157.44 4.37 157.74 4.95 157.97 5.53 158.31 6.38 158.39 7.3 158.62 8.19 158.87 9.2 159.09 10.25 159.64 11.16 160.04 11.84 160.73 12.35 161.51 12.49 162.26 12.65 163.06 12.41 163.68 11.98 164.23 11.59 164.6 10.99 164.89 10.4 165.31 9.39 165.65 8.34 166.02 7.31 166.22 6.79 166.54 6.24 167.1 6.06 167.62 5.96 168.1 6.31 168.41 6.68 168.86 7.2 169.02 7.89 169.16 8.54 169.66 10.91 169.8 13.34 170.05 15.74 170.05 16.33 170.1 16.92 170.2 17.5 170.26 17.91 170.47 18.28 170.46 18.7 170.46 19.1 170.45 19.5 170.52 19.9 170.6 20.37 170.41 20.83 170.49 21.3 170.67 22.49 170.36 23.67 170.23 24.84 170.1 25.52 170.14 26.21 170.14 26.89 170.1 27.39 170.6 27.85 171.1 27.75 171.5 27.68 171.69 27.26 171.81 26.91 172.06 26.16 171.88 25.37 171.78 24.62 171.18 21.41 171.77 17.9 173.77 15.27 174.18 14.76 174.6 14.2 175.23 13.93 175.64 13.74 176.07 13.52 176.34 13.14 176.68 12.66 176.8 12.08 176.93 11.53 177.15 10.5 177.36 9.45 177.79 8.49 178.02 7.98 178.41 7.57 178.85 7.24 179.18 6.97 179.64 7.01 180.04 7.07 180.47 7.25 180.65 7.72 180.77 8.14 180.96 8.84 181.19 9.56 181.69 10.12 182.35 10.83 183.66 10.7 184.18 9.88 184.54 9.41 184.79 8.89 185.08 8.38 185.43 7.78 186.23 7.43 186.87 7.73 187.55 8.13 187.49 9.01 187.62 9.68 187.83 10.7 187.84 11.75 188.17 12.73 188.52 13.82 188.59 14.97 188.73 16.09 188.81 16.79 188.71 17.5 188.81 18.2 188.85 18.5 188.84 18.8 188.79 19.1 188.71 19.53 188.88 19.97 188.83 20.4 188.74 21 188.73 21.6 188.81 22.2 188.88 22.6 188.74 23 188.76 23.4 188.75 23.77 188.87 24.13 188.82 24.5 188.71 25.16 188.8 25.84 188.73 26.51 188.65 27.09 188.64 27.69 188.64 28.28 188.64 28.76 189.07 29.31 189.59 29.15 189.96 28.97 190.2 28.61 190.22 28.21 190.26 27.57 190.24 26.93 190.23 26.3 190.05 25.14 190.19 23.96 190.12 22.8 190.02 22.17 190.03 21.53 190.04 20.9 190.05 20.07 189.99 19.23 190.12 18.4 190.19 17.86 190.04 17.28 190.26 16.76 190.57 15.81 191.14 14.97 191.44 14.02 191.63 13.5 191.55 12.94 191.56 12.4 191.58 11.83 191.49 11.25 191.58 10.68 191.69 10.16 191.79 9.63 191.92 9.11 191.99 8.72 192.46 8.46 192.83 8.56 193.16 8.7 193.47 8.94 193.63 9.26 193.71 9.77 193.62 10.29 193.64 10.8 193.68 11.55 193.44 12.27 193.43 13.02 193.28 14.31 192.94 15.66 193.35 16.94 193.5 17.5 194.05 17.78 194.41 18.19 194.63 18.4 194.55 18.73 194.57 19 194.59 19.54 194.45 20.07 194.38 20.6 194.32 20.97 194.43 21.33 194.43 21.7 194.45 22.07 194.41 22.47 194.57 22.81 194.76 23.26 195.15 23.76 195.7 23.67 196.22 23.75 196.61 23.31 196.8 22.88 197.18 21.93 197.04 20.89 196.9 19.9 196.84 19.4 196.75 18.86 197.03 18.41 197.44 17.64 197.59 16.77 197.62 15.9 197.55 15.4 197.57 14.9 197.52 14.4 197.32 12.89 197 11.41 196.67 9.93 196.49 9.06 196.32 8.18 196.26 7.3 196.28 6.95 196.32 6.48 196.7 6.35 197.36 6.35 197.93 6.84 198.17 7.43 198.87 9.07 199.09 10.85 199.54 12.56 199.78 13.42 199.8 14.32 200 15.19 200 15.19 200 0 200 0 200 0 0 0 0 0M173.74 4.74C174.05 4.43 174.53 4.4 174.94 4.46 175.17 4.61 175.37 4.88 175.35 5.17 175.33 5.87 175.33 6.58 175.34 7.28 175.33 7.65 175.6 7.93 175.74 8.25 175.8 8.51 175.66 8.75 175.59 8.99 175.28 9.88 174.98 10.82 174.3 11.5 174.12 11.71 173.82 11.68 173.57 11.64 173.2 11.28 173.16 10.72 173.06 10.25 173.01 9.1 173.05 7.95 173.04 6.8 173.01 6.06 173.21 5.28 173.74 4.74M3.73 5.3C4.36 5.18 5.1 5.16 5.66 5.54 5.98 5.75 6.3 6.01 6.42 6.39 6.61 6.93 6.71 7.53 6.57 8.1 6.5 8.5 6.69 8.9 6.61 9.3 6.52 9.79 6.6 10.29 6.48 10.78 6.4 11.42 6.36 12.17 5.82 12.62 5.64 12.8 5.34 12.8 5.13 12.68 4.61 12.41 4.31 11.87 4 11.4 3.48 10.68 3.17 9.84 2.9 9 2.62 8.3 2.78 7.53 2.74 6.8 2.68 6.15 3.07 5.46 3.73 5.3M8.14 8.26C8.63 8.57 8.95 9.13 8.97 9.71 9.13 10.27 8.94 10.84 8.94 11.4 8.84 12.32 8.74 13.28 8.31 14.12 8.19 14.3 8.08 14.6 7.81 14.56 7.65 14.58 7.6 14.38 7.53 14.27 7.37 13.87 7.24 13.44 7.24 13 7.23 12.6 7.13 12.2 7.14 11.8 7.15 10.93 7.09 10.06 7.23 9.2 7.23 8.86 7.24 8.35 7.64 8.24 7.8 8.23 7.97 8.23 8.14 8.26Z"' . $svg_flip . ' />';
                break;
            case 'curve_top':
                $svg_paths_top = '<path id="curve-top" d="M0,29.5C0,14,89.45,1.5,200,1.5V0H0Z"' . $svg_flip . ' />';
                break;
            case 'curve_fan_top':
                $svg_paths_top = '<path id="curve-fan-top-opacity1" fill-opacity=".65" d="M200,0H0V.76C100,2.66,200,7.12,200,15Z"' . $svg_flip . ' /><path id="curve-fan-top-opacity2" fill-opacity=".45" d="M200,0H0V.52c100,1.28,200,4.3,200,9.65Z"' . $svg_flip . ' /><path id="curve-fan-top" d="M0,29.5C0,14,89.45,1.5,200,1.5V0H0Z"' . $svg_flip . ' />';
                break;
            case 'zick_zak_fan_top':
                $svg_paths_top = '<path id="zick-zak-fan-top-opacity1" fill-opacity=".7" d="M0 15l20-5 30 5L92 5l15 10 13-5 25 5 10-5 35 10 10-15V0H0v15z"' . $svg_flip . ' /><path id="zick-zak-fan-top" d="M0 20L25 5l40 10 40-10 15 10 5-10 35 10 40-10V0H0v20z"' . $svg_flip . ' />';
                break;
            case 'zick_zak_top':
                $svg_paths_top = '<path id="zick-zak-top" d="M0 20L25 5l40 10 40-10 15 10 5-10 35 10 40-10V0H0v20z"' . $svg_flip . ' />';
                break;
            case 'dots_top':
                $svg_paths_top = '<path id="dots-top" d="M200 12c0 4.76-10.64 3.9-11-1.3-1.6 2.54-5 4.3-9 4.3a11.74 11.74 0 01-7.35-2.42 10 10 0 01-18.42 2.22A17.94 17.94 0 01144 18a18 18 0 01-13.26-5.86C129.66 16.64 125.27 20 120 20c-6 0-10.83-4.34-11-9.74a8 8 0 01-11.78.27 17 17 0 01-30.15.61A11.49 11.49 0 0158.5 15a11.45 11.45 0 01-8.62-3.91 11.48 11.48 0 01-22.5 1.28A13.94 13.94 0 0118 16a14 14 0 01-6.51-1.61C10.3 17.66 3.68 20 0 20V0h200z"' . $svg_flip . ' />';
                break;
            case 'dots_fan_top':
                $svg_paths_top = '<path id="dots-fan-top-opacity" fill-opacity=".64" d="M62 7.68A16.6 16.6 0 0046.64-8 16.5 16.5 0 0029.86 3.26 10 10 0 0024.9 2a10.12 10.12 0 00-9.9 9.72 10 10 0 0017.48 6.9A16.49 16.49 0 0062 7.68zm57 7A10.5 10.5 0 00108.5 3a9.94 9.94 0 00-1.82.17A13 13 0 1094 19a12.89 12.89 0 005-1 10.49 10.49 0 0019.91-3.29zm62.94-.18a9 9 0 10-7.35 7.35 9 9 0 007.28-7.33z"' . $svg_flip . ' /><path id="dots-fan-top" d="M200 12c0 4.76-10.64 3.9-11-1.3-1.6 2.54-5 4.3-9 4.3a11.74 11.74 0 01-7.35-2.42 10 10 0 01-18.42 2.22A17.94 17.94 0 01144 18a18 18 0 01-13.26-5.86C129.66 16.64 125.27 20 120 20c-6 0-10.83-4.34-11-9.74a8 8 0 01-11.78.27 17 17 0 01-30.15.61A11.49 11.49 0 0158.5 15a11.45 11.45 0 01-8.62-3.91 11.48 11.48 0 01-22.5 1.28A13.94 13.94 0 0118 16a14 14 0 01-6.51-1.61C10.3 17.66 3.68 20 0 20V0h200z"' . $svg_flip . ' />';
                break;
            case 'bar_seperator_top':
                $svg_paths_top = '<path id="bar-seperator-top" d="M0 0h200v15H0V0z"/>';
                break;
            case 'bar_seperator_arrow_top':
                $svg_paths_top = '<path id="bar-seperator-arrow-top" d="m100 8-6 7H0V0h200v15h-94l-6-7Z"/>';
                break;
        }
        // END Section Dividers Top

        // Section Dividers Bottom
        if (($options['section_divider_bottom_flip'] === "1")) {
            $svg_flip = ' transform="scale(-1,1) translate(-200,0)"';
        } else {
            $svg_flip = '';
        }

        switch ($options['section_divider_bottom']) {
            case 'default_seperator_invert':
                $svg_paths_bottom = '<path id="default-seperator-invert" d="M0 30C0 30 0.05 18 0.05 18 0.05 18 152.8 0.87 152.8 0.87 152.8 0.87 200 18 200 18 200 18 200 30 200 30 200 30 0 30 0 30Z"' . $svg_flip . ' />';
                break;
            case 'arrow_down':
                $svg_paths_bottom = '<path id="arrow-down-bg" fill-opacity=".7" d="M 0.00,8.00 C 0.00,8.00 100.00,20.00 100.00,20.00 100.00,20.00 200.00,8.00 200.00,8.00 200.00,8.00 200.00,30.00 200.00,30.00 200.00,30.00 0.00,30.00 0.00,30.00 0.00,30.00 0.00,8.00 0.00,8.00 Z"' . $svg_flip . ' /><path id="arrow-down" d="M 0.00,10.00 C 0.00,10.00 100.00,20.00 100.00,20.00 100.00,20.00 200.00,10.00 200.00,10.00 200.00,10.00 200.00,30.00 200.00,30.00 200.00,30.00 0.00,30.00 0.00,30.00 0.00,30.00 0.00,10.00 0.00,10.00 Z"' . $svg_flip . ' />';
                break;
            case 'tilt_small_bottom':
                $svg_paths_bottom = '<path id="tilt-small-bottom" d="M200 30C200 30 0 30 0 30 0 30 200 20 200 20 200 20 200 30 200 30Z"' . $svg_flip . ' />';
                break;
            case 'tilt_large_bottom':
                $svg_paths_bottom = '<path id="tilt-large-bottom" d="M200 30C200 30 0 30 0 30 0 30 200 0 200 0 200 0 200 30 200 30Z"' . $svg_flip . ' />';
                break;
            case 'abstract_bottom':
                $svg_paths_bottom = '<path id="abstract-bottom" d="M192.89 8C193.26 7.99 193.64 8.13 194 8.21 194.57 8.34 194.69 8.25 195.11 8.67 195.11 8.67 200 8.67 200 8.67 200 8.67 200 30 200 30 200 30 0 30 0 30 0 30 0 24.89 0 24.89 0 24.89 0.89 25.11 0.89 25.11 1.95 23.7 3.88 24.25 5.11 23.94 6.07 23.7 6.38 23.13 7.15 22.89 7.87 22.66 8.24 22.74 8.67 23.33 11.48 22.53 11.49 23.47 12.67 22.22 14.53 22.75 13.76 21.56 17.33 21.56 17.33 21.56 22.89 21.42 22.89 21.42 22.89 21.42 27.2 20.08 27.2 20.08 28.62 19.9 30.85 18.12 32 19.78 32 19.78 34.89 19.33 34.89 19.33 35.81 17.66 37.96 18.32 39.56 18.25 39.56 18.25 41.78 18.25 41.78 18.25 41.78 18.25 45.79 18.25 45.79 18.25 45.79 18.25 49.3 17.49 49.3 17.49 50 17.5 50.86 17.9 51.33 17.99 52.06 18.08 53.63 17.49 55.78 17.99 56.25 17.18 57.7 16.28 58.67 16.23 59.04 16.21 59.42 16.35 59.77 16.44 60.34 16.57 60.47 16.47 60.89 16.89 62.45 16.65 63.45 17.21 64.67 17.1 66.18 16.95 69.87 16.12 71.11 16.44 71.11 16.44 71.33 15.78 71.33 15.78 72.4 16.04 72.91 15.8 73.56 16.67 75.28 15.76 77.31 16.56 79.11 16.91 79.11 16.91 81.56 17.17 81.56 17.17 81.56 17.17 86.44 18.62 86.44 18.62 86.44 18.62 92.22 21.78 92.22 21.78 93.06 20.26 94.95 20.65 96.44 20.7 96.44 20.7 103.12 20.7 103.12 20.7 103.12 20.7 107.61 19.59 107.61 19.59 107.61 19.59 107.78 20.22 107.78 20.22 107.78 20.22 108.22 20.22 108.22 20.22 108.22 20.22 108.22 19.56 108.22 19.56 108.22 19.56 109.56 20.44 109.56 20.44 111.1 18.91 111.92 19.58 113.74 19.25 115.52 18.92 114.78 18.34 117.11 18.88 117.68 19.01 117.8 18.91 118.22 19.33 118.22 19.33 123.33 19.33 123.33 19.33 123.33 19.33 128.44 18.89 128.44 18.89 128.44 18.89 128.67 18.22 128.67 18.22 129.58 18.44 130.8 18.87 131.56 18.22 133.88 18.28 133.37 16.6 135.11 16.89 136.17 15.48 138.1 16.03 139.34 15.72 140.29 15.48 140.6 14.91 141.37 14.66 142.09 14.43 142.47 14.51 142.89 15.11 145.7 14.31 145.71 15.24 146.89 14 148.75 14.53 147.99 13.34 151.56 13.33 151.56 13.33 157.11 13.2 157.11 13.2 157.11 13.2 161.43 11.86 161.43 11.86 162.85 11.68 165.07 9.9 166.22 11.56 166.22 11.56 169.11 11.11 169.11 11.11 170.03 9.43 172.19 10.1 173.78 10.03 173.78 10.03 176 10.03 176 10.03 176 10.03 180.01 10.03 180.01 10.03 180.01 10.03 183.52 9.27 183.52 9.27 184.22 9.28 185.08 9.68 185.56 9.76 186.28 9.86 187.85 9.27 190 9.76 190.48 8.96 191.92 8.05 192.89 8ZM104.48 20.76C104.48 20.76 107.71 20.67 107.71 20.67 107.71 20.67 107.49 19.86 107.49 19.86 107.49 19.86 104.48 20.76 104.48 20.76Z"' . $svg_flip . ' />';
                break;
            case 'wave_large_bottom':
                $svg_paths_bottom = '<path id="wave-large-bottom" d="M200 10C200 10 162.55-4.55 121.68 11.75 111.73 16.59 81.97 20.36 54.37 22.95 16.36 27 0 27 0 27 0 27 0 30 0 30 0 30 200 30 200 30 200 30 200 10 200 10Z"' . $svg_flip . ' />';
                break;
            case 'ripped_paper_bottom':
                $svg_paths_bottom = '<path id="ripped-paper-bottom" d="M200 30C200 30 200 22 200 22 200 22 199.83 21.44 199.71 21.11 199.55 20.69 199.06 20.36 198.77 20.19 197.81 19.61 197.1 19.44 196.07 19.47 195.28 19.49 195.48 19.8 194.93 20.51 194.59 20.94 193.8 21.47 193.48 21.75 192.66 22.08 192.59 21.01 192.32 20.8 192.07 20.59 190.34 20.96 189.95 22.04 189.13 21.69 187.91 22.32 187.14 22.84 187.14 22.84 187.25 23.32 187.25 23.32 186.46 23.26 185.65 23.99 185.17 23.94 184.66 23.89 184.67 23.52 183.93 23.31 183.11 23.03 182.78 23.2 182.01 23.31 181.54 23.48 180.09 23.05 179.46 24.77 179.03 24.37 177.7 22.88 177.3 22.92 177.12 22.93 177.09 23.03 176.97 23.16 176.66 22.11 175.64 20.39 174.8 21.1 174.52 21.34 174.39 22 174.24 22.08 173.63 22.9 172.87 23.3 172.3 24.77 172.3 24.77 171.97 25.89 171.97 25.89 171.72 26.66 171.02 27.72 170.43 27.76 169.41 27.84 169.76 26.04 169.17 25.59 169.17 25.59 167.83 24.89 167.83 24.89 167.51 24.68 167.07 24.2 166.79 24.12 166.52 24.04 165.55 24.25 165.03 24 164.25 23.61 164.5 22.73 163.88 22.81 163.25 22.89 162.24 24.21 161.7 24.79 161.31 24.08 160.45 24.73 159.94 24.79 159.51 24.9 159.37 24.73 159 24.44 158.81 25.07 158.68 25.37 158.37 25.89 158.11 26.33 157.34 27.48 156.91 27.3 156.53 27.14 156.58 26.48 156.18 25.73 155.67 24.78 154.61 23.41 153.81 23.16 153.48 25.15 152.21 25.48 151.11 26.05 150.98 23.83 149.97 24.24 148.93 24.53 147.99 24.79 147.91 24.79 146.96 25.24 146.67 25.38 146.21 25.63 145.92 25.55 145.92 25.55 145.3 25.18 145.3 25.18 145.03 25.03 143.44 24.42 143.22 24.46 143.22 24.46 141.66 25.3 141.66 25.3 140.46 25.74 140.56 25.29 140 25.57 140 25.57 138.34 26.72 138.34 26.72 137.91 26.86 137.84 26.52 137.49 26.46 137.24 26.34 136.85 26.48 136.58 26.46 136.24 26.56 135.64 26.65 135.34 26.46 135 26.22 134.93 25.82 134.68 25.47 134.33 24.97 133.11 24.41 132.66 24.72 132.5 24.83 132.51 24.9 132.42 25.09 131.63 24.21 131.11 22.97 130.59 21.72 130.42 21.31 130.22 20.42 129.92 20.34 129.61 20.26 129.23 20.67 129 20.94 129 20.94 127.23 23.32 127.23 23.32 126.68 22.06 125.38 23.62 124.64 23.11 123.94 22.63 122.77 20.6 122.35 20.39 122.03 20.19 121.64 20.39 121.31 20.39 120.8 20.46 120.35 20.31 120.04 19.62 119.86 19.21 119.88 18.82 119.62 18.55 119.28 18.2 117.4 17.91 116.95 17.93 116.04 17.98 114.93 20 114.36 20.04 114 20.07 112.8 19.47 112.49 19.15 111.98 18.62 112.11 18.23 111.45 18.19 110.71 18.14 109.73 18.21 109.48 19.47 108.44 19.34 107.69 18.77 106.78 19.79 106.11 18.77 104.96 18.58 104.08 18.83 103.89 17.49 103.15 17.33 102.41 17.78 101.73 18.2 101.41 18.84 101.27 19.98 100.51 19.33 99.79 19.79 98.99 19.98 97.67 20.37 97.96 20.53 96.81 21.34 95.12 22.54 94.45 23 93.07 25.09 92.98 22.56 91.49 23.6 90.47 24.12 90.1 23.28 89.18 24.2 88.6 24.25 87.75 24.34 88.03 23.37 87.55 23.23 87.01 23.06 85.79 24.49 85.28 24.93 84.91 23.87 84.21 22.9 83.62 22.13 83.38 21.82 83.12 21.38 82.79 21.37 82.2 21.34 81.44 22.49 80.4 22.1 78.98 21.58 77.66 19.88 76.87 19.52 76.55 19.41 75.97 19.19 75.68 19.52 75.44 19.74 75.44 20.22 75.07 20.27 74.63 20.34 73.85 19.57 73.35 19.89 72.99 20.12 73.04 20.72 72.61 20.88 71.99 21.03 71.38 20.24 70.43 20.88 70.2 20.16 69.04 18.28 68.42 18.99 68.26 19.17 68.2 19.66 68.15 19.95 67.21 18.35 67.14 17.33 66.9 15.29 65.64 16.05 65.24 15.83 64 15.91 64 15.91 63.37 15.91 63.37 15.91 63.01 15.89 62.83 15.76 62.44 15.82 62.2 15.83 61.95 15.95 61.71 15.82 61.4 15.68 61.01 15.02 60.78 14.65 59.97 13.41 59.69 12.53 58.49 12.57 57.71 12.6 56.81 12.92 56.52 14.17 55.73 13.83 55.12 14.16 54.34 14.36 53.52 14.57 53.49 14.06 52.68 15.3 52.44 15.67 52.01 16.46 51.83 16.9 51.83 16.9 51.46 18.02 51.46 18.02 51.17 18.66 50.36 19.48 49.87 19.71 49.21 20.01 49.34 19.16 48.98 18.59 48.72 18.17 48.37 18.06 48 18.03 47.64 18 47.1 18.01 46.8 18.36 46.56 18.63 46.53 19.03 46.3 19.44 46 19.98 45.46 20.4 44.99 20.41 44.2 20.43 44.2 19.54 43.73 19.36 43.41 19.23 42.42 19.68 41.88 19.36 41.32 19 41.45 18.17 40.84 18.23 40.31 18.28 39.64 19 39.33 19.63 39.09 20.1 39.06 20.55 38.84 20.72 38.35 21.09 36.94 19.51 36.48 19.45 35.91 19.38 35.22 20.88 34.51 20.88 34.23 20.89 34.01 20.64 33.78 20.43 33.33 21.89 32.43 21.92 31.71 20.88 31.35 20.35 31.32 19.88 31.05 19.75 30.56 19.51 29.34 20.71 29.02 21.25 28.84 21.55 28.8 21.68 28.69 22.04 27.93 21.75 27.32 21.96 26.62 22.46 26.09 22.83 26.1 23.26 25.68 23.25 25.1 23.22 24.41 22.18 23.91 21.75 23.47 21.36 23.36 21.65 22.88 21.4 22.52 21.22 21.96 20.66 21.63 20.58 21.31 20.51 21.09 20.75 20.8 20.89 20.24 21.16 19.03 21.79 18.52 21.72 18.52 21.72 18.62 21.23 18.62 21.23 18.62 21.23 16.54 20.37 16.54 20.37 16.54 20.37 16 19.61 16 19.61 16 19.61 16.23 18.83 16.23 18.83 15.08 18.99 14.58 19.77 13.64 20.59 13.38 19.79 12.64 17.92 12.08 17.68 11.82 17.57 11.5 17.8 11.25 17.92 10.2 18.39 10.24 18.54 9.38 19.11 8.48 19.71 7.46 19.51 6.57 18.99 6.57 18.99 6.99 18.15 6.99 18.15 6.11 17.8 4.73 18.19 4.51 18.15 4.06 17.99 0.92 17.55 0 17 0 17 0 30 0 30 0 30 200 30 200 30ZM200 36"' . $svg_flip . ' />';
                break;
            case 'tree_bottom':
                $svg_paths_bottom = '<path id="tree-bottom" d="M17.87 24.59C18.03 24.62 17.97 24.73 17.95 24.81 17.57 24.82 17.18 24.84 16.81 24.76 16.86 24.67 16.91 24.58 16.95 24.49 17.23 24.62 17.56 24.57 17.87 24.59M147.94 2.04C148.28 2.1 148.52 2.35 148.74 2.6 148.85 2.54 148.97 2.48 149.08 2.42 149.33 2.5 149.59 2.47 149.84 2.4 149.73 2.64 149.41 2.72 149.21 2.89 149.21 2.82 149.21 2.69 149.21 2.63 149.13 2.65 149.04 2.68 148.96 2.7 149.07 2.8 149.18 2.89 149.29 2.99 149.58 2.88 149.89 2.79 150.2 2.78 150.2 2.78 150.22 2.66 150.22 2.66 150.14 2.68 149.97 2.7 149.89 2.71 149.94 2.49 149.85 2.21 150.06 2.06 150.29 2.1 150.51 2.17 150.74 2.23 150.79 2.22 150.89 2.19 150.93 2.18 151.33 2.16 151.74 2.17 152.12 2.04 152.27 2.12 152.42 2.2 152.57 2.28 152.6 2.34 152.65 2.46 152.68 2.52 152.84 2.56 153 2.6 153.16 2.63 153.24 3.06 153.45 3.44 153.84 3.66 153.78 3.69 153.66 3.76 153.6 3.8 153.97 3.69 154.08 4.11 154.08 4.39 154.11 4.42 154.17 4.49 154.2 4.53 154.13 4.65 154.07 4.77 154 4.9 154.1 4.98 154.21 5.06 154.31 5.15 154.41 5.12 154.61 5.07 154.71 5.04 154.63 5.27 154.55 5.5 154.59 5.74 154.53 5.74 154.41 5.74 154.35 5.75 154.27 5.82 154.19 5.9 154.11 5.98 154.28 6.03 154.45 6.09 154.62 6.14 154.6 6.18 154.56 6.27 154.54 6.31 154.21 6.72 153.68 6.7 153.21 6.72 153.31 6.83 153.41 6.95 153.52 7.06 153.21 7.12 152.87 7.2 152.66 6.89 152.75 6.89 152.93 6.91 153.02 6.92 152.92 6.84 152.82 6.77 152.72 6.69 152.64 6.56 152.71 6.43 152.75 6.3 152.71 6.31 152.63 6.33 152.58 6.34 152.54 6.4 152.45 6.52 152.41 6.58 152.25 6.52 152.08 6.46 151.92 6.4 152.05 6.59 152.19 6.77 152.32 6.96 152.28 6.87 152.19 6.7 152.15 6.61 152.45 6.5 152.89 7.02 152.38 7.01 152.37 7.16 152.37 7.31 152.37 7.46 152.47 7.37 152.57 7.28 152.68 7.19 152.83 7.48 152.83 7.8 152.71 8.1 152.46 8.04 152.2 7.98 151.95 7.9 151.99 7.94 152.07 8.02 152.11 8.05 152.11 8.22 152.11 8.39 152.12 8.56 152.12 8.56 152.16 8.6 152.16 8.6 152.58 8.97 152.94 9.44 153.51 9.57 153.49 9.66 153.44 9.83 153.41 9.91 153.72 9.82 154.03 9.76 154.35 9.72 154.38 9.77 154.43 9.88 154.46 9.93 154.38 10.16 154.31 10.39 154.2 10.61 153.94 10.89 153.53 10.75 153.21 10.72 153.37 10.91 153.57 11.06 153.79 11.18 153.61 11.31 153.39 11.36 153.18 11.41 153.06 11.32 152.95 11.23 152.83 11.14 152.74 11.17 152.65 11.21 152.56 11.25 152.57 11.07 152.58 10.89 152.6 10.71 152.48 10.75 152.26 10.83 152.15 10.87 152.17 10.61 152.14 10.32 152.37 10.15 152.32 10.31 152.27 10.48 152.22 10.65 152.48 10.62 152.73 10.67 152.96 10.8 152.81 10.65 152.71 10.47 152.81 10.26 152.75 10.32 152.64 10.44 152.58 10.5 152.55 10.28 152.57 10 152.29 9.93 152.32 9.86 152.36 9.73 152.38 9.66 152.24 9.78 152.11 9.91 151.97 10.04 151.89 10.02 151.73 9.99 151.65 9.98 151.63 10.05 151.58 10.18 151.56 10.25 151.5 10.25 151.4 10.23 151.34 10.23 151.15 10.14 150.97 10.04 150.78 9.95 150.92 9.88 151.06 9.8 151.21 9.73 151.12 9.65 150.95 9.48 150.87 9.39 151.05 9.26 151.23 9.14 151.42 9.01 151.3 9 151.07 8.99 150.96 8.98 151.15 8.92 151.33 8.84 151.52 8.77 151.52 8.61 151.51 8.45 151.51 8.28 151.44 8.25 151.3 8.19 151.23 8.16 151.2 8.14 151.15 8.11 151.12 8.09 151.27 7.8 151.42 7.34 151.02 7.16 151.05 7.39 151.25 7.66 151.08 7.87 150.95 7.8 150.83 7.72 150.71 7.64 150.53 7.65 150.38 7.59 150.26 7.45 150.43 7.37 150.6 7.3 150.77 7.23 150.56 7.11 150.33 7.08 150.1 7.15 150.14 7.27 150.18 7.4 150.22 7.52 150.15 7.56 150.01 7.63 149.94 7.67 150 7.7 150.12 7.77 150.18 7.8 150.17 7.86 150.16 7.97 150.15 8.03 150.1 8.06 149.99 8.13 149.94 8.16 149.96 8.49 150.05 8.8 150.19 9.09 150.31 9.01 150.42 8.93 150.54 8.85 150.65 8.91 150.77 8.95 150.89 8.98 150.89 8.98 150.73 9.02 150.73 9.02 150.79 9.13 150.85 9.25 150.91 9.36 150.81 9.45 150.71 9.53 150.6 9.62 150.6 9.7 150.6 9.79 150.6 9.87 150.53 9.94 150.46 10.01 150.39 10.07 150.41 10.21 150.44 10.36 150.47 10.5 150.16 11.05 150.44 11.77 150.96 12.07 151.02 12.16 151.08 12.25 151.14 12.35 150.94 12.52 150.65 12.63 150.44 12.4 150.42 12.43 150.37 12.49 150.34 12.53 150.25 12.43 150.15 12.33 150.06 12.24 150.03 12.42 149.99 12.61 149.96 12.8 150 12.73 150.07 12.59 150.1 12.53 150.18 12.54 150.33 12.57 150.4 12.59 150.47 12.79 150.51 13 150.49 13.21 150.35 13.2 150.22 13.19 150.08 13.18 150.02 13.11 149.91 12.97 149.85 12.9 149.91 13.03 149.97 13.17 150.03 13.3 149.8 13.42 149.53 13.2 149.34 13.43 149.31 13.37 149.25 13.26 149.22 13.2 149.02 13.18 148.83 13.11 148.7 12.95 148.52 12.96 148.33 12.96 148.15 12.97 148.2 13.12 148.25 13.27 148.29 13.42 148.23 13.52 148.17 13.63 148.11 13.74 148.02 13.78 147.92 13.82 147.83 13.86 147.72 13.86 147.5 13.86 147.38 13.86 147.44 13.73 147.49 13.6 147.54 13.48 147.49 13.49 147.37 13.53 147.32 13.54 147.29 13.46 147.25 13.3 147.22 13.22 146.98 13.17 146.74 13.1 146.5 13.04 146.46 13.27 146.41 13.49 146.36 13.72 145.8 15.03 145.43 16.44 145.5 17.88 145.57 18.42 145.57 18.96 145.56 19.5 145.53 20.31 145.37 21.14 145.6 21.94 146.03 21.66 146.39 21.27 146.86 21.05 146.81 20.94 146.77 20.84 146.73 20.73 146.82 20.72 146.99 20.7 147.08 20.69 147.37 20.44 147.51 20.07 147.54 19.69 147.77 19.69 148.01 19.69 148.24 19.69 148.29 19.81 148.34 19.92 148.4 20.03 148.47 19.81 148.54 19.59 148.61 19.37 148.63 19.33 148.67 19.24 148.69 19.2 148.89 19.12 149.09 19.05 149.29 18.98 149.32 19.11 149.34 19.23 149.37 19.36 149.6 19.22 149.85 19.1 150.1 19 150.16 19.13 150.21 19.26 150.27 19.39 150.27 19.39 150.38 19.39 150.38 19.39 150.38 19.54 150.38 19.69 150.39 19.84 150.59 19.81 150.78 19.79 150.98 19.76 151.04 19.8 151.32 19.76 151.36 19.7 151.41 19.72 151.51 19.74 151.56 19.76 151.62 19.67 151.67 19.59 151.73 19.5 151.92 19.49 152.11 19.48 152.3 19.48 152.37 19.56 152.44 19.65 152.52 19.74 152.71 19.65 152.91 19.56 153.11 19.46 153.04 19.83 153.16 20.17 153.46 20.39 153.46 20.54 153.46 20.71 153.44 20.86 153.37 21.12 153.13 21.3 153.11 21.57 153.47 21.44 153.77 21.16 154.17 21.18 154.27 21.4 154.39 21.61 154.46 21.85 154.4 22.15 154.17 22.38 153.92 22.54 153.93 22.69 153.93 22.84 153.94 23 153.86 23.05 153.77 23.11 153.69 23.16 153.76 23.35 153.84 23.53 153.91 23.72 154.07 23.73 154.23 23.74 154.4 23.75 154.3 23.51 154.24 23.25 154.23 22.99 154.39 22.96 154.56 22.94 154.73 22.91 154.72 23.05 154.72 23.19 154.72 23.34 154.85 23.27 154.97 23.2 155.1 23.13 154.99 22.92 154.88 22.7 154.76 22.49 154.94 22.48 155.12 22.48 155.3 22.47 155.35 22.58 155.4 22.69 155.45 22.8 155.49 22.82 155.8 22.69 155.88 22.7 156 22.61 156.12 22.52 156.23 22.44 156.22 22.25 156.2 22.07 156.18 21.88 156.38 21.81 156.58 21.74 156.78 21.67 156.68 21.55 156.57 21.42 156.47 21.29 156.58 21.21 156.69 21.13 156.81 21.06 156.65 20.89 156.49 20.72 156.34 20.54 156.64 20.52 156.92 20.61 157.2 20.72 157.56 20.52 157.92 20.27 158.36 20.29 158.76 20.3 159.14 20.2 159.54 20.17 159.55 20.1 159.55 19.98 159.56 19.91 159.7 20.04 159.85 20.17 160 20.29 160.16 20.09 160.36 19.96 160.59 20.16 160.77 20.18 160.95 20.2 161.13 20.23 161.13 20.49 161.22 20.73 161.38 20.93 161.49 21.01 161.6 21.08 161.7 21.15 161.63 21.18 161.47 21.22 161.39 21.24 161.36 21.36 161.33 21.48 161.3 21.6 161.2 21.6 161.11 21.6 161.01 21.61 160.93 21.73 160.85 21.84 160.77 21.96 160.66 21.91 160.55 21.86 160.43 21.81 160.35 21.94 160.26 22.08 160.18 22.21 159.98 22.23 159.79 22.24 159.59 22.26 160.08 22.29 160.58 22.24 160.95 21.9 161.12 21.9 161.28 21.91 161.45 21.91 161.51 22.07 161.57 22.23 161.63 22.38 161.68 22.38 161.78 22.39 161.83 22.39 161.83 22.19 161.83 21.99 161.83 21.79 162.2 21.8 162.73 21.64 162.94 22.07 163.03 22.3 162.95 22.56 163 22.8 163.1 22.96 163.25 23.09 163.38 23.23 163.32 23.04 163.25 22.85 163.18 22.66 163.28 22.4 163.35 22.13 163.4 21.85 163.47 21.95 163.55 22.05 163.63 22.14 163.66 22.11 163.73 22.05 163.76 22.02 163.9 22.09 164.03 22.16 164.16 22.23 164.25 22.16 164.35 22.09 164.45 22.02 164.47 21.86 164.49 21.69 164.52 21.53 164.7 21.85 164.87 22.19 165.03 22.53 165.13 22.37 165.23 22.22 165.34 22.06 165.4 22.18 165.45 22.29 165.51 22.4 165.58 22.23 165.59 22.01 165.77 21.92 165.96 21.9 166.13 21.99 166.3 22.04 166.35 22.21 166.4 22.38 166.45 22.55 166.51 22.5 166.57 22.45 166.63 22.4 166.57 21.89 166.55 21.35 166.27 20.9 166.5 20.89 166.73 20.87 166.96 20.85 166.97 21.07 166.98 21.29 166.99 21.51 167.04 21.29 167.09 21.06 167.19 20.85 167.33 20.84 167.38 21.05 167.48 21.13 167.45 20.86 167.4 20.58 167.45 20.31 167.64 19.99 168.05 20.09 168.36 20.07 168.52 19.95 168.68 19.94 168.82 20.09 169 20.28 169.24 20.14 169.43 20.05 169.2 19.79 169 19.5 169.03 19.14 169.21 19.15 169.4 19.16 169.58 19.18 169.63 19.09 169.67 19 169.72 18.91 169.82 19.01 169.92 19.11 170.03 19.21 170.3 18.96 170.6 18.75 170.93 18.58 170.88 18.32 170.82 18.06 170.76 17.8 170.78 17.76 170.82 17.69 170.84 17.65 170.88 17.72 170.98 17.88 171.02 17.95 171.06 17.8 171.1 17.66 171.15 17.52 171.04 17.4 170.93 17.28 170.83 17.16 170.88 17.13 170.98 17.06 171.03 17.02 171.12 17.14 171.21 17.27 171.3 17.39 171.34 17.16 171.37 16.92 171.41 16.69 171.53 16.8 171.65 16.92 171.77 17.04 171.9 17.11 172.04 17.19 172.17 17.27 172.16 17.32 172.14 17.43 172.13 17.49 172.24 17.46 172.36 17.43 172.47 17.41 172.48 17.15 172.5 16.89 172.57 16.65 172.54 16.56 172.51 16.48 172.48 16.39 172.54 16.39 172.67 16.39 172.73 16.4 172.7 16.52 172.67 16.65 172.64 16.77 172.86 16.76 172.94 16.56 173.04 16.4 173.1 16.41 173.24 16.42 173.3 16.43 173.24 16.2 173.2 15.95 173.04 15.76 173.19 15.79 173.35 15.77 173.51 15.74 173.52 15.52 173.53 15.31 173.54 15.1 173.63 15.17 173.72 15.24 173.81 15.31 173.83 15.25 173.87 15.12 173.89 15.05 173.94 15.02 174.12 14.78 174.13 14.72 174.21 14.85 174.29 14.98 174.38 15.11 174.39 15.03 174.41 14.86 174.42 14.78 174.57 14.86 174.7 15.04 174.88 14.98 174.92 14.79 174.94 14.6 174.96 14.41 175.12 14.5 175.28 14.59 175.44 14.68 175.49 14.9 175.54 15.12 175.59 15.34 175.52 15.4 175.38 15.5 175.31 15.55 175.54 15.72 175.79 15.85 176.07 15.86 176.12 15.77 176.16 15.67 176.21 15.58 176.35 15.62 176.5 15.66 176.65 15.7 176.84 15.58 177.03 15.47 177.23 15.37 177.36 15.49 177.48 15.61 177.6 15.73 177.64 15.67 177.73 15.55 177.77 15.49 177.82 15.51 177.92 15.55 177.97 15.57 178.04 15.37 178.11 15.17 178.18 14.97 178.46 15.03 178.72 15.16 178.93 15.35 178.96 15.34 179.02 15.31 179.04 15.29 178.81 15.07 178.6 14.83 178.41 14.58 178.55 14.54 178.7 14.51 178.84 14.48 178.89 14.34 178.94 14.2 179 14.06 179.23 14.26 179.45 14.48 179.65 14.72 179.59 14.57 179.53 14.42 179.47 14.26 179.6 14.15 179.74 13.99 179.95 14.02 179.95 14.2 179.95 14.38 179.94 14.57 180.16 14.29 180.5 14.28 180.78 14.48 180.73 14.62 180.69 14.75 180.65 14.89 180.88 14.91 181.04 15.07 181.14 15.27 181.37 15.24 181.6 15.19 181.83 15.19 181.96 15.39 182.05 15.6 182.16 15.81 182.22 15.71 182.29 15.61 182.36 15.51 182.49 15.55 182.63 15.69 182.75 15.56 182.93 15.31 183.12 15.07 183.38 14.9 183.44 15.03 183.5 15.16 183.56 15.29 183.75 15.28 183.95 15.27 184.15 15.25 184.04 15.15 183.94 15.04 183.84 14.94 183.94 14.86 184.04 14.79 184.14 14.71 183.95 14.57 183.73 14.47 183.5 14.41 183.44 14.16 183.38 13.92 183.32 13.67 183.58 13.65 183.84 13.63 184.1 13.64 184.21 13.78 184.26 13.96 184.34 14.12 184.49 14.12 184.63 14.13 184.78 14.13 185.04 14.48 185.31 14.82 185.6 15.14 185.73 15.09 185.87 15.05 186.01 15 186.2 15.13 186.39 15.25 186.59 15.34 186.31 14.92 185.9 14.59 185.62 14.16 185.35 14.05 185 13.98 184.85 13.7 184.63 13.34 184.22 12.9 184.53 12.48 184.36 12.32 184.23 12.14 184.13 11.93 184.21 11.97 184.38 12.04 184.46 12.08 184.36 11.82 184.27 11.56 184.17 11.29 184.22 11.18 184.27 11.08 184.32 10.97 184.9 11.15 185.35 11.6 185.54 12.17 185.58 12.11 185.67 11.98 185.71 11.92 185.84 12.06 185.96 12.2 186.11 12.32 186.26 12.31 186.38 12.2 186.52 12.14 186.11 11.74 185.81 11.23 185.65 10.68 185.59 10.62 185.46 10.51 185.4 10.46 185.56 10.41 185.71 10.32 185.89 10.31 186.08 10.36 186.25 10.48 186.43 10.56 186.35 10.32 186.27 10.07 186.19 9.83 186.23 9.88 186.43 9.91 186.46 9.86 186.55 9.94 186.63 10.02 186.73 10.1 186.75 9.83 186.74 9.55 186.72 9.27 186.78 9.18 186.84 9.08 186.9 8.98 187.01 9.18 187.12 9.39 187.22 9.59 187.3 9.37 187.44 9.16 187.41 8.92 187.31 8.72 187.16 8.55 187.03 8.38 187.19 8.34 187.34 8.29 187.5 8.26 187.5 8.26 187.56 8.26 187.56 8.26 187.58 8.3 187.61 8.4 187.63 8.44 187.62 8.51 187.6 8.64 187.59 8.71 187.79 8.6 188.06 8.56 188.13 8.84 188.25 8.82 188.34 8.75 188.4 8.65 188.47 8.72 188.55 8.79 188.62 8.87 188.68 8.74 188.74 8.61 188.8 8.49 188.8 8.49 188.94 8.5 188.94 8.5 188.9 8.34 188.87 8.18 188.84 8.02 188.96 8.09 189.08 8.18 189.2 8.26 189.21 8.2 189.24 8.06 189.26 8 189.39 8.03 189.51 8.08 189.62 8.16 189.64 8.11 189.68 7.99 189.7 7.93 189.7 7.93 189.75 7.9 189.75 7.9 189.83 8.19 189.92 8.47 190.02 8.75 190.26 8.54 190.52 8.35 190.85 8.34 191 8.73 191 9.23 191.4 9.47 191.49 9.37 191.57 9.27 191.67 9.18 191.78 9.26 191.9 9.35 192 9.44 191.97 9.18 191.93 8.93 191.88 8.67 191.98 8.59 192.08 8.52 192.18 8.45 192.23 8.72 192.31 8.99 192.47 9.22 192.53 9.15 192.63 9 192.68 8.93 192.9 9.2 193.14 9.47 193.36 9.74 193.41 9.68 193.45 9.63 193.5 9.57 193.58 9.69 193.66 9.8 193.74 9.92 194.3 9.98 194.58 10.51 195.08 10.68 195 10.49 194.91 10.31 194.83 10.12 194.78 10.09 194.68 10.02 194.64 9.99 194.62 9.76 194.61 9.53 194.6 9.31 194.46 9.29 194.31 9.28 194.17 9.27 194.07 9.06 193.97 8.85 193.88 8.64 193.8 8.63 193.65 8.6 193.58 8.59 193.47 8.42 193.36 8.24 193.25 8.06 193.33 7.93 193.41 7.8 193.5 7.67 193.62 7.87 193.74 8.08 193.87 8.28 193.95 8.27 194.11 8.26 194.19 8.25 194.19 8.14 194.19 8.04 194.2 7.93 194.34 7.97 194.49 8.01 194.64 8.04 194.56 7.68 194.32 7.39 194.17 7.06 194.19 6.9 194.24 6.75 194.28 6.59 194.4 6.78 194.66 6.7 194.61 6.53 194.64 6.5 194.94 6.65 195.06 6.76 195.11 6.46 194.98 6.19 194.81 5.95 194.88 5.95 195.02 5.95 195.09 5.96 195.15 6.05 195.2 6.14 195.26 6.23 195.47 6.11 195.67 5.95 195.92 5.94 196.02 6.03 196.11 6.14 196.2 6.24 196.31 6.15 196.43 6.05 196.55 5.96 196.61 6.01 196.68 6.07 196.75 6.12 196.81 5.97 196.87 5.83 196.94 5.68 197 5.92 197.06 6.15 197.13 6.39 197.51 6.21 197.33 5.77 197.33 5.44 197.45 5.63 197.57 5.82 197.69 6.02 197.74 5.79 197.79 5.55 197.84 5.32 198.2 5.39 198.62 5.57 198.67 5.98 199.04 5.96 199.49 5.77 199.41 5.77 199.62 5.3 199.99 4.88 199.88 4.33 199.88 4.07 200 3.65 200 3.65 200 3.65 200 30 200 30 200 30 0 30 0 30 0 30 0 18.6 0 18.6 0.04 18.61 0.32 18.79 0.35 18.8 0.4 18.82 0.49 18.87 0.55 18.89 0.57 18.94 0.61 19.03 0.63 19.08 0.73 19.03 0.82 18.98 0.92 18.92 0.93 19.08 0.94 19.24 0.94 19.4 1.11 19.42 1.27 19.44 1.44 19.42 1.27 19.56 1.23 19.74 1.16 19.92 1.23 19.91 1.37 19.9 1.44 19.89 1.53 20.01 1.62 20.16 1.85 20.17 1.82 20.07 1.79 19.98 1.76 19.89 1.82 19.89 1.95 19.88 2.02 19.88 1.99 19.95 1.95 20.01 1.92 20.07 2 20.26 2.02 20.45 2.02 20.64 2.14 20.66 2.26 20.68 2.38 20.7 2.37 20.66 2.35 20.58 2.34 20.54 2.48 20.48 2.62 20.42 2.76 20.36 2.88 20.28 3.01 20.19 3.13 20.1 3.17 20.28 3.21 20.45 3.25 20.63 3.34 20.53 3.43 20.44 3.52 20.35 3.58 20.38 3.68 20.43 3.73 20.46 3.62 20.54 3.51 20.63 3.4 20.72 3.45 20.82 3.49 20.93 3.53 21.04 3.58 20.99 3.68 20.87 3.73 20.82 3.75 20.85 3.79 20.9 3.81 20.93 3.75 21.12 3.68 21.31 3.63 21.51 3.97 21.64 4.28 21.79 4.57 21.97 4.68 21.9 4.78 21.83 4.89 21.75 4.94 21.82 4.98 21.88 5.03 21.95 5.22 21.94 5.42 21.93 5.61 21.92 5.64 22.19 5.43 22.41 5.19 22.6 5.39 22.66 5.64 22.77 5.82 22.62 5.97 22.52 6.14 22.52 6.3 22.61 6.62 22.63 7.05 22.56 7.25 22.79 7.3 22.99 7.24 23.2 7.22 23.4 7.32 23.34 7.37 23.19 7.52 23.2 7.62 23.35 7.67 23.52 7.73 23.68 7.73 23.52 7.74 23.36 7.75 23.19 7.99 23.21 8.23 23.22 8.47 23.23 8.18 23.56 8.16 23.96 8.1 24.34 8.16 24.38 8.23 24.42 8.29 24.45 8.34 24.33 8.39 24.2 8.44 24.07 8.62 24.04 8.8 23.97 8.99 23.99 9.18 24.05 9.19 24.22 9.26 24.34 9.32 24.26 9.39 24.18 9.44 24.09 9.55 24.21 9.66 24.32 9.77 24.44 9.94 24.18 10.11 23.93 10.3 23.69 10.32 23.82 10.35 23.94 10.37 24.06 10.47 24.11 10.57 24.16 10.67 24.21 10.81 24.16 10.95 24.11 11.08 24.06 11.12 24.08 11.19 24.13 11.22 24.15 11.3 24.08 11.38 24.01 11.46 23.93 11.52 24.14 11.59 24.34 11.69 24.54 11.62 24.68 11.55 24.81 11.48 24.95 11.62 24.85 11.77 24.76 11.88 24.64 11.93 24.46 11.85 24.27 11.94 24.09 12.15 23.78 12.71 23.9 13.09 23.89 13.09 24.04 13.09 24.19 13.09 24.33 13.14 24.33 13.25 24.33 13.3 24.33 13.37 24.21 13.43 24.1 13.49 23.98 13.67 23.98 13.84 23.97 14.01 23.97 14.4 24.22 14.92 24.26 15.42 24.24 15.22 24.23 15.02 24.21 14.81 24.2 14.72 24.1 14.64 24 14.55 23.9 14.43 23.94 14.31 23.98 14.19 24.02 14.11 23.93 14.03 23.84 13.94 23.75 13.85 23.75 13.75 23.75 13.65 23.75 13.62 23.66 13.58 23.57 13.55 23.48 13.47 23.47 13.45 23.31 13.56 23.25 13.73 23.1 13.83 22.92 13.83 22.73 14.01 22.71 14.2 22.69 14.38 22.68 14.62 22.53 14.83 22.63 15 22.78 15.15 22.68 15.31 22.59 15.46 22.5 15.46 22.55 15.47 22.64 15.48 22.68 15.89 22.71 16.29 22.78 16.71 22.78 17.16 22.76 17.54 22.95 17.91 23.1 18.2 23.01 18.49 22.95 18.8 22.96 18.65 23.09 18.49 23.22 18.32 23.34 18.44 23.4 18.56 23.46 18.67 23.52 18.56 23.61 18.45 23.71 18.34 23.8 18.55 23.85 19.16 24.5 19.28 24.56 19.37 24.56 19.46 24.56 19.54 24.55 19.54 24.59 19.54 24.66 19.54 24.7 19.59 24.68 20.36 24.99 20.49 25.04 20.49 24.93 21.16 25.33 21.33 25.32 21.41 25.18 21.49 25.04 21.56 24.91 21.47 24.87 21.39 24.83 21.3 24.78 21.31 24.67 21.32 24.56 21.32 24.45 21.06 24.32 20.95 23.6 21.06 23.44 21.48 23.42 21.79 23.63 22.16 23.73 22.14 23.52 21.9 23.39 21.83 23.2 21.8 23.08 21.8 22.97 21.8 22.85 22.12 22.68 22.24 22.43 22.17 22.16 22.37 22.23 22.58 22.3 22.78 22.37 22.86 22.3 22.93 22.24 23.01 22.17 23.21 22.18 23.4 22.19 23.6 22.19 23.66 22.26 23.94 22.35 23.98 22.34 24.02 22.38 24.1 22.46 24.14 22.5 24.2 22.47 24.32 22.41 24.38 22.38 24.59 22.4 24.79 22.42 25 22.44 25 22.33 25 22.22 25 22.11 25 22.11 25.12 22.11 25.12 22.11 25.18 22.01 25.24 21.92 25.29 21.82 25.56 21.9 25.81 21.98 26.06 22.09 26.08 21.99 26.11 21.9 26.13 21.8 26.34 21.86 26.56 21.91 26.76 21.97 26.78 22 26.82 22.06 26.84 22.09 26.92 22.26 26.99 22.42 27.07 22.59 27.12 22.5 27.18 22.42 27.23 22.33 27.47 22.33 27.72 22.33 27.96 22.33 27.99 22.61 28.13 22.89 28.44 23.08 28.53 23.08 28.71 23.1 28.81 23.1 28.76 23.18 28.71 23.26 28.67 23.34 29.16 23.5 29.53 23.79 29.98 24 30.22 23.41 30.89 23.3 31.18 23.42 31.18 23.61 31.16 23.84 31.48 23.89 31.8 23.79 32.18 23.73 32.51 23.83 32.72 23.92 32.65 24.1 32.68 24.25 32.73 24.18 32.78 24.11 32.82 24.05 32.87 24.04 32.96 24.04 33.01 24.04 33.08 23.96 33.14 23.88 33.21 23.8 33.46 23.79 33.72 23.77 33.96 23.81 34.19 23.87 34.17 24.07 34.22 24.21 34.29 24.08 34.37 23.96 34.45 23.84 34.68 24.02 34.89 24.21 35.14 24.38 35.33 24.37 35.51 24.33 35.69 24.3 35.79 24.4 35.89 24.5 35.99 24.6 36.06 24.43 36.08 24.25 36.17 24.09 36.34 23.94 36.54 23.81 36.72 23.67 37.06 23.76 37.35 24.06 37.74 23.92 38.03 23.99 38.34 24.08 38.44 24.31 38.57 24.28 38.7 24.25 38.82 24.22 38.9 24.37 38.98 24.52 39.06 24.67 39.65 24.44 40.32 24.62 40.94 24.65 41.79 24.78 42.73 24.7 43.48 25.07 43.87 25.04 44.24 25.12 44.56 25.28 44.95 25.49 45.48 25.4 45.92 25.54 46.4 25.69 46.88 25.86 47.38 25.98 47.9 26.05 48.43 25.98 48.95 26.07 49.44 26.15 49.95 26.21 50.46 26.19 51.46 26.28 52.46 26.41 53.47 26.35 54.11 26.31 54.82 26.61 55.37 26.27 55.47 26.39 55.51 26.53 55.56 26.66 55.71 26.59 55.86 26.53 56 26.47 56.14 26.49 56.29 26.52 56.43 26.54 56.83 26.26 57.41 26.24 57.94 26.19 57.99 26.14 58.09 26.04 58.14 25.99 58.42 26.11 58.68 26.25 58.96 26.37 59.33 26.39 59.69 26.3 60.04 26.24 60.11 26.12 60.18 26 60.25 25.87 60.49 25.83 60.74 25.78 60.99 25.74 61.08 25.83 61.16 25.92 61.25 26.01 61.56 25.86 61.91 25.72 62.3 25.76 62.35 25.84 62.41 25.92 62.46 26.01 62.81 26 63.16 25.97 63.51 25.91 63.58 25.71 63.7 25.53 63.92 25.4 63.97 25.42 64.07 25.48 64.12 25.5 64.21 25.34 64.3 25.15 64.55 25.08 64.86 25.13 65.11 25.27 65.37 25.38 65.46 25.32 65.55 25.26 65.64 25.2 65.74 25.29 65.84 25.37 65.94 25.45 65.95 25.4 65.97 25.29 65.99 25.23 66.21 25.24 66.42 25.24 66.64 25.25 66.86 25.37 67.1 25.48 67.36 25.57 67.36 25.44 67.37 25.31 67.38 25.18 67.69 25.15 68.15 25.42 68.23 25.33 68.76 25.43 69.32 25.44 69.85 25.54 70.46 25.65 71.13 25.25 71.69 25.57 71.75 25.57 71.87 25.56 71.93 25.56 72.12 25.62 72.32 25.72 72.52 25.62 72.83 25.49 73.17 25.47 73.51 25.51 73.6 25.59 73.69 25.68 73.8 25.76 73.92 25.73 74.04 25.69 74.16 25.65 74.18 25.59 74.21 25.48 74.22 25.42 74.33 25.51 74.44 25.59 74.55 25.68 74.73 25.62 74.92 25.56 75.11 25.51 75.58 25.64 78.03 25.43 78.28 25.32 78.33 25.37 78.42 25.46 78.46 25.51 78.71 25.41 79.86 25.36 80.18 25.43 80.29 25.38 80.41 25.33 80.53 25.28 80.65 25.31 80.76 25.33 80.88 25.36 80.96 25.3 81.05 25.24 81.13 25.19 81.44 25.29 81.78 25.35 82.09 25.2 82.55 25.24 83.58 25.03 83.64 24.92 83.93 24.89 84.23 24.91 84.51 24.97 85.36 25.2 87.69 25.08 87.93 25.33 87.93 25.33 90.72 23.31 90.64 23.55 91.46 23.22 92.35 23.55 93.18 23.25 93.45 23.16 93.73 23.14 94.01 23.19 94.07 23.33 94.13 23.47 94.18 23.62 94.62 23.62 95.06 23.62 95.5 23.56 95.79 23.76 96.12 23.68 96.42 23.54 96.5 23.61 96.89 23.7 97 23.67 97.12 23.73 97.23 23.8 97.34 23.86 97.64 23.77 97.94 23.66 98.25 23.62 98.53 23.67 98.75 23.84 98.99 23.97 99.03 23.91 99.12 23.79 99.16 23.72 99.41 23.86 99.64 24.1 99.95 24.08 100.19 24.07 100.43 24.01 100.67 23.97 100.72 24.08 100.76 24.18 100.81 24.29 101.23 24.01 101.76 24.15 102.22 23.97 102.39 24.05 102.57 24.13 102.75 24.21 102.86 24.09 102.96 23.97 103.06 23.85 103.08 23.93 103.11 24.09 103.12 24.17 103.24 24.22 103.35 24.28 103.47 24.32 103.57 24.21 103.66 24.09 103.75 23.97 104.08 23.92 104.41 23.95 104.7 24.12 104.89 24.26 105.09 24.12 105.27 24.04 105.33 24.05 105.44 24.05 105.5 24.05 106.03 23.63 106.68 24.16 107.27 24.01 107.78 23.88 108.31 23.87 108.83 23.73 108.9 23.85 108.98 23.97 109.05 24.1 109.2 23.9 109.35 23.49 109.64 23.53 109.65 23.7 109.66 23.88 109.66 24.05 109.91 23.94 110.14 23.79 110.35 23.63 110.56 23.61 110.77 23.61 110.98 23.6 110.99 23.67 111.02 23.82 111.03 23.9 111.12 23.79 111.22 23.67 111.32 23.56 111.4 23.64 111.49 23.72 111.57 23.8 111.83 23.65 112.07 23.46 112.36 23.4 112.61 23.49 112.69 23.74 112.78 23.97 112.83 23.93 112.92 23.86 112.97 23.82 113.18 24 113.3 24.25 113.36 24.52 113.69 24.59 114.03 24.64 114.37 24.64 114.42 24.53 114.47 24.42 114.52 24.31 114.9 24.25 115.23 24.45 115.53 24.65 115.62 24.53 115.7 24.4 115.79 24.28 116.02 24.34 116.26 24.4 116.5 24.46 116.56 24.63 116.63 24.8 116.69 24.96 117.04 25.04 117.38 25.16 117.73 25.13 118.01 24.98 118.25 24.78 118.52 24.62 118.57 24.69 118.67 24.82 118.72 24.89 119.22 24.96 119.78 24.98 120.17 25.36 120.31 25.33 120.44 25.3 120.58 25.27 120.72 25.35 120.86 25.44 121 25.52 121.05 25.34 121.09 25.16 121.18 25 121.72 25.46 122.4 25.05 123.01 25.11 123.99 25.19 124.95 25.01 125.91 24.89 126.4 24.91 126.89 24.84 127.36 24.72 127.86 24.6 128.37 24.7 128.87 24.61 129.35 24.45 129.81 24.22 130.28 24.01 130.69 23.83 131.2 23.94 131.58 23.66 131.89 23.45 132.24 23.35 132.62 23.38 133.34 22.88 134.25 23 135.06 22.81 135.66 22.78 136.3 22.53 136.87 22.84 136.94 22.63 137.02 22.43 137.1 22.23 137.22 22.27 137.34 22.31 137.46 22.35 137.56 22.04 137.86 21.92 138.13 21.83 138.51 22.02 138.79 21.61 139.12 21.49 139.29 21.69 139.48 21.86 139.65 22.07 139.74 22.28 139.76 22.52 139.82 22.74 139.91 22.61 140.01 22.48 140.11 22.35 140.28 22.38 140.46 22.43 140.63 22.45 140.88 22.23 141.08 21.96 141.3 21.72 141.38 21.89 141.45 22.05 141.52 22.22 141.57 22.03 141.55 21.77 141.77 21.69 142 21.63 142.25 21.66 142.49 21.67 142.56 21.77 142.62 21.88 142.69 21.99 142.73 21.99 142.96 22.18 143 22.28 143.03 22.08 142.96 21.82 143.17 21.7 143.49 21.57 143.85 21.66 144.15 21.79 144.46 21.72 144.45 21.41 144.45 21.15 144.57 20.63 144.4 20.12 144.31 19.61 144.35 19.57 144.43 19.48 144.47 19.43 144.49 18.81 144.5 18.19 144.54 17.56 144.58 17.22 144.58 16.87 144.39 16.57 144.4 16.37 144.41 16.18 144.41 15.99 144.51 15.92 144.61 15.85 144.72 15.78 144.68 15.53 144.65 15.28 144.5 15.07 144.46 15.02 144.4 14.92 144.36 14.87 144.31 14.54 144.28 14.21 144.18 13.9 144.25 13.81 144.31 13.72 144.38 13.63 144.26 13.59 144.14 13.55 144.03 13.51 143.75 13.42 143.48 13.31 143.2 13.22 143.16 13.25 143.07 13.31 143.02 13.33 143.02 13.33 143 13.34 143 13.34 142.98 12.96 142.73 12.64 142.42 12.44 142.24 12.61 142.06 12.78 141.88 12.95 141.92 13.03 142 13.2 142.04 13.28 141.95 13.39 141.85 13.5 141.76 13.61 141.83 13.55 141.97 13.43 142.04 13.37 142.06 13.43 142.1 13.55 142.12 13.61 142.1 13.44 142.08 13.26 142.07 13.09 142.19 13.09 142.44 13.1 142.57 13.11 142.51 13.24 142.46 13.38 142.41 13.52 142.49 13.53 142.65 13.56 142.73 13.57 142.64 13.7 142.56 13.84 142.49 13.98 142.45 14.17 142.3 14.27 142.13 14.35 142.16 14.44 142.18 14.53 142.2 14.62 141.73 14.9 141.15 14.81 140.63 14.8 140.58 14.63 140.52 14.46 140.47 14.29 140.59 14.25 140.72 14.22 140.86 14.18 140.86 14.1 140.87 13.94 140.88 13.86 140.95 13.91 141.02 13.96 141.1 14.01 141.28 13.84 141.46 13.67 141.63 13.5 141.63 13.5 141.46 13.47 141.46 13.47 141.58 13.02 141.97 12.75 142.29 12.45 142.13 12.41 141.97 12.37 141.81 12.34 141.81 12.34 141.91 12.19 141.91 12.19 142 12.15 142.08 12.11 142.17 12.08 142.17 11.99 142.18 11.83 142.18 11.75 141.99 11.57 141.75 11.44 141.5 11.37 141.53 11.46 141.6 11.64 141.64 11.73 141.59 11.78 141.54 11.83 141.49 11.88 141.38 11.97 141.27 12.06 141.15 12.15 141.2 12.19 141.3 12.26 141.35 12.3 141.19 12.46 141.03 12.64 141.07 12.88 140.97 12.95 140.89 13.02 140.8 13.1 140.82 12.96 140.86 12.7 140.88 12.56 140.68 12.74 140.59 12.96 140.61 13.22 140.58 13.11 140.56 13.01 140.53 12.9 140.04 12.72 139.68 13.16 139.26 13.31 139.22 13.3 139.16 13.28 139.12 13.27 139.17 13.39 139.22 13.5 139.27 13.62 138.93 13.75 138.6 13.92 138.23 13.88 138.26 14.18 138.36 14.63 138.05 14.81 137.97 14.77 137.81 14.68 137.73 14.64 137.82 14.51 137.92 14.39 138.01 14.26 137.84 14.37 137.67 14.48 137.5 14.59 137.32 14.69 137.12 14.76 136.93 14.84 136.71 14.59 136.51 14.33 136.31 14.06 136.4 13.81 136.47 13.53 136.67 13.34 136.73 13.47 136.79 13.59 136.85 13.72 136.8 13.49 136.68 13.27 136.68 13.04 136.75 12.89 136.89 12.8 137 12.69 137.01 12.61 137.03 12.43 137.04 12.34 137.15 12.32 137.37 12.28 137.48 12.26 137.43 12.35 137.33 12.53 137.28 12.61 137.49 12.44 137.58 12.19 137.57 11.92 137.74 11.91 137.92 11.9 138.09 11.89 138.18 11.95 138.27 12.01 138.36 12.07 138.26 11.96 138.13 11.86 137.97 11.82 137.97 11.79 137.96 11.73 137.96 11.7 137.92 11.74 137.84 11.82 137.81 11.86 137.57 11.64 137.35 11.4 137.18 11.11 137.26 11.11 137.43 11.1 137.51 11.1 137.62 10.91 137.31 10.85 137.24 10.72 137.13 10.59 137.11 10.41 137.04 10.26 137.13 10.22 137.32 10.14 137.42 10.1 137.41 10.24 137.41 10.38 137.4 10.53 137.42 10.45 137.44 10.29 137.45 10.21 137.71 10.43 138.03 10.42 138.33 10.54 138.53 10.48 138.73 10.42 138.93 10.36 138.88 10.31 138.78 10.22 138.73 10.18 138.74 10.09 138.76 9.93 138.77 9.85 138.82 9.82 138.91 9.75 138.95 9.72 139.05 9.59 139.16 9.47 139.25 9.33 139.15 9.31 139.06 9.24 138.96 9.22 138.96 9.09 138.96 8.95 138.97 8.82 139.09 8.72 139.21 8.6 139.31 8.47 139.18 8.52 139.05 8.57 138.93 8.62 138.88 8.86 138.84 9.09 138.81 9.33 138.84 9.38 138.9 9.5 138.93 9.56 138.81 9.64 138.69 9.71 138.56 9.77 138.45 9.83 138.34 9.9 138.24 9.96 138.11 9.94 137.98 9.92 137.85 9.9 137.86 9.84 137.88 9.72 137.9 9.66 137.81 9.65 137.63 9.63 137.55 9.62 137.5 9.43 137.45 9.24 137.41 9.05 137.55 9.14 137.68 9.24 137.83 9.33 137.76 9.17 137.66 9.06 137.51 8.98 137.46 8.89 137.41 8.8 137.37 8.72 137.24 8.4 137.39 8.14 137.72 8.08 137.56 7.73 137.39 7.38 137.29 7.01 137.28 6.85 137.28 6.7 137.27 6.54 137.44 6.51 137.6 6.49 137.77 6.46 137.7 6.3 137.63 6.14 137.56 5.97 137.62 5.98 137.72 6 137.77 6.01 137.83 5.86 137.9 5.72 137.96 5.57 138.09 5.63 138.22 5.68 138.35 5.74 138.34 5.66 138.31 5.52 138.3 5.44 138.62 5.24 138.96 5.03 139.36 5.01 139.49 4.72 139.85 4.77 140.11 4.71 140.12 4.8 140.14 4.99 140.16 5.09 140.35 4.91 140.51 4.7 140.63 4.47 140.88 4.49 141.13 4.49 141.37 4.45 141.23 4.18 141.08 3.92 140.93 3.66 140.99 3.66 141.13 3.67 141.2 3.67 141.17 3.64 141.1 3.57 141.07 3.54 141.08 3.41 141.08 3.28 141.09 3.15 141.23 3.07 141.38 2.99 141.53 2.91 141.62 2.68 141.7 2.45 141.87 2.27 142.02 2.25 142.17 2.29 142.32 2.3 142.67 2.07 143.11 2.18 143.47 2.33 143.43 2.43 143.38 2.54 143.34 2.64 143.55 2.6 143.76 2.56 143.96 2.52 144.02 2.63 144.08 2.75 144.15 2.86 144.34 2.93 144.46 3.08 144.57 3.25 144.57 3.25 144.62 3.23 144.62 3.23 144.72 3.12 144.81 3 144.9 2.89 144.89 2.83 144.85 2.71 144.83 2.66 144.98 2.66 145.13 2.66 145.28 2.67 145.34 2.61 145.4 2.54 145.46 2.48 145.56 2.56 145.66 2.63 145.77 2.7 145.94 2.62 146.14 2.46 146.31 2.67 146.41 2.55 146.51 2.44 146.62 2.32 147.09 2.47 147.53 2.27 147.94 2.04M151.58 3.88C151.54 4.04 151.6 4.1 151.76 4.06 151.8 3.9 151.73 3.84 151.58 3.88M150.74 4.44C150.66 4.82 151.15 4.56 151.05 4.33 150.91 4.28 150.81 4.32 150.74 4.44M151.17 5.12C151.29 5.03 151.41 4.94 151.53 4.86 151.46 4.69 151.59 4.35 151.31 4.34 151 4.49 151 4.86 151.17 5.12M150.57 4.78C150.64 4.84 150.64 4.84 150.57 4.78M150.78 5.03C150.6 5.37 151.16 5.05 150.78 5.03M150.94 5.42C150.93 5.47 150.91 5.55 150.9 5.6 151.11 5.66 151.32 5.74 151.53 5.81 151.5 5.63 151.48 5.44 151.44 5.26 151.27 5.31 151.11 5.37 150.94 5.42M153.07 6.05C153.05 6.08 152.99 6.14 152.97 6.16 153.07 6.51 153.48 6.01 153.07 6.05M148.88 7.34C148.95 7.38 149.03 7.42 149.1 7.46 149.14 7.37 149.18 7.29 149.22 7.21 149.17 7.22 149.06 7.23 149.01 7.23 148.94 7.09 148.88 6.94 148.81 6.79 148.83 6.74 148.85 6.63 148.87 6.57 148.66 6.78 148.87 7.09 148.88 7.34M140.95 6.96C140.84 7.12 141.12 7.26 141.23 7.14 141.34 6.98 141.05 6.83 140.95 6.96M142.81 7.2C142.82 7.39 142.84 7.59 142.86 7.79 143.06 7.66 143.2 7.48 143.3 7.27 143.16 7.22 143.02 7.17 142.89 7.13 142.87 7.14 142.83 7.18 142.81 7.2M147.43 7.19C147.52 7.31 147.65 7.36 147.8 7.34 147.74 7.44 147.63 7.63 147.58 7.73 147.53 7.68 147.43 7.57 147.38 7.52 147.33 7.8 147 7.8 146.82 7.95 146.88 8.02 147.01 8.16 147.08 8.23 146.98 8.26 146.88 8.3 146.78 8.34 146.78 8.63 146.76 8.93 146.7 9.22 147.01 9.15 147.2 8.75 147.53 8.83 147.45 8.79 147.38 8.74 147.3 8.69 147.32 8.53 147.35 8.37 147.38 8.22 147.41 8.16 147.44 8.1 147.47 8.04 147.51 7.95 147.6 7.78 147.64 7.7 147.81 7.7 147.97 7.71 148.14 7.71 148.02 7.66 147.91 7.6 147.8 7.54 147.82 7.47 147.86 7.32 147.89 7.25 147.73 7.23 147.58 7.21 147.43 7.19M146.6 7.4C146.58 7.64 146.54 7.87 146.47 8.1 146.62 7.92 146.9 7.56 146.6 7.4M143.38 7.81C143.36 7.87 143.31 8 143.28 8.06 143.21 8.07 143.06 8.11 142.98 8.13 143.03 8.24 143.1 8.34 143.18 8.43 143.37 8.36 143.67 8.29 143.6 8.02 143.75 8.16 143.91 8.28 144.08 8.4 144.11 8.22 144.14 8.05 144.17 7.88 143.93 7.68 143.65 7.64 143.38 7.81M149.43 7.66C149.49 7.73 149.49 7.73 149.43 7.66M141.41 8.39C141.32 8.48 141.23 8.57 141.15 8.66 141.26 8.68 141.37 8.67 141.48 8.65 141.62 8.67 141.77 8.68 141.92 8.69 141.96 8.7 142.03 8.71 142.07 8.72 142.19 8.53 142.41 8.57 142.61 8.6 142.48 8.83 142.32 9.03 142.13 9.22 141.95 9.2 141.77 8.79 141.65 9.15 141.65 9.15 141.6 9.07 141.6 9.07 141.4 9.12 141.19 9.17 140.99 9.2 140.97 9.26 140.93 9.36 140.92 9.41 140.67 9.23 140.41 9.31 140.18 9.45 140.15 9.62 140.25 9.78 140.27 9.95 140.15 9.9 140.03 9.86 139.91 9.82 139.96 9.99 139.87 10.15 139.79 10.29 139.92 10.36 140.03 10.48 139.93 10.63 139.98 10.6 140.07 10.55 140.11 10.52 140.26 10.06 140.83 10.1 141.16 9.83 141.36 9.66 141.59 9.55 141.83 9.43 141.83 9.43 141.87 9.5 141.87 9.5 141.96 9.31 142.21 9.35 142.33 9.18 142.54 9.23 142.75 9.18 142.94 9.07 142.89 9.06 142.8 9.03 142.75 9.01 142.77 8.91 142.8 8.81 142.83 8.7 142.77 8.63 142.7 8.56 142.64 8.49 142.65 8.32 142.44 8.12 142.29 8.25 142 8.34 141.71 8.38 141.41 8.39M143.57 8.44C143.63 8.51 143.63 8.51 143.57 8.44M145.23 8.84C145.23 8.84 145.34 8.8 145.34 8.8 145.42 8.93 145.5 9.06 145.58 9.19 145.86 9.15 146.14 9.2 146.34 9.42 146.48 9.14 146.61 8.85 146.55 8.53 146.5 8.57 146.39 8.64 146.33 8.68 146.2 8.62 146.07 8.57 145.93 8.51 145.7 8.6 145.28 8.52 145.23 8.84M143.42 8.69C143.54 8.84 143.65 9 143.75 9.17 143.82 9.19 143.96 9.25 144.03 9.27 143.98 8.96 143.58 8.93 143.42 8.69M144.74 8.7C144.72 8.76 144.69 8.89 144.67 8.96 144.59 8.9 144.43 8.8 144.34 8.74 144.3 8.87 144.25 8.99 144.21 9.12 144.48 9.17 144.82 9.47 145.03 9.14 145.03 9.26 145.03 9.49 145.03 9.6 145.05 9.55 145.07 9.46 145.08 9.42 145.13 9.39 145.23 9.35 145.28 9.32 145.28 9.32 145.03 9.39 145.03 9.39 145.22 9.1 144.87 8.91 144.74 8.7M189.87 9.03C189.69 9.37 190.25 9.05 189.87 9.03M140.05 9.24C140.11 9.31 140.11 9.31 140.05 9.24M142.92 9.3C142.92 9.35 142.92 9.46 142.92 9.51 142.81 9.5 142.6 9.47 142.5 9.46 142.31 9.53 142.1 9.59 141.96 9.75 141.88 9.74 141.72 9.72 141.63 9.71 141.45 9.89 141.2 9.97 140.96 10.06 140.97 10.11 140.99 10.2 141.01 10.25 140.84 10.2 140.6 10.06 140.58 10.32 140.87 10.29 141.28 10.43 141.41 10.08 141.6 9.98 141.78 9.88 141.97 9.79 142.06 10.07 141.73 10.05 141.69 10.27 141.82 10.23 141.94 10.15 142.04 10.05 142.11 10.07 142.25 10.1 142.32 10.11 142.4 9.94 142.43 9.76 142.45 9.57 142.48 9.89 142.66 10.17 142.96 10.29 142.96 10.29 143.01 10.15 143.01 10.15 142.8 10.18 142.68 9.93 142.88 9.85 143 9.99 143.08 10.19 143.28 10.23 143.13 10.4 142.95 10.58 142.93 10.83 143.04 10.83 143.25 10.82 143.35 10.82 143.34 10.7 143.34 10.59 143.35 10.47 143.4 10.63 143.49 10.77 143.62 10.88 143.76 10.83 143.89 10.79 144.03 10.76 144.01 10.56 143.99 10.36 143.98 10.16 143.93 10.19 143.81 10.24 143.75 10.27 143.75 10.27 143.7 10.13 143.7 10.13 143.94 10.15 144.01 9.9 143.8 9.79 143.52 9.59 143.3 9.24 142.92 9.3M145.75 9.37C145.81 9.44 145.81 9.44 145.75 9.37M144.94 9.72C144.95 10.1 145.28 9.55 144.94 9.72M146.44 9.83C146.37 9.99 146.42 10.04 146.58 9.98 146.65 9.82 146.61 9.77 146.44 9.83M186.85 9.77C186.7 10.05 187.17 10.64 187.3 10.14 187.21 9.96 187.02 9.87 186.85 9.77M144.45 9.91C144.46 10.21 144.47 10.52 144.48 10.83 144.79 11.02 145.1 11.21 145.42 11.38 145.44 11.44 145.49 11.57 145.51 11.63 145.51 11.57 145.52 11.45 145.52 11.39 145.52 11.39 145.82 11.41 145.82 11.41 145.82 11.47 145.84 11.58 145.85 11.64 145.83 11.3 146.27 11 146.02 10.69 146.01 10.75 145.99 10.89 145.99 10.95 145.9 10.94 145.72 10.92 145.63 10.91 145.62 10.98 145.6 11.12 145.59 11.2 145.59 11.2 145.45 11.3 145.45 11.3 145.44 11.22 145.42 11.07 145.41 10.99 145.56 10.89 145.66 10.75 145.71 10.58 145.55 10.54 145.42 10.46 145.31 10.36 144.97 10.33 144.72 10.08 144.45 9.91M142.55 10.41C142.61 10.47 142.61 10.47 142.55 10.41M146.77 10.53C146.84 10.59 146.84 10.59 146.77 10.53M186.13 10.66C186.06 10.78 186.12 10.96 186.23 11.02 186.45 11.01 186.32 10.58 186.13 10.66M142.4 11.24C142.39 11.57 142.43 11.9 142.58 12.2 142.8 12.15 143.03 12 143.27 12.05 143.43 12.12 143.69 12.31 143.79 12.06 143.59 12.09 143.47 11.97 143.39 11.8 143.32 11.8 143.16 11.81 143.08 11.81 143.02 11.76 142.89 11.66 142.82 11.62 142.85 11.58 142.91 11.51 142.94 11.47 142.87 11.43 142.73 11.34 142.66 11.29 142.73 11.28 142.88 11.25 142.96 11.24 143.18 11.2 143.29 11.38 143.39 11.54 143.39 11.36 143.39 11.17 143.39 10.99 143.33 10.99 143.19 11 143.12 11 142.88 11.08 142.64 11.16 142.4 11.24M148.38 10.98C148.45 11.05 148.45 11.05 148.38 10.98M148.83 11C148.79 11.16 148.85 11.22 149.01 11.18 149.05 11.02 148.99 10.96 148.83 11M139.4 11.51C139.48 11.45 139.57 11.38 139.65 11.32 139.71 11.34 139.82 11.37 139.87 11.39 139.83 11.27 139.79 11.16 139.75 11.05 139.61 11.18 139.48 11.33 139.4 11.51M141.84 11.2C141.79 11.35 142.02 11.48 142.14 11.41 142.19 11.26 141.96 11.13 141.84 11.2M147.71 11.21C147.77 11.28 147.77 11.28 147.71 11.21M196.09 11.36C196.33 11.61 196.35 12.1 196.79 12.08 196.83 12.03 196.91 11.92 196.96 11.86 197.07 11.9 197.18 11.94 197.29 11.98 197.26 11.88 197.22 11.79 197.18 11.7 197.09 11.71 197 11.72 196.9 11.73 196.84 11.64 196.78 11.55 196.72 11.46 196.63 11.46 196.47 11.46 196.38 11.46 196.34 11.39 196.25 11.26 196.21 11.19 196.17 11.25 196.13 11.31 196.09 11.36M149.18 11.33C149.24 11.39 149.24 11.39 149.18 11.33M149.82 11.35C149.92 11.48 150.02 11.6 150.13 11.73 150.17 11.67 150.25 11.55 150.28 11.49 150.23 11.5 150.12 11.52 150.07 11.53 150.07 11.53 150.17 11.35 150.17 11.35 150.09 11.35 149.91 11.35 149.82 11.35M144.14 11.63C143.94 11.56 143.74 11.59 143.89 11.82 144.01 11.77 144.24 11.66 144.35 11.61 144.35 11.61 144.25 11.87 144.25 11.87 144.25 11.87 144.57 11.87 144.57 11.87 144.38 12.01 144.16 12.06 143.94 12.11 143.92 12.19 143.88 12.34 143.86 12.42 143.9 12.47 143.99 12.56 144.04 12.6 144.1 12.73 144.16 12.85 144.23 12.98 144.21 13.04 144.18 13.18 144.17 13.24 144.41 13.23 144.68 13.26 144.85 13.06 144.85 13.06 144.89 13.09 144.89 13.09 144.96 12.98 145.04 12.88 145.12 12.78 144.99 12.7 144.84 12.63 144.76 12.5 144.84 12.48 145.01 12.44 145.1 12.42 144.99 12.34 144.87 12.31 144.74 12.33 144.67 12.31 144.53 12.27 144.46 12.25 144.5 12.16 144.6 11.98 144.64 11.89 144.74 11.9 144.92 11.92 145.01 11.93 144.98 11.91 144.91 11.87 144.88 11.85 144.83 11.85 144.75 11.86 144.7 11.87 144.6 11.71 144.48 11.57 144.37 11.42 144.29 11.49 144.22 11.56 144.14 11.63M147.1 11.47C147.08 11.48 147.05 11.5 147.03 11.52 147.07 11.57 147.17 11.69 147.22 11.74 147.14 11.76 146.99 11.8 146.91 11.82 146.92 11.86 146.94 11.93 146.94 11.96 147.14 11.84 147.36 11.9 147.52 12.06 147.56 11.96 147.61 11.87 147.66 11.77 147.88 11.79 148.31 11.89 148.2 12.23 148.43 12.16 148.27 11.87 148.3 11.71 148.49 11.63 148.64 11.77 148.8 11.83 148.76 11.7 148.62 11.64 148.52 11.55 148.35 11.6 148.17 11.62 147.99 11.65 147.98 11.58 147.95 11.46 147.94 11.4 147.93 11.46 147.92 11.58 147.91 11.65 147.86 11.63 147.75 11.59 147.7 11.57 147.54 11.83 147.22 11.68 147.1 11.47M149.06 11.56C149.01 11.73 149.07 11.77 149.23 11.7 149.27 11.54 149.22 11.49 149.06 11.56M149.33 11.9C149.39 11.97 149.39 11.97 149.33 11.9M149.77 11.91C149.64 11.85 149.41 12.05 149.62 12.12 149.75 12.19 149.98 11.95 149.77 11.91M150.11 11.9C150.17 11.96 150.17 11.96 150.11 11.9M178.63 12.69C178.66 12.69 186.55 12.07 186.55 12.07 186.6 12.2 186.65 12.34 186.7 12.47 187.02 12.52 187.22 12.82 187.47 13.01 187.39 13.11 187.31 13.22 187.23 13.32 187.39 13.16 187.6 13.2 187.8 13.21 187.95 12.93 187.65 12.72 187.45 12.56 187.21 12.39 187.08 12.12 186.91 11.89 186.82 11.93 186.64 12.02 186.55 12.07M140.92 12.24C140.99 12.3 140.99 12.3 140.92 12.24M142.83 12.25C142.96 12.51 143.24 12.65 143.43 12.88 143.43 12.88 143.44 12.68 143.44 12.68 143.44 12.68 143.54 12.69 143.54 12.69 143.51 12.74 143.45 12.86 143.42 12.91 143.66 13.01 143.91 13.1 144.16 13.18 144.19 12.86 143.94 12.63 143.76 12.41 143.72 12.44 143.64 12.5 143.6 12.53 143.5 12.43 143.39 12.33 143.29 12.22 143.14 12.23 142.98 12.24 142.83 12.25M148.5 12.21C148.41 12.36 148.62 12.6 148.78 12.51 148.85 12.36 148.66 12.1 148.5 12.21M146.52 12.64C146.78 12.84 147.1 12.74 147.38 12.63 147.38 12.53 147.38 12.43 147.38 12.32 147.11 12.47 146.83 12.62 146.52 12.64M140.47 12.74C140.5 12.76 140.5 12.76 140.47 12.74M145.27 13.28C145.06 13.32 145.14 13.69 145.35 13.62 145.53 13.57 145.43 13.27 145.27 13.28M145.05 14.5C145.05 14.5 145.13 14.5 145.13 14.5 145.19 14.23 145.27 13.97 145.33 13.71 145.23 13.97 145.17 14.24 145.05 14.5M190.35 14.37C190.42 14.55 190.48 14.73 190.63 14.86 190.6 15.04 190.67 15.21 190.76 15.37 190.99 15.34 191.21 15.31 191.44 15.29 191.47 14.83 191.29 14.39 190.89 14.14 190.71 14.23 190.53 14.3 190.35 14.37M184.58 16.06C184.74 16.01 184.89 15.97 185.05 15.92 184.94 15.71 184.85 15.43 184.56 15.46 184.32 15.63 184.53 15.86 184.58 16.06M175.22 15.68C175.27 15.74 175.27 15.74 175.22 15.68M190.93 15.79C190.96 15.88 191 15.97 191.04 16.06 191.09 16.06 191.19 16.04 191.24 16.03 191.3 16.32 191.43 16.58 191.63 16.8 191.63 16.85 191.64 16.96 191.64 17.01 191.73 16.87 191.82 16.73 191.89 16.58 191.83 16.38 191.67 16.23 191.54 16.07 191.53 16.04 191.52 15.96 191.51 15.92 191.32 15.85 191.12 15.81 190.93 15.79M185.65 16.03C185.61 16.16 185.58 16.28 185.54 16.41 185.84 16.62 186.16 16.82 186.52 16.91 186.24 16.6 185.95 16.31 185.65 16.03M176.69 17.04C176.5 17.38 177.07 17.07 176.69 17.04M194.59 17.57C194.44 17.65 194.3 17.72 194.16 17.8 194.23 17.97 194.28 18.15 194.33 18.34 194.45 18.33 194.56 18.32 194.67 18.31 194.75 18.36 194.82 18.41 194.9 18.47 195.07 18.38 195.24 18.29 195.42 18.21 195.41 18.03 195.41 17.85 195.41 17.67 195.13 17.69 194.84 17.7 194.59 17.57M157.24 22.74C157.08 22.78 157.14 22.92 157.16 23.04 157.53 23.04 157.9 23.07 158.26 22.96 158.21 22.84 158.17 22.72 158.12 22.6 157.86 22.78 157.53 22.7 157.24 22.74M142.61 25.16C142.45 25.29 142.19 25.37 142.18 25.61 142.59 25.6 142.86 25.25 143.22 25.09 143.32 25.14 143.42 25.21 143.52 25.28 143.47 25.14 143.42 25 143.37 24.87 143.08 24.86 142.83 24.99 142.61 25.16Z"' . $svg_flip . ' />';
                break;
            case 'curve_bottom':
                $svg_paths_bottom = '<path id="curve-bottom" d="M0,.5c0,15.48,89.45,28,200,28V30H0Z"' . $svg_flip . ' />';
                break;
            case 'curve_fan_bottom':
                $svg_paths_bottom = '<path id="curve-fan-bottom-opacity1" fill-opacity=".65" d="M200,15c0,7.88-100,12.34-200,14.24V30H200Z"' . $svg_flip . ' /><path id="curve-fan-bottom-opacity2" fill-opacity=".45" d="M200,19.83c0,5.35-100,8.37-200,9.65V30H200Z"' . $svg_flip . ' /><path id="curve-fan-bottom" d="M0,.5c0,15.48,89.45,28,200,28V30H0Z"' . $svg_flip . ' />';
                break;
            case 'zick_zak_fan_bottom':
                $svg_paths_bottom = '<path id="zick-zak-fan-bottom-opacity1" fill-opacity=".7" d="M0 15l20 5 30-5 42 10 15-10 13 5 25-5 10 5 35-10 10 15v5H0V15z"' . $svg_flip . ' /><path id="zick-zak-fan-bottom" d="M0 10l25 15 40-10 40 10 15-10 5 10 35-10 40 10v5H0V10z"' . $svg_flip . ' />';
                break;
            case 'zick_zak_bottom':
                $svg_paths_bottom = '<path id="zick-zak-bottom" d="M0 10l25 15 40-10 40 10 15-10 5 10 35-10 40 10v5H0V10z"' . $svg_flip . ' />';
                break;
            case 'dots_bottom':
                $svg_paths_bottom = '<path id="dots-bottom" d="M200 18c0-4.76-10.64-3.9-11 1.3-1.6-2.54-5-4.3-9-4.3a11.74 11.74 0 00-7.35 2.42 10 10 0 00-18.42-2.22 17.94 17.94 0 00-23.49 2.66C129.66 13.36 125.27 10 120 10c-6 0-10.83 4.34-11 9.74a8 8 0 00-11.78-.27 17 17 0 00-30.15-.61 11.46 11.46 0 00-17.2.05 11.48 11.48 0 00-22.5-1.28 13.95 13.95 0 00-15.89-2C10.3 12.34 3.68 10 0 10v20h200z"' . $svg_flip . ' />';
                break;
            case 'dots_fan_bottom':
                $svg_paths_bottom = '<path id="dots-bottom-opacity" fill-opacity=".64" d="M45.5 4a16.45 16.45 0 00-13 6.38 10 10 0 10-2.62 15.36A16.5 16.5 0 1045.5 4zm63 1a10.5 10.5 0 00-9.5 6 13 13 0 107.66 14.82 9.94 9.94 0 001.82.17 10.5 10.5 0 000-21zM173 7a9 9 0 109 9 9 9 0 00-9-9z"' . $svg_flip . ' /><path id="dots-fan-bottom" d="M200 18c0-4.76-10.64-3.9-11 1.3-1.6-2.54-5-4.3-9-4.3a11.74 11.74 0 00-7.35 2.42 10 10 0 00-18.42-2.22 17.94 17.94 0 00-23.49 2.66C129.66 13.36 125.27 10 120 10c-6 0-10.83 4.34-11 9.74a8 8 0 00-11.78-.27 17 17 0 00-30.15-.61 11.46 11.46 0 00-17.2.05 11.48 11.48 0 00-22.5-1.28 13.95 13.95 0 00-15.89-2C10.3 12.34 3.68 10 0 10v20h200z"' . $svg_flip . ' />';
                break;
            case 'bar_seperator_bottom':
                $svg_paths_bottom = '<path id="bar-seperator-bottom" d="M0 30h200V15H0v15z"/>';
                break;
            case 'bar_seperator_arrow_bottom':
                $svg_paths_bottom = '<path id="bar-seperator-arrow-bottom" d="m100 22-6-7H0v15h200V15h-94l-6 7Z"/>';
                break;
        }
        // END Section Dividers Bottom

        return ['svg_paths_top' => $svg_paths_top, 'svg_paths_bottom' => $svg_paths_bottom];
    }


    /**
     * Creates thumbnails for an image
     *
     * @param   string  $imagePath        The path to the original image
     * @param   string  $thumbnailFolder  The folder where the thumbnails should be saved
     * @param   array   $options          An array of options for creating the thumbnails
     * @param   array   $ItemOptions      An Item array of options for creating the thumbnails (Slider Pro)
     *
     * @return void
     *
     * @since  v1.2.0
     */
    public static function createThumbnails(string $imagePath, string $thumbnailFolder, array $options, array $ItemOptions = []): void
    {

        if (empty($imagePath)) {
            return;
        }

        $ex = '.' . pathinfo($imagePath, PATHINFO_EXTENSION);
        $fileName = 'th_' . pathinfo($imagePath, PATHINFO_FILENAME);

        $srcsets = [];

        // Image Pro Component create thumbnails
        if (isset($options['image_typ']) && !isset($ItemOptions['item_background_image'])) {
            if ($options['image_typ'] === "1" && !empty($options['image_width_srcset_bg']) && $options['image_typ_srcset_bg'] === '1') {
                // Image Pro Component create thumbnails -Background Images
                $tmpSrcset = explode(',', $options['image_width_srcset_bg']);
            } elseif ($options['image_typ'] === "0" && !empty($options['image_width_srcset_default']) && $options['image_typ_srcset_default'] === '1') {
                // Image Pro Component create thumbnails -Default Images
                $tmpSrcset = explode(',', $options['image_width_srcset_default']);
            }
        }
        // Media Card Pro Component create thumbnails
        elseif (!empty($options['image']) && !empty($options['image_width_srcset_bg'])) {
            $tmpSrcset = explode(',', $options['image_width_srcset_bg']);
        }
        // Text Block Pro Component create thumbnails
        elseif (isset($options['use_text_block_with_image']) && $options['use_text_block_with_image'] === "1" && $options['use_positions_component'] === "0" && !empty($options['image_text_block_width_srcset']) && !empty($options['image_text_block'])) {
            $tmpSrcset = explode(',', $options['image_text_block_width_srcset']);
        }
        // Text Block Pro Component create thumbnails with positions option
        elseif (isset($options['use_positions_component']) && $options['use_positions_component'] === "1" && !empty($options['image_positions_component_width_srcset']) && !empty($options['image'])) {
            $tmpSrcset = explode(',', $options['image_positions_component_width_srcset']);
        }
        // Newsletter Subscribe Pro Component create thumbnails
        elseif (isset($options['newsletter_subscribe_pro_layout']) && $options['newsletter_subscribe_pro_layout'] === "1" && !empty($options['image_block'])  && !empty($options['image_block_width_srcset'])) {
            $tmpSrcset = explode(',', $options['image_block_width_srcset']);
        }
        // Sections Background images create thumbnails
        elseif (isset($options['custom_background']) && $options['custom_background'] === "1" && $options['background_image_srcset'] === "1" && !empty($options['background_image'])) {
            $tmpSrcset = explode(',', $options['image_width_srcset']);
        }
        // Slider Pro create thumbnails
        elseif ((isset($ItemOptions['item_background_image']) || isset($ItemOptions['item_image']) ) && !empty($options['image_width_srcsets'])) {
            $tmpSrcset = explode(',', $options['image_width_srcsets']);
        }

        if (empty($tmpSrcset)) {
            return;
        }

        $srcsets = array_merge($srcsets, array_map('trim', array_filter($tmpSrcset, 'is_numeric')));
        $srcsets = array_unique($srcsets);
        sort($srcsets);

        // create thumbnails only on admin view
        $fileFolder = '../' . $thumbnailFolder;

        foreach ($srcsets as $val) {
            if ($val < 4000) {
                $file = Path::clean($fileFolder . '/' . $fileName . '_' . $val . $ex);

                if (!is_file($file)) {
                    $quality = ($val < 500) ? 60 : 90;
                    $fullPath = Path::clean('../' . $imagePath);
                    self::image_resize($fullPath, $val, 0, $quality, 0, Path::clean($fileFolder), false);
                }
            }
        }

        // delete files if srcset value not exists
        $existingThumbnails = glob(Path::clean($fileFolder . '/' . $fileName . '_*' . $ex));
        foreach ($existingThumbnails as $thumbnail) {
            $thumbnailName = basename($thumbnail, $ex);
            $thumbnailValue = substr($thumbnailName, strlen($fileName) + 1);

            if (!in_array($thumbnailValue, $srcsets, true)) {
                chmod($thumbnail, 0777);
                unlink($thumbnail);
            }
        }
    }


    /**
     * @param   string  $imagePath
     * @param   string  $thumbnailFolder
     *
     *
     * @since 1.6.3
     */
    public static function deleteThumbnails(string $imagePath, string $thumbnailFolder): void
    {
        $ex = '.' . pathinfo($imagePath, PATHINFO_EXTENSION);
        $fileName = 'th_' . pathinfo($imagePath, PATHINFO_FILENAME);
        $fileFolder = '../' . $thumbnailFolder;

        // delete files
        $existingThumbnails = glob(Path::clean($fileFolder . '/' . $fileName . '_*' . $ex));
        if (!empty($existingThumbnails)) {
            foreach ($existingThumbnails as $thumbnail) {
                chmod($thumbnail, 0777);
                unlink($thumbnail);
            }
        }
    }


    /**
     * Get Component classes.
     *
     * @param   array  $options
     *
     * @return string
     *
     * @since  v1.2.0
     */
    public static function getClasses(array $options): string
    {
        $classes = array_filter([
            $options['show'] ?? '',
            $options['hidden'] ?? '',
            $options['class'] ?? '',
            $options['modul_padding'] ?? '',
            $options['modul_shadow'] ?? '',
            $options['alignment'] ?? '',
            $options['modul_height'] ?? '',
            $options['flex_content_vertical'] ?? '',
            $options['color_style'] ?? '',
            (($options['use_img_transition'] ?? 0) === '1' || ($options['use_overlay_transition'] ?? 0) === '1') ? 'uk-transition-toggle' : ''
        ]);

        return implode(' ', $classes);
    }


    /**
     * Get Title and/or Subtitle classes.
     *
     * @param   array  $options
     *
     * @return array
     *
     * @since  v1.2.0
     */
    public static function getTitleAndSubtitleClasses(array $options): array
    {

        if (!is_array($options)) {
            $options = [];
        }
        $classes = ['title' => '', 'subtitle' => ''];

        if (!empty($options['title']) && ($options['title_show'] ?? 1) === "1") {
            $title_classes = array_filter([
                $options['title_font_size'] ?? '',
                $options['title_font_weight'] ?? '',
                $options['title_style'] ?? '',
                $options['title_text_color'] ?? '',
                $options['title_text_transform'] ?? '',
                ($options['title_font_family_handwriting'] ?? '') === "1" ? 'tm-handwriting-font' : '',
                !empty($options['title_width_viewport']) && $options['image_height'] === 'viewport' && ($options['image_typ'] ?? 1) === "1" ? 'uk-width-' . $options['title_width_viewport'] : ''
            ]);
            $classes['title'] = ' ' . implode(' ', $title_classes);
        }

        if (!empty($options['subtitle'])) {
            $subtitle_classes = array_filter([
                $options['subtitle_font_size'] ?? '',
                $options['subtitle_font_weight'] ?? '',
                $options['subtitle_text_color'] ?? '',
                $options['subtitle_title_style'] ?? '',
                $options['subtitle_text_transform'] ?? '',
            ]);
            $classes['subtitle'] = ' ' . implode(' ', $subtitle_classes);
        }

        return $classes;
    }


    /**
     * @return array
     *
     *  @since 1.0.0
     */
    public static function getSectionConfig(): array
    {
        $section_config = [];
        $form = Form::getInstance('section', JPATH_ROOT . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'section.xml');
        $general_fields = $form->getFieldset('general');
        $options_fields = $form->getFieldset('options');

        foreach ($general_fields as $field) {
            $name = $field->__get('name');
            $section_config[$name] = (string)$form->getFieldAttribute($name, 'default');
        }
        foreach ($options_fields as $field) {
            $name = $field->__get('name');
            $section_config['options'][$name] = (string)$form->getFieldAttribute($name, 'default');
        }
        $form->reset(true);
        return $section_config;
    }


    /**
     * @return array
     *
     *  @since 1.0.0
     */
    public static function getColumnConfig(): array
    {
        $column_config = [];
        $form = Form::getInstance('column', JPATH_ROOT . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'column.xml');
        $general_fields = $form->getFieldset('general');
        $options_fields = $form->getFieldset('options');

        foreach ($general_fields as $field) {
            $name = $field->__get('name');
            $column_config[$name] = (string)$form->getFieldAttribute($name, 'default');
        }
        foreach ($options_fields as $field) {
            $name = $field->__get('name');
            $column_config['options'][$name] = (string)$form->getFieldAttribute($name, 'default');
        }
        $form->reset(true);
        return $column_config;
    }


    /**
     * @return array
     *
     *  @since 1.0.0
     */
    public static function getComponents(): array
    {
        $components = [];
        $files = Folder::files(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'components', '.xml', false, true);

        foreach ($files as $file) {
//          $form = Factory::getContainer()->get(FormFactoryInterface::class)->createForm(str_replace('.xml', '', basename($file)), []);
            $form = Form::getInstance(str_replace('.xml', '', basename($file)), $file);
            self::$forms[$form->getFieldAttribute('type', 'default')] = $form;
            $components[] = array(
                'type' => $form->getFieldAttribute('type', 'default'),
                'category' => $form->getFieldAttribute('category', 'default')
            );
        }
        return $components;
    }


    /**
     * @param   null  $src
     * @param   int   $width
     * @param   null  $height
     * @param   int   $quality
     * @param   bool  $crop
     * @param   bool  $cacheDir
     * @param   bool  $directOutput
     *
     * @return bool|string
     *
     * @since 1.0.0
     */
    public static function image_resize($src = null, int $width = 100, $height = null, int $quality = 80, bool $crop = false, bool|string $cacheDir = false, bool $directOutput = true): bool|string
    {
        $img = (File::exists($src) ? getimagesize($src) : '');
        if ($img && extension_loaded('gd')) {
            if (!list($w, $h) = getimagesize($src)) {
                return "Unsupported picture type!";
            }

            $type = strtolower(substr(strrchr($src, "."), 1));
            if ($type === 'jpeg') {
                $type = 'jpg';
            }

            $file_name = 'th_' . pathinfo($src, PATHINFO_FILENAME) . '_' . $width;

            if ($cacheDir) {
                if (!file_exists($cacheDir)) {
                    Folder::create($cacheDir, 0755);
                }
                // Check if cached file exists:
                $dst = Path::clean($cacheDir . '/' . $file_name . '.' . $type);
//              var_dump($dst);
                if (is_file($dst)) {
                    if ($directOutput) {
                        switch ($type) {
                            case 'bmp':
                                $img = imagecreatefrombmp($dst);
                                break;
                            case 'webp':
                                $img = imagecreatefromwebp($dst);
                                break;
                            case 'gif':
                                $img = imagecreatefromgif($dst);
                                imagegif($img);
                                break;
                            case 'png':
                                $img = imagecreatefrompng($dst);
                                imagepng($img, null, $quality);
                                break;
                            case 'jpg':
                            case 'jpeg':
                                $img = imagecreatefromjpeg($dst);
                                imagejpeg($img, null, $quality);
                                break;
                        }
                        die();
                    }

                    return $dst;
                }
            }

            if (extension_loaded('gd')) {
                switch ($type) {
                    case 'bmp':
                        $img = imagecreatefrombmp($src);
                        break;
                    case 'webp':
                        $img = imagecreatefromwebp($src);
                        break;
                    case 'gif':
                        $img = imagecreatefromgif($src);
                        break;
                    case 'png':
                        $img = imagecreatefrompng($src);
                        break;
                    case 'jpg':
                    case 'jpeg':
                        $img = imagecreatefromjpeg($src);
                        break;
                    default:
                        return "Unsupported picture type!";
                }
            } else {
                return false;
            }

            // Calculate missing dimensions:
            if ($width === null || $width === 0) {
                $width = $w * ($height / $h);
            } elseif ($height === null || $height === 0) {
                $height = $h * ($width / $w);
            }

            // resize
            if ($crop) {
                $ratio = max($width / $w, $height / $h);
                $x = 0;
                $y = 0;
                if ($width / $height > $w / $h) {
                    $y = ($h - ($height / $ratio)) / 2;
                } else {
                    $x = ($w - ($width / $ratio)) / 2;
                }
                $h = $height / $ratio;
                $w = $width / $ratio;
            } else {
                $ratio = min($width / $w, $height / $h);
                $width = $w * $ratio;
                $height = $h * $ratio;
                $x = 0;
                $y = 0;
            }

            if (extension_loaded('gd')) {
                imageantialias($img, true);
            } else {
                return false;
            }

            if (extension_loaded('gd')) {
                $new = imagecreatetruecolor((int) $width, (int) $height);
            } else {
                return false;
            }

            // preserve transparency
            if (($type === "gif" || $type === "png") && extension_loaded('gd')) {
                imagecolortransparent($new, imagecolorallocatealpha($new, 0, 0, 0, 127));
                imagealphablending($new, false);
                imagesavealpha($new, true);
            }

            self::newimagecopyresampled($new, $img, 0, 0, $x, $y, $width, $height, $w, $h);

            if ($cacheDir && extension_loaded('gd')) {
                // Save file
                $dst = $cacheDir . '/' . $file_name . '.' . $type;
                switch ($type) {
                    case 'bmp':
                        imagewbmp($new, $dst);
                        break;
                    case 'gif':
                        imagegif($new, $dst);
                        break;
                    case 'jpg':
                        imagejpeg($new, $dst, $quality);
                        break;
                    case 'png':
                        imagepng($new, $dst);
                        break;
                }
            }

            if ($directOutput) {
                switch ($type) {
                    case 'bmp':
                        header('Content-Type: image/bmp');
                        imagewbmp($new);
                        break;
                    case 'gif':
                        header('Content-Type: image/gif');
                        imagegif($new);
                        break;
                    case 'jpg':
                        header('Content-Type: image/jpeg');
                        imagejpeg($new, null, $quality);
                        break;
                    case 'png':
                        header('Content-Type: image/png');
                        imagepng($new);
                        break;
                }
                return true;
            }

            return $dst ?? false;
        }

        return "Wrong path!";
    }


    /**
     * @param          $dst_image
     * @param          $src_image
     * @param   float  $dst_x
     * @param   float  $dst_y
     * @param   int    $src_x
     * @param   int    $src_y
     * @param   float  $dst_w
     * @param   float  $dst_h
     * @param   int    $src_w
     * @param   int    $src_h
     * @param   int    $quality
     *
     * @return bool
     *
     * @since 1.0.0
     */
    public static function newimagecopyresampled($dst_image, $src_image, float $dst_x, float $dst_y, int $src_x, int $src_y, float $dst_w, float $dst_h, int $src_w, int $src_h, int $quality = 3): bool
    {
        if (empty($src_image) || empty($dst_image)) {
            return false;
        }
        if ($quality < 5 && (($dst_w * $quality) < $src_w || ($dst_h * $quality) < $src_h)) {
            $tmp_w = floor($dst_w * $quality);
            $tmp_h = floor($dst_h * $quality);
            $temp = imagecreatetruecolor($tmp_w + 1, $tmp_h + 1);
            imagecopyresized($temp, $src_image, $dst_x * $quality, $dst_y * $quality, $src_x, $src_y, $tmp_w + 1, $tmp_h + 1, $src_w, $src_h);
            imagecopyresampled($dst_image, $temp, 0, 0, 0, 0, (int)$dst_w, (int)$dst_h, (int)$tmp_w, (int)$tmp_h);
            imagedestroy($temp);
        } else {
            imagecopyresampled($dst_image, $src_image, $dst_x, $dst_y, $src_x, $src_y, $dst_w, $dst_h, $src_w, $src_h);
        }
        return true;
    }


    /**
     * @param $obj
     *
     * @return array|mixed
     *
     *  @since 1.0.0
     */
    public static function toArray($obj): mixed
    {
        if (is_object($obj)) {
            $obj = (array)$obj;
        }
        if (is_array($obj)) {
            $new_array = array();
            foreach ($obj as $key => $val) {
                $new_array[$key] = self::toArray($val);
            }
        } else {
            $new_array = $obj;
        }
        return $new_array;
    }


    /**
     * @param $array
     *
     * @return mixed
     *
     *  @since 1.0.0
     */
    public static function escapeHtmlArray($array): mixed
    {
        $not_escapable = ['title', 'button_text', 'content', 'item_content', 'item_description_content', 'item_text', 'video_content'];

        foreach ($array as $key => $val) {
            if (!in_array($key, $not_escapable, true)) {
                $array[$key] = self::escapeHtml($val);
            } elseif (!strpos($val, 'src="' . Uri::root(true) . '/')) {
                $val            = preg_replace('/src="(?!http(s)*:\/\/)/', 'src="' . Uri::root(true) . '/$1', $val);
                $array[$key]    = $val;
            }
        }

        return $array;
    }


    /**
     * @param $string
     *
     * @return array|string|null
     *
     *  @since 1.0.0
     */
    public static function escapeHtml($string): array|string|null
    {
        if ($string) {
            $string = htmlentities($string, ENT_QUOTES, 'UTF-8');
            $string = preg_replace('/&lt;span class=&quot;search-result&quot;&gt;(.*?)&lt;\/span&gt;/', '<span class="search-result">$1</span>', $string);
        }

        return $string;
    }


    /**
     * @param $name
     * @param bool $cleanNum
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function cleanName($name, bool $cleanNum = false): string
    {
        $name = str_replace(array('_', '+', '-', '.'), ' ', $name);
        if ($cleanNum) {
            $name = preg_replace('/[0-9]+/', '', $name);
        }
        return ucwords($name);
    }


    /**
     * @return int
     *
     * @throws \Exception
     * @since 1.0.0
     */
    public static function randomNumber(): int
    {
        return random_int(1000, 9999);
    }


    /**
     * @param $link
     *
     * @return int
     *
     *  @since 1.0.0
     */
    public static function getPageItemIdByLink($link): int
    {
        $db    = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true)
            ->select('id')
            ->from($db->quoteName('#__menu'))
            ->where($db->quoteName('link') . ' = ' . $db->quote($link))
            ->where($db->quoteName('published') . ' = 1');
        $db->setQuery($query);
        $result = $db->loadObject();

        return $result->id ?? 0;
    }


    /**
     * Methode to get actual Version
     *
     * @return string
     *
     *
     * @throws \JsonException
     *
     * @since 0.0.1
     */
    public static function getVersion(): string
    {
        $db    = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true)->select('e.manifest_cache')->select($db->quoteName('e.manifest_cache'))->from($db->quoteName('#__extensions', 'e'))->where($db->quoteName('e.element') . ' = ' . $db->quote('com_uithemebuilderlite'));
        $db->setQuery($query);
        $manifest_cache = json_decode($db->loadResult(), false, 512, JSON_THROW_ON_ERROR);
        if (isset($manifest_cache->version) && $manifest_cache->version) {
            return $manifest_cache->version;
        }
        return '1.0';
    }


    /**
     * @param $array
     *
     * @return string
     *
     *  @since 0.0.1
     */
    public static function buildStyle($array): string
    {
        $style = '';
        if (count($array)) {
            $style .= ' style="';
            foreach ($array as $key => $val) {
                if ($key === 'background-image' || $key === 'mask' || $key === '-webkit-mask') {
                    $style .= $key . ': url(' . htmlspecialchars('\'' . $val . '\'', ENT_QUOTES) . ');';
                } else {
                    $style .= $key . ':' . $val . ';';
                }
            }
            $style .= '"';
        }
        return $style;
    }


    /**
     * @param $component_type
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function componentTypeToTitle($component_type): string
    {
        return Text::_('COM_UITHEMEBUILDERLITE_' . strtoupper($component_type));
    }


    /**
     * @param $component_category
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function componentCategoryToTitle($component_category): string
    {
        return Text::_('COM_UITHEMEBUILDERLITE_' . strtoupper($component_category));
    }


    /**
     * @param $component_category
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function componentModCategoryToTitle($component_category): string
    {
        return Text::_('MOD_UITHEMEBUILDERLITE_' . strtoupper($component_category));
    }


    /**
     * @param $component_type
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function componentDesc($component_type): string
    {
        return Text::_('COM_UITHEMEBUILDERLITE_' . strtoupper($component_type) . '_DESC');
    }


    /**
     * @param $component_type
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function componentModDesc($component_type): string
    {
        return Text::_('MOD_UITHEMEBUILDERLITE_' . strtoupper($component_type) . '_DESC');
    }


    /**
     * @param $component_type
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function componentModTypeToTitle($component_type): string
    {
        return Text::_('MOD_UITHEMEBUILDERLITE_' . strtoupper($component_type));
    }


    /**
     * @param string $class
     *
     * @return mixed|true|void
     *
     *  @since 1.0.0
     */
    public static function getProParams(string $class = '')
    {
        if (!$class) {
            return true;
        }
        if (file_exists(JPATH_ROOT . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . strtolower($class) . '.php')) {
            include_once(JPATH_ROOT . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . strtolower($class) . '.php');
            $newClassName = 'uiThemeBuilderParams' . ucfirst($class);
            return new $newClassName;
        }
    }


    /**
     * @param $text
     * @param $number
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function createId($text, $number): string
    {
        $id = '';
        if ($text) {
            $id .= preg_replace('/[^\da-z]/i', '', strtolower($text));
        }
        $id .= $number;
        return $id;
    }


    /**
     * @param $form
     * @param $fields
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function renderFormFields($form, $fields): string
    {
        $html = '';
        foreach ($fields as $field) {
            $control_group_class = 'uk-form-stacked';
            $control_group_class .= ($form->getFieldAttribute($field, 'type') === 'hidden') ? ' uk-hidden' : '';
            $control_group_showon = $form->getFieldAttribute($field, 'showon') ? ' data-showon="' . $form->getFieldAttribute($field, 'showon') . '"' : '';
            $html .= '<div class="uk-margin ' . $control_group_class . '"' . $control_group_showon . '>';
                $html .= '<div>';
                    $html .= $form->getLabel($field);
                    $html .= '<div class="uk-form-controls">';
                        $html .= $form->getInput($field);
                    $html .= '</div>';
                $html .= '</div>';
            $html .= '</div>';
        }
        return $html;
    }


    /**
     * @param $form
     * @param $fields
     *
     * @return string
     *
     *  @since 1.0.0
     */
    public static function renderFormFieldsHorizontal($form, $fields): string
    {
        $html = '';
        foreach ($fields as $field) {
            $control_group_class = 'uk-form-horizontal';
            $control_group_class .= ($form->getFieldAttribute($field, 'type') === 'hidden') ? ' uk-hidden' : '';
            $control_group_showon = $form->getFieldAttribute($field, 'showon') ? ' data-showon="' . $form->getFieldAttribute($field, 'showon') . '"' : '';
            $html .= '<div class="uk-margin ' . $control_group_class . '"' . $control_group_showon . '>';
            $html .= '<div>';
            $html .= $form->getLabel($field);
            $html .= '<div class="uk-form-controls">';
            $html .= $form->getInput($field);
            $html .= '</div>';
            $html .= '</div>';
            $html .= '</div>';
        }
        return $html;
    }


    /**
     * @param $svg_path
     * @param bool $key
     * @param bool $color_placeholder_1
     * @param bool $color_placeholder_2
     * @param bool $color_placeholder_3
     * @param bool $text_placeholder
     * @param bool $text_font_size_placeholder
     * @param bool $opacity_placeholder
     *
     * @return bool|string
     *
     *  @since 1.0.0
     */
    public static function convertSVGtoURI($svg_path, int|bool $key = false, $color_placeholder_1 = false, $color_placeholder_2 = false, $color_placeholder_3 = false, bool|string $text_placeholder = false, bool|string $text_font_size_placeholder = false, int|bool|string $opacity_placeholder = false): bool|string
    {
        if (!$svg_path) {
            return true;
        }

        // Load SVG and optimize for ui
        $data = file_get_contents($svg_path);
        // Placeholder to change color / text / font size / opacity
        if ($color_placeholder_1) {
            $data = str_replace("[COLOR_1]", $color_placeholder_1, $data);
        }
        if ($color_placeholder_2) {
            $data = str_replace("[COLOR_2]", $color_placeholder_2, $data);
        }
        if ($color_placeholder_3) {
            $data = str_replace("[COLOR_3]", $color_placeholder_3, $data);
        }
        if ($text_placeholder) {
            $data = str_replace("[TEXT]", $text_placeholder, $data);
        }
        if ($text_font_size_placeholder) {
            $data = str_replace("[FONT_SIZE]", $text_font_size_placeholder, $data);
        }
        if ($text_font_size_placeholder) {
            $data = str_replace("[OPACITY_1]", $opacity_placeholder, $data);
        }

        // optimize SVG
        $data = preg_replace("/[\n\r]/", "", $data);
        $data = str_replace(array('"', "%", "<", ">", " ", "!", "*", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "#", "[", "]", '{', '}'), array("'", "%25", "%3C", "%3E", "%20", "%21", "%2A", "%28", "%29", "%3B", "%3A", "%40", "%26", "%3D", "%2B", "%24", "%2C", "%2F", "%3F", "%23", "%5B", "%5D", '%7B', '%7D'), $data);
        $data = trim($data);

        return $data;
    }


    /**
     * Static method to get an instance of a Table class if it can be found in the table include paths.
     *
     * @param   string  $type    The type (name) of the Table class to get an instance of.
     * @param   string  $prefix  An optional prefix for the table class name.
     * @param   array   $config  An optional array of configuration values for the Table object.
     *
     * @return  Table|boolean   A Table object if found or boolean false on failure.
     *
     * @since       1.1.4
     */
    static function getTableInstance(string $type, string $prefix = 'JTable', array $config = []): Table|bool
    {
        // Sanitize and prepare the table class name.
        $type       = preg_replace('/[^A-Z0-9_.-]/i', '', $type);
        $tableClass = $prefix . ucfirst($type);

        // If a database object was passed in the configuration array use it, otherwise get the global one from Factory.
        $db = $config['dbo'] ?? Factory::getContainer()->get('DatabaseDriver');

        // Check for a possible service from the container otherwise manually instantiate the class
        if (Factory::getContainer()->has($tableClass)) {
            return Factory::getContainer()->get($tableClass);
        }

        // Instantiate a new table class and return it.
        return new $tableClass($db);
    }
}
