<?php
/**
 * @package        ui/Theme-Builder Lite
 * @author         Stephan W.
 * @author         url    https://www.ui-themebuilder.com/
 * @copyright      Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer      Stephan Wittling - https://www.ui-themebuilder.com/
 *                ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *                but WITHOUT ANY WARRANTY; without even the implied warranty of
 *                MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *                See the GNU General Public License for more details.
 * @license        http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\Field;

// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use SW\Component\uiThemeBuilderLite\Administrator\Helper\PageHelper;

class SVGSectionMaskListField extends ListField
{

    /**
     * The form field type.
     *
     * @var     string
     *
     * @since   v1.0.0
     */
    protected $type = 'SVGSectionMaskList';

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     *
     * @since   1.0.0
     */
    public function getInput(): string
    {
        $html = array();
        $attr = !empty($this->class) ? ' class="' . $this->class . '"' : '';
        $svglist = (array)$this->getSVGMaskFiles();
        $html[] = HTMLHelper::_('select.genericlist', $svglist, $this->name, trim($attr), 'value', 'text', $this->value, $this->id);

        return implode($html);
    }

    public function getSVGMaskFiles(): array
    {
        $shape_path = JPATH_ROOT . DIRECTORY_SEPARATOR . 'media' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'svg-masks' . DIRECTORY_SEPARATOR;
        $shapes = $this->getFiles($shape_path);

        $svglist = array(
            0 => array(
                'value' => '',
                'text' => Text::_('COM_UITHEMEBUILDERLITE_SELECT_SVG')
            )
        );

        if (count((array)$shapes)) {
            foreach ($shapes as $shape) {
                $title_tmp = str_replace('.svg', '', $shape);
                $title_tmp = PageHelper::cleanName($title_tmp, true);
                $title = ucwords($title_tmp);

                $svglist[$shape] = $title;
            }
        }

        return $svglist;
    }

    protected function getFiles($path): bool|array
    {
        if (is_dir($path)) {
            $res = array();
            foreach (array_filter(glob($path . "section_*.svg"), 'is_file') as $file) {
                $res[] = str_replace($path, "", $file);
            }
            return $res;
        }

        return false;
    }
}
