<?php
/**
 * @package        ui/Theme-Builder Lite
 * @author         Stephan W.
 * @author         url    https://www.ui-themebuilder.com/
 * @copyright      Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer      Stephan Wittling - https://www.ui-themebuilder.com/
 *                ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *                but WITHOUT ANY WARRANTY; without even the implied warranty of
 *                MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *                See the GNU General Public License for more details.
 * @license        http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\Field;

// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

class ModulesListField extends ListField
{

    /**
     * The form field type.
     *
     * @var     string
     *
     * @since   v1.0.0
     */
    protected $type = 'ModulesList';

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     *
     * @since   v.1.0.0
     */
    public function getInput(): string
    {
        $html = array();
        $attr = !empty($this->class) ? ' class="' . $this->class . '"' : '';
        $options = (array)$this->getModulesList();
        $html[] = HTMLHelper::_('select.genericlist', $options, $this->name, trim($attr), 'value', 'text', $this->value, $this->id);
        return implode($html);
    }

    public function getModulesList(): array
    {
        $db    = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true)->select($db->qn('id') . ', ' . $db->qn('title'))->from($db->qn('#__modules'))->where($db->qn('client_id') . ' = 0')->where($db->qn('published') . ' = 1')->order($db->qn('ordering') . ', ' . $db->qn('title'));
        $db->setQuery($query);
        $modules = $db->loadObjectList();
        $options = array(
            0 => array(
                'value' => '',
                'text' => Text::_('COM_UITHEMEBUILDERLITE_SELECT_MODULE')
            )
        );

        foreach ($modules as $module) {
            $tmp = array(
                'value' => $module->id,
                'text' => $module->title
            );
            $options[] = (object)$tmp;
        }

        return $options;
    }
}
