<?php
/**
 * @package        ui/Theme-Builder Lite
 * @author         Stephan W.
 * @author         url    https://www.ui-themebuilder.com/
 * @copyright      Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer      Stephan Wittling - https://www.ui-themebuilder.com/
 *                ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *                but WITHOUT ANY WARRANTY; without even the implied warranty of
 *                MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *                See the GNU General Public License for more details.
 * @license        http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\Field;

// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

class ArticleListField extends ListField
{

    /**
     * The form field type.
     *
     *
     * @since   v0.0.1
     */
    protected $type = 'ArticleList';

    /**
     * Method to get the field input markup.
     *
     * @return  string  The field input markup.
     *
     * @since   v0.0.1
     */
    protected function getInput(): string
    {
        $html = array();
        $attr = !empty($this->class) ? ' class="' . $this->class . '"' : '';
        $options = $this->getArticleCategorieslist();
        $html[] = HTMLHelper::_('select.genericlist', $options, $this->name, trim($attr), 'value', 'text', $this->value, $this->id);
        return implode($html);
    }

    /**
     *
     * @return array|array[]
     *
     * @since   v0.0.1
     */
    public function getArticleCategorieslist(): array
    {
        $db    = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true)->select('DISTINCT a.id, a.title, a.level, a.published, a.lft');
        $subQuery = $db->getQuery(true)->select('id,title,level,published,parent_id,extension,lft,rgt')->from('#__categories')->where($db->quoteName('published') . ' = ' . $db->quote(1))->where($db->quoteName('extension') . ' = ' . $db->quote('com_content'));
        $query->from('(' . $subQuery->__toString() . ') AS a')->join('LEFT', $db->quoteName('#__categories') . ' AS b ON a.lft > b.lft AND a.rgt < b.rgt');
        $query->order('a.lft ASC');
        $db->setQuery($query);
        $categories = $db->loadObjectList();
        $options = array(
            0 => array(
                'value' => '',
                'text' => Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_ALL_CAT')
            )
        );
        $j = 1;
        if (count((array)$categories)) {
            foreach ($categories as $category) {
                $options[$j]['value'] = $category->id;
                $options[$j]['text'] = str_repeat('- ', ($category->level - 1)) . $category->title;
                ++$j;
            }
        }

        return $options;
    }
}
