<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\Extension;

defined('JPATH_PLATFORM') or die;

use Joomla\CMS\Association\AssociationServiceInterface;
use Joomla\CMS\Association\AssociationServiceTrait;
use Joomla\CMS\Categories\CategoryServiceInterface;
use Joomla\CMS\Categories\CategoryServiceTrait;
use Joomla\CMS\Component\Router\RouterServiceInterface;
use Joomla\CMS\Component\Router\RouterServiceTrait;
use Joomla\CMS\Extension\BootableExtensionInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\HTML\HTMLRegistryAwareTrait;
use Joomla\CMS\Tag\TagServiceInterface;
use Joomla\CMS\Tag\TagServiceTrait;
use Psr\Container\ContainerInterface;
use SW\Component\uiThemeBuilderLite\Administrator\Service\HTML\AdministratorService;

/**
 * Component class for com_uithemebuilderlite
 *
 * @since  1.0.0
 */
class uiThemeBuilderLiteComponent extends MVCComponent implements
    BootableExtensionInterface,
    CategoryServiceInterface,
    AssociationServiceInterface,
    RouterServiceInterface,
    TagServiceInterface
{
    use AssociationServiceTrait;
    use HTMLRegistryAwareTrait;
    use RouterServiceTrait;
    use CategoryServiceTrait, TagServiceTrait {
        CategoryServiceTrait::getTableNameForSection insteadof TagServiceTrait;
        CategoryServiceTrait::getStateColumnForSection insteadof TagServiceTrait;
    }

    /**
     * The trashed condition
     *
     * @since   1.0.6
     */
    public const CONDITION_NAMES = [
        self::CONDITION_PUBLISHED => 'JPUBLISHED',
        self::CONDITION_UNPUBLISHED => 'JUNPUBLISHED',
        self::CONDITION_ARCHIVED => 'JARCHIVED',
        self::CONDITION_TRASHED => 'JTRASHED',
    ];

    /**
     * The archived condition
     *
     * @since   1.0.6
     */
    public const CONDITION_ARCHIVED = 2;

    /**
     * The published condition
     *
     * @since   1.0.6
     */
    public const CONDITION_PUBLISHED = 1;

    /**
     * The unpublished condition
     *
     * @since   1.0.6
     */
    public const CONDITION_UNPUBLISHED = 0;

    /**
     * The trashed condition
     *
     * @since   1.0.6
     */
    public const CONDITION_TRASHED = -2;

    /**
     * Booting the extension. This is the function to set up the environment of the extension like
     * registering new class loaders, etc.
     *
     * If required, some initial set up can be done from services of the container, e.g.
     * registering HTML services.
     *
     * @param ContainerInterface $container The container
     *
     * @return  void
     *
     * @since   1.0.0
     */
    public function boot(ContainerInterface $container): void
    {
        $this->getRegistry()->register('uithemebuilderliteadministrator', new AdministratorService);
    }

    /**
     * Adds Count Items for Category Manager.
     *
     * @param \stdClass[] $items   The category objects
     * @param string      $section The section
     *
     * @return  void
     *
     * @since   v1.0.0
     */
    public function countItems(array $items, string $section): void
    {
        try {
            $config = (object)[
                'related_tbl' => $this->getTableNameForSection($section),
                'state_col' => $this->getStateColumnForSection($section),
                'group_col' => 'catid',
                'relation_type' => 'category_or_group',
            ];

            ContentHelper::countRelations($items, $config);
        } catch (\Exception $e) {
            // Ignore it
        }
    }

    /**
     * Returns the table for the count items functions for the given section.
     *
     * @param   string|null  $section  The section
     *
     * @return  string|null
     *
     * @since   v1.0.0
     */
    protected function getTableNameForSection(string $section = null): ?string
    {
        return 'uithemebuilderlite';
    }

    /**
     * Returns the state column for the count items functions for the given section.
     *
     * @param   string|null  $section  The section
     *
     * @return  string|null
     *
     * @since   v1.0.0
     */
    protected function getStateColumnForSection(string $section = null): ?string
    {
        return 'published';
    }
}
