<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Path;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Versioning\VersionableControllerTrait;
use Joomla\Utilities\ArrayHelper;
use SimpleXMLElement;
use SW\Component\uiThemeBuilderLite\Administrator\Helper\PageHelper;

/**
 * Controller for a single page
 *
 * @since  v1.0.0
 */
class PageController extends FormController
{

    use VersionableControllerTrait;

    /**
     * Constructor.
     *
     * @param   array                                             $config   An optional associative array of configuration settings.
     *                                                                      Recognized key values include 'name', 'default_task', 'model_path', and
     *                                                                      'view_path' (this list is not meant to be comprehensive).
     * @param   \Joomla\CMS\MVC\Factory\MVCFactoryInterface|null  $factory  The factory.
     * @param   null                                              $app      The Application for the dispatcher
     * @param   null                                              $input    Input
     *
     * @throws \Exception
     *
     * @since  1.0.0
     */
    public function __construct($config = array (), MVCFactoryInterface $factory = null, $app = null, $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
    }

    /**
     * @return void
     *
     * @throws \Exception
     *
     * @since   v1.0.0
     */
    public function renderSectionConfig(): void
    {
        $app                = Factory::getApplication();
        $html               = '';
        $row                = $app->input->getArray();
        $form               = Form::getInstance(PageHelper::createId('section', PageHelper::randomNumber()), JPATH_ROOT . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'section.xml');
        $row_general_fields = $form->getFieldset('general');
        $row_options_fields = $form->getFieldset('options');

        $basic_name      = ['type', 'grid', 'admin_visibility', 'visibility', 'hidden', 'publish_up', 'publish_down', 'basic_spacer', 'basic_spacer_1', 'basic_spacer_2', 'basic_spacer_3', 'html_tag', 'class', 'id'];
        $container_name  = ['section_full_width', 'container_width'];
        $grid_name       = ['grid_match', 'grid_match_row', 'grid_match_target', 'grid_gutter', 'grid_row_gap', 'grid_divider'];
        $title_name      = ['title_show', 'title', 'title_font_family_handwriting', 'title_heading', 'title_font_size', 'title_font_weight', 'title_text_transform', 'title_style', 'title_text_color', 'subtitle', 'subtitle_font_family_handwriting', 'subtitle_font_size', 'subtitle_font_weight', 'subtitle_text_transform', 'subtitle_heading', 'subtitle_title_style', 'heading_alignment', 'title_spacer_1', 'use_svg_title', 'mask_height', 'mask_color', 'mask_color_output', 'title_spacer_2', 'svg_title_stroke', 'svg_title_stroke_fill_color', 'svg_title_stroke_color', 'svg_title_stroke_width', 'title_spacer_3', 'svg_subtitle_stroke', 'svg_subtitle_stroke_fill_color', 'svg_subtitle_stroke_color', 'svg_subtitle_stroke_width', 'title_position_x', 'title_position_y', 'subtitle_position_x', 'subtitle_position_y'];
        $background_name = ['background_image_responsive', 'image_width_srcset', 'background_image_srcset', 'section_svg_list', 'section_svg_background_color_fallback', 'section_svg_background_color_2', 'section_svg_background_color_3', 'section_svg_background_text', 'section_svg_background_text_font_size', 'section_svg_background_attachment', 'section_svg_background_image_size', 'section_svg_background_image_repeat', 'section_svg_background_position_x', 'section_svg_background_position_y', 'section_svg_background_image_opacity', 'section_svg_background_image_responsive', 'custom_background', 'background', 'background_image', 'background_image_blend_modes', 'background_image_attachment', 'background_image_position', 'background_image_size', 'background_image_repeat', 'color_style', 'background_color', 'gradient_effect', 'gradient_angle', 'gradient_color_1', 'gradient_color_1_position', 'gradient_color_2', 'gradient_color_2_position', 'gradient_color_3', 'gradient_color_3_position', 'radial_conical_x_position', 'radial_conical_y_position', 'gradient_preview', 'shape_background', 'shape', 'shape_preview', 'shape_width', 'shape_height', 'shape_width_pixel', 'shape_height_pixel', 'shape_color', 'shape_position', 'shape_margin_top', 'shape_margin_right', 'shape_margin_bottom', 'shape_margin_left', 'shape_position_zindex', 'shape_border', 'shape_border_style', 'shape_border_color', 'shape_transform', 'shape_transform_rotate', 'shape_transform3d_1', 'shape_transform3d_2', 'shape_transform3d_3', 'shape_shadow', 'shape_background_image', 'shape_background_image', 'shape_background_image_repeat', 'shape_background_image_size', 'shape_background_image_blend_modes', 'shape_background_image_attachment', 'shape_background_image_position', 'background_spacer_1', 'background_spacer_2', 'background_spacer_3', 'background_spacer_4', 'background_spacer_5', 'background_spacer_6', 'background_spacer_7', 'video_url', 'thumbnail_image', 'video_auto_play', 'video_show_controls', 'video_show_info', 'video_show_suggestions', 'video_loop', 'video_muted', 'video_start'];
        $style_name      = ['svg_mask_mirrored_horizontally', 'svg_mask__color', 'svg_mask_list', 'svg_mask_repeat', 'svg_mask_position', 'use_svg_custom_mask_size', 'svg_mask_size', 'svg_custom_mask_size', 'section_align_content', 'section_load_components', 'section_height_viewport', 'section_height_viewport_offset_top', 'section_height_viewport_offset_bottom', 'section_height_viewport_expand', 'section_height_viewport_min_height', 'section_padding', 'section_margin', 'style_spacer_1', 'style_spacer_2', 'style_spacer_3', 'style_spacer_4', 'style_spacer_5', 'section_key', 'section_key_opacity', 'section_key_font_size', 'section_key_position', 'section_divider_z_index', 'section_divider_top_dropshadow', 'section_filter_dropShadow_color_top', 'section_dropShadow_blur_top', 'section_dropShadow_blur_y_offset_top', 'section_divider_top', 'section_divider_top_flip', 'section_divider_top_color', 'section_divider_top_height', 'section_divider_top_gradient', 'svg_preview_top', 'section_divider_top_color_1', 'section_divider_top_color_1_position', 'section_divider_top_color_2', 'section_divider_top_color_2_position', 'gradient_x1_position', 'gradient_y1_position', 'gradient_x2_position', 'gradient_y2_position', 'section_divider_bottom_gradient', 'svg_preview_bottom', 'section_divider_bottom_color_1', 'section_divider_bottom_color_1_position', 'section_divider_bottom_color_2', 'section_divider_bottom_color_2_position', 'gradient_x1_position_bottom', 'gradient_y1_position_bottom', 'gradient_x2_position_bottom', 'gradient_y2_position_bottom', 'section_divider_bottom', 'section_divider_bottom_flip', 'section_divider_bottom_color', 'section_divider_bottom_height', 'section_divider_bottom_dropshadow', 'section_filter_dropShadow_color_bottom', 'section_dropShadow_blur_bottom', 'section_dropShadow_blur_y_offset_bottom'];
        $animation_name  = ['scrollspy_animation', 'scrollspy_animation_delay', 'scrollspy_animation_repeat', 'scrollspy_animation_type', 'animation_spacer_1', 'parallax_animation_media', 'animation_spacer_2', 'parallax_animation_title', 'parallax_animation_title_opacity_values', 'parallax_animation_title_y_values', 'parallax_animation_title_x_values', 'parallax_animation_title_scale_values', 'parallax_animation_title_viewport', 'animation_spacer_3', 'parallax_animation_subtitle', 'parallax_animation_subtitle_opacity_values', 'parallax_animation_subtitle_y_values', 'parallax_animation_subtitle_x_values', 'parallax_animation_subtitle_scale_values', 'parallax_animation_subtitle_viewport', 'animation_spacer_4', 'parallax_animation_background', 'parallax_animation_background_x', 'parallax_animation_background_y', 'parallax_animation_background_viewport', 'parallax_animation_background_media', 'parallax_animation_background_grayscale', 'parallax_animation_background_saturate', 'parallax_animation_background_color'];

        if (!empty($row_general_fields)) {
            foreach ($row_general_fields as $field) {
                $name = $field->__get('name');
                $form->setFieldAttribute($name, 'default', $row[$name]);
                if (in_array($name, $basic_name)) {
                    $basic_fields[] = $name;
                }
            }
        }

        if (!empty($row_options_fields)) {
            foreach ($row_options_fields as $field) {
                $name = $field->__get('name');
                if (!empty($row['options']) && isset($row['options'][$name])) {
                    $form->setFieldAttribute($name, 'default', $row['options'][$name]);
                }
                if (in_array($name, $basic_name)) {
                    $basic_fields[] = $name;
                }
                if (in_array($name, $container_name)) {
                    $container_fields[] = $name;
                }
                if (in_array($name, $grid_name)) {
                    $grid_fields[] = $name;
                }
                if (in_array($name, $title_name)) {
                    $title_fields[] = $name;
                }
                if (in_array($name, $background_name)) {
                    $background_fields[] = $name;
                }
                if (in_array($name, $style_name)) {
                    $style_fields[] = $name;
                }
                if (in_array($name, $animation_name)) {
                    $animation_fields[] = $name;
                }
            }
            $html .= '<div class="options-tabs">';
            $html .= '<div class="uk-background-primary uk-light uk-padding-small">';
            $html .= '<ul class="uk-flex-center uk-subnav uk-margin-remove" uk-switcher="connect: .section-options-tab; animation: uk-animation-fade;">';
            if (!empty($basic_fields)) {
                $html .= '<li class="uk-active"><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_BASICS') . '</a></li>';
            }
            if (!empty($container_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_CONTAINER') . '</a></li>';
            }
            if (!empty($grid_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_GRID') . '</a></li>';
            }
            if (!empty($title_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_TITLE') . '</a></li>';
            }
            if (!empty($background_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_BACKGROUND') . '</a></li>';
            }
            if (!empty($style_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_STYLE') . '</a></li>';
            }
            if (!empty($animation_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_ANIMATION') . '</a></li>';
            }
            $html .= '</ul>';
            $html .= '</div>';
            $html .= '<div class="uk-modal-body" uk-overflow-auto="">';
            $html .= '<div class="uk-height-medium">';
            $html .= '<ul class="uk-switcher section-options-tab uk-margin">';
            if (!empty($basic_fields)) {
                $html .= '<li class="basic-tab-content uk-active">';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $basic_fields);
                $html .= '</li>';
            }
            if (!empty($container_fields)) {
                $html .= '<li class="container-tab-content">';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $container_fields);
                $html .= '</li>';
            }
            if (!empty($grid_fields)) {
                $html .= '<li class="grid-tab-content">';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $grid_fields);
                $html .= '</li>';
            }
            if (!empty($title_fields)) {
                $html .= '<li class="title-tab-content">';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $title_fields);
                $html .= '</li>';
            }
            if (!empty($background_fields)) {
                $html .= '<li class="background-tab-content">';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $background_fields);
                $html .= '</li>';
            }
            if (!empty($style_fields)) {
                $html .= '<li class="style-tab-content">';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $style_fields);
                $html .= '</li>';
            }
            if (!empty($animation_fields)) {
                $html .= '<li class="animation-tab-content">';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $animation_fields);
                $html .= '</li>';
            }
            $html .= '</ul>';
            $html .= '</div>';
            $html .= '<div class="loader"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>';
            $html .= '</div>';
            $html .= '</div>';
        }
        $form->reset(true);
        echo $html;
        Jexit();
    }

    /**
     * @return void
     *
     * @throws \Exception
     *
     * @since   v1.1.0
     */
    public function sectionPreview(): void
    {

        $app = Factory::getApplication();

        $section         = $app->input->getArray(array (), null, 'RAW');
        $section_options = PageHelper::escapeHtmlArray($section['options']);

        $title_show                  = ($section_options['title_show'] ?? 1);
        $titleAndSubtitleClasses     = PageHelper::getTitleAndSubtitleClasses($section_options);
        $title_class                 = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];
        $subtitle_class              = ($titleAndSubtitleClasses['subtitle'] === '') ? '' : ' ' . $titleAndSubtitleClasses['subtitle'];
        $titleMargin                 = '';
        $subtitleMargin              = '';
        $heading_alignment           = '';
        $position_relative           = '';
        $section_svg_divider_z_index = '';
        $section_css                 = '';
        $section_divider_top         = '';
        $section_divider_bottom      = '';
        $buildStyle                  = '';
        $container_buildStyle        = '';
        $section_full_width          = ($section_options['section_full_width'] ?? 1);
        $section_classes             = '';
        $section_mask_classes        = '';
        $grid_match                  = ($section_options['grid_match'] ?? 1);
        $grid_match_row              = (isset($section_options['grid_match_row']) && $section_options['grid_match_row'] == 1 && $section_options['grid_match'] == 1 ? ' row: false' : '');
        $grid_match_target           = (isset($section_options['grid_match_target']) && $section_options['grid_match'] == 1 && !empty($section_options['grid_match_target']) ? 'target: ' . $section_options['grid_match_target'] . ';' : '');
        $grid_gutter_class           = '';
        $container_classes           = '';
        $section_height_viewport     = '';
        $section_parallax            = '';
        $background_image_srcset     = ($section_options['background_image_srcset'] ?? 0);
        $srcsets                     = [];
        $srcset                      = '';
        $section_style               = [];

        $custom_background = ($section_options['custom_background'] ?? 0);

        $shape_position      = ($section_options['shape_position'] ?? 'left');
        $section_shape_class = '';
        $shape_margin_top    = (!empty($section_options['shape_margin_top']) ? $section_options['shape_margin_top'] . 'px' : 0);
        $shape_margin_right  = (!empty($section_options['shape_margin_right']) ? $section_options['shape_margin_right'] . 'px' : 0);
        $shape_margin_bottom = (!empty($section_options['shape_margin_bottom']) ? $section_options['shape_margin_bottom'] . 'px' : 0);
        $shape_margin_left   = (!empty($section_options['shape_margin_left']) ? $section_options['shape_margin_left'] . 'px' : 0);

        $shape_position_zindex = ($section_options['shape_position_zindex'] ?? 0);
        $shape_border          = (!empty($section_options['shape_border']) ? $section_options['shape_border'] . 'px' : '');
        $shape_transform       = ($section_options['shape_transform'] ?? 'unset');
        $shape_shadow          = (!empty($section_options['shape_shadow']) ? ' ' . $section_options['shape_shadow'] : '');

        $shape_background_image_repeat     = ($section_options['shape_background_image_repeat'] ?? 0);
        $shape_background_image_attachment = ($section_options['shape_background_image_attachment'] ?? "");
        $shape_background_image_position   = ((isset($section_options['shape_background_image_position']) && !empty($section_options['shape_background_image_position']) && !empty($section_options['shape_background_image'])) ? ' ' . $section_options['shape_background_image_position'] : '');

        $section_svg_background_image_responsive = ($section_options['section_svg_background_image_responsive'] ?? '');

        $section_key_show = ($section_options['section_key'] ?? 0);
        $key              = PageHelper::randomNumber();

        $currentDate              = Factory::getDate()->format('Y-m-d H:i:s');
        $get_publish_down_section = ($section_options['publish_down'] ?? null);
        $get_publish_up_section   = ($section_options['publish_up'] ?? null);

        $publish_down      = $get_publish_down_section == null ? null : $section_options['publish_down'];
        $isExpired         = !is_null($publish_down) && strtotime($publish_down) < strtotime($currentDate);
        $isNotPublishedYet = strtotime($get_publish_up_section) > strtotime($currentDate);
        $isUnpublished     = $isNotPublishedYet || $isExpired;

        $section_show = true;

        if ($isExpired) {
            $section_show = false;
        } elseif ($isUnpublished) {
            $section_show = false;
        }

        unset($section_options['columns']);

        if (!empty($section_options['class'])) {
            $section_classes .= ' ' . $section_options['class'];
        }

        // Alignment section content
        if ($section_options['section_align_content'] === "1" && $section_options['heading_alignment'] === 'uk-text-left' && (!empty($section_options['title']) || !empty($section_options['subtitle']))) {
            $section_classes .= ' uk-flex uk-flex-middle';
        } elseif ($section_options['section_align_content'] === "1" && $section_options['heading_alignment'] === 'uk-text-right' && (!empty($section_options['title']) || !empty($section_options['subtitle']))) {
            $section_classes .= ' uk-flex uk-flex-middle uk-flex-right';
        } elseif ($section_options['section_align_content'] === "1" && $section_options['heading_alignment'] === 'uk-text-center' && (!empty($section_options['title']) || !empty($section_options['subtitle']))) {
            $section_classes .= ' uk-flex uk-flex-middle uk-flex-center';
        } elseif ($section_options['section_align_content'] === "1" && $section_full_width === "1" && !empty($section_options['container_width']) && $section_options['section_load_components'] === "1") {
            $section_classes   .= ' uk-flex uk-flex-middle';
            $container_classes .= ' uk-width-3-4@xl uk-width-2-3@l';
        } elseif ($section_options['section_align_content'] === "1") {
            $section_classes .= ' uk-flex uk-flex-middle';
        }
        // END Alignment section content

        if (!empty($section_options['visibility'])) {
            $section_classes .= ' ' . $section_options['visibility'];
        }
        if (!empty($section_options['hidden'])) {
            $section_classes .= ' ' . $section_options['hidden'];
        }
        if (!empty($section_options['section_padding'])) {
            $section_classes .= ' ' . $section_options['section_padding'];
        }
        if (!empty($section_options['section_margin'])) {
            $section_classes .= ' ' . $section_options['section_margin'];
        }

        // Section Dividers
        if ((!empty($section_options['section_divider_bottom']) || !empty($section_options['section_divider_top'])) && $section_options['section_divider_z_index'] === "1") {
            $section_svg_divider_z_index = ' uk-position-z-index';
        }

        $divider_paths = PageHelper::getSectionDividers($section_options);

        if (!empty($section_options['section_divider_top'])) {
            $svg_paths_top   = $divider_paths['svg_paths_top'];
            $section_classes .= ' ui-separator-top-' . $key;

            if (!empty($section_options['section_divider_top_color'])) {
                $shape_paths_color_t = 'fill: ' . $section_options['section_divider_top_color'] . ';';
            } elseif (($section_options['section_divider_top_gradient'] === "1") && (!empty($section_options['section_divider_top_color_1'])) && (!empty($section_options['section_divider_top_color_2']))) {
                $shape_paths_color_t = 'fill: url(#ui-gradient-' . $key . ');';
            } else {
                $shape_paths_color_t = '';
            }

            if ($section_options['section_divider_top_dropshadow'] === "1") {
                $section_divider_top .= '<svg class="ui-separator ui-separator-top-' . $key . $section_svg_divider_z_index . '" viewBox="0 0 200 30" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="overflow: visible">';
            } else {
                $section_divider_top .= '<svg class="ui-separator ui-separator-top-' . $key . $section_svg_divider_z_index . '" viewBox="0 0 200 30" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">';
            }
            // SVG Filter´s Gradient / DropShadow (Top)
            if (($section_options['section_divider_top_gradient'] === "1") || ($section_options['section_divider_top_dropshadow'] === "1")) {
                $section_divider_top .= '<defs>';
                // Gradient
                if (($section_options['section_divider_top_gradient'] === "1") && (!empty($section_options['section_divider_top_color_1'])) && (!empty($section_options['section_divider_top_color_2']))) {
                    $section_divider_top .= '<linearGradient id="ui-gradient-' . $key . '" x1="' . $section_options['gradient_x1_position'] . '%" y1="' . $section_options['gradient_y1_position'] . '%" x2="' . $section_options['gradient_x2_position'] . '%" y2="' . $section_options['gradient_y2_position'] . '%" color-interpolation-filters="sRGB">';
                    $section_divider_top .= '<stop offset="' . $section_options['section_divider_top_color_1_position'] . '%" style="stop-color:' . $section_options['section_divider_top_color_1'] . ';stop-opacity:1" />';
                    $section_divider_top .= '<stop offset="' . $section_options['section_divider_top_color_2_position'] . '%" style="stop-color:' . $section_options['section_divider_top_color_2'] . ';stop-opacity:1" />';
                    $section_divider_top .= '</linearGradient>';
                }
                // DropShadow
                if ($section_options['section_divider_top_dropshadow'] === "1") {
                    $section_divider_top .= '<filter id="dropshadowfiltertop-section-' . $key . '" filterUnits="userSpaceOnUse" x="0" y="0" width="100%" height="120%" color-interpolation-filters="sRGB">';
                    $section_divider_top .= '<feGaussianBlur in="SourceAlpha" result="blur" stdDeviation="' . $section_options['section_dropShadow_blur_top'] . '"></feGaussianBlur>';
                    $section_divider_top .= '<feFlood flood-color="' . $section_options['section_filter_dropShadow_color_top'] . '" result="color" ></feFlood>';
                    $section_divider_top .= '<feComposite in="color" in2="blur" operator="in" result="ShadowBlur"></feComposite>';
                    $section_divider_top .= '<feOffset in="ShadowBlur" result="dropShadow" dx="0" dy="' . $section_options['section_dropShadow_blur_y_offset_top'] . '"></feOffset>';
                    $section_divider_top .= '<feMerge>';
                    $section_divider_top .= '<feMergeNode in="dropShadow"></feMergeNode>';
                    $section_divider_top .= '<feMergeNode in="SourceGraphic"></feMergeNode>';
                    $section_divider_top .= '</feMerge>';
                    $section_divider_top .= '</filter>';
                }
                $section_divider_top .= '</defs>';
            }
            // END SVG Filter´s
            if ($section_options['section_divider_top_dropshadow'] === "1") {
                $section_divider_top .= '<g filter="url(#dropshadowfiltertop-section-' . $key . ')">';
                $section_divider_top .= $svg_paths_top;
                $section_divider_top .= '</g>';
            } else {
                $section_divider_top .= $svg_paths_top;
            }

            $section_divider_top .= '</svg>';

            // Inline CSS Top Divider
            if (!empty($section_options['section_divider_top_height'])) {
                $section_css .= '.ui-separator.ui-separator-top-' . $key . '{height:' . $section_options['section_divider_top_height'] . 'px}';
            }
            $section_css .= '.ui-separator.ui-separator-top-' . $key . ' path{' . $shape_paths_color_t . ' stroke-linecap:round}';
        }

        if (!empty($section_options['section_divider_bottom'])) {
            $svg_paths_bottom = $divider_paths['svg_paths_bottom'];
            $section_classes  .= ' ui-separator-bottom-' . $key;

            if (!empty($section_options['section_divider_bottom_color'])) {
                $shape_paths_color_b = 'fill:' . $section_options['section_divider_bottom_color'] . ';';
            } elseif (($section_options['section_divider_bottom_gradient'] === "1") && (!empty($section_options['section_divider_bottom_color_1'])) && (!empty($section_options['section_divider_bottom_color_2']))) {
                $shape_paths_color_b = 'fill:url(#ui-gradient-bottom-' . $key . ');';
            } else {
                $shape_paths_color_b = '';
            }

            if ($section_options['section_divider_bottom_dropshadow'] === "1") {
                $section_divider_bottom .= '<svg class="ui-separator ui-separator-bottom-' . $key . $section_svg_divider_z_index . '" viewBox="0 0 200 30" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="overflow: visible">';
            } else {
                $section_divider_bottom .= '<svg class="ui-separator ui-separator-bottom-' . $key . $section_svg_divider_z_index . '" viewBox="0 0 200 30" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">';
            }
            // SVG Filter´s Gradient / DropShadow (Bottom)
            if (($section_options['section_divider_bottom_gradient'] === "1") || ($section_options['section_divider_bottom_dropshadow'] === "1")) {
                $section_divider_bottom .= '<defs>';
                // Gradient
                if (($section_options['section_divider_bottom_gradient'] === "1") && (!empty($section_options['section_divider_bottom_color_1'])) && (!empty($section_options['section_divider_bottom_color_2']))) {
                    $section_divider_bottom .= '<linearGradient id="ui-gradient-bottom-' . $key . '" x1="' . $section_options['gradient_x1_position_bottom'] . '%" y1="' . $section_options['gradient_y1_position_bottom'] . '%" x2="' . $section_options['gradient_x2_position_bottom'] . '%" y2="' . $section_options['gradient_y2_position_bottom'] . '%">';
                    $section_divider_bottom .= '<stop offset="' . $section_options['section_divider_bottom_color_1_position'] . '%" style="stop-color:' . $section_options['section_divider_bottom_color_1'] . ';stop-opacity:1" />';
                    $section_divider_bottom .= '<stop offset="' . $section_options['section_divider_bottom_color_2_position'] . '%" style="stop-color:' . $section_options['section_divider_bottom_color_2'] . ';stop-opacity:1" />';
                    $section_divider_bottom .= '</linearGradient>';
                }
                // DropShadow
                if ($section_options['section_divider_bottom_dropshadow'] === "1") {
                    $section_divider_bottom .= '<filter id="dropshadowfilter-bottom-section-' . $key . '" filterUnits="userSpaceOnUse" x="0" y="-20%" width="100%" height="120%" color-interpolation-filters="sRGB">';
                    $section_divider_bottom .= '<feGaussianBlur in="SourceAlpha" result="blur" stdDeviation="' . $section_options['section_dropShadow_blur_bottom'] . '"></feGaussianBlur>';
                    $section_divider_bottom .= '<feFlood flood-color="' . $section_options['section_filter_dropShadow_color_bottom'] . '" result="color" ></feFlood>';
                    $section_divider_bottom .= '<feComposite in="color" in2="blur" operator="in" result="ShadowBlur"></feComposite>';
                    $section_divider_bottom .= '<feOffset in="ShadowBlur" result="dropShadow" dx="0" dy="' . $section_options['section_dropShadow_blur_y_offset_bottom'] . '"></feOffset>';
                    $section_divider_bottom .= '<feMerge>';
                    $section_divider_bottom .= '<feMergeNode in="dropShadow"></feMergeNode>';
                    $section_divider_bottom .= '<feMergeNode in="SourceGraphic"></feMergeNode>';
                    $section_divider_bottom .= '</feMerge>';
                    $section_divider_bottom .= '</filter>';
                }
                $section_divider_bottom .= '</defs>';
            }
            // END SVG Filter´s
            if ($section_options['section_divider_bottom_dropshadow'] === "1") {
                $section_divider_bottom .= '<g filter="url(#dropshadowfilter-bottom-section-' . $key . ')">';
                $section_divider_bottom .= $svg_paths_bottom;
                $section_divider_bottom .= '</g>';
            } else {
                $section_divider_bottom .= $svg_paths_bottom;
            }

            $section_divider_bottom .= '</svg>';

            // Inline CSS Bottom Divider
            if (!empty($section_options['section_divider_bottom_height'])) {
                $section_css .= '.ui-separator.ui-separator-bottom-' . $key . '{height:' . $section_options['section_divider_bottom_height'] . 'px}';
            }
            $section_css .= '.ui-separator.ui-separator-bottom-' . $key . ' path{' . $shape_paths_color_b . 'stroke-linecap:round}';
        }
        // END Section Dividers

        // Section Background
        if ($custom_background === "1") {
            if (!empty($section_options['background_image']) || !empty($section_options['background_image_size'])) {
                // Background srcset
                if (!empty($section_options['background_image']) && $background_image_srcset === "1" && !empty($section_options['image_width_srcset'])) {
                    [$width, $height] = getimagesize(Uri::root() . $section_options['background_image']);
                    $ex        = '.' . pathinfo($section_options['background_image'], PATHINFO_EXTENSION);
                    $file_name = 'th_' . pathinfo($section_options['background_image'], PATHINFO_FILENAME);
                    // ratio
                    $ratio = round($width / $height * 100);

                    $type             = PageHelper::toArray($section);
                    $typeitem         = str_replace('_', '-', $type['type']) . 's';
                    $thumbnail_folder = 'media/com_uithemebuilderlite/ui-themebuilder-thumb/' . $typeitem;

                    PageHelper::createThumbnails($section_options['background_image'], $thumbnail_folder, $section_options);

                    $tmp_srcset    = explode(',', $section_options['image_width_srcset']);
                    $merge_srcsets = array_merge($srcsets, $tmp_srcset);
                    $srcsets       = array_map('trim', $merge_srcsets);
                    $srcsets       = array_unique($srcsets);

                    $min_val = min($srcsets);

                    $srcset .= ' data-sizes="';
                    $srcset .= '(min-width:  ' . $min_val . 'px) 90vw, ';
                    $srcset .= '(max-width: ' . $width . 'px) 100vw, ';
                    $srcset .= '(max-aspect-ratio: ' . $width . '/' . $height . ') ' . $ratio . 'vh" ';
                    $srcset .= 'data-srcset="';

                    foreach ($srcsets as $i => $val) {
                        if (is_numeric($val) && $val < 4000) {
                            unset($srcsets[$i]);
                            $srcset .= Uri::root() . $thumbnail_folder . '/' . $file_name . '_' . $val . $ex . ' ' . $val . 'w, ';
                        }
                    }

                    $srcset .= Uri::root() . $section_options['background_image'] . ' ' . $width . 'w" ';
                    $srcset .= 'data-src="' . Uri::root() . $section_options['background_image'] . '"';
                    $srcset .= ' uk-img=""';
                } elseif (!empty($section_options['background_image'])) {
                    $section_style['background-image'] = Uri::root() . $section_options['background_image'];
                } else {
                    $section_style['background-image'] = 'https://media.ui-themebuilder.com/com_uithemebuilderpro/unsplash/unsplash_custom.jpg?' . time();
                }

                if (!empty($section_options['background_image_responsive']) && !empty($section_options['background_image'])) {
                    $section_classes .= ' ' . $section_options['background_image_responsive'];
                }
                if ($section_options['background_image_repeat'] === "0") {
                    $section_classes .= ' uk-background-norepeat';
                }
                if (!empty($section_options['background_image_size'])) {
                    $section_classes .= ' ' . $section_options['background_image_size'];
                }

                // Section Parallax Background Settings
                if ($section_options['parallax_animation_background'] === "1") {
                    if (!empty($section_options['parallax_animation_media'])) {
                        $parallax_attr_media = ' media: ' . $section_options['parallax_animation_media'] . ';';
                    } else {
                        $parallax_attr_media = '';
                    }

                    if ($section_options['parallax_animation_background_viewport']) {
                        $parallax_animation_background_viewport = ' viewport: ' . $section_options['parallax_animation_background_viewport'] . ';';
                    } else {
                        $parallax_animation_background_viewport = '';
                    }

                    if (!empty($section_options['parallax_animation_background_x'])) {
                        $parallax_x = 'bgx: ' . $section_options['parallax_animation_background_x'] . ';';
                    } else {
                        $parallax_x = '';
                    }
                    if (!empty($section_options['parallax_animation_background_y'])) {
                        $parallax_y = 'bgy: ' . $section_options['parallax_animation_background_y'] . ';';
                    } else {
                        $parallax_y = '';
                    }

                    // Filters
                    if (!empty($section_options['parallax_animation_background_grayscale'])) {
                        $parallax_animation_background_grayscale = ' grayscale: ' . $section_options['parallax_animation_background_grayscale'] . ';';
                    } else {
                        $parallax_animation_background_grayscale = '';
                    }
                    if (!empty($section_options['parallax_animation_background_saturate'])) {
                        $parallax_animation_background_saturate = ' saturate: ' . $section_options['parallax_animation_background_saturate'] . ';';
                    } else {
                        $parallax_animation_background_saturate = '';
                    }
                    if (!empty($section_options['parallax_animation_background_color']) && !empty($section_options['background_color'])) {
                        $parallax_animation_background_color = ' background-color: ' . $section_options['background_color'] . ',' . $section_options['parallax_animation_background_color'] . ';';
                    } else {
                        $parallax_animation_background_color = '';
                    }

                    $section_parallax = ' uk-parallax="' . $parallax_x . $parallax_y . $parallax_attr_media . $parallax_animation_background_viewport . $parallax_animation_background_grayscale . $parallax_animation_background_saturate . $parallax_animation_background_color . '"';
                }
            }

            if (!empty($section_options['background_color'])) {
                $section_style['background-color'] = $section_options['background_color'];
            }
            if (!empty($section_options['background_color']) && !empty($section_options['background_image_blend_modes'])) {
                $section_classes .= ' ' . $section_options['background_image_blend_modes'];
            }

            if (!empty($section_options['background_image']) && !empty($section_options['background_image_attachment'])) {
                $section_classes .= ' ' . $section_options['background_image_attachment'];
            }
            if (!empty($section_options['background_image']) && !empty($section_options['background_image_position'])) {
                $section_classes .= ' ' . $section_options['background_image_position'];
            }

            // Gradient Background
        } elseif ($custom_background === "2") {
            $color1 = ($section_options['gradient_color_1'] ?? '');
            $color2 = ($section_options['gradient_color_2'] ?? '');
            $color3 = ($section_options['gradient_color_3'] ?? '');

            $color1_position = (isset($section_options['gradient_color_1_position']) ? $section_options['gradient_color_1_position'] . '%' : '');
            $color2_position = (isset($section_options['gradient_color_2_position']) ? $section_options['gradient_color_2_position'] . '%' : '');
            $color3_position = (isset($section_options['gradient_color_3_position']) ? $section_options['gradient_color_3_position'] . '%' : '');

            $radial_conical_x_position = (isset($section_options['radial_conical_x_position']) ? $section_options['radial_conical_x_position'] . '%' : '');
            $radial_conical_y_position = (isset($section_options['radial_conical_y_position']) ? $section_options['radial_conical_y_position'] . '%' : '');

            // linear gradient
            if ($section_options['gradient_effect'] === 'linear' && (!empty($color1) || !empty($color2) || !empty($color3))) {
                $section_style['background-color'] = $color1; // Fallback color
                // 3 active colors
                if (!empty($color1) && !empty($color2) && !empty($color3)) {
                    $section_style['background'] = 'linear-gradient(' . $section_options['gradient_angle'] . 'deg, ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                    // 2 active colors
                } elseif (!empty($color1) && !empty($color2)) {
                    $section_style['background'] = 'linear-gradient(' . $section_options['gradient_angle'] . 'deg,' . $color1 . $color1_position . ', ' . $color2 . $color2_position . ')';
                }
                $section_style['background-attachment'] = 'scroll';

                // radial gradient
            } elseif ($section_options['gradient_effect'] === 'radial' && ((!empty($color1) && !empty($color2)) || !empty($color3)) && ($radial_conical_x_position && $radial_conical_y_position)) {
                $section_style['background-color'] = $color1; // Fallback color
                // 3 active colors
                if (!empty($color1) && !empty($color2) && !empty($color3)) {
                    $section_style['background'] = 'radial-gradient(circle at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                    // 2 active colors
                } elseif (!empty($color1) && !empty($color2)) {
                    $section_style['background'] = 'radial-gradient(circle at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ')';
                }
                $section_style['background-attachment'] = 'scroll';

                // conical gradient
            } elseif ($section_options['gradient_effect'] === 'conical' && ((!empty($color1) && !empty($color2)) || !empty($color3)) && ($radial_conical_x_position && $radial_conical_y_position)) {
                $section_style['background-color'] = $color1; // Fallback color
                // 3 active colors
                if (!empty($color1) && !empty($color2) && !empty($color3)) {
                    $section_style['background'] = 'conic-gradient(from ' . $section_options['gradient_angle'] . 'deg at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                    // 2 active colors
                } elseif (!empty($color1) && !empty($color2)) {
                    $section_style['background'] = 'conic-gradient(from ' . $section_options['gradient_angle'] . 'deg at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ')';
                }
            }

            // SVG Background
        } elseif ($custom_background === "3") {
            if (!empty($section_options['section_svg_list'])) {
                $svg_path                   = Uri::root() . $section_options['section_svg_list'];
                $color_placeholder_1        = $section_options['section_svg_background_color_fallback'];
                $color_placeholder_2        = $section_options['section_svg_background_color_2'];
                $color_placeholder_3        = $section_options['section_svg_background_color_3'];
                $text_placeholder           = $section_options['section_svg_background_text'];
                $text_font_size_placeholder = $section_options['section_svg_background_text_font_size'] . 'px';
                $opacity_placeholder        = $section_options['section_svg_background_image_opacity'];

                $section_classes .= ' ui-section-svg-bg-' . $key;
                $section_classes .= ' ' . $section_svg_background_image_responsive;

                // CSS output
                $section_css .= '.ui-section-svg-bg-' . $key . '{';
                if (!empty($section_options['section_svg_background_color_fallback'])) {
                    $section_css .= 'background: ' . $section_options['section_svg_background_color_fallback'] . ';';
                    $section_css .= 'background-color: ' . $section_options['section_svg_background_color_fallback'] . ';';
                }
                if (!empty($section_options['section_svg_background_attachment'])) {
                    $section_css .= 'background-attachment: ' . $section_options['section_svg_background_attachment'] . ';';
                }
                if (!empty($section_options['section_svg_background_image_size'])) {
                    $section_css .= 'background-size: ' . $section_options['section_svg_background_image_size'] . ';';
                }
                if (!empty($section_options['section_svg_background_image_repeat'])) {
                    $section_css .= 'background-repeat: ' . $section_options['section_svg_background_image_repeat'] . ';';
                }
                if (!empty($section_options['section_svg_background_position_x']) && !empty($section_options['section_svg_background_position_y'])) {
                    $section_css .= 'background-position: ' . $section_options['section_svg_background_position_x'] . ' ' . $section_options['section_svg_background_position_y'] . ';';
                }
                    $section_css .= 'background-image: url("data:image/svg+xml,' . PageHelper::convertSVGtoURI($svg_path, $key, $color_placeholder_1, $color_placeholder_2, $color_placeholder_3, $text_placeholder, $text_font_size_placeholder, $opacity_placeholder) . '");';
                $section_css .= '}';
            }

            // Shape Section Background
        } elseif ($custom_background === "4") {
            if (!empty($section_options['background_color']) && empty($section_options['shape_background'])) {
                $section_style['background-color'] = $section_options['background_color'];
            }

            // default section background
            if (!empty($section_options['shape_background'])) {
                $section_classes .= ' ' . $section_options['shape_background'];
            }

            // square / circle shape
            if (($section_options['shape'] === 'square' || $section_options['shape'] === 'circle') && ((!empty($section_options['shape_width']) && !empty($section_options['shape_height'])) || (!empty($section_options['shape_width_pixel']) && !empty($section_options['shape_height_pixel'])))) {
                // CSS Class
                if ($section_options['shape'] === 'square') {
                    $section_shape_class = 'ui-shape-square-' . $key;
                } elseif ($section_options['shape'] === 'circle') {
                    $section_shape_class = 'ui-shape-circle-' . $key;
                }
                // CSS
                $section_css .= '.' . $section_shape_class . '{';
                // width & height pixel or %
                if (!empty($section_options['shape_width']) && !empty($section_options['shape_height'])) {
                    $section_css .= 'width: ' . $section_options['shape_width'] . '%;';
                    $section_css .= 'height: ' . $section_options['shape_height'] . '%;';
                } elseif (!empty($section_options['shape_width_pixel']) && !empty($section_options['shape_height_pixel'])) {
                    $section_css .= 'width: ' . $section_options['shape_width_pixel'] . 'px;';
                    $section_css .= 'height: ' . $section_options['shape_height_pixel'] . 'px;';
                }
                // background-color
                if (!empty($section_options['shape_color'])) {
                    $section_css .= 'background-color: ' . $section_options['shape_color'] . ';';
                } else {
                    $section_css .= 'background-color: transparent;';
                }
                // background-image
                if (!empty($section_options['shape_background_image'])) {
                    $section_css .= 'background-image: url("' . Uri::root() . $section_options['shape_background_image'] . '");';
                    // image repeat
                    if ($shape_background_image_repeat === "0") {
                        $section_css .= 'background-repeat: no-repeat;';
                    }
                    // image size
                    if (!empty($section_options['shape_background_image_size'])) {
                        $section_css .= 'background-size: ' . $section_options['shape_background_image_size'] . ';';
                    }
                    // image blend modes
                    if (!empty($section_options['shape_background_image_blend_modes']) && !empty($section_options['shape_color'])) {
                        $section_css .= 'background-blend-mode: ' . $section_options['shape_background_image_blend_modes'] . ';';
                    }
                    // image attachment
                    if ($shape_background_image_attachment === "fixed") {
                        $section_css .= 'background-attachment: fixed;';
                    }
                }
                // position
                $section_css .= 'top: 0;';
                if ($shape_position === 'right') {
                    $section_css .= 'right: 0;';
                } else {
                    $section_css .= 'left: 0;';
                }
                // margin
                if (!$shape_margin_top || !$shape_margin_right || !$shape_margin_bottom || !$shape_margin_left) {
                    $section_css .= 'margin: ' . $shape_margin_top . ' ' . $shape_margin_right . ' ' . $shape_margin_bottom . ' ' . $shape_margin_left . ';';
                }
                // border
                if ($shape_border && !empty($section_options['shape_border_style']) && !empty($section_options['shape_border_color'])) {
                    $section_css .= 'border: ' . $shape_border . ' ' . $section_options['shape_border_style'] . ' ' . $section_options['shape_border_color'] . ';';
                }
                if ($section_options['shape'] === 'circle') {
                    $section_css .= 'border-radius: 50%;';
                }
                // transform rotate
                if ($shape_transform === 'rotate' && !empty($section_options['shape_transform_rotate'])) {
                    $section_css .= 'transform: rotate(' . $section_options['shape_transform_rotate'] . 'deg);';
                    // transform rotate3d
                } elseif ($shape_transform === 'rotate3d' && !empty($section_options['shape_transform_rotate']) && !empty($section_options['shape_transform3d_1']) && !empty($section_options['shape_transform3d_2']) && !empty($section_options['shape_transform3d_3'])) {
                    $section_css .= 'transform: rotate3d(' . $section_options['shape_transform3d_1'] . ', ' . $section_options['shape_transform3d_2'] . ', ' . $section_options['shape_transform3d_3'] . ', ' . $section_options['shape_transform_rotate'] . 'deg);';
                } else {
                    $section_css .= 'transform: unset;';
                }
                // z-index
                if ($shape_position_zindex === "1") {
                    $section_css .= 'z-index: 1;';
                } else {
                    $section_css .= 'z-index: 0;';
                }
                $section_css .= '}';

                // triangle shape
            } elseif ($section_options['shape'] === 'triangle' && !empty($section_options['shape_color'])) {
                // CSS Class
                $section_shape_class = 'ui-shape-triangle-' . $key;

                // CSS
                $section_css .= '.' . $section_shape_class . '{';
                // width & height
                $section_css .= 'width: 0;';
                $section_css .= 'height: 0;';

                // background-color
                $section_css .= 'background-color: transparent;';
                // position
                $section_css .= 'top: 0;';
                if ($shape_position === 'right') {
                    $section_css .= 'right: 0;';
                } else {
                    $section_css .= 'left: 0;';
                }
                // margin
                if (!$shape_margin_top || !$shape_margin_right || !$shape_margin_bottom || !$shape_margin_left) {
                    $section_css .= 'margin: ' . $shape_margin_top . ' ' . $shape_margin_right . ' ' . $shape_margin_bottom . ' ' . $shape_margin_left . ';';
                }
                // border (build triangle)
                if (!empty($section_options['shape_height_pixel'])) {
                    $section_css .= 'border-left: ' . $section_options['shape_height_pixel'] / 2 . 'px solid transparent;';
                    $section_css .= 'border-right: ' . $section_options['shape_height_pixel'] / 2 . 'px solid transparent;';
                    $section_css .= 'border-bottom: ' . $section_options['shape_height_pixel'] . 'px solid ' . $section_options['shape_color'] . ';';
                }
                // transform rotate
                if ($shape_transform === 'rotate' && !empty($section_options['shape_transform_rotate'])) {
                    $section_css .= 'transform: rotate(' . $section_options['shape_transform_rotate'] . 'deg);';
                    // transform rotate3d
                } elseif ($shape_transform === 'rotate3d' && !empty($section_options['shape_transform_rotate']) && !empty($section_options['shape_transform3d_1']) && !empty($section_options['shape_transform3d_2']) && !empty($section_options['shape_transform3d_3'])) {
                    $section_css .= 'transform: rotate3d(' . $section_options['shape_transform3d_1'] . ', ' . $section_options['shape_transform3d_2'] . ', ' . $section_options['shape_transform3d_3'] . ', ' . $section_options['shape_transform_rotate'] . 'deg);';
                } else {
                    $section_css .= 'transform: unset;';
                }
                // z-index
                if ($shape_position_zindex === "1") {
                    $section_css .= 'z-index: 1;';
                } else {
                    $section_css .= 'z-index: 0;';
                }
                $section_css .= '}';
            }
            // Video Background
        } elseif ($custom_background === "5") {
            $section_video_classes   = ' ui-video-section-' . $key;
            $section_video_css_class = trim($section_video_classes);

            $video_source     = '';
            $video_extensions = array ('asf', 'avi', 'flv', 'm4v', 'mp4', 'ogg', 'ogv', 'webm');

            $video_auto_play        = ($section_options['video_auto_play'] ?? 1);
            $video_show_controls    = ($section_options['video_show_controls'] ?? 1);
            $video_show_suggestions = ($section_options['video_show_suggestions'] ?? 1);
            $video_loop             = ($section_options['video_loop'] ?? 1);
            $video_show_info        = ($section_options['video_show_info'] ?? 1);
            $video_muted            = ($section_options['video_muted'] ?? 1);

            // CSS output
            $section_css .= '.' . $section_video_css_class . ' {';

            $section_css .= 'top: 0;';
            $section_css .= 'left: 0;';
            $section_css .= 'z-index: 0;';

            $section_css .= '}';

            $video_url_tmp = ($section_options['video_url'] ?? 'https://www.youtube-nocookie.com/embed/YE7VzlLtp-4');
            $video_url     = parse_url($video_url_tmp);

            // Video autoplay params
            if ($video_auto_play === "1") {
                $video_params_autoplay = 'autoplay=1&amp;';
                $ui_video              = '';
            } else {
                $video_params_autoplay = '';
                $ui_video              = 'autoplay: inview';
            }
            // Video controls
            if ($video_show_controls === "1") {
                $video_params_controls = 'controls=1';
            } else {
                $video_params_controls = 'controls=0';
            }
            // Video suggestions
            if ($video_show_suggestions === "1") {
                $video_params_rel = 'rel=1';
            } else {
                $video_params_rel = 'rel=0';
            }
            // Video loop
            if ($video_loop === "1") {
                $video_params_loop = 'loop=1';
            } else {
                $video_params_loop = 'loop=0';
            }
            // Video info
            if ($video_show_info === "1") {
                $video_params_show_info = 'showinfo=1';
            } else {
                $video_params_show_info = 'showinfo=0';
            }
            // Video muted
            if ($video_muted === "1") {
                $muted           = 'automute: true';
                $video_muted_url = '&amp;mute=1';
            } else {
                $video_muted_url = '&amp;mute=0';
                $muted           = '&amp;mute=0';
            }
            // Video start at
            if (!empty($section_options['video_start'])) {
                $video_start = '&amp;start=' . $section_options['video_start'];
            } else {
                $video_start = '';
            }
            // Video iframe source
            if (!empty($section_options['video_url'])) {
                switch ($video_url['host']) {
                    case 'www.youtube-nocookie.com':
                    case 'youtube.com':
                    case 'www.youtube.com':
                        $video_class = ' ui-youtube-video';
                        $video_src   = $section_options['video_url'] . '?' . $video_params_autoplay . $video_params_controls . '&amp;' . $video_params_loop . '&amp;' . $video_params_show_info . '&amp;' . $video_params_rel . '&amp;iv_load_policy=3&amp;showsearch=0&amp;modestbranding=1' . $video_muted_url . '&amp;origin=' . Uri::root() . '&amp;playsinline=1' . $video_start;

                        $video_source = '<div class="uk-visible@m uk-cover-container uk-position-absolute uk-width-1-1 uk-height-1-1 ' . $section_video_classes . $video_class . '" itemprop="video" itemscope="" itemtype="http://schema.org/VideoObject" uk-scrollspy="cls: uk-animation-fade; target: > *; delay: 250;">';
                        if (!empty($section_options['thumbnail_image'])) {
                            $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $section_options['thumbnail_image'] . '" />';
                        }
                        $video_source .= '<meta itemprop="embedURL" content="' . $section_options['video_url'] . '" />';
                        $video_source .= '<iframe src="' . $video_src . '" frameborder="0" allow="accelerometer; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="" uk-responsive="" uk-cover="" uk-video="' . $ui_video . $muted . '"></iframe>';
                        $video_source .= '</div>';

                        break;

                    case 'vimeo.com':
                    case 'www.vimeo.com':
                        $doc = Factory::getApplication()->getDocument();
                        // $doc->addScript('https://player.vimeo.com/api/player.js');
                        if ($video_auto_play === "0") {
                            $vimeoID = '';
                            // $doc->addScript(Uri::base(true) . '/media/com_uithemebuilderlite/js/uivimeoplayer.js');

                            if (preg_match("/(https?:\/\/)?(www\.)?(player\.)?vimeo\.com\/?(showcase\/)*([0-9)([a-z]*\/)*([0-9]{6,11})[?]?.*/", $section_options['video_url'], $output_array)) {
                                $vimeoID = $output_array[6];
                            }

                            $js =
                                '
									$(document).ready(function(){ 

										uiVimeoPlayer' . $key . ' = uiVimeoPlayerLoadVideo("vimeoSection' . $key . '",' . $vimeoID . ');
										uiVimeoPlayer' . $key . '.pause();
										$(window).scroll(function(){ uiVimeoPlayerPlayPause("vimeoSection' . $key . '" , uiVimeoPlayer' . $key . '); });

											$("#btnPause").bind("click", function() {
												uiVimeoPlayer' . $key . '.pause();
											});
											$("#btnPlay").bind("click", function() {
												uiVimeoPlayer' . $key . '.play();
											});
									});
								';

                            $doc->addScriptDeclaration(trim(preg_replace('/^\s+|\n|\r|\s+$/m', '', $js)));
                        }

                        $video_class = ' ui-vimeo-video';
                        $video_src   = 'https://player.vimeo.com/video/' . basename($video_url['path']) . '?' . $video_params_autoplay . $video_params_loop . '&amp;title=0&amp;byline=0&amp;portrait=0';

                        $video_source = '<div id="vimeoSection' . $key . '" class="uk-visible@m uk-cover-container uk-position-absolute uk-width-1-1 uk-height-1-1 ' . $section_video_classes . $video_class . '" itemprop="video" itemscope="" itemtype="http://schema.org/VideoObject" uk-scrollspy="cls: uk-animation-fade; target: > *; delay: 250;">';
                        if (!empty($section_options['thumbnail_image'])) {
                            $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $section_options['thumbnail_image'] . '" />';
                        }
                        $video_source .= '<meta itemprop="embedURL" content="' . $section_options['video_url'] . '" />';
                        $video_source .= '<iframe src="' . $video_src . '" frameborder="0" allow="accelerometer; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="" uk-responsive="" uk-cover="" uk-video="' . $muted . '"></iframe>';
                        $video_source .= '</div>';

                        break;

                    default:
                        if (in_array(File::getExt($section_options['video_url']), $video_extensions)) {
                            $video_class = ' default-video-player';
                            // Video autoplay params
                            if ($video_auto_play === "1") {
                                $video_params_autoplay = ' autoplay ';
                                $ui_video              = '';
                            } else {
                                $video_params_autoplay = ' ';
                                $ui_video              = 'autoplay: inview';
                            }
                            // Video controls
                            if ($video_show_controls === "1") {
                                $video_params_controls = 'controls ';
                            } else {
                                $video_params_controls = '';
                            }
                            // Video loop
                            if ($video_loop === "1") {
                                $video_params_loop = 'loop ';
                            } else {
                                $video_params_loop = '';
                            }
                            // Video muted
                            if ($video_muted === "1") {
                                $muted = 'muted';
                            } else {
                                $muted = '';
                            }

                            $video_src = $section_options['video_url'];

                            $video_source = '<div class="uk-visible@m uk-cover-container uk-position-absolute uk-width-1-1 uk-height-1-1 ' . $section_video_classes . $video_class . '" itemprop="video" itemscope="" itemtype="http://schema.org/VideoObject" uk-scrollspy="cls: uk-animation-fade; target: > *; delay: 250;">';
                            if (!empty($section_options['thumbnail_image'])) {
                                $video_source .= '<meta itemprop="thumbnailURL" content="' . Uri::root() . $section_options['thumbnail_image'] . '" />';
                            }
                            $video_source .= '<meta itemprop="embedURL" content="' . $section_options['video_url'] . '" />';
                            $video_source .= '<video ' . $video_params_controls . $video_params_loop . $muted . ' playsinline' . $video_params_autoplay . 'uk-cover uk-video="' . $ui_video . '">';
                            $video_source .= '<source src="' . $video_src . '" type="video/' . File::getExt($section_options['video_url']) . '">';
                            $video_source .= '</video>';
                            $video_source .= '</div>';
                        }
                        break;
                }
            }

            // Default Section Background
        } elseif (!empty($section_options['background'])) {
            $section_classes .= ' ' . $section_options['background'];
        }

        // Section Mask Settings
        $use_svg_custom_mask_size       = ($section_options['use_svg_custom_mask_size'] ?? 0);
        $svg_mask_fill_color            = ($section_options['svg_mask__color'] ?? '#FFFFFF');
        $svg_mask_mirrored_horizontally = ($section_options['svg_mask_mirrored_horizontally'] ?? 0);

        if (!empty($section_options['svg_mask_list']) && ($custom_background === "1" || $custom_background === "2" || $custom_background === "3" || $custom_background === "5")) {
            $section_mask_classes   = ' ui-mask-section-' . $key;
            $section_mask_css_class = trim($section_mask_classes);
            $svg_mask_path          = Uri::root() . 'media/com_uithemebuilderlite/images/svg-masks/' . $section_options['svg_mask_list'];

            if (empty($section_options['background_color']) && (!empty($section_options['svg_mask__color']) && isset($section_options['svg_mask__color']))) {
                $section_style['background-color'] = $section_options['svg_mask__color'];
            }
            // CSS output
            $section_css .= '.' . $section_mask_css_class . ' {';
            $section_css .= 'top: 0;';
            $section_css .= 'left: 0;';
            $section_css .= 'background-image: url("data:image/svg+xml,' . PageHelper::convertSVGtoURI($svg_mask_path, $key, $svg_mask_fill_color, false, false, false, false, false) . '");';
            $section_css .= 'background-repeat: ' . (isset($section_options['svg_mask_repeat']) ? $section_options['svg_mask_repeat'] . ';' : 'inherit;');
            if ($use_svg_custom_mask_size === "0") {
                $section_css .= 'background-size: ' . (isset($section_options['svg_mask_size']) ? $section_options['svg_mask_size'] . ';' : 'auto;');
            } else {
                $section_css .= 'background-size: ' . (isset($section_options['svg_custom_mask_size']) ? $section_options['svg_custom_mask_size'] . ';' : '100%;');
            }
            if ($svg_mask_mirrored_horizontally === "1") {
                $section_css .= '-webkit-transform: scaleX(-1);';
                $section_css .= 'transform: scaleX(-1);';
            }

            $section_css .= 'background-position: ' . (isset($section_options['svg_mask_position']) ? $section_options['svg_mask_position'] . ';' : 'center;');

            $section_css .= '}';
        }

        // build section styles
        if (!empty($section_style)) {
            $buildStyle = PageHelper::buildStyle($section_style);
        }

        // Section Container Position relative
        if ((!empty($section_options['section_divider_bottom']) || !empty($section_options['section_divider_top'])) || ($custom_background === "4" && $section_options['shape'] !== '') || $section_key_show === "1" || !empty($section_options['svg_mask_list'])) {
            $container_classes .= ' uk-position-relative';
            $position_relative = ' uk-position-relative';
        }

        // Add Inline CSS SVGs Dividers / SVG Background / Shapes / Masks
        if (!empty($section_options['section_divider_bottom']) || !empty($section_options['section_divider_top']) || !empty($section_options['section_svg_list']) || !empty($section_options['shape']) || !empty($section_options['svg_mask_list']) || ($custom_background === "5" && !empty($section_options['video_url']))) {
            $inline_css = '<style>' . $section_css . '</style>';
        } else {
            $inline_css = '';
        }
        // END Section Backgrounds

        // Section Grid
        // $grid_match_attr = ($grid_match === "1") ? ' uk-height-match="' . $grid_match_row . '"' : '';

        if (!empty($section_options['grid_gutter'])) {
            $grid_gutter_class .= ' ' . $section_options['grid_gutter'];
        }
        if (!empty($section_options['grid_row_gap'])) {
            $grid_gutter_class .= ' ' . $section_options['grid_row_gap'];
        }
        if (!empty($section_options['grid_divider'])) {
            $grid_gutter_class .= ' ' . $section_options['grid_divider'];
        }
        // END Section Grid


        /*      if ($section_options['section_height_viewport'] == 1)
        {
            if (!empty($section_options['section_height_viewport_offset_top']))
            {
                $section_height_viewport_offset_top        = 'offset-top:' . $section_options['section_height_viewport_offset_top'] . ';';
            }
            else
            {
                $section_height_viewport_offset_top        = '';
            }
            if (!empty($section_options['section_height_viewport_offset_bottom']))
            {
                $section_height_viewport_offset_bottom     = ' offset-bottom:' . $section_options['section_height_viewport_offset_bottom'] . ';';
            }
            else
            {
                $section_height_viewport_offset_bottom     = '';
            }
            if (!empty($section_options['section_height_viewport_expand']))
            {
                $section_height_viewport_expand            = ' expand:' . $section_options['section_height_viewport_expand'] . ';';
            }
            else
            {
                $section_height_viewport_expand            = '';
            }
            if (!empty($section_options['section_height_viewport_min_height']))
            {
                $section_height_viewport_offset_min_height = ' min-height:' . $section_options['section_height_viewport_min_height'] . ';';
            }
            else
            {
                $section_height_viewport_offset_min_height = '';
            }
            $section_height_viewport                   = ' uk-height-viewport="' . $section_height_viewport_offset_top . $section_height_viewport_offset_bottom . $section_height_viewport_expand . $section_height_viewport_offset_min_height . '"';
        }
 */
        if ($section_options['section_height_viewport'] === "1") {
            $section_classes .= ' ui-height-viewport';
        }

        if (!empty($section_options['color_style'])) {
            $section_classes .= ' ' . $section_options['color_style'];
        }

        // Scrollspy Animation
        if ($section_options['scrollspy_animation'] === "1") {
            $cls = '';
            if (!empty($section_options['scrollspy_animation_type'])) {
                $cls = 'cls: ' . $section_options['scrollspy_animation_type'] . ';';
            }
            if ($section_options['scrollspy_animation_repeat'] === "1") {
                $repeat = ' repeat: true';
            } else {
                $repeat = '';
            }
            if (!empty($section_options['scrollspy_animation_delay'])) {
                $delay = ' delay: ' . $section_options['scrollspy_animation_delay'] . ';';
            } else {
                $delay = ' delay: 500;';
            }
            $scrollspy_animation_attr = ' uk-scrollspy="' . $cls . $delay . $repeat . '"';
        } else {
            $scrollspy_animation_attr = '';
        }
        // END Scrollspy Animation

        // Parallax Animation
        // Title
        if ($section_options['parallax_animation_title'] === "1") {
            if (!empty($section_options['parallax_animation_media'])) {
                $parallax_attr_media = ' media: ' . $section_options['parallax_animation_media'] . ';';
            } else {
                $parallax_attr_media = '';
            }

            if (!empty($section_options['parallax_animation_title_opacity_values'])) {
                $parallax_attr_title_opacity = 'opacity: ' . $section_options['parallax_animation_title_opacity_values'] . ';';
            } else {
                $parallax_attr_title_opacity = '';
            }

            if (!empty($section_options['parallax_animation_title_y_values'])) {
                $parallax_attr_title_y = ' y: ' . $section_options['parallax_animation_title_y_values'] . ';';
            } else {
                $parallax_attr_title_y = '';
            }

            if (!empty($section_options['parallax_animation_title_x_values'])) {
                $parallax_attr_title_x = ' x: ' . $section_options['parallax_animation_title_x_values'] . ';';
            } else {
                $parallax_attr_title_x = '';
            }

            if (!empty($section_options['parallax_animation_title_scale_values'])) {
                $parallax_attr_title_scale = ' scale: ' . $section_options['parallax_animation_title_scale_values'] . ';';
            } else {
                $parallax_attr_title_scale = '';
            }

            if ($section_options['parallax_animation_title_viewport']) {
                $parallax_attr_title_viewport = ' viewport: ' . $section_options['parallax_animation_title_viewport'] . ';';
            } else {
                $parallax_attr_title_viewport = '';
            }

            $parallax_attr_title = ' uk-parallax="' . $parallax_attr_title_opacity . $parallax_attr_title_y . $parallax_attr_title_x . $parallax_attr_title_scale . $parallax_attr_media . $parallax_attr_title_viewport . '"';
        } else {
            $parallax_attr_title = '';
        }

        // SubTitle
        if ($section_options['parallax_animation_subtitle'] === "1") {
            if (!empty($section_options['parallax_animation_media'])) {
                $parallax_attr_subtitle_media = ' media: ' . $section_options['parallax_animation_media'] . ';';
            } else {
                $parallax_attr_subtitle_media = '';
            }

            if (!empty($section_options['parallax_animation_subtitle_opacity_values'])) {
                $parallax_attr_subtitle_opacity = 'opacity: ' . $section_options['parallax_animation_subtitle_opacity_values'] . ';';
            } else {
                $parallax_attr_subtitle_opacity = '';
            }

            if (!empty($section_options['parallax_animation_subtitle_y_values'])) {
                $parallax_attr_subtitle_y = ' y: ' . $section_options['parallax_animation_subtitle_y_values'] . ';';
            } else {
                $parallax_attr_subtitle_y = '';
            }

            if (!empty($section_options['parallax_animation_subtitle_x_values'])) {
                $parallax_attr_subtitle_x = ' x: ' . $section_options['parallax_animation_subtitle_x_values'] . ';';
            } else {
                $parallax_attr_subtitle_x = '';
            }

            if (!empty($section_options['parallax_animation_subtitle_scale_values'])) {
                $parallax_attr_subtitle_scale = ' scale: ' . $section_options['parallax_animation_subtitle_scale_values'] . ';';
            } else {
                $parallax_attr_subtitle_scale = '';
            }

            if ($section_options['parallax_animation_subtitle_viewport']) {
                $parallax_attr_subtitle_viewport = ' viewport: ' . $section_options['parallax_animation_subtitle_viewport'] . ';';
            } else {
                $parallax_attr_subtitle_viewport = '';
            }

            $parallax_attr_subtitle = ' uk-parallax="' . $parallax_attr_subtitle_opacity . $parallax_attr_subtitle_y . $parallax_attr_subtitle_x . $parallax_attr_subtitle_scale . $parallax_attr_subtitle_media . $parallax_attr_subtitle_viewport . '"';
        } else {
            $parallax_attr_subtitle = '';
        }
        // END Parallax Animation

        if (isset($section_options['title']) && !empty($section_options['title'])) {
            $section_title = PageHelper::escapeHtml($section_options['title']);
        } else {
            $section_title = Text::_('COM_UITHEMEBUILDERLITE_SECTION');
        } ?>

        <div id="section" class="section-container active-section">

            <div class="section-tools uk-position-absolute uk-position-top-left uk-width-1-1">
                <div uk-grid="" class="uk-grid-small uk-flex-middle">
                    <div class="uk-width-auto">
                        <div class="uk-panel">
                            <ul class="uk-iconnav">
                                <li class="uk-drag move-section" uk-tooltip="<?php echo $section_title; ?>">
                                    <i class="uk-text-emphasis uk-margin-small-top uk-margin-small-left uk-icon-button uk-drag"
                                       uk-icon="move"></i>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="uk-width-expand">
                        <div class="uk-flex uk-flex-right">
                            <div class="uk-panel uk-overlay uk-overlay-primary uk-padding-small">
                                <div uk-grid="" class="uk-grid-small uk-flex-middle">
                                    <?php $rn = PageHelper::randomNumber() . $key; ?>
                                    <div id="section-options-toggle-1<?php echo $rn; ?>"
                                         class="section-options-toggle uk-width-expand" hidden="">
                                        <div uk-grid="" class="uk-flex-middle">

                                            <div class="uk-width-expand">
                                                <ul class="uk-iconnav section-actions">

                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_SAVE_SECTION'); ?>">
                                                        <a class="btn-save-section" href="javascript:void(0)"><i
                                                                uk-icon="ui-save"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_ADD_ROW'); ?>">
                                                        <a class="btn-add-section" href="javascript:void(0)"><i
                                                                uk-icon="ui-section"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DUPLICATE_ROW'); ?>">
                                                        <a class="btn-duplicate-section" href="javascript:void(0)"><i
                                                                uk-icon="copy"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_CONFIGURE_ROW'); ?>">
                                                        <a class="btn-config-section" href="javascript:void(0)"><i
                                                                uk-icon="cog"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DELETE_ROW'); ?>">
                                                        <a class="btn-delete-section" href="javascript:void(0)"><i
                                                                uk-icon="trash"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_ADD_MANAGE_COLUMNS'); ?>">
                                                        <a class="btn-manage-columns btn-manage-columns<?php echo $rn; ?> uk-text-muted"
                                                           href="javascript:void(0)"><i uk-icon="ui-columns"></i></a>
                                                        <div id="manage-columns-dropdown<?php echo $rn; ?>"
                                                             class="manage-columns-dropdown manage-columns-dropdown<?php echo $rn; ?> uk-background-secondary uk-light"
                                                             uk-dropdown="mode: click; pos: top-right; toggle: .btn-manage-columns<?php echo $rn; ?>">
                                                            <div class="uk-width-xlarge">
                                                                <div class="uk-margin-small uk-height-max-medium"
                                                                     uk-overflow-auto>
                                                                    <ul class="uk-grid-medium uk-child-width-1-1@s uk-child-width-1-4@m uk-flex-center uk-margin grids"
                                                                        uk-grid="">
                                                                        <li>
                                                                            <div
                                                                                class="grid-default<?php echo(($section['grid'] === '1-1') ? ' active uk-background-primary uk-light' : ''); ?>"
                                                                                data-grid="1-1"
                                                                                uk-tooltip="1-1 (whole)">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#whole"
                                                                                    uk-svg>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div
                                                                                class="grid-default<?php echo(($section['grid'] === '1-2,1-2') ? ' active uk-background-primary uk-light' : ''); ?>"
                                                                                data-grid="1-2;1-2"
                                                                                uk-tooltip="1-2;1-2 (halves)">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#halves"
                                                                                    uk-svg>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div
                                                                                class="grid-default<?php echo(($section['grid'] === '1-3,1-3,1-3') ? ' active uk-background-primary uk-light' : ''); ?>"
                                                                                data-grid="1-3;1-3;1-3"
                                                                                uk-tooltip="1-3;1-3;1-3 (thirds)">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#thirds"
                                                                                    uk-svg>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div
                                                                                class="grid-default<?php echo(($section['grid'] === '1-4,1-4,1-4,1-4') ? ' active uk-background-primary uk-light' : ''); ?>"
                                                                                data-grid="1-4;1-4;1-4;1-4"
                                                                                uk-tooltip="1-4;1-4;1-4;1-4 (quarters)">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#quarters"
                                                                                    uk-svg>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div
                                                                                class="grid-default<?php echo(($section['grid'] === 'auto,expand,whole') ? ' active uk-background-primary uk-light' : ''); ?>"
                                                                                data-grid="auto;expand;1-1"
                                                                                uk-tooltip="auto;expand;1-1">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#auto-expand-whole"
                                                                                    uk-svg>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div
                                                                                class="grid-default<?php echo(($section['grid'] === 'expand,1-2,expand') ? ' active uk-background-primary uk-light' : ''); ?>"
                                                                                data-grid="expand;1-2;expand"
                                                                                uk-tooltip="expand;1-2;expand">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#expand-1-2-expand"
                                                                                    uk-svg>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div
                                                                                class="grid-default<?php echo(($section['grid'] === 'expand,2-3') ? ' active uk-background-primary uk-light' : ''); ?>"
                                                                                data-grid="expand;2-3"
                                                                                uk-tooltip="expand;2-3">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#expand-2-3"
                                                                                    uk-svg>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <div
                                                                                class="grid-default<?php echo(($section['grid'] === 'expand,large,expand') ? ' active uk-background-primary uk-light' : ''); ?>"
                                                                                data-grid="expand;large;expand"
                                                                                uk-tooltip="expand;large;expand">
                                                                                <img
                                                                                    src="../media/com_uithemebuilderlite/images/icons/layouts.min.svg#expand-large-expand"
                                                                                    uk-svg>
                                                                            </div>
                                                                        </li>
                                                                        <li class="uk-hidden">
                                                                            <div
                                                                                class="grid-default custom-grid<?php echo(($section['grid'] === '1-1' || $section['grid'] === '1-2,1-2' || $section['grid'] === '1-3,1-3,1-3' || $section['grid'] === '1-4,1-4,1-4,1-4' || $section['grid'] === 'auto,expand,whole' || $section['grid'] === 'expand,1-2,expand' || $section['grid'] === 'expand,2-3' || $section['grid'] === 'expand,large,expand') ? '' : ' active'); ?>"
                                                                                data-grid="<?php $section_grid = str_replace(',', ';', $section['grid']);
                                                                                echo $section_grid; ?>">
                                                                            </div>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                                <div class="uk-padding-small">
                                                                    <div class="uk-flex uk-flex-center">
                                                                        <div class="uk-flex uk-flex-middle">
                                                                            <span
                                                                                class="uk-text-small uk-margin-small-right uk-text-muted"><?php echo Text::_('COM_UITHEMEBUILDERLITE_CUSTOM_GRID'); ?></span>
                                                                            <div class="uk-width-expand">
                                                                                <div class="uk-inline">
                                                                                    <a class="uk-form-icon uk-form-icon-flip btn-generate-layout"
                                                                                       href="javascript:void(0)"
                                                                                       uk-icon="ui-columns"></a>
                                                                                    <input type="text" class="uk-input"
                                                                                           name="custom_layout"
                                                                                           placeholder="expand;2-3"
                                                                                           value="">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_TOGGLE_SECTION'); ?>">
                                                        <a class="btn-toggle-section"
                                                           href="#ui-section-1<?php echo $key; ?>"
                                                           uk-toggle="animation: uk-animation-slide-left, uk-animation-fade;"><i
                                                                uk-icon="chevron-down"></i></a></li>
                                                    <li uk-tooltip="<?php echo Text::_('COM_UITHEMEBUILDERLITE_DISABLE_SECTION'); ?>">
                                                        <a class="btn-disable-section"
                                                           href="javascript:void(0)"<?php echo(($section['admin_visibility'] === '0') ? ' uk-icon="lock"' : ' uk-icon="unlock"'); ?>></a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-auto">
                                        <ul class="uk-iconnav">
                                            <li title="" tabindex="0" uk-tooltip="Toggle Section Options">
                                                <a class="btn-toggle-section-options" href="javascript:void(0)"
                                                   uk-toggle="target: #section-options-toggle-1<?php echo $rn; ?>">
                                                    <i uk-icon="more-vertical"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php
            // Section HTML output
            $html = '<' . $section_options['html_tag'] . ' id="ui-section-1' . $key . '" class="ui-section-preview uk-section uk-position-relative' . $section_classes . '"' . $section_parallax . $scrollspy_animation_attr . $section_height_viewport . $srcset . $buildStyle . '>';

            // SVG dividers
            $html .= $section_divider_top;
            $html .= $section_divider_bottom;

            // visible section number
            if ($section_key_show === "1" && isset($section_options['section_key_position'])) {
                $add_key = 1;
                // opacity style
                if (!empty($section_options['section_key_opacity'])) {
                    $section_key_style['opacity'] = $section_options['section_key_opacity'];
                }
                // font-size style
                if (!empty($section_options['section_key_font_size']) && isset($section_options['section_key_font_size'])) {
                    $section_key_style['font-size'] = $section_options['section_key_font_size'] . '%';
                }
                // build inline styles
                if (!empty($section_key_style)) {
                    $section_key_buildStyle = PageHelper::buildStyle($section_key_style);
                }

                $html .= '<div class="uk-visible@m">';
                if ($key <= 8) {
                    $html .= '<div class="uk-position-large uk-position-' . $section_options['section_key_position'] . ' uk-text-bold ui-section-key" ' . $section_key_buildStyle . '>' . $add_key . '</div>';
                } else {
                    $html .= '<div class="uk-position-large uk-position-' . $section_options['section_key_position'] . ' uk-text-bold ui-section-key" ' . $section_key_buildStyle . '>' . $add_key . '</div>';
                }
                $html .= '</div>';
            }

            // Section Video Background
            if ($custom_background === "5" && !empty($section_options['video_url'])) {
                $html .= $video_source;
            }

            // Section Mask
            if (isset($section_options['svg_mask_list']) && !empty($section_options['svg_mask_list'])) {
                $html .= '<div class="uk-visible@m uk-position-absolute uk-width-1-1 uk-height-1-1 ' . $section_mask_classes . '"></div>';
            }

            // Section Shapes
            if ($custom_background === "4" && !empty($section_options['shape'])) {
                $html .= '<div class="uk-visible@m uk-position-absolute ' . $section_shape_class . $shape_shadow . $shape_background_image_position . '"></div>';
            }

            if (($section_full_width === "0") && !empty($section_options['container_width'])) {
                $container_classes .= ' ' . $section_options['container_width'];
                $html              .= '<div class="uk-container' . $container_classes . '"' . $container_buildStyle . '>';
            }

            if (($section_options['section_load_components'] === "0") && ($section_options['heading_alignment'] === 'uk-text-center') && ($section_options['section_height_viewport'] === "1")) {
                if ((!empty($section_options['title']) || !empty($section_options['subtitle'])) && ($title_show === "1" && $section_options['use_svg_title'] === "0")) {
                    if (!empty($section_options['heading_alignment'])) {
                        $heading_alignment = ' ' . $section_options['heading_alignment'];
                    }
                    $html .= '<div class="' . trim($grid_gutter_class) . $position_relative . '" uk-grid="">';
                    $html .= '<div class="uk-width-1-1">';
                    $html .= '<div class="uk-position-center uk-flex uk-flex-center uk-flex-middle ' . $heading_alignment . '">';
                    $html .= '<div class="uk-margin-auto uk-margin-auto-vertical uk-width-auto">';
                    if (!empty($section_options['title'])) {
                        if (!empty($section_options['subtitle'])) {
                            $titleMargin = 'uk-margin-remove';
                        }
                        $html .= '<' . $section_options['title_heading'] . ' class="' . trim($titleMargin . $title_class) . '"' . $parallax_attr_title . '>';
                        $html .= '<span>' . $section_options['title'] . '</span>';
                        $html .= '</' . $section_options['title_heading'] . '>';
                    }
                    if (!empty($section_options['subtitle'])) {
                        if (!empty($section_options['title'])) {
                            $subtitleMargin = 'uk-margin-small-top';
                        }
                        $html .= '<' . $section_options['subtitle_heading'] . ' class="' . trim($subtitleMargin . $subtitle_class) . '"' . $parallax_attr_subtitle . '>';
                        $html .= '<span>' . $section_options['subtitle'] . '</span>';
                        $html .= '</' . $section_options['subtitle_heading'] . '>';
                    }
                    $html .= '</div>';
                    $html .= '</div>';
                    $html .= '</div>';
                    $html .= '</div>';
                } elseif ((!empty($section_options['title']) || !empty($section_options['subtitle'])) && ($title_show === "1" && $section_options['use_svg_title'] === "1")) {
                    // SVG Title/Subtitle Style -Viewport-height
                    // Title Stroke Settings
                    if ($section_options['svg_title_stroke'] === "1") {
                        if (!empty($section_options['svg_title_stroke_fill_color'])) {
                            $fill_stroke = ' fill-stroke="' . $section_options['svg_title_stroke_fill_color'] . '"';
                        } else {
                            $fill_stroke = '';
                        }
                        if (!empty($section_options['svg_title_stroke_color'])) {
                            $stroke = ' stroke="' . $section_options['svg_title_stroke_color'] . '"';
                        } else {
                            $stroke = '';
                        }
                        if (!empty($section_options['svg_title_stroke_width'])) {
                            $stroke_width = ' stroke-width="' . $section_options['svg_title_stroke_width'] . '"';
                        } else {
                            $stroke_width = '';
                        }

                        $title_stroke = $fill_stroke . $stroke . $stroke_width;
                    } else {
                        $title_stroke = '';
                    }

                    // Subtitle Stroke Settings
                    if ($section_options['svg_subtitle_stroke'] === "1") {
                        if (!empty($section_options['svg_subtitle_stroke_fill_color'])) {
                            $sub_fill_stroke = ' fill-stroke="' . $section_options['svg_subtitle_stroke_fill_color'] . '"';
                        } else {
                            $sub_fill_stroke = '';
                        }
                        if (!empty($section_options['svg_subtitle_stroke_color'])) {
                            $sub_stroke = ' stroke="' . $section_options['svg_subtitle_stroke_color'] . '"';
                        } else {
                            $sub_stroke = '';
                        }
                        if (!empty($section_options['svg_subtitle_stroke_width'])) {
                            $sub_stroke_width = ' stroke-width="' . $section_options['svg_subtitle_stroke_width'] . '"';
                        } else {
                            $sub_stroke_width = '';
                        }

                        $sub_title_stroke = $sub_fill_stroke . $sub_stroke . $sub_stroke_width;
                    } else {
                        $sub_title_stroke = '';
                    }
                    $html .= '<svg class="ui-svg-title uk-position-cover" width="100%" height="100%"' . $section_height_viewport . ' xmlns="http://www.w3.org/2000/svg">';
                    $html .= '<defs>';
                    $html .= '<mask id="text-mask-' . $key . '">';
                    $html .= '<rect width="100%" height="100%" fill="' . $section_options['mask_color'] . '" />';
                    $html .= '<g id="text-' . $key . '">';
                    if (!empty($section_options['title'])) {
                        $html .= '<text text-anchor="middle" x="' . $section_options['title_position_x'] . '%" y="' . $section_options['title_position_y'] . '%" id="svgTitle" class="' . trim($title_class) . '"' . $title_stroke . $parallax_attr_title . '>' . $section_options['title'] . '</text>';
                    }
                    if (!empty($section_options['subtitle'])) {
                        $html .= '<text text-anchor="middle" x="' . $section_options['subtitle_position_x'] . '%" y="' . $section_options['subtitle_position_y'] . '%" id="svgSubtitle" class="' . trim($subtitle_class) . '"' . $sub_title_stroke . $parallax_attr_subtitle . '>' . $section_options['subtitle'] . '</text>';
                    }
                    $html .= '</g>';
                    $html .= '</mask>';
                    $html .= '</defs>';
                    $html .= '<rect id="base" x="0" y="0" width="100%" height="100%" fill="' . $section_options['mask_color_output'] . '" mask="url(#text-mask-' . $key . ')" />';
                    $html .= '</svg>';
                }
            } elseif ((!empty($section_options['title']) || !empty($section_options['subtitle'])) && ($title_show === "1" && $section_options['use_svg_title'] === "0")) {
                if (!empty($section_options['heading_alignment'])) {
                    $heading_alignment = ' ' . $section_options['heading_alignment'];
                }
                $html .= '<div class="' . $grid_gutter_class . $position_relative . '" uk-grid="">';
                $html .= '<div class="uk-width-1-1">';
                $html .= '<div class="uk-padding-small' . $heading_alignment . '">';
                if (!empty($section_options['title'])) {
                    if (!empty($section_options['subtitle'])) {
                        $titleMargin = 'uk-margin-remove';
                    }
                    $html .= '<' . $section_options['title_heading'] . ' class="' . trim($titleMargin . $title_class) . '"' . $parallax_attr_title . '>';
                    $html .= '<span>' . $section_options['title'] . '</span>';
                    $html .= '</' . $section_options['title_heading'] . '>';
                }
                if (!empty($section_options['subtitle'])) {
                    if (!empty($section_options['title'])) {
                        $subtitleMargin = 'uk-margin-small-top';
                    }
                    $html .= '<' . $section_options['subtitle_heading'] . ' class="' . trim($subtitleMargin . $subtitle_class) . '"' . $parallax_attr_subtitle . '>';
                    $html .= '<span>' . $section_options['subtitle'] . '</span>';
                    $html .= '</' . $section_options['subtitle_heading'] . '>';
                }
                $html .= '</div>';
                $html .= '</div>';
                $html .= '</div>';
            } elseif ((!empty($section_options['title']) || !empty($section_options['subtitle'])) && ($title_show === "1" && $section_options['use_svg_title'] === "1")) {
                // SVG Title/Subtitle Style
                // Title Stroke Settings
                if ($section_options['svg_title_stroke'] === "1") {
                    if (!empty($section_options['svg_title_stroke_fill_color'])) {
                        $fill_stroke = ' fill-stroke="' . $section_options['svg_title_stroke_fill_color'] . '"';
                    } else {
                        $fill_stroke = '';
                    }
                    if (!empty($section_options['svg_title_stroke_color'])) {
                        $stroke = ' stroke="' . $section_options['svg_title_stroke_color'] . '"';
                    } else {
                        $stroke = '';
                    }
                    if (!empty($section_options['svg_title_stroke_width'])) {
                        $stroke_width = ' stroke-width="' . $section_options['svg_title_stroke_width'] . '"';
                    } else {
                        $stroke_width = '';
                    }

                    $title_stroke = $fill_stroke . $stroke . $stroke_width;
                } else {
                    $title_stroke = '';
                }

                // Subtitle Stroke Settings
                if ($section_options['svg_subtitle_stroke'] === "1") {
                    if (!empty($section_options['svg_subtitle_stroke_fill_color'])) {
                        $sub_fill_stroke = ' fill-stroke="' . $section_options['svg_subtitle_stroke_fill_color'] . '"';
                    } else {
                        $sub_fill_stroke = '';
                    }
                    if (!empty($section_options['svg_subtitle_stroke_color'])) {
                        $sub_stroke = ' stroke="' . $section_options['svg_subtitle_stroke_color'] . '"';
                    } else {
                        $sub_stroke = '';
                    }
                    if (!empty($section_options['svg_subtitle_stroke_width'])) {
                        $sub_stroke_width = ' stroke-width="' . $section_options['svg_subtitle_stroke_width'] . '"';
                    } else {
                        $sub_stroke_width = '';
                    }

                    $sub_title_stroke = $sub_fill_stroke . $sub_stroke . $sub_stroke_width;
                } else {
                    $sub_title_stroke = '';
                }

                $html .= '<svg class="ui-svg-title uk-height-' . $section_options['mask_height'] . '" width="100%" height="100%" xmlns="http://www.w3.org/2000/svg">';
                $html .= '<defs>';
                $html .= '<mask id="text-mask-' . $key . '">';
                $html .= '<rect width="100%" height="100%" fill="' . $section_options['mask_color'] . '" />';
                $html .= '<g id="text-' . $key . '">';
                if (!empty($section_options['title'])) {
                    $html .= '<text text-anchor="middle" x="' . $section_options['title_position_x'] . '%" y="' . $section_options['title_position_y'] . '%" id="svgTitle" class="' . trim($title_class) . '"' . $title_stroke . $parallax_attr_title . '>' . $section_options['title'] . '</text>';
                }
                if (!empty($section_options['subtitle'])) {
                    $html .= '<text text-anchor="middle" x="' . $section_options['subtitle_position_x'] . '%" y="' . $section_options['subtitle_position_y'] . '%" id="svgSubtitle" class="' . trim($subtitle_class) . '"' . $sub_title_stroke . $parallax_attr_subtitle . '>' . $section_options['subtitle'] . '</text>';
                }
                $html .= '</g>';
                $html .= '</mask>';
                $html .= '</defs>';
                $html .= '<rect id="base" x="0" y="0" width="100%" height="100%" fill="' . $section_options['mask_color_output'] . '" mask="url(#text-mask-' . $key . ')" />';
                $html .= '</svg>';
            }
            // END Title/Subtitle Settings

            // $html .= '<div class="ui-columns">';
            $html .= '<div class="ui-columns ' . trim($grid_gutter_class) . $position_relative . '" uk-grid=""' . $scrollspy_animation_attr . '>';
            $html .= '</div>';
            // $html .= '</div>';

            if ($section_full_width === "0") {
                $html .= '</div>';
            }

            $html .= '<div class="section-options-preview ui-preview-section-options uk-hidden"></div>';
            $html .= '<input class="json-section ui-preview-json-section" type="hidden" value="">';
            if ($inline_css) {
                $html .= $inline_css;
            }
            $html .= '</' . $section_options['html_tag'] . '>';
            // END section html

            echo $html;

            ?>
        </div>

        <?php
        Jexit();
    }

    /**
     * @return void
     *
     * @throws \Exception
     *
     * @since   v0.0.1
     */
    public function renderColumnConfig(): void
    {
        $app                   = Factory::getApplication();
        $html                  = '';
        $column                = $app->input->getArray();
        $form                  = Form::getInstance(PageHelper::createId('column', PageHelper::randomNumber()), JPATH_ROOT . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'column.xml');
        $column_general_fields = $form->getFieldset('general');
        $column_options_fields = $form->getFieldset('options');

        $basic_name      = ['class', 'id', 'grid', 'type'];
        $grid_name       = ['grid_child_width', 'grid_gutter', 'grid_row_gap', 'grid_divider', 'masonry_grid', 'grid_m', 'grid_l', 'grid_xl', 'masonry_grid_parallax'];
        $title_name      = ['title_show', 'title', 'title_heading', 'title_font_size', 'title_font_weight', 'title_text_transform', 'title_style', 'title_text_color', 'subtitle', 'subtitle_font_size', 'subtitle_font_weight', 'subtitle_text_transform', 'subtitle_heading', 'subtitle_title_style', 'heading_alignment'];
        $background_name = ['background_image_responsive', 'image_width_srcset', 'background_image_srcset', 'section_svg_list', 'section_svg_background_color_fallback', 'section_svg_background_color_2', 'section_svg_background_color_3', 'section_svg_background_text', 'section_svg_background_text_font_size', 'section_svg_background_attachment', 'section_svg_background_image_size', 'section_svg_background_image_repeat', 'section_svg_background_position_x', 'section_svg_background_position_y', 'section_svg_background_image_opacity', 'section_svg_background_image_responsive', 'custom_background', 'background', 'background_image', 'background_image_blend_modes', 'background_image_attachment', 'background_image_position', 'background_image_size', 'background_image_repeat', 'color_style', 'background_color', 'gradient_effect', 'gradient_angle', 'gradient_color_1', 'gradient_color_1_position', 'gradient_color_2', 'gradient_color_2_position', 'gradient_color_3', 'gradient_color_3_position', 'radial_conical_x_position', 'radial_conical_y_position', 'gradient_preview', 'shape_background', 'shape', 'shape_preview', 'shape_width', 'shape_height', 'shape_width_pixel', 'shape_height_pixel', 'shape_color', 'shape_position', 'shape_margin_top', 'shape_margin_right', 'shape_margin_bottom', 'shape_margin_left', 'shape_position_zindex', 'shape_border', 'shape_border_style', 'shape_border_color', 'shape_transform', 'shape_transform_rotate', 'shape_transform3d_1', 'shape_transform3d_2', 'shape_transform3d_3', 'shape_shadow', 'shape_background_image', 'shape_background_image', 'shape_background_image_repeat', 'shape_background_image_size', 'shape_background_image_blend_modes', 'shape_background_image_attachment', 'shape_background_image_position', 'background_spacer_1', 'background_spacer_2', 'background_spacer_3', 'background_spacer_4', 'background_spacer_5', 'background_spacer_6', 'background_spacer_7', 'video_url', 'thumbnail_image', 'video_auto_play', 'video_show_controls', 'video_show_info', 'video_show_suggestions', 'video_loop', 'video_muted', 'video_start'];
        $flex_name       = ['flex_column_items_vertical'];

        if (!empty($column_general_fields)) {
            foreach ($column_general_fields as $field) {
                $form->setFieldAttribute($field->name, 'default', $column[$field->name]);
                if (in_array($field->name, $basic_name)) {
                    $basic_fields[] = $field->name;
                }
            }
        }

        if (!empty($column_options_fields)) {
            foreach ($column_options_fields as $field) {
                if (!empty($column['options']) && isset($column['options'][$field->name])) {
                    $form->setFieldAttribute($field->name, 'default', $column['options'][$field->name]);
                }
                if (in_array($field->name, $basic_name)) {
                    $basic_fields[] = $field->name;
                }
                if (in_array($field->name, $title_name)) {
                    $title_fields[] = $field->name;
                }
                if (in_array($field->name, $grid_name)) {
                    $grid_fields[] = $field->name;
                }
                if (in_array($field->name, $background_name)) {
                    $background_fields[] = $field->name;
                }
                if (in_array($field->name, $flex_name)) {
                    $flex_fields[] = $field->name;
                }
            }
            $html .= '<div class="options-tabs">';
            $html .= '<div class="uk-background-primary uk-light uk-padding-small">';
            $html .= '<ul class="uk-flex-center uk-subnav uk-margin-remove" uk-switcher="connect: .column-options-tabs; animation: uk-animation-fade;">';
            if (!empty($basic_fields)) {
                $html .= '<li class="uk-active"><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_BASICS') . '</a></li>';
            }
            if (!empty($title_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_TITLE') . '</a></li>';
            }
            if (!empty($grid_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_GRID') . '</a></li>';
            }
            if (!empty($background_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_BACKGROUND') . '</a></li>';
            }
            if (!empty($flex_fields)) {
                $html .= '<li><a href="javascript:void(0)">' . Text::_('COM_UITHEMEBUILDERLITE_FLEX_SETTINGS') . '</a></li>';
            }
            $html .= '</ul>';
            $html .= '</div>';
            $html .= '<div class="uk-modal-body" uk-overflow-auto>';
            $html .= '<div class="uk-height-medium">';
            $html .= '<ul class="uk-switcher column-options-tabs uk-margin">';
            if (!empty($basic_fields)) {
                $html .= '<li class="uk-active">';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $basic_fields);
                $html .= '</li>';
            }
            if (!empty($title_fields)) {
                $html .= '<li>';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $title_fields);
                $html .= '</li>';
            }
            if (!empty($grid_fields)) {
                $html .= '<li>';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $grid_fields);
                $html .= '</li>';
            }
            if (!empty($background_fields)) {
                $html .= '<li class="background-tab-content">';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $background_fields);
                $html .= '</li>';
            }
            if (!empty($flex_fields)) {
                $html .= '<li>';
                $html .= PageHelper::renderFormFieldsHorizontal($form, $flex_fields);
                $html .= '</li>';
            }
            $html .= '</ul>';
            $html .= '</div>';
            $html .= '<div class="loader"><span class="uk-position-center" uk-spinner="ratio: 4.5"></span></div>';
            $html .= '</div>';
            $html .= '</div>';
        }
        $form->reset(true);
        echo $html;
        Jexit();
    }

    /**
     * @return void
     *
     * @throws \Exception
     *
     * @since   v1.1.0
     */
    public function columnPreview(): void
    {
        $app = Factory::getApplication();

        $column         = $app->input->getArray(array (), null);
        $column_options = PageHelper::escapeHtmlArray($column['options']);

        $title_show = ($column_options['title_show'] ?? 1);

        $column_grid_gutter_class = '';
        $column_heading_alignment = ' class="uk-padding-small uk-padding-remove-vertical"';

        $flex_column_items_vertical = (isset($column_options['flex_column_items_vertical']) && !empty($column_options['flex_column_items_vertical']) ? ' ' . $column_options['flex_column_items_vertical'] : '');

        $key                      = PageHelper::randomNumber();
        $column_css               = '';
        $column_class             = '';
        $custom_column_background = (isset($column_options['custom_background']) && $column_options['custom_background'] ? $column_options['custom_background'] : "0");

        $shape_position      = ($column_options['shape_position'] ?? 'left');
        $shape_margin_top    = ((isset($column_options['shape_margin_top']) && !empty($column_options['shape_margin_top'])) ? $column_options['shape_margin_top'] . 'px' : 0);
        $shape_margin_right  = ((isset($column_options['shape_margin_right']) && !empty($column_options['shape_margin_right'])) ? $column_options['shape_margin_right'] . 'px' : 0);
        $shape_margin_bottom = ((isset($column_options['shape_margin_bottom']) && !empty($column_options['shape_margin_bottom'])) ? $column_options['shape_margin_bottom'] . 'px' : 0);
        $shape_margin_left   = ((isset($column_options['shape_margin_left']) && !empty($column_options['shape_margin_left'])) ? $column_options['shape_margin_left'] . 'px' : 0);

        $shape_position_zindex = ($column_options['shape_position_zindex'] ?? 0);
        $shape_border          = ((isset($column_options['shape_border']) && !empty($column_options['shape_border'])) ? $column_options['shape_border'] . 'px' : '');
        $shape_transform       = ($column_options['shape_transform'] ?? 'unset');
//      $shape_shadow = ((isset($column_options['shape_shadow']) && !empty($column_options['shape_shadow'])) ? ' ' . $column_options['shape_shadow'] : '');

        $shape_background_image_repeat     = ($column_options['shape_background_image_repeat'] ?? 0);
        $shape_background_image_attachment = ($column_options['shape_background_image_attachment'] ?? "");
        $shape_background_image_position   = ((isset($column_options['shape_background_image_position']) && !empty($column_options['shape_background_image_position']) && !empty($column_options['shape_background_image'])) ? ' ' . $column_options['shape_background_image_position'] : '');


        $inlineColumnCss = '';

        if (!empty($column_options['id'])) {
            $column_id = ' id="' . $column_options['id'] . '"';
        } else {
            $column_id = '';
        }
        if (!empty($column_options['class'])) {
            $column_class .= ' ' . $column_options['class'];
        }

        // Add Column Background
        if ($custom_column_background === "1") {
            // default column background
            if (!empty($column_options['background_color'])) {
                $column_css .= '.ui-column-' . $key . '{';
                    $column_css .= 'position: relative;';
                $column_css .= '}';

                $column_css .= '.ui-column-' . $key . '::before{';
                    $column_css .= 'content: "";';
                    $column_css .= 'position: absolute;';
                    $column_css .= 'top: 0;';
                    $column_css .= 'left: 40px;';
                    $column_css .= 'width: calc(100% - 55px);';
                    $column_css .= 'height: 100%;';
    //              $column_css .= 'z-index: -2;';
                    $column_css .= 'background-color: ' . $column_options['background_color'] . ';';
                $column_css .= '}';

                $column_css .= '@media (min-width: 1200px){';
                    $column_css .= '.ui-column-' . $key . '::before{';
                    $column_css .= 'width: calc(100% - 40px);';
                    $column_css .= '}';
                $column_css .= '}';
            }
        } elseif ($custom_column_background === "2") {
            $column_class .= ' uk-position-relative';

            // square / circle shape
            if (($column_options['shape'] === 'square' || $column_options['shape'] === 'circle') && ((!empty($column_options['shape_width']) && !empty($column_options['shape_height'])) || (!empty($column_options['shape_width_pixel']) && !empty($column_options['shape_height_pixel'])))) {
                // CSS
                $column_css .= '.ui-column-' . $key . ' .ui-column-container::before{';

                $column_css .= 'content: " ";';
                $column_css .= 'position: absolute;';

                // width & height pixel or %
                if (!empty($column_options['shape_width']) && !empty($column_options['shape_height'])) {
                    $column_css .= 'width: ' . $column_options['shape_width'] . '%;';
                    $column_css .= 'height: ' . $column_options['shape_height'] . '%;';
                } elseif (!empty($column_options['shape_width_pixel']) && !empty($column_options['shape_height_pixel'])) {
                    $column_css .= 'width: ' . $column_options['shape_width_pixel'] . 'px;';
                    $column_css .= 'height: ' . $column_options['shape_height_pixel'] . 'px;';
                }
                // background-color
                if (!empty($column_options['shape_color'])) {
                    $column_css .= 'background-color: ' . $column_options['shape_color'] . ';';
                } else {
                    $column_css .= 'background-color: transparent;';
                }
                // background-image
                if (!empty($column_options['shape_background_image'])) {
                    $column_css .= 'background-image: url("' . Uri::root() . $column_options['shape_background_image'] . '");';
                    // image repeat
                    if ($shape_background_image_repeat === "0") {
                        $column_css .= 'background-repeat: no-repeat;';
                    }
                    // image position
                    if (!empty($column_options['shape_background_image_position'])) {
                        $backgroundPosition = '';

                        if ($column_options['shape_background_image_position'] === 'uk-background-top-left') {
                            $backgroundPosition = '0 0';
                        } elseif ($column_options['shape_background_image_position'] === 'uk-background-top-center') {
                            $backgroundPosition = '50% 0';
                        } elseif ($column_options['shape_background_image_position'] === 'uk-background-top-right') {
                            $backgroundPosition = '100% 0';
                        } elseif ($column_options['shape_background_image_position'] === 'uk-background-center-left') {
                            $backgroundPosition = '0 50%';
                        } elseif ($column_options['shape_background_image_position'] === 'uk-background-center-center') {
                            $backgroundPosition = '50% 50%';
                        } elseif ($column_options['shape_background_image_position'] === 'uk-background-center-right') {
                            $backgroundPosition = '100% 50%';
                        } elseif ($column_options['shape_background_image_position'] === 'uk-background-bottom-left') {
                            $backgroundPosition = '0 100%';
                        } elseif ($column_options['shape_background_image_position'] === 'uk-background-bottom-center') {
                            $backgroundPosition = '50% 100%';
                        } elseif ($column_options['shape_background_image_position'] === 'uk-background-bottom-right') {
                            $backgroundPosition = '100% 100%';
                        }

                        $column_css .= 'background-position: ' . $backgroundPosition . ';';
                    }
                    // image size
                    if (!empty($column_options['shape_background_image_size'])) {
                        $column_css .= 'background-size: ' . $column_options['shape_background_image_size'] . ';';
                    }
                    // image blend modes
                    if (!empty($column_options['shape_background_image_blend_modes']) && !empty($column_options['shape_color'])) {
                        $column_css .= 'background-blend-mode: ' . $column_options['shape_background_image_blend_modes'] . ';';
                    }
                    // image attachment
                    if ($shape_background_image_attachment === "fixed") {
                        $column_css .= 'background-attachment: fixed;';
                    }
                }
                // position
                $column_css .= 'top: 0;';
                if ($shape_position === 'right') {
                    $column_css .= 'right: 0;';
                } else {
                    $column_css .= 'left: 0;';
                }
                // margin #ToDo
                if (!$shape_margin_top || !$shape_margin_right || !$shape_margin_bottom || !$shape_margin_left) {
                    $column_css .= 'margin: ' . $shape_margin_top . ' ' . $shape_margin_right . ' ' . $shape_margin_bottom . ' ' . $shape_margin_left . ';';
                }
                // border
                if ($shape_border && !empty($column_options['shape_border_style']) && !empty($column_options['shape_border_color'])) {
                    $column_css .= 'border: ' . $shape_border . ' ' . $column_options['shape_border_style'] . ' ' . $column_options['shape_border_color'] . ';';
                }
                if ($column_options['shape'] === 'circle') {
                    $column_css .= 'border-radius: 50%;';
                }
                // transform rotate
                if ($shape_transform === 'rotate' && !empty($column_options['shape_transform_rotate'])) {
                    $column_css .= 'transform: rotate(' . $column_options['shape_transform_rotate'] . 'deg);';
                    // transform rotate3d
                } elseif ($shape_transform === 'rotate3d' && !empty($column_options['shape_transform_rotate']) && !empty($column_options['shape_transform3d_1']) && !empty($column_options['shape_transform3d_2']) && !empty($column_options['shape_transform3d_3'])) {
                    $column_css .= 'transform: rotate3d(' . $column_options['shape_transform3d_1'] . ', ' . $column_options['shape_transform3d_2'] . ', ' . $column_options['shape_transform3d_3'] . ', ' . $column_options['shape_transform_rotate'] . 'deg);';
                } else {
                    $column_css .= 'transform: unset;';
                }
                // z-index
                if ($shape_position_zindex === "1") {
                    $column_css .= 'z-index: 1;';
                }/* else {
                        $column_css .= 'z-index: -1;';
                    }*/
                $column_css .= '}';

                // triangle shape
            } elseif ($column_options['shape'] === 'triangle' && !empty($column_options['shape_color'])) {
                // CSS
                $column_css .= '.ui-column-' . $key . ' .ui-column-container::before{';
                // width & height
                $column_css .= 'width: 0;';
                $column_css .= 'height: 0;';

                // background-color
                $column_css .= 'background-color: transparent;';
                // position
                $column_css .= 'top: 0;';
                if ($shape_position === 'right') {
                    $column_css .= 'right: 0;';
                } else {
                    $column_css .= 'left: 0;';
                }
                // margin
                if (!$shape_margin_top || !$shape_margin_right || !$shape_margin_bottom || !$shape_margin_left) {
                    $column_css .= 'margin: ' . $shape_margin_top . ' ' . $shape_margin_right . ' ' . $shape_margin_bottom . ' ' . $shape_margin_left . ';';
                }
                // border (build triangle)
                if (!empty($column_options['shape_height_pixel'])) {
                    $column_css .= 'border-left: ' . $column_options['shape_height_pixel'] / 2 . 'px solid transparent;';
                    $column_css .= 'border-right: ' . $column_options['shape_height_pixel'] / 2 . 'px solid transparent;';
                    $column_css .= 'border-bottom: ' . $column_options['shape_height_pixel'] . 'px solid ' . $column_options['shape_color'] . ';';
                }
                // transform rotate
                if ($shape_transform === 'rotate' && !empty($column_options['shape_transform_rotate'])) {
                    $column_css .= 'transform: rotate(' . $column_options['shape_transform_rotate'] . 'deg);';
                    // transform rotate3d
                } elseif ($shape_transform === 'rotate3d' && !empty($column_options['shape_transform_rotate']) && !empty($column_options['shape_transform3d_1']) && !empty($column_options['shape_transform3d_2']) && !empty($column_options['shape_transform3d_3'])) {
                    $column_css .= 'transform: rotate3d(' . $column_options['shape_transform3d_1'] . ', ' . $column_options['shape_transform3d_2'] . ', ' . $column_options['shape_transform3d_3'] . ', ' . $column_options['shape_transform_rotate'] . 'deg);';
                } else {
                    $column_css .= 'transform: unset;';
                }
                // z-index
                if ($shape_position_zindex === "1") {
                    $column_css .= 'z-index: 1;';
                }/* else {
                        $column_css .= 'z-index: -1;';
                    }*/
                $column_css .= '}';
            }
        }

        if (!empty($column_options['color_style'])) {
            $column_class .= ' ' . $column_options['color_style'];
        }

        // Add Inline CSS Background / Shapes
        if (!empty($column_css)) {
            $inlineColumnCss = '<style>' . $column_css . '</style>';
        }

        // Column Grid Options
        if (!empty($column_options['grid_gutter'])) {
            $column_grid_gutter_class .= ' ' . $column_options['grid_gutter'];
        }
        if (!empty($column_options['grid_row_gap'])) {
            $column_grid_gutter_class .= ' ' . $column_options['grid_row_gap'];
        }
        if (!empty($column_options['grid_divider'])) {
            $column_grid_gutter_class .= ' ' . $column_options['grid_divider'];
        }

        $rn             = PageHelper::randomNumber();
        $GridChildWidth = (!empty($column_options['grid_child_width']) ? ' uk-child-width-' . $column_options['grid_child_width'] . '@m' : ' uk-child-width-1-1');


        // column html
        $html = '<div' . $column_id . ' class="column uk-width-' . $column['grid'] . '@m active-column ui-column-' . $key . $column_class . $flex_column_items_vertical . '">';

        $html .= '<div class="column-wrap">';

        $html .= '<div class="column-tools uk-position-absolute uk-position-top-center uk-light">';
        $html .= '<div uk-grid="" class="uk-grid-small uk-flex-middle">';
        $html .= '<div class="uk-width-auto">';
        $html .= '<div uk-grid="" class="uk-grid-small uk-flex-middle">';
        $html .= '<div class="uk-width-auto">';
        $html .= '<ul class="uk-iconnav ui-background-secondary">';
        $html .= '<li title="" tabindex="0" uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_TOGGLE_COLUMN_OPTIONS') . '">';
        $html .= '<a href="javascript:void(0)" class="btn-column-options-toggle uk-text-emphasis uk-icon-button ui-icon-button" uk-toggle="target: #column-options-toggle-1' . $rn . '">';
        $html .= '<i class="uk-icon" uk-icon="icon: more-vertical; ratio: .8"></i>';
        $html .= '</a>';
        $html .= '</li>';
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '<div id="column-options-toggle-1' . $rn . '" class="column-options-toggle uk-width-auto uk-flex-middle" hidden="">';
        $html .= '<div uk-grid="" class="uk-grid uk-grid-stack">';
        $html .= '<div class="uk-width-expand uk-first-column uk-flex-middle">';
        $html .= '<ul class="uk-iconnav">';
        $html .= '<li uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_CONFIGURE_COLUMN') . '">';
        $html .= '<a class="btn-column-config uk-icon-button ui-icon-button" href="javascript:void(0)"><i uk-icon="icon: cog; ratio: .8"></i></a>';
        $html .= '</li>';
        $html .= '<li uk-tooltip="' . Text::_('COM_UITHEMEBUILDERLITE_ADD_COMPONENT') . '">';
        $html .= '<a class="btn-add-component uk-icon-button ui-icon-button" href="javascript:void(0)"><i uk-icon="icon: ui-component; ratio: .8"></i></a>';
        $html .= '</li>';
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '<div class="uk-width-expand">';
        $html .= '<div class="uk-flex uk-flex-right">';
        $html .= '<ul class="uk-iconnav">';
        $html .= '<li>';
        $html .= '<i class="uk-drag move-column uk-icon-button ui-icon-button uk-text-emphasis" uk-icon="icon: move; ratio: .6"></i>';
        $html .= '</li>';
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';


        // column title + subtitle html
        if ((!empty($column_options['title']) || !empty($column_options['subtitle'])) && $title_show === "1") {
            $titleAndSubtitleClasses = PageHelper::getTitleAndSubtitleClasses($column_options);
            $title_class             = ($titleAndSubtitleClasses['title'] === '') ? '' : ' ' . $titleAndSubtitleClasses['title'];
            $subtitle_class          = ($titleAndSubtitleClasses['subtitle'] === '') ? '' : ' ' . $titleAndSubtitleClasses['subtitle'];

            if (isset($column_options['heading_alignment']) && !empty($column_options['heading_alignment'])) {
                $column_heading_alignment = ' class="uk-padding-small uk-padding-remove-vertical ' . $column_options['heading_alignment'] . '"';
            }
            $html .= '<div class="' . trim($column_grid_gutter_class) . '" uk-grid="">';
            $html .= '<div class="uk-width-1-1">';
            $html .= '<div' . $column_heading_alignment . '>';
            if (!empty($column_options['title'])) {
                $html .= '<' . $column_options['title_heading'] . ' class="' . trim($title_class) . '">';
                $html .= '<span>' . $column_options['title'] . '</span>';
                $html .= '</' . $column_options['title_heading'] . '>';
            }
            if (!empty($column_options['subtitle'])) {
                $html .= '<' . $column_options['subtitle_heading'] . ' class="uk-margin-remove-top ' . trim($subtitle_class) . '">';
                $html .= '<span>' . $column_options['subtitle'] . '</span>';
                $html .= '</' . $column_options['subtitle_heading'] . '>';
            }
            $html .= '</div>';
            $html .= '</div>';
            $html .= '</div>';
        }

        if ($column_options['masonry_grid'] === "1") {
            $child_width = '';
            if (!empty($column_options['masonry_grid_parallax'])) {
                $parallax = ' parallax:' . $column_options['masonry_grid_parallax'];
            } else {
                $parallax = '';
            }
            if (!empty($column_options['grid_m'])) {
                $child_width .= ' uk-child-width-' . $column_options['grid_m'] . '@m';
            }
            if (!empty($column_options['grid_l'])) {
                $child_width .= ' uk-child-width-' . $column_options['grid_l'] . '@l';
            }
            if (!empty($column_options['grid_xl'])) {
                $child_width .= ' uk-child-width-' . $column_options['grid_xl'] . '@xl';
            }
            $html .= '<div class="ui-column-container uk-child-width-1-1' . $child_width . $column_grid_gutter_class . '" uk-grid="masonry: true;' . $parallax . '" uk-sortable="handle: .uk-drag.component-title; group: sortable-component-group">';
        } else {
            $html .= '<div class="ui-column-container' . $GridChildWidth . $column_grid_gutter_class . '" uk-grid="" uk-sortable="handle: .uk-drag.component-title; group: sortable-component-group">';
        }

        $html .= '</div>';

        $html .= '<div class="column-options ui-preview-column-options uk-hidden"></div>';
        $html .= '<input class="json-column ui-preview-json-column" type="hidden" value="">';
        if ($inlineColumnCss) {
            $html .= $inlineColumnCss;
        }
        $html .= '</div>';
        $html .= '</div>';


        echo $html;

        Jexit();
    }

    /**
     * @return void
     *
     * @throws \Exception
     *
     * @since   v0.0.1
     */
    public function renderComponent(): void
    {
        PageHelper::getComponents();
        $app                    = Factory::getApplication();
        $html                   = '';
        $items_html             = '';
        $component              = $app->input->getArray(array (), null, 'RAW');
        $form                   = PageHelper::$forms[$component['type']];
        $fieldsets              = $form->getFieldsets();
        $element_general_fields = $form->getFieldset('general');
        $element_options_fields = $form->getFieldset('options');
        $first_item             = $form->getFieldset('item-1');
        $default_items          = 0;

        $basic_name          = ['show', 'hidden', 'publish_up', 'publish_down', 'basic_spacer', 'basic_spacer_0', 'basic_spacer_1', 'basic_spacer_2', 'basic_spacer_3', 'basic_spacer_4', 'basic_spacer_5', 'admin_label', 'menutype', 'base_menulist', 'use_random_unsplash_search', 'unsplash_search_query', 'unsplash_size', 'unsplash_custom_search_query', 'gallery_dir', 'gallery_thumb_dir', 'gallery_preview_size', 'gallery_thumb_size', 'gallery_square_thumb', 'gallery_images_quality', 'gallery_microdata', 'txt_email_list_file_name', 'mail_notification', 'csv_email_list_file_name', 'enable_anti_spam', 'save_email_list', 'numscroller_min', 'numscroller_max', 'numscroller_delay', 'numscroller_increment', 'description_show', 'flickr-image-count', 'flickr-id', 'countdown_time', 'module', 'use_filter_tags', 'filter_tags', 'spacer_height', 'divider_type', 'type', 'masonry_grid', 'grid', 'grid_gutter_settings', 'grid_settings_m', 'grid_settings_l', 'grid_settings_xl', 'class', 'id', 'component_position', 'component_position_left', 'component_position_right', 'component_position_top', 'component_position_bottom', 'component_position_zindex', 'component_image_height'];
        $title_name          = ['title_show', 'title_position', 'title', 'title_heading', 'title_font_size', 'title_font_weight', 'title_style', 'title_text_color', 'title_width_viewport', 'subtitle_show', 'subtitle', 'subtitle_font_size', 'subtitle_font_weight', 'subtitle_heading', 'subtitle_title_style', 'heading_alignment'];
        $article_name        = ['article_resource', 'article_catid', 'article_tag_list', 'include_subcat', 'article_card_style', 'article_alignment', 'article_limit', 'article_ordering', 'article_use_filter', 'article_filter_tags', 'article_nav_alignment', 'article_sub_nav_style', 'article_sub_nav_color_style', 'article_intro_show', 'article_intro_limit', 'article_date_show', 'article_category_show', 'article_tag_show', 'article_autor_show', 'article_use_autor_img', 'article_autor_image', 'article_spacer_1', 'article_spacer_2', 'article_spacer_3', 'article_read_more', 'article_button_text', 'article_button_menulist', 'article_button_target', 'article_button_icon', 'article_button_size', 'article_button_type', 'article_link', 'article_spacer_4', 'article_grid_match', 'article_grid_gutter', 'article_grid_settings_m', 'article_grid_settings_l', 'article_grid_settings_xl'];
        $article_slider_name = ['article_post_format', 'article_slider_autoplay', 'article_slider_autoplay_interval', 'article_slider_pause_on_hover', 'article_slider_center', 'article_slider_color_style', 'article_show_controls', 'article_controls_color_style', 'article_nav_controls_large', 'article_controls_outside', 'article_show_indicators', 'article_indicators_position'];
        $background_name     = ['image_width_srcset', 'background_image_srcset', 'svg_list', 'svg_background_color_fallback', 'svg_background_color_2', 'svg_background_color_3', 'svg_background_text', 'svg_background_text_font_size', 'svg_background_image_opacity', 'svg_background_attachment', 'svg_background_image_size', 'svg_background_image_repeat', 'svg_background_position_x', 'svg_background_position_y', 'svg_background_image_opacity', 'custom_background', 'background_color', 'background', 'background_image', 'background_image_blend_modes', 'background_image_attachment', 'background_image_position', 'background_image_size', 'background_image_repeat', 'color_style', 'box_svg_list', 'box_svg_background_color_fallback', 'box_svg_background_color_2', 'box_svg_background_color_3', 'box_svg_background_text', 'box_svg_background_text_font_size', 'box_svg_background_attachment', 'box_svg_background_image_size', 'box_svg_background_image_repeat', 'box_svg_background_position_x', 'box_svg_background_position_y', 'box_svg_background_image_opacity', 'custom_box_background', 'box_background_color', 'box_icon_background', 'box_background_image', 'box_background_image_blend_modes', 'box_background_image_attachment', 'box_background_image_position', 'box_background_image_size', 'box_background_image_repeat', 'box_color_style', 'gradient_effect', 'gradient_angle', 'gradient_color_1', 'gradient_color_1_position', 'gradient_color_2', 'gradient_color_2_position', 'gradient_color_3', 'gradient_color_3_position', 'radial_conical_x_position', 'radial_conical_y_position'];
        $style_name          = ['item_animations', 'dropdown_width', 'dropdown_columns', 'nav_layout', 'nav_modifier', 'navbar_logo', 'nav_center', 'navbar_container', 'navbar_transparent', 'navbar_boundary_align', 'navbar_boundary_pos', 'navbar_tooltip', 'navbar_tooltip_position', 'navbar_split', 'offcanvas', 'offcanvas_only', 'offcanvas_flip', 'offcanvas_mode', 'offcanvas_overlay', 'offcanvas_accordion', 'navbar_dropbar', 'navbar_parent_icon', 'svg_mask_list', 'svg_mask_repeat', 'svg_mask_position', 'use_svg_custom_mask_size', 'svg_mask_size', 'svg_custom_mask_size', 'svg_mask_mode', 'gallery_home_category', 'cover_grid', 'image_min_height', 'gallery_download', 'gallery_layout', 'gallery_images_number', 'item_pagination_user_limit_show', 'item_pagination_show', 'item_pagination_limit', 'show_load_more', 'show_load_more_reset', 'show_load_more_button_size', 'show_load_more_button_full_width', 'show_load_more_button_space', 'show_load_more_start_items', 'show_load_more_add_items', 'show_load_more_button_type', 'container_height', 'map_layer', 'map_lat', 'map_lon', 'map_pin', 'map_zoom', 'map_scale', 'map_world_warp', 'map_zoom_control', 'scroll_wheel_zoom', 'map_search_control', 'map_control_locate', 'card_image_logo_invert', 'card_image_logo', 'card_image_logo_alt', 'image_typ_background_size', 'svg_typ_background_image_size', 'svg_image_typ', 'svg_image_typ_with_imageplaceholder', 'svg_image_typ_height', 'svg_image_typ_background', 'newsletter_subscribe_pro_layout', 'alignment', 'button_group', 'button_text', 'button_url', 'button_target', 'button_menulist', 'button_icon', 'button_size', 'button_type', 'style_spacer_1', 'style_spacer_2', 'style_spacer_3', 'style_spacer_4', 'style_spacer_5', 'style_spacer_6', 'style_spacer_7', 'style_spacer_8', 'style_spacer_9', 'style_spacer_10', 'style_spacer_11', 'lightbox_layout', 'masonry_grid_style', 'grid_column_gap', 'offcanvas_link_show', 'grid_row_gap', 'grid_slider_column_gap', 'grid_m', 'grid_l', 'grid_xl', 'list_styles', 'description_list_style', 'list_style', 'list_style_color_modifiers', 'list_style_large', 'leader_style', 'leader_style_media', 'nav_align', 'module_tag', 'content_html_tag', 'text_block_content', 'nav_transparent', 'nav_alignment', 'sub_nav_style', 'sub_nav_color_style', 'countdown_height', 'countdown_alignment', 'countdown_separator_show', 'countdown_separator', 'countdown_label_show', 'image_position', 'image_typ_srcset_bg', 'image_width_srcsets', 'image_width_srcset_bg', 'image_typ_srcset_default', 'image_width_srcset_default', 'image_creator', 'overlapping_overlays', 'image_typ', 'image_height', 'image_border_style', 'image_overlay_style', 'image_overlay_position', 'use_image_link', 'content', 'content_margin', 'content_padding', 'use_caption', 'remove_padding', 'modul_content_padding', 'flex_content_vertical', 'modul_padding', 'modul_height', 'modul_shadow', 'modul_shadow_bottom', 'image_shadow', 'image_shadow_bottom', 'alert_type', 'close', 'tab_style', 'tab_alignment', 'countdown_date', 'card_style', 'tile_style', 'tile_size', 'badge_text', 'card_style_hover', 'card_size', 'slider_color_style', 'indicators_color_style', 'controls_color_style', 'slider_height_viewport', 'slider_height', 'slider_height_viewport_offset_top', 'slider_height_viewport_offset_bottom', 'slider_height_viewport_offset_expand', 'slider_height_viewport_offset_min_height', 'use_grid', 'grid_match', 'grid_gutter', 'nav_controls_large', 'controls_outside', 'layout', 'margin', 'button_full_width', 'icons_font_size', 'social_icons_font_size', 'color', 'button_alignment', 'alt_text', 'text_block_image_alt_text', 'text_block_image', 'category', 'caption', 'icon', 'icon_position', 'image', 'image_block', 'image_block_width_srcset', 'image_text_block_width_srcset', 'image_text_block', 'image_url', 'text_block_image_width', 'text_block_content_width', 'use_text_block_with_image', 'image_alt_text', 'image_position', 'indicators_position', 'layout', 'table_modifier', 'table_size', 'table_hover', 'show_thumbnav', 'show_thumbnav_position', 'show_controls', 'slider_autoplay', 'slider_autoplay_interval', 'slider_pause_on_hover', 'show_indicators', 'slider_center', 'social_facebook', 'social_twitter', 'social_instagram', 'social_linkedin', 'social_youtube', 'social_tumblr', 'social_vimeo', 'social_flickr', 'social_pinterest', 'social_icons_position', 'social_icons_target', 'grid_width', 'lightbox_animation', 'lightbox_autoplay', 'lightbox_autoplay_interval', 'image_positions_component_width_srcset', 'use_positions_component', 'position', 'position_modifier', 'box_padding', 'box_background', 'use_box_header_footer', 'box_icon_position', 'icon_box_pro_layout', 'use_box_border', 'use_box_shadow', 'box_icon', 'box_icon_size', 'box_image', 'box_size', 'contact_form_show_icons', 'contact_form_layout_grid', 'contact_form_layout_margin', 'contact_form_layout', 'contact_form_modal', 'contact_form_modal_size', 'button_text_modal', 'text_font_weight_modal', 'button_size_modal', 'button_type_modal', 'button_full_width_modal', 'contact_form_sucsess', 'contact_form_error', 'contact_form_show_gender', 'contact_form_show_tel', 'contact_form_subjects', 'contact_form_show_label', 'contact_form_show_input_placeholder', 'contact_form_show_agreement_checkbox', 'contact_form_captcha', 'contact_form_captcha_type', 'contact_form_links', 'contact_form_timeout', 'contact_form_badwordfilter', /*'contact_form_badwordfields', */
            'contact_form_captcha_question'];
        $svg_name            = ['svg_height', 'svg_image_height', 'svg_image_width', 'svg_image_x_padding', 'svg_image_y_padding', 'use_filter_shadow', 'filter_dropShadow_color', 'dropShadow_x_offset', 'dropShadow_y_offset', 'dropShadow_blur_x_offset', 'dropShadow_blur_y_offset', 'innerShadowfilter_color', 'innerShadow_x_offset', 'innerShadow_y_offset', 'innerShadow_blur_x_offset', 'mask_filter', 'mask_Shadow_blur', 'mask_position_y', 'mask_position_x', 'mask_circle_radius', 'mask_ellipse_radius_x', 'mask_ellipse_radius_y', 'innerShadow_blur_y_offset', 'clippy_mask', 'svg_spacer_1', 'svg_spacer_2', 'card_divider_bottom', 'card_divider_bottom_dropshadow', 'filter_dropShadow_color_bottom', 'dropShadow_blur_bottom', 'dropShadow_blur_y_offset_bottom', 'use_gradient_overlay', 'gradient_overlay_opacity', 'gradient_presets', 'card_divider_bottom_flip', 'card_divider_top', 'card_divider_top_dropshadow', 'filter_dropShadow_color_top', 'dropShadow_blur_top', 'dropShadow_blur_y_offset', 'card_divider_top_flip'];
        $video_name          = ['video_url', 'video_width', 'video_height', 'thumbnail_image', 'video_cover', 'video_cover_height', 'video_cover_height_viewport', 'video_content_padding', 'video_content_box_padding', 'video_viewport_offset_top', 'video_viewport_offset_bottom', 'video_content_position', 'video_content_position_margin', 'video_content_overlay', 'video_content', 'video_spacer', 'video_start', 'video_show_suggestions', 'video_show_info', 'video_show_controls', 'video_auto_play', 'video_loop', 'video_muted'];
        $transition_name     = ['transition_spacer_1', 'transition_spacer_2', 'use_img_transition', 'img_transition', 'use_overlay_transition', 'overlay_transition'];
        $animation_name      = ['scrollspy_animation', 'scrollspy_animation_delay', 'scrollspy_animation_repeat', 'scrollspy_animation_type', 'animation_spacer_1', 'box_scrollspy_animation', 'box_scrollspy_animation_delay', 'box_scrollspy_animation_repeat', 'box_scrollspy_animation_type', 'animation_spacer_2', 'animation_spacer_3', 'animation_spacer_4', 'parallax_animation_box', 'parallax_animation_box_opacity_values', 'parallax_animation_box_y_values', 'parallax_animation_box_x_values', 'parallax_animation_box_scale_values', 'parallax_animation_box_rotate_values', 'parallax_animation_viewport', 'parallax_animation_media', 'parallax_animation_background', 'parallax_animation_background_x', 'parallax_animation_background_y', 'parallax_animation_background_grayscale', 'parallax_animation_background_saturate', 'parallax_animation_background_color'];

        if (!empty($component['items'])) {
            foreach ($fieldsets as $fieldset) {
                if (str_contains($fieldset->name, 'item-')) {
                    $default_items++;
                }
            }
            if (count($component['items']) - $default_items > 0) {
                $element_xml = simplexml_load_string(file_get_contents(JPATH_ROOT . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . $component['type'] . '.xml'));
                for ($i = 1; $i <= count($component['items']) - $default_items; $i++) {
                    $item_index = $i + $default_items;
                    $xml        = '<fieldset name="item-' . $item_index . '">';
                    foreach ($element_xml->fieldset[2] as $field) {
                        $field_name         = (string) $field->attributes()->name;
                        $field_name_explode = explode('-', $field_name);
                        if (($form->getFieldAttribute($field_name, 'type') === 'list') || ($form->getFieldAttribute($field_name, 'type') === 'radio')) {
                            $xml .= '<field name="' . $field_name_explode[0] . '-' . $item_index . '" type="' . $form->getFieldAttribute($field_name, 'type') . '" default="' . $form->getFieldAttribute($field_name, 'default') . '" class="' . $form->getFieldAttribute($field_name, 'class') . '" label="' . $form->getFieldAttribute($field_name, 'label') . '" description="' . $form->getFieldAttribute($field_name, 'description') . '" showon="' . $form->getFieldAttribute($field_name, 'showon') . '">';
                            foreach ($field->option as $option) {
                                $xml .= '<option value="' . (string) $option->attributes()->value . '">' . (string) $option . '</option>';
                            }
                            $xml .= '</field>';
                        } else {
                            $xml .= '<field name="' . $field_name_explode[0] . '-' . $item_index . '" type="' . $form->getFieldAttribute($field_name, 'type') . '" default="' . $form->getFieldAttribute($field_name, 'default') . '" class="' . $form->getFieldAttribute($field_name, 'class') . '" label="' . $form->getFieldAttribute($field_name, 'label') . '" description="' . $form->getFieldAttribute($field_name, 'description') . '" showon="' . $form->getFieldAttribute($field_name, 'showon') . '"/>';
                        }
                    }
                    $xml .= '</fieldset>';
                    $form->setField(new SimpleXMLElement($xml));
                }
            } else {
                for ($i = 0; $i < $default_items - count($component['items']); $i++) {
                    $item_index  = $default_items - $i;
                    $item_fields = $form->getFieldset('item-' . $item_index);
                    foreach ($item_fields as $field) {
                        $form->removeField($field->name);
                    }
                }
            }
        }

        if (!empty($element_general_fields)) {
            foreach ($element_general_fields as $field) {
                $form->setFieldAttribute($field->name, 'default', $component[$field->name]);
                if (in_array($field->name, $basic_name, true)) {
                    $basic_fields[] = $field->name;
                }
            }
        }

        if (!empty($element_options_fields)) {
            foreach ($element_options_fields as $field) {
                if (!empty($component['options']) && isset($component['options'][$field->name])) {
                    $form->setFieldAttribute($field->name, 'default', $component['options'][$field->name]);
                }
                if (in_array($field->name, $basic_name, true)) {
                    $basic_fields[] = $field->name;
                }
                if (in_array($field->name, $title_name, true)) {
                    $title_fields[] = $field->name;
                }
                if (in_array($field->name, $article_name, true)) {
                    $article_fields[] = $field->name;
                }
                if (in_array($field->name, $article_slider_name, true)) {
                    $article_post_format_fields[] = $field->name;
                }
                if (in_array($field->name, $background_name, true)) {
                    $background_fields[] = $field->name;
                }
                if (in_array($field->name, $style_name, true)) {
                    $style_fields[] = $field->name;
                }
                if (in_array($field->name, $svg_name, true)) {
                    $svg_style_fields[] = $field->name;
                }
                if (in_array($field->name, $video_name, true)) {
                    $video_fields[] = $field->name;
                }
                if (in_array($field->name, $transition_name, true)) {
                    $transition_fields[] = $field->name;
                }
                if (in_array($field->name, $animation_name, true)) {
                    $animation_fields[] = $field->name;
                }
            }
            $html .= '<div class="options-tabs">';
            $html .= '<div class="uk-background-primary uk-light uk-padding-small">';
            $html .= '<ul class="uk-flex-center uk-subnav uk-margin-remove">';
            if (!empty($basic_fields)) {
                $html .= '<li class="uk-active"><a class="t-btn active" href="javascript:void(0)" data-name="basics">' . Text::_('COM_UITHEMEBUILDERLITE_BASICS') . '</a></li>';
            }
            if (!empty($title_fields)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="title">' . Text::_('COM_UITHEMEBUILDERLITE_TITLE') . '</a></li>';
            }
            if (!empty($article_fields)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="articles">' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE') . '</a></li>';
            }
            if (!empty($article_post_format_fields)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="articles-slider">' . Text::_('COM_UITHEMEBUILDERLITE_ARTICLE_FORMAT') . '</a></li>';
            }
            if (!empty($background_fields)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="background">' . Text::_('COM_UITHEMEBUILDERLITE_BACKGROUND') . '</a></li>';
            }
            if (!empty($style_fields)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="styles">' . Text::_('COM_UITHEMEBUILDERLITE_STYLE') . '</a></li>';
            }
            if (!empty($svg_style_fields)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="svg-styles">' . Text::_('COM_UITHEMEBUILDERLITE_SVG_STYLE') . '</a></li>';
            }
            if (!empty($video_fields)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="video">' . Text::_('COM_UITHEMEBUILDERLITE_VIDEO') . '</a></li>';
            }
            if (!empty($transition_fields)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="transition">' . Text::_('COM_UITHEMEBUILDERLITE_TRANSITION') . '</a></li>';
            }
            if (!empty($animation_fields)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="animation">' . Text::_('COM_UITHEMEBUILDERLITE_ANIMATION') . '</a></li>';
            }
            if (!empty($first_item)) {
                $html .= '<li><a class="t-btn" href="javascript:void(0)" data-name="items">' . Text::_('COM_UITHEMEBUILDERLITE_ITEMS') . '</a></li>';
            }
            $html .= '</ul>';
            $html .= '</div>';
            $html .= '<div class="uk-modal-body" uk-overflow-auto="">';
            $html .= '<div class="uk-height-large">';
            $html .= '<div class="uk-child-width-expand" uk-grid="">';
            $html .= '<div id="options" class="uk-width-xlarge">';
            $html .= '<div class="tab-content component-options-tabs">';
            if (!empty($basic_fields)) {
                $html .= '<div class="tab-pane active uk-padding-small uk-height-large uk-overflow-auto basics uk-animation-fade" id="basics">';
                $html .= PageHelper::renderFormFields($form, $basic_fields);
                $html .= '</div>';
            }
            if (!empty($title_fields)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto title" id="title">';
                $html .= PageHelper::renderFormFields($form, $title_fields);
                $html .= '</div>';
            }
            if (!empty($article_fields)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto articles" id="articles">';
                $html .= PageHelper::renderFormFields($form, $article_fields);
                $html .= '</div>';
            }
            if (!empty($article_post_format_fields)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto articles-slider" id="articles-slider">';
                $html .= PageHelper::renderFormFields($form, $article_post_format_fields);
                $html .= '</div>';
            }
            if (!empty($background_fields)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto background" id="background">';
                $html .= PageHelper::renderFormFields($form, $background_fields);
                $html .= '</div>';
            }
            if (!empty($style_fields)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto styles" id="style">';
                $html .= PageHelper::renderFormFields($form, $style_fields);
                $html .= '</div>';
            }
            if (!empty($svg_style_fields)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto svg-styles" id="svg-style">';
                $html .= PageHelper::renderFormFields($form, $svg_style_fields);
                $html .= '</div>';
            }
            if (!empty($video_fields)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto video" id="video">';
                $html .= PageHelper::renderFormFields($form, $video_fields);
                $html .= '</div>';
            }
            if (!empty($transition_fields)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto transition" id="transition">';
                $html .= PageHelper::renderFormFields($form, $transition_fields);
                $html .= '</div>';
            }
            if (!empty($animation_fields)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto animation" id="animation">';
                $html .= PageHelper::renderFormFields($form, $animation_fields);
                $html .= '</div>';
            }
            if (!empty($first_item)) {
                $html .= '<div class="tab-pane uk-padding-small uk-height-large uk-overflow-auto items" id="items">';

                $accordion_id = PageHelper::createId('iterative', PageHelper::randomNumber());
                $item_index   = 0;
                $fieldsets    = $form->getFieldsets();

                foreach ($fieldsets as $fieldset) {
                    if (str_contains($fieldset->name, 'item-')) {
                        $item_options_fields = $form->getFieldset($fieldset->name);

                        if (!empty($item_options_fields)) {
                            if (!empty($component['items'][$item_index]['options']['item_title'])) {
                                $item_title = $component['items'][$item_index]['options']['item_title'];
                            } elseif (!empty($component['items'][$item_index]['options']['item_text'])) {
                                $item_title = $component['items'][$item_index]['options']['item_text'];
                            } elseif (!empty($component['items'][$item_index]['options']['lightbox_image_caption'])) {
                                $item_title = $component['items'][$item_index]['options']['lightbox_image_caption'];
                            } else {
                                $item_title = Text::_('COM_UITHEMEBUILDERLITE_ITEM_TITLE');
                            }

                            $items_html .= '<li class="item-options">';
                            $items_html .= '<div class="accordion-heading uk-flex uk-flex-middle">';
                            $items_html .= '<div>';
                            $items_html .= '<i class="move-item uk-drag" uk-icon="icon: move"></i>';
                            $items_html .= '</div>';
                            $items_html .= '<div>';
                            $items_html .= '<h6 class="uk-h6 uk-text-uppercase uk-margin-remove uk-flex uk-flex-middle">';
                            $items_html .= '<span class="uk-margin-small-left">';
                            $items_html .= '<a href="javascript:void(0)" class="uk-accordion-title uk-link-reset uk-text-truncate">' . $item_title . '</a>';
                            $items_html .= '</span>';
                            $items_html .= '</h6>';
                            $items_html .= '</div>';
                            $items_html .= '<div class="item-actions uk-margin-auto-left">';
                            $items_html .= '<div class="uk-margin-small-right">';
                            $items_html .= '<ul class="uk-iconnav">';
                            $items_html .= '<li><a class="btn-duplicate-item" href="javascript:void(0)" uk-icon="icon: copy"></a></li>';
                            $items_html .= '<li><a class="btn-delete-item" href="javascript:void(0)" uk-icon="icon: trash"></a></li>';
                            $items_html .= '</ul>';
                            $items_html .= '</div>';
                            $items_html .= '</div>';
                            $items_html .= '</div>';
                            $items_html .= '<div class="uk-accordion-content">';
                            $items_html .= '<div class="uk-background-muted uk-padding">';
                            foreach ($item_options_fields as $field) {
                                $field_name = explode('-', $field->name);
                                $showon     = $form->getFieldAttribute($field->name, 'showon') ? ' data-showon="' . $form->getFieldAttribute($field->name, 'showon') . '"' : '';

                                if (!empty($component['items']) && isset($component['items'][$item_index]['options'][$field_name[0]])) {
                                    $form->setFieldAttribute($field->name, 'default', $component['items'][$item_index]['options'][$field_name[0]]);
                                }
                                $items_html .= '<div class="uk-margin uk-form-stacked';
                                if ($form->getFieldAttribute($field->name, 'type') === 'hidden') {
                                    $items_html .= ' hidden';
                                }
                                $items_html .= '" ' . $showon . '>';
                                $items_html .= '<div>';
                                $items_html .= $form->getLabel($field->name);
                                $items_html .= '<div class="uk-form-controls">';
                                $items_html .= $form->getInput($field->name);
                                $items_html .= '</div>';
                                $items_html .= '</div>';
                                $items_html .= '</div>';
                            }
                            $items_html .= '</div>';
                            $items_html .= '</div>';
                            $items_html .= '</li>';
                        }
                        $item_index++;
                    }
                }
                if ($items_html) {
                    $html .= '<button type="button" class="btn-add-item uk-button uk-button-primary uk-margin"><span class="uk-margin-small-right" uk-icon="plus-circle"></span>' . Text::_('COM_UITHEMEBUILDERLITE_ADD_ITEM') . '</button>';
                    $html .= '<div id="' . $accordion_id . '" class="iterative-items">';
                    $html .= '<ul uk-accordion="content: .uk-accordion-content; toggle: .uk-h6.uk-text-uppercase; " uk-sortable="handle: .move-item.uk-drag">';
                    $html .= $items_html;
                    $html .= '</ul>';
                    $html .= '</div>';
                }
                $html .= '</div>';
            }
            $html .= '</div>';
            $html .= '</div>';
            $html .= '<div><div class="uk-panel uk-padding-small"></div></div>';
            $html .= '</div>';
            $html .= '</div>';
            $html .= '</div>';
            $html .= '</div>';
        }

        $form->reset(true);
        echo $html;
        Jexit();
    }

    /**
     * @return void
     *
     * @throws \Exception
     *
     * @since   v0.0.1
     */
    public function componentPreview(): void
    {
        $app               = Factory::getApplication();
        $component         = $app->input->getArray(array (), null, 'RAW');
        $component_options = PageHelper::escapeHtmlArray($component['options']);

        $buildStyle = '';
        $class      = 'ui-' . str_replace('_', '-', $component['type']);
        $getClasses = ' ' . PageHelper::getClasses($component_options);

        $custom_background          = ($component_options['custom_background'] ?? 0);
        $background_image_repeat    = ($component_options['background_image_repeat'] ?? 0);
        $scrollspy_animation        = ($component_options['scrollspy_animation'] ?? 0);
        $scrollspy_animation_repeat = ($component_options['scrollspy_animation_repeat'] ?? 0);

        $inline_css = '';
        $style      = [];

        $folder           = str_replace('_', '-', $component['type']);
        $thumbnail_folder = Path::clean('media/com_uithemebuilderlite/ui-themebuilder-thumb/' . $folder);

        $background_image_srcset = ($component_options['background_image_srcset'] ?? 0);
        $component_srcset        = '';
        $srcsets                 = [];

        $key              = PageHelper::randomNumber();

        // Text Block Pro
        $use_text_block_with_image = ($component_options['use_text_block_with_image'] ?? 0);
        $use_positions_component   = ($component_options['use_positions_component'] ?? 1);

        // Image Pro
        $image_typ_srcset_default = ($component_options['image_typ_srcset_default'] ?? 0);
        $image_typ_srcset_bg      = ($component_options['image_typ_srcset_bg'] ?? 0);
        $image_typ                = ($component_options['image_typ'] ?? 1);
        $component_image_height   = (isset($component_options['component_image_height']) && !empty($component_options['component_image_height']) ? $component_options['component_image_height'] : '');

        // Newsletter Subscribe Pro
        $newsletter_subscribe_pro_layout = ($component_options['newsletter_subscribe_pro_layout'] ?? 0);

        // Get Component Layouts
        if (File::exists(JPATH_THEMES . DIRECTORY_SEPARATOR . $app->getTemplate() . DIRECTORY_SEPARATOR . 'html' . DIRECTORY_SEPARATOR . 'layouts' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $component['type'] . '.php')) {
            $layouts = new FileLayout($component['type'], JPATH_THEMES . DIRECTORY_SEPARATOR . $app->getTemplate() . DIRECTORY_SEPARATOR . 'html' . DIRECTORY_SEPARATOR . 'layouts' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR);
        } else {
            $layouts = new FileLayout($component['type'], JPATH_ROOT . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_uithemebuilderlite' . DIRECTORY_SEPARATOR . 'layouts' . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR);
        }

        // Scrollspy Animation
        if ($scrollspy_animation === "1") {
            $cls = '';
            if (!empty($component_options['scrollspy_animation_type'])) {
                $cls = 'cls: ' . $component_options['scrollspy_animation_type'] . ';';
            }
            if ($scrollspy_animation_repeat === "1") {
                $repeat = ' repeat: true';
            } else {
                $repeat = '';
            }
            if (!empty($component_options['scrollspy_animation_delay'])) {
                $delay = ' delay: ' . $component_options['scrollspy_animation_delay'] . ';';
            } else {
                $delay = ' delay: 500;';
            }
            $scrollspy_animation_attr = ' uk-scrollspy="' . $cls . $delay . $repeat . '"';
        } else {
            $scrollspy_animation_attr = '';
        }

        // Image Pro Component create thumbnails
        if ($component['type'] === 'image_pro' && (($image_typ === "0" && !empty($component_options['image']) && $image_typ_srcset_default === "1" && !empty($component_options['image_width_srcset_default'])) || ($image_typ === "1" && !empty($component_options['image']) && $image_typ_srcset_bg === "1" && !empty($component_options['image_width_srcset_bg'])))) {
            PageHelper::createThumbnails($component_options['image'], $thumbnail_folder, $component_options);
        }
        // Image Pro Component delete thumbnails
        elseif ($component['type'] === 'image_pro' && (($image_typ === "0" && !empty($component_options['image']) && $image_typ_srcset_default === "0" ) || ($image_typ === "1" && !empty($component_options['image']) && $image_typ_srcset_bg === "0" ))) {
            PageHelper::deleteThumbnails($component_options['image'], $thumbnail_folder);
        }

        // Text Block Pro Component create thumbnails
        if ($component['type'] === 'text_block_pro' && ( ($use_text_block_with_image === "1" && !empty($component_options['image_text_block']) && !empty($component_options['image_text_block_width_srcset'])) || ($use_positions_component === "1" && !empty($component_options['image']) && !empty($component_options['image_positions_component_width_srcset'])))) {
            if ($use_text_block_with_image === "1" && !empty($component_options['image_text_block']) && !empty($component_options['image_text_block_width_srcset'])) {
                PageHelper::createThumbnails($component_options['image_text_block'], $thumbnail_folder, $component_options);
            } elseif ($use_positions_component === "1" && !empty($component_options['image']) && !empty($component_options['image_positions_component_width_srcset'])) {
                PageHelper::createThumbnails($component_options['image'], $thumbnail_folder, $component_options);
            }
        }
        // Text Block Pro Component delete thumbnails
        elseif ($component['type'] === 'text_block_pro' && ( ($use_text_block_with_image === "1" && !empty($component_options['image_text_block']) && empty($component_options['image_text_block_width_srcset'])) || ($use_positions_component === "1" && !empty($component_options['image']) && empty($component_options['image_positions_component_width_srcset'])))) {
            if ($use_text_block_with_image === "1" && !empty($component_options['image_text_block']) && empty($component_options['image_text_block_width_srcset'])) {
                PageHelper::deleteThumbnails($component_options['image_text_block'], $thumbnail_folder);
            } elseif ($use_positions_component === "1" && !empty($component_options['image']) && empty($component_options['image_positions_component_width_srcset'])) {
                PageHelper::deleteThumbnails($component_options['image'], $thumbnail_folder);
            }
        }

        // Newsletter Subscribe Pro Component create thumbnails
        if ($component['type'] === 'newsletter_subscribe_pro' && $newsletter_subscribe_pro_layout === "1" && !empty($component_options['image_block']) && !empty($component_options['image_block_width_srcset'])) {
            PageHelper::createThumbnails($component_options['image_block'], $thumbnail_folder, $component_options);
        }
        // Newsletter Subscribe Pro Component delete thumbnails
        elseif ($component['type'] === 'newsletter_subscribe_pro' && $newsletter_subscribe_pro_layout === "1" && !empty($component_options['image_block']) && empty($component_options['image_block_width_srcset'])) {
            PageHelper::deleteThumbnails($component_options['image_block'], $thumbnail_folder);
        }

        // Media Card Pro Component create thumbnails
        if ($component['type'] === 'media_card_pro' && !empty($component_options['image']) && !empty($component_options['image_width_srcset_bg'])) {
            PageHelper::createThumbnails($component_options['image'], $thumbnail_folder, $component_options);
        }
        // Media Card Pro Component delete thumbnails
        elseif ($component['type'] === 'media_card_pro' && !empty($component_options['image']) && empty($component_options['image_width_srcset_bg'])) {
            PageHelper::deleteThumbnails($component_options['image'], $thumbnail_folder);
        }

        // Slider Pro Component create thumbnails
        if ($component['type'] === 'slider_pro' && !empty($component_options['image_width_srcsets'])) {
            $itemBackgroundImages = array_column($component['items'], 'options', 'item_background_image');
            $itemCardImages = array_column($component['items'], 'options', 'item_image');

            if (!empty($itemBackgroundImages)) {
                foreach ($itemBackgroundImages as $ItemOptions) {
                    PageHelper::createThumbnails($ItemOptions['item_background_image'], $thumbnail_folder, $component_options, $ItemOptions);
                }
            } elseif (!empty($itemCardImages)) {
                foreach ($itemCardImages as $ItemOptions) {
                    PageHelper::createThumbnails($ItemOptions['item_image'], $thumbnail_folder, $component_options, $ItemOptions);
                }
            }
        }
        // Slider Pro Component delete thumbnails
        elseif ($component['type'] === 'slider_pro' && empty($component_options['image_width_srcsets'])) {
            $itemBackgroundImages = array_column($component['items'], 'options', 'item_background_image');
            $itemCardImages = array_column($component['items'], 'options', 'item_image');

            if (!empty($component_options['item_background_image'])) {
                foreach ($itemBackgroundImages as $ItemOptions) {
                    PageHelper::deleteThumbnails($ItemOptions['item_background_image'], $thumbnail_folder);
                }
            } elseif (!empty($component_options['item_image'])) {
                foreach ($itemCardImages as $ItemOptions) {
                    PageHelper::createThumbnails($ItemOptions['item_image'], $thumbnail_folder, $component_options, $ItemOptions);
                }
            }
        }

        // Custom Backgrounds
        if ($custom_background === "1") {
            if ((!empty($component_options['background_image'])) || (!empty($component_options['background_image_size']))) {
                if (!empty($component_options['background_image'])) {
                    // Background Srcset
                    if ($background_image_srcset === "1" && !empty($component_options['image_width_srcset'])) {
                        [$width, $height] = getimagesize(Uri::root() . $component_options['background_image']);
                        $ex        = '.' . pathinfo($component_options['background_image'], PATHINFO_EXTENSION);
                        $file_name = 'th_' . pathinfo($component_options['background_image'], PATHINFO_FILENAME);
                        // ratio
                        $ratio = round($width / $height * 100);

                        $tmp_srcset    = explode(',', $component_options['image_width_srcset']);
                        $merge_srcsets = array_merge($srcsets, $tmp_srcset);
                        $srcsets       = array_map('trim', $merge_srcsets);
                        $srcsets       = array_unique($srcsets);

                        $min_val = min($srcsets);

                        $component_srcset .= ' data-sizes="';
                        $component_srcset .= '(min-width: ' . $min_val . 'px) 90vw, ';
                        $component_srcset .= '(max-width: ' . $width . 'px) 100vw, ';
                        $component_srcset .= '(max-aspect-ratio: ' . $width . '/' . $height . ') ' . $ratio . 'vh" ';
                        $component_srcset .= 'data-srcset="';

                        foreach ($srcsets as $i => $val) {
                            if (is_numeric($val) && $val < 4000) {
                                unset($srcsets[$i]);
                                $component_srcset .= Uri::root() . $thumbnail_folder . '/' . $file_name . '_' . $val . $ex . ' ' . $val . 'w, ';
                            }
                        }

                        $component_srcset .= Uri::root() . $component_options['background_image'] . ' ' . $width . 'w" ';
                        $component_srcset .= 'data-src="' . Uri::root() . $component_options['background_image'] . '"';
                        $component_srcset .= ' uk-img';
                    } else {
                        $style['background-image'] = Uri::root() . $component_options['background_image'];
                        $component_srcset          = '';
                    }

                    if ($background_image_repeat === "0") {
                        $class .= ' uk-background-norepeat';
                    }

                    if (!empty($component_options['background_image_size'])) {
                        $class .= ' ' . $component_options['background_image_size'];
                    }
                }
            }
            if (!empty($component_options['background_color'])) {
                $style['background-color'] = $component_options['background_color'];
            }
            if (((!empty($component_options['background_image'])) && (!empty($component_options['background_color']))) && !empty($component_options['background_image_blend_modes'])) {
                $class .= ' ' . $component_options['background_image_blend_modes'];
            }
            if ((!empty($component_options['background_image'])) && (!empty($component_options['background_image_attachment']))) {
                $class .= ' ' . $component_options['background_image_attachment'];
            }
            if ((!empty($component_options['background_image'])) && (!empty($component_options['background_image_position']))) {
                $class .= ' ' . $component_options['background_image_position'];
            }
            // SVG Background
        } elseif ($custom_background === "2") {
            if (!empty($component_options['svg_list'])) {
                $class .= ' ui-' . str_replace('_', '-', $component['type']) . $key;

                $svg_path                   = Uri::root() . $component_options['svg_list'];
                $color_placeholder_1        = $component_options['svg_background_color_fallback'];
                $color_placeholder_2        = $component_options['svg_background_color_2'];
                $color_placeholder_3        = $component_options['svg_background_color_3'];
                $text_placeholder           = $component_options['svg_background_text'];
                $text_font_size_placeholder = $component_options['svg_background_text_font_size'] . 'px';
                $opacity_placeholder        = $component_options['svg_background_image_opacity'];

                // CSS output
                $css = '.ui-' . str_replace('_', '-', $component['type']) . $key . '{';
                if (!empty($component_options['svg_background_color_fallback'])) {
                    $css .= 'background: ' . $component_options['svg_background_color_fallback'] . ';';
                    $css .= 'background-color: ' . $component_options['svg_background_color_fallback'] . ';';
                }
                if (!empty($component_options['svg_background_attachment'])) {
                    $css .= 'background-attachment: ' . $component_options['svg_background_attachment'] . ';';
                }
                if (!empty($component_options['svg_background_image_size'])) {
                    $css .= 'background-size: ' . $component_options['svg_background_image_size'] . ';';
                }
                if (!empty($component_options['svg_background_image_repeat'])) {
                    $css .= 'background-repeat: ' . $component_options['svg_background_image_repeat'] . ';';
                }
                if (!empty($component_options['svg_background_position_x']) && !empty($component_options['svg_background_position_y'])) {
                    $css .= 'background-position: ' . $component_options['svg_background_position_x'] . ' ' . $component_options['svg_background_position_y'] . ';';
                }
                    $css .= 'background-image: url("data:image/svg+xml,' . PageHelper::convertSVGtoURI($svg_path, $key, $color_placeholder_1, $color_placeholder_2, $color_placeholder_3, $text_placeholder, $text_font_size_placeholder, $opacity_placeholder) . '");';
                $css .= '}';

                $inline_css = '<style>' . $css . '</style>';
            }
            // Gradient Background
        } elseif ($custom_background === "3") {
            $color1 = ($component_options['gradient_color_1'] ?? '');
            $color2 = ($component_options['gradient_color_2'] ?? '');
            $color3 = ($component_options['gradient_color_3'] ?? '');

            $color1_position = (isset($component_options['gradient_color_1_position']) ? $component_options['gradient_color_1_position'] . '%' : '');
            $color2_position = (isset($component_options['gradient_color_2_position']) ? $component_options['gradient_color_2_position'] . '%' : '');
            $color3_position = (isset($component_options['gradient_color_3_position']) ? $component_options['gradient_color_3_position'] . '%' : '');

            $radial_conical_x_position = (isset($component_options['radial_conical_x_position']) ? $component_options['radial_conical_x_position'] . '%' : '');
            $radial_conical_y_position = (isset($component_options['radial_conical_y_position']) ? $component_options['radial_conical_y_position'] . '%' : '');

            // linear gradient
            if ($component_options['gradient_effect'] === 'linear' && (!empty($color1) || !empty($color2) || !empty($color3))) {
                $style['background-color'] = $color1; // Fallback color
                // 3 active colors
                if (!empty($color1) && !empty($color2) && !empty($color3)) {
                    $style['background'] = 'linear-gradient(' . $component_options['gradient_angle'] . 'deg, ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                    // 2 active colors
                } elseif (!empty($color1) && !empty($color2)) {
                    $style['background'] = 'linear-gradient(' . $component_options['gradient_angle'] . 'deg,' . $color1 . $color1_position . ', ' . $color2 . $color2_position . ')';
                }
                $style['background-attachment'] = 'scroll';

                // radial gradient
            } elseif ($component_options['gradient_effect'] === 'radial' && ((!empty($color1) && !empty($color2)) || !empty($color3)) && ($radial_conical_x_position && $radial_conical_y_position)) {
                $style['background-color'] = $color1; // Fallback color
                // 3 active colors
                if (!empty($color1) && !empty($color2) && !empty($color3)) {
                    $style['background'] = 'radial-gradient(circle at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                    // 2 active colors
                } elseif (!empty($color1) && !empty($color2)) {
                    $style['background'] = 'radial-gradient(circle at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ')';
                }
                $style['background-attachment'] = 'scroll';

                // conical gradient
            } elseif ($component_options['gradient_effect'] === 'conical' && ((!empty($color1) && !empty($color2)) || !empty($color3)) && ($radial_conical_x_position && $radial_conical_y_position)) {
                $style['background-color'] = $color1; // Fallback color
                // 3 active colors
                if (!empty($color1) && !empty($color2) && !empty($color3)) {
                    $style['background'] = 'conic-gradient(from ' . $component_options['gradient_angle'] . 'deg at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ', ' . $color3 . ' ' . $color3_position . ')';
                    // 2 active colors
                } elseif (!empty($color1) && !empty($color2)) {
                    $style['background'] = 'conic-gradient(from ' . $component_options['gradient_angle'] . 'deg at ' . $radial_conical_x_position . ' ' . $radial_conical_y_position . ', ' . $color1 . ' ' . $color1_position . ', ' . $color2 . ' ' . $color2_position . ')';
                }
            }

            // Default Background
        } elseif (!empty($component_options['background'])) {
            $class .= ' ' . $component_options['background'];
        }

        // Component inline position style
        if (!empty($component_options['component_position'])) {
            $class .= ' ' . $component_options['component_position'];
            // Left
            if (!empty($component_options['component_position_left'])) {
                $style['left'] = $component_options['component_position_left'];
            }
            // Right
            if (!empty($component_options['component_position_right'])) {
                $style['right'] = $component_options['component_position_right'];
            }
            // Top
            if (!empty($component_options['component_position_top'])) {
                $style['top'] = $component_options['component_position_top'];
            }
            // Bottom
            if (!empty($component_options['component_position_bottom'])) {
                $style['bottom'] = $component_options['component_position_bottom'];
            }
            // z-index
            if (!empty($component_options['component_position_zindex'])) {
                $style['z-index'] = $component_options['component_position_zindex'];
            }
        }
        // set height in px or % (Image Pro)
        if ($component_image_height) {
            $style['height'] = $component_options['component_image_height'];
        }
        // Module Style
        if (!empty($style)) {
            $buildStyle = PageHelper::buildStyle($style);
        }

        echo '<div id="ui-component-preview" class="' . trim($class . $getClasses) . '"' . $scrollspy_animation_attr . $component_srcset . $buildStyle . '>' . $layouts->render($component) . $inline_css . '</div>';

        Jexit();
    }

    /**
     * Method to save a record.
     *
     * @param $key
     * @param $urlVar
     *
     * @return void
     *
     * @throws \Exception
     *
     * @since   v0.0.1
     */
    public function save($key = null, $urlVar = null)
    {
        $output            = array ();
        $output['status']  = false;
        $output['message'] = Text::_('JINVALID_TOKEN');

        Session::checkToken() or die(json_encode($output, JSON_THROW_ON_ERROR));

        $app      = Factory::getApplication();
        $user     = $app->getIdentity();
        $model    = $this->getModel();
        $data     = $this->input->post->get('jform', array (), 'array');
        $task     = $this->getTask();
        $context  = 'com_uithemebuilderlite.edit.page';
        $recordId = $this->input->getInt($urlVar);

        if (empty($recordId)) {
            $authorised = $user->authorise('core.create', 'com_uithemebuilderlite') || (count((array) $user->getAuthorisedCategories('com_uithemebuilderlite', 'core.create')));
        } else {
            $authorised = $user->authorise('core.edit', 'com_uithemebuilderlite') || $user->authorise('core.edit', 'com_uithemebuilderlite.page.' . $recordId) || $user->authorise('core.edit', 'com_uithemebuilderlite.page.' . $recordId) || ($user->authorise('core.edit.own', 'com_uithemebuilderlite.page.' . $recordId) && $data['created_by'] == $user->id);
        }

        if ($authorised !== true) {
            $output['status']  = false;
            $output['message'] = Text::_('JERROR_ALERTNOAUTHOR');
            echo json_encode($output, JSON_THROW_ON_ERROR);
            die();
        }

        if (empty($urlVar)) {
            $urlVar = $key;
        }

        if ($task === 'save2copy') {
            if ($model->checkin($data['id']) === false) {
                $output['status']  = false;
                $output['message'] = Text::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError());
                echo json_encode($output, JSON_THROW_ON_ERROR);
                die();
            }
            $data['id'] = 0;
            $task       = 'apply';
        }

        $form = $model->getForm($data);
        if (!$form) {
            $output['status']   = false;
            $output['message']  = $model->getError();
            $output['redirect'] = false;
            echo json_encode($output, JSON_THROW_ON_ERROR);
            die();
        }

        $data = $model->validate($form, $data);
        if ($data === false) {
            $errors            = $model->getErrors();
            $output['status']  = false;
            $output['message'] = '';
            for ($i = 0, $n = count((array) $errors); $i < $n && $i < 3; $i++) {
                if ($errors[$i] instanceof Exception) {
                    $output['message'] .= $errors[$i]->getMessage();
                } else {
                    $output['message'] .= $errors[$i];
                }
            }
            $app->setUserState('com_uithemebuilderlite.edit.page.data', $data);
            $output['redirect'] = 'index.php?option=' . $this->option . '&view=' . $this->view_item . $this->getRedirectToItemAppend($recordId);
            echo json_encode($output, JSON_THROW_ON_ERROR);
            die();
        }

        if (!$model->save($data)) {
            $app->setUserState('com_uithemebuilderlite.edit.page.data', $data);
            $output['status']   = false;
            $output['message']  = Text::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', $model->getError());
            $output['redirect'] = 'index.php?option=' . $this->option . '&view=' . $this->view_item . $this->getRedirectToItemAppend($recordId);
            echo json_encode($output, JSON_THROW_ON_ERROR);
            die();
        }

        if ($model->checkin($data['id']) === false) {
            $output['status']   = false;
            $output['message']  = Text::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError());
            $output['redirect'] = 'index.php?option=' . $this->option . '&view=' . $this->view_item . $this->getRedirectToItemAppend($recordId);
            echo json_encode($output, JSON_THROW_ON_ERROR);
            die();
        }

        $output['status']  = true;
        $output['message'] = Text::_('COM_UITHEMEBUILDERLITE_PAGE_SAVE_SUCCESS');

        switch ($task) {
            case 'apply':
                $recordId = $model->getState($this->context . '.id');
                $this->holdEditId($context, $recordId);
                $app->setUserState('com_uithemebuilderlite.edit.page.data', null);
                $output['redirect'] = 'index.php?option=' . $this->option . '&view=' . $this->view_item . $this->getRedirectToItemAppend($recordId);
                $output['id']       = $recordId;
                break;

            default:
                $this->releaseEditId($context, $recordId);
                $app->setUserState('com_uithemebuilderlite.edit.page.data', null);
                $output['redirect'] = Route::_('index.php?option=' . $this->option . '&view=' . $this->view_list . $this->getRedirectToListAppend(), false);
                break;
        }
        echo json_encode($output, JSON_THROW_ON_ERROR);
        die();
    }

    /**
     * Method override to check if you can edit an existing record.
     *
     * @param   array   $data  An array of input data.
     * @param   string  $key   The name of the key for the primary key.
     *
     * @return  boolean
     *
     * @since   0.0.1
     */
    protected function allowEdit($data = array (), $key = 'id'): bool
    {
        $recordId = (int) isset($data[$key]) ? $data[$key] : 0;
        $user     = $this->app->getIdentity();

        // Zero record (id:0), return component edit permission by calling parent controller method
        if (!$recordId) {
            return parent::allowEdit($data, $key);
        }

        // Check edit on the record asset (explicit or inherited)
        if ($user->authorise('core.edit', 'com_uithemebuilderlite.page.' . $recordId)) {
            return true;
        }

        // Check edit own on the record asset (explicit or inherited)
        if ($user->authorise('core.edit.own', 'com_uithemebuilderlite.page.' . $recordId)) {
            // Existing record already has an owner, get it
            $record = $this->getModel()->getItem($recordId);

            if (empty($record)) {
                return false;
            }

            // Grant if current user is owner of the record
            return $user->id == $record->created_by;
        }

        return false;
    }

    /**
     * Function that allows child controller access to model data
     * after the data has been saved.
     *
     * @param   BaseDatabaseModel  $model      The data model object.
     * @param   array              $validData  The validated data.
     *
     * @return  void
     *
     * @since   v0.0.1
     */
    protected function postSaveHook(BaseDatabaseModel $model, $validData = array ()): void
    {

        if ($this->getTask() === 'save2menu') {
            $editState = [];

            $id = $model->getState('com_uithemebuilderlite.edit.page.id');

            $link = 'index.php?option=com_uithemebuilderlite&view=page&id=' . $id;
            $type = 'component';

            $editState['id']            = $id;
            $editState['link']          = $link;
            $editState['title']         = $model->getItem($id)->title;
            $editState['type']          = $type;
            $editState['request']['id'] = $id;

            $this->app->setUserState('com_menus.edit.item', array (
                    'data' => $editState,
                    'type' => $type,
                    'link' => $link));

            $this->setRedirect(Route::_('index.php?option=com_menus&view=item&client_id=0&menutype=mainmenu&layout=edit', false));
        }
    }

    /**
     * Method override to check if you can add a new record.
     *
     * @param   array  $data  An array of input data.
     *
     * @return  boolean
     *
     * @since   0.0.1
     */
    protected function allowAdd($data = array ()): bool
    {
        $categoryId = ArrayHelper::getValue($data, 'catid', $this->input->getInt('filter_category_id'), 'int');

        if ($categoryId) {
            // If the category has been passed in the data or URL check it.
            return $this->app->getIdentity()->authorise('core.create', 'com_uithemebuilderlite.category.' . $categoryId);
        }

        // In the absence of better information, revert to the component permissions.
        return parent::allowAdd();
    }
}
