<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2023 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/

namespace SW\Component\uiThemeBuilderLite\Administrator\Controller;

// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Router\Route;
use SW\Component\uiThemeBuilderLite\Administrator\Helper\PageHelper;

/**
 * ui-Theme-Builder master display controller.
 *
 * @since  v1.0.0
 */
class DisplayController extends BaseController
{
    /**
     * The default view.
     *
     * @var    string
     *
     * @since  v1.0.0
     */
    protected $default_view = 'pages';

    /**
     * Method to display a view.
     *
     * @param   boolean  $cachable   If true, the view output will be cached
     * @param   array    $urlparams  An array of safe URL parameters and their variable types, for valid values see {@link \JFilterInput::clean()}.
     *
     * @return  BaseController|bool  This object to support chaining.
     *
     * @throws \Exception
     *
     * @since   v1.0.0
     *
     */
    public function display($cachable = false, $urlparams = array()): BaseController|bool
    {
        $view = $this->input->get('view', 'pages');
        $layout = $this->input->get('layout', 'pages');
        $id = $this->input->getInt('id');

        if ($view == 'page' && $layout == 'edit' && !$this->checkEditId('com_uithemebuilderlite.edit.page', $id)) {
            if (!count($this->app->getMessageQueue())) {
                $this->setMessage(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 'error');
            }

            $this->setRedirect(Route::_('index.php?option=com_uithemebuilderlite&view=pages', false));

            return false;
        }

        return parent::display();
    }


    /**
     *
     *
     * @throws \Exception
     * @since v0.0.1
     */
    public function ajaxCallProParams(): void
    {
        $input = Factory::getApplication()->input;
        $class = $input->get('class', '', 'cmd');
        $method = $input->get('method', '', 'cmd');
        $params = $input->get('params', '', 'array');
        if ($paramsClass = PageHelper::getProParams($class)) {
            echo $paramsClass->$method($params);
        }
        exit();
    }

    /**
     * @param   string  $default_view
     *
     * @return DisplayController
     *
     * @since  1.0.0
     */
    public function setDefaultView(string $default_view): DisplayController
    {
        $this->default_view = $default_view;

        return $this;
    }
}
