<?php
/**
 * @package      ui/Theme-Builder Lite
 * @author       Stephan W.
 * @author       url   https://www.ui-themebuilder.com/
 * @copyright    Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
 * @developer    Stephan Wittling - https://www.ui-themebuilder.com/
 *               ui/Theme-Builder Lite is distributed in the hope that it will be useful,
 *               but WITHOUT ANY WARRANTY; without even the implied warranty of
 *               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *               See the GNU General Public License for more details.
 * @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die('Restricted access');


extract($displayData, EXTR_REFS);

$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete == ' autocomplete="on"' ? '' : $autocomplete;

$attributes = array(
    !empty($class) ? 'class="ui-input ' . $class . '"' : 'class="ui-input"',
    !empty($size) ? 'size="' . $size . '"' : '',
    $disabled ? 'disabled' : '',
    $readonly ? 'readonly' : '',
    strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
    !empty($onchange) ? 'onchange="' . $onchange . '"' : '',
    isset($max) ? 'max="' . $max . '"' : '',
    !empty($step) ? 'step="' . $step . '"' : '',
    isset($min) ? 'min="' . $min . '"' : '',
    $required ? 'required aria-required="true"' : '',
    $autocomplete,
    $autofocus ? 'autofocus' : ''
);

if (is_numeric($value)) {
    $value = (float)$value;
} else {
    $value = '';
    $value = ($required && isset($min)) ? $min : $value;
}

// Including fallback code for HTML5 non supported browsers.
JHtml::_('jquery.framework');
JHtml::_('script', 'system/html5fallback.js', array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));

?>
<input type="number" name="<?php echo $name; ?>" id="<?php echo $id; ?>" value="<?php echo
htmlspecialchars($value, ENT_COMPAT, 'UTF-8'); ?>" <?php echo implode(' ', $attributes); ?> />
