<?php
/**
* @package      mod ui/Theme-Builder Pro
* @author       Stephan W.
* @author url   https://www.ui-themebuilder.com/
* @copyright Copyright (C) 2021 ui-themebuilder.com, All rights reserved.
* @developer Stephan Wittling – https://www.ui-themebuilder.com/

*               ui/Theme-Builder Pro is distributed in the hope that it will be useful,
*               but WITHOUT ANY WARRANTY; without even the implied warranty of
*               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*               See the GNU General Public License for more details.

* @license      http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
defined('_JEXEC') or die;


use Joomla\CMS\Helper\ModuleHelper;
use SW\Component\uiThemeBuilderLite\Site\Helper\SitePageHelper;

$moduleclass        = $params->get('moduleclass_sfx') ? ' ' . htmlspecialchars($params->get('moduleclass_sfx'), ENT_COMPAT, 'UTF-8') : '';
$moduleTag          = $params->get('module_tag', 'div');
$components         = SitePageHelper::toArray(json_decode($params->get('elements'), false, 512, JSON_THROW_ON_ERROR));
$modGridChildWidth  = '1-1';
$modGrid            = 'small';
$cacheParams        = $params->get('cache', '0');
$cacheTime          = $params->get('cache_time', '0');
$modID              = md5($module->id * 2.33);

if ($cacheParams == 1) {
    $cache = true;
    if ($cacheTime !== 0) {
        $cacheTime = $params->get('cache_time', '0');
    }
} else {
    $cache      = false;
    $cacheTime  = '';
}

$module->content    = SitePageHelper::loadModComponents($components, $modID, $cache, $cacheTime, $modGridChildWidth, $modGrid);

require ModuleHelper::getLayoutPath('mod_uithemebuilderlite', $params->get('layout', 'default'));
