<?php
/**
* @package		Warp Theme Framework* +, UIKit* v3, Pre.php
* *@copyright	Copyright (C) YOOtheme GmbH
*
* @modified		Stephan W. http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/
namespace Warp\Joomla\Menu;
// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Joomla\CMS\Factory;

/**
 * Menu base class.
 */
class Pre {

	/**
	 * Process menu
	 *
	 * @param   object  $module
	 * @param   object  $element
	 *
	 * @throws \Exception
	 * @since 1.4.3
	 */
	public function process($module, $element)
	{
		global $warp;

		// has ul ?
		if (!$element->first('ul:first')) {
			return false;
		}

		// init vars
		$menu = Factory::getApplication()->getMenu();

		// get warp config
		$config = $warp['config'];

		foreach ($element->find('li') as $li) {

			$item = null;

			//get menu item
			if (preg_match('/item-(\d+)/', $li->attr('class'), $matches)) {
				$item = $menu->getItem($matches[1]);
			}

			//set id
			if (isset($item)) {
				$li->attr('data-id', $item->id);
			}

			//set current and active
			if ($li->hasClass('active') || $li->hasClass('current')) {
				$li->attr('data-menu-active', $li->hasClass('current') == 'current' ? 2 : 1);
			}

			//set columns and width, icons, subtitle
			if (isset($item)) {

				if ($columns = (int) $config->get("menus.{$item->id}.columns")) {
					$li->attr('data-menu-columns', $columns);
				}

				if ($columnwidth = (int) $config->get("menus.{$item->id}.columnwidth")) {
					$li->attr('data-menu-columnwidth', $columnwidth);
				}

				if ($icon = $config->get("menus.{$item->id}.icon")) {
					if (preg_match('/\.(gif|png|jpg|jpeg|svg)$/', $icon)) {
						$li->attr('data-menu-image', $warp['path']->url('site:').$icon);
					} else {
						$li->attr('data-menu-icon', $icon);
					}
				}

				if ($subtitle = $config->get("menus.{$item->id}.subtitle")) {
					$li->attr('data-menu-subtitle', $subtitle);
				}

				if ($moduleid = (int) $config->get("menus.{$item->id}.moduleid")) {
					$li->attr('data-menu-moduleid', $moduleid);
				}

			}

			if($span = $li->first("span:first")) {

				$type = false;


				if ($span->hasClass("nav-header")) {
					$span->parent()->attr('data-menu-header', $span->hasClass('nav-header') === 'nav-header' ? 2 : 1);
					$type = "header";
				}

				if($span->hasClass("separator")) {
					$span->parent()->attr('data-menu-separator', $span->hasClass('separator') == 'separator' ? 2 : 1);
					$isline = preg_match("/^\s*\-+\s*$/", $span->text());
					$type = $isline ? "separator-line" : "separator-text";
				}

				if($type === "header") {
					$span->_replaceWith($span->text());
				} else if($type === "separator-text") {
					$span->_replaceWith('<a class="uk-disabled" href="#" >'.$span->text().'</a>');
				} else if($type === "separator-line") {
					$span->_replaceWith('<span></span>');
				}

			}

			$li->removeAttr('id')->removeAttr('class');
			$li->parent()->removeAttr('class');

		}

		return $element;

	}
}
