<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Template/Layouts
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Layout\LayoutHelper;

// render widgets
$widgets    = $this['widgets']->load($position);
$count      = count($widgets);
$output     = array();
$config     = $this['config'];
$displays   = array_fill_keys(array('@s', '@m', '@l', '@xl', ), array());
$responsive = $config->get("grid.{$position}.responsive", '') ? : '@s';
$stacked    = array_diff($keys = array_keys($displays), array_slice($keys, array_search($responsive, $keys, true)));

$user = Factory::getApplication()->getIdentity();

/*$params           = [];
foreach ($widgets as $index => $widget) {


	// set widget params
	$params['count']  = $count;
	$params['order']  = $index + 1;
	$params['first']  = $params['order'] == 1;
	$params['last']   = $params['order'] == $count;
	$params['suffix'] = $widget->parameter->get('moduleclass_sfx', '');

	// pass through menu params
	if ($widget->menu) {
		$widget->nav_settings = array('scrollspy' => false);
	}

    $params = array_merge($params, $config->get('widgets.'.$widget->id, array()));

	// render widget
	$output[] = $this->render('widget', compact('widget', 'params'));

    if ($this['config']['frontediting'] && $user->authorise('core.edit', 'com_modules.module.' . $widget->id)) {

        LayoutHelper::render('joomla.edit.frontediting_modules', array(
            'moduleHtml'   => &$output[$index],
            'module'       => $widget,
            'position'     => $position,
            'menusediting' => $this['config']['frontendMenuEditing']
        ));
    }

    foreach ($displays as $name => &$display) {
        if ($config->get("widgets.{$widget->id}.display.{$name}", true)) {
            $display[] = $index;
        }
    }
}*/

$params = []; // create empty array outside of loop
foreach ($widgets as $index => $widget) {
	// set widget-specific params
	$widgetParams = [
		'count' => $count,
		'order' => $index + 1,
		'first' => $index === 0,
		'last' => $index === $count - 1,
		'suffix' => $widget->parameter->get('moduleclass_sfx', ''),
	];
	$params += $widgetParams; // a shorthand array union
	// pass through menu params
	if ($widget->menu) {
		$widget->nav_settings = ['scrollspy' => false];
	}
	$widgetConfig = $config->get('widgets.'.$widget->id, []);
	$params += $widgetConfig; // shorthand array union
	// render widget
	$output[] = $this->render('widget', compact('widget', 'params'));
	// edit widget if frontediting is enabled
	if ($this['config']['frontediting'] && $user->authorise('core.edit', 'com_modules.module.' . $widget->id)) {
		LayoutHelper::render('joomla.edit.frontediting_modules', [
			'moduleHtml' => &$output[$index],
			'module' => $widget,
			'position' => $position,
			'menusediting' => $this['config']['frontendMenuEditing'],
		]);
	}
	// update display array
	foreach ($displays as $name => &$display) {
		if ($config->get("widgets.{$widget->id}.display.{$name}", true)) {
			$display[] = $index;
		}
	}
}

// render widget layout
echo (isset($layout) && $layout) ? $this->render("grid/{$layout}", array('widgets' => $output, 'displays' => $displays, 'stacked' => $stacked)) : implode("\n", $output);
