<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Template/Layouts
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

// get theme configuration
include($this['path']->path('layouts:theme.config.php'));


// output navbar ?>
<?php if ($this['widgets']->count('menu') ||
		$this['widgets']->count('menusplit') ||
		$this['widgets']->count('logo') ||
		$this['widgets']->count('offcanvas') ||
		$this['widgets']->count('search') ||
		$this['widgets']->count('login') ||
		$this['widgets']->count('transparent')) : ?>

	<?php // Transparent Navbar + transparent Position ?>
	<?php if ($this['widgets']->count('transparent') ) { ?>

		<div class="uk-position-relative">
			<?php if ($this['widgets']->count('transparent')) : ?>
				<div class="uk-container uk-container-expand uk-padding-remove-horizontal">
					<?php echo $this['widgets']->render('transparent'); ?>
				</div>
			<?php endif; ?>
			<div class="uk-position-top">

				<?php echo $this['config']->get('navbars.navbar.sticky_navbar') ? '<div'.$navbar_attr_sticky.'>' : ''; ?>

					<?php // Navbar + Logo center ?>
					<?php if ( $this['config']->get('navbars.navbar.center_navbar_logo') && $this['widgets']->count('menu') && $this['widgets']->count('menusplit') ) { ?>

						<nav class="uk-navbar-container<?php echo $navbar_transparent; ?><?php echo $navbar_color_mode; ?>">
							<?php if (!empty($navbar_container)) : ?>
								<div class="<?php echo $navbar_container; ?>">
							<?php endif; ?>
									<div class="<?php echo $navbar_text_bold; ?>" itemscope itemtype="http://schema.org/SiteNavigationElement"<?php echo $navbar_attr; ?>>

										<?php if ($this['widgets']->count('offcanvas')) : ?>
											<div class="uk-navbar-left uk-hidden@l">
												<?php if ($this['config']->get('boxed_layouts')) : ?><div class="uk-navbar-item"><?php endif; ?>
													<a class="uk-navbar-toggle" href="#offcanvas" uk-navbar-toggle-icon="" uk-toggle=""></a>
												<?php if ($this['config']->get('boxed_layouts')) : ?></div><?php endif; ?>
											</div>
										<?php endif; ?>

										<div class="uk-navbar-center">
											<div class="uk-navbar-center-left">
												<div>
													<?php echo $this['widgets']->render('menu'); ?>
												</div>
											</div>
											<?php if ($this['widgets']->count('logo')) : ?>
												<a class="uk-navbar-item uk-logo uk-visible@l" href="<?php echo $this['config']->get('site_url'); ?>"><?php echo $this['widgets']->render('logo'); ?></a>
											<?php endif; ?>
											<div class="uk-navbar-center-right uk-visible@l">
												<div>
													<?php echo $this['widgets']->render('menusplit'); ?>
												</div>
											</div>
										</div>

										<?php if ($this['widgets']->count('search') || $this['widgets']->count('login')) : ?>
											<div class="uk-navbar-right">
												<?php if ($this['config']->get('boxed_layouts')) : ?><div class="uk-navbar-item"><?php endif; ?>
													<?php if ($this['widgets']->count('search')) : ?><a class="uk-navbar-toggle" title="<?php echo Text::_('JSEARCH_FILTER'); ?>" href="#modal-full-search" uk-search-icon="" uk-toggle=""></a><?php endif; ?>
													<?php if ($this['widgets']->count('login')) : ?><a class="uk-navbar-toggle" title="<?php echo Text::_('JACTION_LOGIN_SITE'); ?>" href="#modal-full-login" uk-toggle=""><span uk-icon="icon: user"></span></a><?php endif; ?>
												<?php if ($this['config']->get('boxed_layouts')) : ?></div><?php endif; ?>
											</div>
										<?php endif; ?>

									</div>
							<?php if (!empty($navbar_container)) : ?>
								</div>
							<?php endif; ?>
						</nav>

					<?php // Navbar + Logo left ?>
					<?php } else { ?>

						<nav class="uk-navbar-container<?php echo $navbar_transparent; ?><?php echo $navbar_color_mode; ?>">
							<?php if (!empty($navbar_container)) : ?>
								<div class="<?php echo $navbar_container; ?>">
							<?php endif; ?>
									<div class="<?php echo $navbar_text_bold; ?>" itemscope itemtype="https://schema.org/SiteNavigationElement"<?php echo $navbar_attr; ?>>

										<?php if ($this['widgets']->count('logo')) : ?>
											<div class="uk-navbar-left uk-visible@l">
												<a class="uk-navbar-item uk-logo" href="<?php echo $this['config']->get('site_url'); ?>"><?php echo $this['widgets']->render('logo'); ?></a>
											</div>
										<?php endif; ?>

										<?php if ($this['widgets']->count('menu')) : ?>
											<div class="<?php echo $this['widgets']->count('logo') ? 'uk-navbar-center uk-visible@l' : 'uk-navbar-left uk-visible@l' ?>">
												<?php echo $this['widgets']->render('menu'); ?>
											</div>
										<?php endif; ?>

										<?php if ($this['widgets']->count('offcanvas')) : ?>
											<div class="uk-navbar-left uk-hidden@l">
												<?php if ($this['config']->get('boxed_layouts')) : ?><div class="uk-navbar-item"><?php endif; ?>
													<a class="uk-navbar-toggle" href="#offcanvas" uk-navbar-toggle-icon="" uk-toggle=""></a>
												<?php if ($this['config']->get('boxed_layouts')) : ?></div><?php endif; ?>
											</div>
										<?php endif; ?>

										<?php if ($this['widgets']->count('search') || $this['widgets']->count('login')) : ?>
											<div class="uk-navbar-right">
												<?php if ($this['config']->get('boxed_layouts')) : ?><div class="uk-navbar-item"><?php endif; ?>
													<?php if ($this['widgets']->count('search')) : ?><a class="uk-navbar-toggle" title="<?php echo Text::_('JSEARCH_FILTER'); ?>" href="#modal-full-search" uk-search-icon="" uk-toggle=""></a><?php endif; ?>
													<?php if ($this['widgets']->count('login')) : ?><a class="uk-navbar-toggle" title="<?php echo Text::_('JACTION_LOGIN_SITE'); ?>" title="<?php echo Text::_('JACTION_LOGIN_SITE'); ?>" href="#modal-full-login" uk-toggle=""><span uk-icon="icon: user"></span></a><?php endif; ?>
												<?php if ($this['config']->get('boxed_layouts')) : ?></div><?php endif; ?>
											</div>
										<?php endif; ?>
									</div>
							<?php if (!empty($navbar_container)) : ?>
								</div>
							<?php endif; ?>
						</nav>

					<?php } ?>

				<?php echo $this['config']->get('navbars.navbar.sticky_navbar') ? '</div>' : ''; ?>

			</div>
		</div>

		<?php // Default Navbar ?>
	<?php } else { ?>

		<?php echo $this['config']->get('navbars.navbar.sticky_navbar') ? '<div'.$navbar_attr_sticky.'>' : ''; ?>

			<?php // Navbar + Logo center ?>
			<?php if ( $this['config']->get('navbars.navbar.center_navbar_logo') && 
						$this['widgets']->count('menu') && 
						$this['widgets']->count('menusplit') ) { ?>

				<nav class="uk-navbar-container<?php echo $navbar_transparent; ?><?php echo $navbar_color_mode; ?>">
					<?php if (!empty($navbar_container)) : ?>
						<div class="<?php echo $navbar_container; ?>">
					<?php endif; ?>
							<div class="<?php echo $navbar_text_bold; ?>" itemscope itemtype="https://schema.org/SiteNavigationElement"<?php echo $navbar_attr; ?>>

								<div class="uk-navbar-center">

									<?php if ($this['widgets']->count('offcanvas')) : ?>
										<a class="uk-navbar-toggle uk-hidden@l" href="#offcanvas" uk-navbar-toggle-icon="" uk-toggle=""></a>
									<?php endif; ?>

									<div class="uk-navbar-center-left uk-visible@l">
										<div>
											<?php echo $this['widgets']->render('menu'); ?>
										</div>
									</div>

									<?php if ($this['widgets']->count('logo')) : ?>
										<a class="uk-navbar-item uk-logo uk-visible@l" href="<?php echo $this['config']->get('site_url'); ?>"><?php echo $this['widgets']->render('logo'); ?></a>
									<?php endif; ?>

									<div class="uk-navbar-center-right uk-visible@l">
										<div>
											<?php echo $this['widgets']->render('menusplit'); ?>
										</div>
									</div>
								</div>

								<?php if ($this['widgets']->count('search') ||
										$this['widgets']->count('login')) : ?>
									<div class="uk-navbar-right">
										<?php if ($this['config']->get('boxed_layouts')) : ?><div class="uk-navbar-item"><?php endif; ?>
											<?php if ($this['widgets']->count('search')) : ?><a class="uk-navbar-toggle" title="<?php echo Text::_('JSEARCH_FILTER'); ?>" href="#modal-full-search" uk-search-icon="" uk-toggle=""></a><?php endif; ?>
											<?php if ($this['widgets']->count('login')) : ?><a class="uk-navbar-toggle" title="<?php echo Text::_('JACTION_LOGIN_SITE'); ?>" href="#modal-full-login" uk-toggle=""><span uk-icon="icon: user"></span></a><?php endif; ?>
										<?php if ($this['config']->get('boxed_layouts')) : ?></div><?php endif; ?>
									</div>
								<?php endif; ?>

							</div>
					<?php if (!empty($navbar_container)) : ?>
						</div>
					<?php endif; ?>
				</nav>

			<?php // Navbar + Logo left ?>
			<?php } else { ?>

				<nav class="uk-navbar-container<?php echo $navbar_transparent; ?><?php echo $navbar_color_mode; ?>">
					<?php if (!empty($navbar_container)) : ?>
						<div class="<?php echo $navbar_container; ?>">
					<?php endif; ?>

							<div class="<?php echo $navbar_text_bold; ?>" itemscope itemtype="https://schema.org/SiteNavigationElement"<?php echo $navbar_attr; ?>>

								<?php if ($this['widgets']->count('logo')) : ?>
									<div class="uk-navbar-left uk-visible@l">
										<a class="uk-navbar-item uk-logo" href="<?php echo $this['config']->get('site_url'); ?>"><?php echo $this['widgets']->render('logo'); ?></a>
									</div>
								<?php endif; ?>

								<?php if ($this['widgets']->count('menu')) : ?>
									<div class="<?php echo $this['widgets']->count('logo') ? 'uk-navbar-center uk-visible@l' : 'uk-navbar-left uk-visible@l' ?>">
										<?php echo $this['widgets']->render('menu'); ?>
									</div>
								<?php endif; ?>

								<?php if ($this['widgets']->count('offcanvas')) : ?>
									<div class="uk-navbar-left uk-hidden@l">
										<?php if ($this['config']->get('boxed_layouts')) : ?><div class="uk-navbar-item"><?php endif; ?>
											<a class="uk-navbar-toggle" href="#offcanvas" uk-navbar-toggle-icon="" uk-toggle=""></a>
										<?php if ($this['config']->get('boxed_layouts')) : ?></div><?php endif; ?>
									</div>
								<?php endif; ?>

								<?php if ($this['widgets']->count('search') || 
											$this['widgets']->count('login')) : ?>
									<div class="uk-navbar-right">
										<?php if ($this['config']->get('boxed_layouts')) : ?><div class="uk-navbar-item"><?php endif; ?>
											<?php if ($this['widgets']->count('search')) : ?><a class="uk-navbar-toggle" title="<?php echo Text::_('JSEARCH_FILTER'); ?>" href="#modal-full-search" uk-search-icon="" uk-toggle=""></a><?php endif; ?>
											<?php if ($this['widgets']->count('login')) : ?><a class="uk-navbar-toggle" title="<?php echo Text::_('JACTION_LOGIN_SITE'); ?>" href="#modal-full-login" uk-toggle=""><span uk-icon="icon: user"></span></a><?php endif; ?>
										<?php if ($this['config']->get('boxed_layouts')) : ?></div><?php endif; ?>
									</div>
								<?php endif; ?>

							</div>
					<?php if (!empty($navbar_container)) : ?>
						</div>
					<?php endif; ?>
				</nav>
			<?php } ?>

		<?php echo $this['config']->get('navbars.navbar.sticky_navbar') ? '</div>' : ''; ?>

	<?php } ?>

<?php endif; ?>
