<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Template/Layouts
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;

// get theme configuration
include($this['path']->path('layouts:theme.config.php'));

/*
 * Add assets
 */

// CSS
$this['asset']->addFile('css', 'css:google-fonts-local.css');

$this['asset']->addFile('css', 'css:fontawesome.css', array('rel' => 'lazy-stylesheet'));

// Load theme.css and if exists custom.css
$this['asset']->addFile('css', 'css:theme.css');
if ($style = $this['config']->get('style'))
{
	foreach (array('css' => 'theme:styles/%s/css', 'js' => 'theme:styles/%s/js', 'layouts' => 'theme:styles/%s/layouts') as $name => $resource) {
		if ($p = $this['path']->path(sprintf($resource, $style)))
		{
			$custom_css	= $p . '/custom.css';
			if( file_exists($custom_css) )
			{
				$this['asset']->addFile('css', 'css:custom.css');
			}
		}
	}
}

// JS
// $jquery = JHtml::script('media/vendor/jquery/jquery.min.js', array('relative' => false, 'version' => 'auto', 'pathOnly' => true));
// $this['asset']->addFile('js', $jquery);
HTMLHelper::_('jquery.framework');

/*if ($this['config']->get('bootstrap', true)) {
	HTMLHelper::stylesheet('media/vendor/bootstrap/css/bootstrap.css', array('relative' => false, 'version' => 'auto'));
	$bootstrap = HTMLHelper::script('media/vendor/bootstrap/js/bootstrap-es5.js', array('relative' => false, 'version' => 'auto', 'pathOnly' => true));
	$this['asset']->addFile('js', $bootstrap);
}*/

$uikitJs        = HTMLHelper::script('templates/uithemebuilder/js/uikit.min.js', array('relative' => false, 'version' => 'auto', 'pathOnly' => true));
$uikit_iconsJs  = HTMLHelper::script('templates/uithemebuilder/js/uikit-icons.min.js', array('relative' => false, 'version' => 'auto', 'pathOnly' => true));
$theme_js       = HTMLHelper::script('templates/uithemebuilder/js/theme.js', array('relative' => false, 'version' => 'auto', 'pathOnly' => true));

$this['asset']->addFile('js', $uikitJs);
$this['asset']->addFile('js', $uikit_iconsJs);
$this['asset']->addFile('js', $theme_js);

// Load the javascript video player from vimeo.com
if ($this['config']['javascript_vimeo']) :
	$vPlayer = HTMLHelper::script('media/com_uithemebuilderlite/js/player.min.js', array('relative' => false, 'version' => 'auto', 'pathOnly' => true));
	$vimeoPlayer = HTMLHelper::script('media/com_uithemebuilderlite/js/uivimeoplayer.js', array('relative' => false, 'version' => 'auto', 'pathOnly' => true));

	$this['asset']->addFile('js', $vPlayer);
	$this['asset']->addFile('js', $vimeoPlayer);
endif;

// Output as HTML5
if ($this['system']->document->getType() === 'html') {
	$this['system']->document->setHtml5(true);
} ?>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<?php if($this['config']->get('responsive', true)): ?>
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php endif; ?>
<?php if($this['config']->get('responsive_handheldfriendly', true)): ?>
<meta name="HandheldFriendly" content="true" />
<?php endif; ?>
<?php if (isset($error)): ?>
	<?php if($this['config']->get('meta_refresh', true) && $error == '404' ): ?>
		<meta http-equiv="refresh" content="3;url=<?php echo Uri::base() ?>" />
	<?php endif; ?>
	<title><?php echo $error; ?> - <?php echo $title; ?></title>
<?php else: ?>
	<jdoc:include type="head" />
<?php endif;

$currentUrl = Uri::getInstance()->toString(); ?>
<link rel="canonical" href="<?php echo $currentUrl; ?>">
<meta name="robots" content="max-snippet:-1, max-image-preview:large, max-video-preview:-1">

<?php
$apple_touch_icon = JPATH_ROOT . '/templates/uithemebuilder/apple_touch_icon.png';
if( file_exists($apple_touch_icon) ) { ?>
	<link rel="apple-touch-icon-precomposed" href="<?php echo $this['path']->url('theme:apple_touch_icon.png'); ?>">
<?php
}

// get styles and scripts
$styles  = $this['asset']->get('css');
$scripts = $this['asset']->get('js');

// load bootstrap styles
/* if ($this['config']->get('bootstrap', true) && $file = $this['path']->url('css:bootstrap.css')) {
	HTMLHelper::_('bootstrap.framework');
	$styles->prepend($bootstrap = $this['asset']->createFile($file));
} */

// customizer mode
if ($this['config']['customizer'])
{
	foreach ($this['config']['less']['files'] as $file => $less)
	{

		foreach ($styles as $style)
		{
			$url = $style->getUrl();
			if (str_ends_with($url, $file))
			{
				$style['data-file'] = $file;
				break;
			}
		}
	}
}
// developer mode
else if ($this['config']['dev_mode'])
{

    // less files & filter
    $files  = array();
    $filter = $this['assetfilter']->create(array('CssImportResolver', 'CssRewriteUrl'));

	foreach ($styles as $style) {

        if (!$style instanceof Warp\Asset\FileAsset) continue;

		$file = sprintf('less:%s.less', basename($style->getPath(), '.css'));

		if ($this['path']->path($file)) {

			$source = $this['asset']->createFile($file)->getContent($filter).PHP_EOL;

			if ($this['config']['style'] === 'default') {
				$source .= $this['asset']->createFile('less:style.less')->getContent();
			} else {
				$source .= $this['asset']->createFile(sprintf('theme:styles/%s/style.less', $this['config']['style']))->getContent();
			}

            $files[] = array('target' => basename($style->getPath()), 'source' => $this['asset']->createString($source, array_merge($style->getOptions(), array('type' => 'text/less')))->getContent());

            $styles->replace($style, $this['asset']->createString('', array_merge($style->getOptions(), array('data-file' => basename($style->getPath())))));
        }
    }

    $this['asset']->addString('js', 'var less = { env: "development" }, files = '. json_encode($files, JSON_THROW_ON_ERROR) .';');
    $this['asset']->addFile('js', 'warp:vendor/jquery/jquery-less.js');
    $this['asset']->addFile('js', 'warp:vendor/jquery/jquery-rtl.js');
    $this['asset']->addFile('js', 'warp:vendor/less/less.js');
    $this['asset']->addFile('js', 'warp:js/developer.js');

}
// compress styles and scripts
else if ($compression = $this['config']['compression'] or $this['config']['direction'] === 'rtl')
{

	$options = array();
	$filters = array('CssImportResolver', 'CssRewriteUrl');

	// set options
	if ($compression == 3) {
		$options['Gzip'] = true;
	}

	// set filter
	if ($this['config']['direction'] === 'rtl') {
		$filters[] = 'CssRtl';
	}

	if ($compression >= 2 && ($this['useragent']->browser() !== 'msie' || version_compare($this['useragent']->version(), '8.0', '>='))) {
		$filters[] = 'CssImageBase64';
	}

	// cache styles and check for remote styles
	if ($styles) {

		// if (isset($bootstrap)) {
			// $styles->remove($bootstrap);
		// }

		$styles = array($this['asset']->cache('theme.css', $styles, array_merge($filters, array('CssCompressor')), $options));

		foreach ($styles[0] as $style) {
			if ($style->getType() === 'File' && !$style->getPath()) {
				$styles[] = $style;
			}
		}

		// if (isset($bootstrap)) {
			// array_unshift($styles, $this['asset']->cache('bootstrap.css', $bootstrap, array_merge($filters, array('CssCompressor')), $options));
		// }
	}

	// cache scripts and check for remote scripts
	if ($scripts)
	{

		$scripts = array($this['asset']->cache('theme.js', $scripts, array('JsCompressor'), $options));

		foreach ($scripts[0] as $script)
		{
			if ($script->getType() === 'File' && !$script->getPath())
			{
				$scripts[] = $script;
			}
		}
	}

	// compress joomla styles and scripts
	$head = $this['system']->document->getHeadData();
	$data = array('styleSheets' => array(), 'scripts' => array());

	foreach ($head['styleSheets'] as $style => $meta)
	{

		if (preg_match('/\.css$/i', $style)) {
			$asset = $this['asset']->createFile($style);
			if ($asset->getPath()) {
				$style = $this['asset']->cache(basename($style), $asset, array('CssImportResolver', 'CssRewriteUrl', 'CssCompressor'), $options)->getUrl();
			}
		}

		$data['styleSheets'][$style] = $meta;
	}

	foreach ($head['scripts'] as $script => $meta)
	{

		if (preg_match('/\.js$/i', $script))
		{
			$asset = $this['asset']->createFile($script);
			if ($asset->getPath())
			{
				$script = $this['asset']->cache(basename($script), $asset, array('JsCompressor'), $options)->getUrl();
			}
		}

		$data['scripts'][$script] = $meta;
	}

	$this['system']->document->setHeadData(array_merge($head, $data));
}

// add styles
if ($styles)
{
	foreach ($styles as $style)
	{
		if ($url = $style->getUrl())
		{
			printf("<link href=\"%s?%s\" %srel=\"stylesheet\">%s", $url, $version, isset($style['data-file']) ? 'data-file="'.$style['data-file'].'" ' : '', "\n");
		} else {
			printf("<style %s>%s</style>\n", $this['field']->attributes($style->getOptions(), array('base_path', 'base_url')), $style->getContent());
		}
	}
}

// add scripts
if ($scripts)
{
	foreach ($scripts as $script)
	{
		if ($url = $script->getUrl())
		{
			printf("<script src=\"%s?%s\"></script>%s", $url, $version, "\n");
		} else {
			printf("<script>%s</script>\n", $script->getContent());
		}
	}
}

$this->output('head');
