<?php
/**
* @package		Warp Theme Framework* +, UIKit* v3, article_defaults.php**
* *@copyright	Copyright (C) YOOtheme GmbH
*
* @modified**	Stephan W. http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/
// no direct access
defined('_JEXEC') or die('Restricted access');


use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\CMS\Layout\LayoutHelper;

$default_args = array(
	'permalink' => '',
	'image' => '',
	'image_alignment' => '',
	'image_alt' => '',
	'image_caption' => '',
	'intro_image' => '',
	'float_intro' => '',
	'title' => '',
	'title_link' => '',
	'author' => '',
	'author_url' => '',
	'date' => '',
	'datetime' => '',
	'category' => '',
	'category_url' => '',
	'hook_aftertitle' => '',
	'hook_beforearticle' => '',
	'hook_afterarticle' => '',
	'content_language' => '',
	'article' => '',
	'tags' => '',
	'edit' => '',
	'url' => '',
	// 'more' => '',
	'previous' => '',
	'prev_title' => '',
	'next' => '',
	'next_title' => '',
	'is_column_item' => ''
);

if (!isset($item, $params)) {
    return $default_args;
}

// Create shortcuts to some parameters.
$images	= json_decode($item->images, false, 512, JSON_THROW_ON_ERROR);

if ($params->get('access-view')) :
	$link = Route::_(RouteHelper::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language));
else :
	$menu = Factory::getApplication()->getMenu();
	$active = $menu->getActive();
	$itemId = $active->id;
	// #ToDo load Modal
	$link = new Uri(Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId . '&tmpl=component', false));
	$link->setVar('return', base64_encode(RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language)));
endif;

$args = array_merge($default_args, array(
	// 'permalink'			=> ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language),

	'image'					=> isset($images->image_fulltext) && $params->get('access-view') ? htmlspecialchars($images->image_fulltext, ENT_COMPAT, 'UTF-8') : '',
	'image_alignment'		=> empty($images->float_fulltext) ? htmlspecialchars($params->get('float_fulltext')) : htmlspecialchars($images->float_fulltext),
	'image_alt'				=> isset($images->image_fulltext_alt) ? htmlspecialchars($images->image_fulltext_alt) : '',
	'image_caption'			=> isset($images->image_fulltext_caption) ? htmlspecialchars($images->image_fulltext_caption) : '',

	'intro_image'			=> isset($images->image_intro) && $params->get('access-view') ? htmlspecialchars($images->image_intro, ENT_COMPAT, 'UTF-8') : '',
	'float_intro'			=> empty($images->float_intro) ? htmlspecialchars($params->get('float_intro')) : htmlspecialchars($images->float_intro),
	'image_intro_alt'		=> isset($images->image_intro_alt) ? htmlspecialchars($images->image_intro_alt) : '',
	'image_intro_caption'	=> isset($images->image_intro_caption) ? htmlspecialchars($images->image_intro_caption) : '',

	'title'				=> $params->get('show_title') ? $this->escape($this->item->title) : '',
	'title_link'		=> $params->get('link_titles'),
	'title_link_url'	=> $params->get('show_title') || $params->get('link_titles') || (isset($images->image_intro) && ($params->get('access-view') || $params->get('show_noauth', '0') == '1') ) ? Route::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language)) : '',

	'author'			=> $params->get('show_author') ? ($item->created_by_alias ? $item->created_by_alias : $item->author) : '',
	'author_url'		=> !empty($item->contactid) && $params->get('link_author') == true ? Route::_('index.php?option=com_contact&view=contact&id='.$item->contactid) : '',

	'date'				=> $params->get('show_create_date') ? $item->created : '',
	'date_published'	=> $params->get('show_publish_date') ? $item->publish_up : '',
	'date_modified'		=> $params->get('show_modify_date') ? $item->modified : '',

	'datetime'			=> substr($item->publish_up, 0, 10),

	'category'			=> $params->get('show_category') ? $this->escape($item->category_title) : '',
	'category_url'		=> $params->get('link_category') ? Route::_(RouteHelper::getCategoryRoute($item->catid, $item->category_language)) : '',
	'parent_category'	=> $params->get('show_parent_category') ? $this->escape($item->category_title) : '',

	'hits'				=> $params->get('show_hits') ? $this->item->hits : '',

	'show_tags'			=> $params->get('show_tags') && !empty($item->tags->itemTags) ? LayoutHelper::render('joomla.content.tags', $item->tags->itemTags) : '',
	'info'				=> $params->get('info_block_position', 0) ?: '',

	'info_block_above'		=> LayoutHelper::render('joomla.content.info_block', array('item' => $item, 'params' => $params, 'position' => 'above')),
	'info_block_below'		=> LayoutHelper::render('joomla.content.info_block', array('item' => $item, 'params' => $params, 'position' => 'below')),

	'hook_aftertitle'		=> !$params->get('show_intro') ? $item->event->afterDisplayTitle : '',
	'hook_beforearticle'	=> $item->event->beforeDisplayContent.($item->toc ?? ''),
	'hook_afterarticle'		=> $item->event->afterDisplayContent,

	'more' 				 => $params->get('show_readmore') ? LayoutHelper::render('joomla.content.readmore', array('item' => $item, 'params' => $params, 'link' => $link)) : '',
	'more_small' 		 => $params->get('show_readmore') ? LayoutHelper::render('joomla.content.readmore_small', array('item' => $item, 'params' => $params, 'link' => $link)) : '',

	'article_intro'			=> $params->get('show_intro') ? $item->introtext : '',

	'content_language'		=> ($item->language === '*') ? Factory::getApplication()->get('language') : $item->language,

	'associations'		=> $params->get('show_associations') ? LayoutHelper::render('joomla.content.info_block.associations_single_article', array('item' => $item, 'params' => $params)) : ''

));


return $args;
