<?php
/**
 * @package		Warp Theme Framework* +, UIKit* v3, default.php**
 * *@copyright	Copyright (C) YOOtheme GmbH
 *
 * @modified**		Stephan W. http://www.3d-hobby-art.de
 * @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Tags\Site\Helper\RouteHelper;
use Joomla\CMS\Language\Text;

// Create a shortcut for params.
$item    = $this->item;
$params  = $item->params;
$urls	 = json_decode($item->urls, false, 512, JSON_THROW_ON_ERROR);
$canEdit = $params->get('access-edit');
$user	 = Factory::getApplication()->getIdentity();
$args 	 = include(__DIR__.'/../article_defaults.php');

// get view
$menu = Factory::getApplication()->getMenu()->getActive();
$view = is_object($menu) && isset($menu->query['view']) ? $menu->query['view'] : null;

if ($view === 'article')
{
	$args['permalink'] = '';
}

if ($this->params->get('show_page_heading')) {
	echo '<h1>'.$this->escape($this->params->get('page_heading')).'</h1>';
}

// set author_url
if (!empty($item->contactid) && $params->get('link_author') == true) {
	$needle = 'index.php?option=com_contact&view=contact&id=' . $item->contactid;
	$menu = Factory::getApplication()->getMenu();
	$item = $menu->getItems('link', $needle, true);
	$args['author_url'] = !empty($item) ? $needle . '&Itemid=' . $item->id : $needle;
}

// set article
$article = "";
if ($params->get('access-view')) {

	if (!empty($item->pagination) && !$item->paginationposition && $item->paginationrelative) {
		$article .= $item->pagination;
	}

	if ( (isset($urls) && ((!empty($urls->urls_position) && ($urls->urls_position == '0')) || ($params->get('urls_position') == '0' && empty($urls->urls_position))))
		|| (empty($urls->urls_position) && (!$params->get('urls_position')))) {
			$article .= $this->loadTemplate('links');
	}

	$article .= $item->text;

	if (isset($urls) && ((!empty($urls->urls_position)  && ($urls->urls_position=='1')) || ( $params->get('urls_position')=='1') )) {
		$article .= $this->loadTemplate('links');
	}

// optional teaser intro text for guests
} elseif ($params->get('show_noauth') == true && $user->get('guest')) {

	$article .= $item->introtext;

	// optional link to let them register to see the article.
	if ($params->get('show_readmore') && $item->fulltext != null) {
		$menu = Factory::getApplication()->getMenu();
		$active = $menu->getActive();
		$itemId = $active->id;
		$link = new Uri(Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false));
		$link->setVar('return', base64_encode(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language)));
		$article .= '<p class="links">';
		$article .= '<a href="'.$link.'">';
			$attribs = json_decode($item->attribs, false, 512, JSON_THROW_ON_ERROR);

			if ($attribs->alternative_readmore === null) {
				$article .= Text::_('COM_CONTENT_REGISTER_TO_READ_MORE');
			} elseif ($readmore = $item->alternative_readmore) {
				$article .= $readmore;
				if ($params->get('show_readmore_title', 0) !== 0) {
					$article .= JHtml::_('string.truncate', ($item->title), $params->get('readmore_limit'));
				}
			} elseif ($params->get('show_readmore_title', 0) === 0) {
				$article .= Text::sprintf('COM_CONTENT_READ_MORE_TITLE');
			} else {
				$article .= Text::_('COM_CONTENT_READ_MORE');
				$article .= JHtml::_('string.truncate', ($item->title), $params->get('readmore_limit'));
			}

		$article .= '</a></p>';
	}
}

$args['article'] = $article;

// set tags
$tags = '';
if ($params->get('show_tags', 1) && !empty($item->tags->itemTags)) {
	$tags .= '<ul class="ui-tags uk-grid-small uk-child-width-auto" uk-grid="">';
	foreach ($item->tags->itemTags as $tag) {
		if ( in_array($tag->access, JAccess::getAuthorisedViewLevels(Factory::getApplication()->getIdentity()->get('id')), true) ) {
			$tags .= '<li><a class="tm-tags" href="' . Route::_(RouteHelper::getComponentTagRoute($tag->tag_id . ':' . $tag->alias)) . '"><span itemprop="keywords">' . $this->escape($tag->title) . '</span></a></li>';
		}
	}
	$tags .= '</ul>';

}

$args['tags'] = $tags;

// set edit
if (!$this->print) {
	$attrs = array('class' => 'uk-margin-right');

	$args['edit']  = $canEdit ? LayoutHelper::render('joomla.content.icons', array('params' => $params, 'item' => $item)) : '';
	// $args['edit'] .= $params->get('show_print_icon') ? JHtml::_('icon.print_popup', $this->item, $params, $attrs) : '';
	// $args['edit'] .= $params->get('show_email_icon') ? JHtml::_('icon.email', $this->item, $params, $attrs) : '';
} // else {
	// $args['edit'] = JHtml::_('icon.print_screen', $this->item, $params);
// }

// set previous and next
if (!empty($item->pagination)) {

	if ($item->prev) {
		$args['previous'] = ($prev = $item->prev) ? $prev : '';

		$url = JPATH_BASE . '/' . $item->prev;
		$url_components = parse_url($url);

		// Use parse_str() function to parse the
		// string passed via URL.
		parse_str($url_components['query'], $params);
		$url_id = $params['id'];
		$exploded_url_id =  explode(":",$url_id);
		$article_id = $exploded_url_id[0];

		$article = Table::getInstance("content");
		$article->load($article_id);

//		$db = Factory::getDbo();
		$db    = Factory::getContainer()->get('DatabaseDriver');
		$db->setQuery('SELECT catid 
					  FROM #__content
					  WHERE id = ' . $article_id);
		$cat = $db->loadResult(); 

//		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName('path'))
			->from($db->quoteName('#__menu'))
			->where($db->quoteName('link') . ' LIKE ' . $db->quote('%?option=com_content&view=category&id=' . $cat . '%'));

		$db->setQuery($query);

		$path = $db->loadResult();
		$article_prev_title = $article->get("title"); 

		$args['prev_title'] = ($prev_title = $article_prev_title) ? $prev_title : '';

	}

	if ($item->next) {
		$args['next'] = ($next = $item->next) ? $next : '';

		$url = JPATH_BASE . '/' . $item->next;
		$url_components = parse_url($url);
	 
		// Use parse_str() function to parse the
		// string passed via URL.
		parse_str($url_components['query'], $params);
		$url_id = $params['id'];
		$exploded_url_id =  explode(":",$url_id);
		$article_id = $exploded_url_id[0];

		$article = Table::getInstance("content");
		$article->load($article_id);

//		$db = Factory::getDbo();
		$db    = Factory::getContainer()->get('DatabaseDriver');
		$db->setQuery('SELECT catid 
					 FROM #__content
					 WHERE id = ' . $article_id);
		$cat = $db->loadResult(); 

//		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName('path'))
			->from($db->quoteName('#__menu'))
			->where($db->quoteName('link') . ' LIKE ' . $db->quote('%?option=com_content&view=category&id=' . $cat . '%'));

		$db->setQuery($query);

		$path = $db->loadResult(); 
		$article_next_title = $article->get("title");

		$args['next_title'] = ($next_title = $article_next_title) ? $next_title : '';

	}
}

// render template
echo $warp['template']->render('article', $args);
