<?php
/**
* @package		Warp Theme Framework* +, UIKit* v3, check.php**
* *@copyright	Copyright (C) YOOtheme GmbH
*
* @modified**	Stephan W. http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');


// check common
$this['check']->checkCommon();

// check writable
foreach (array($this['path']->path('cache:'), $this['path']->path('theme:'), $this['path']->path('admin:/templates/system')) as $directory) {
	$this['check']->checkWritable($directory);
}

// output
$critical = $this['check']->getIssues('critical');
$notice   = $this['check']->getIssues('notice');

if ($critical || $notice) {

	$label = array();

	if ($critical) {
		$label[] = count($critical).' critical';
	}

	if ($notice) {
		$label[] = count($notice).' potential';
	}

	echo '<p>'.implode(' and ', $label).' issue(s) detected.</p>';
	echo '<ul class="uk-list uk-list-line tm-width">';

	echo implode('', array_map(function($message) {
		return "<li class=\"uk-text-danger\"><i class=\"fa-bolt\" aria-hidden=\"true\"></i> {$message}</li>";
	}, $critical));

	echo implode('', array_map(function($message) {
		return "<li class=\"uk-text-warning\"><i class=\"fa-bolt\" aria-hidden=\"true\"></i> {$message}</li>";
	}, $notice));

	echo '</ul>';

} else {
	echo "<p>Warp engine operational and ready for take off.<p>";
}
