<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Warp/Menu/Subnav.php
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
namespace Warp\Menu;

// No direct access
defined ('_JEXEC') or die ('Restricted access');


use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;

/**
 * Subnav menu renderer.
 *
 * @since 1.0.0
 */
class Subnav {

	protected static $modules = array();

	/**
	 * Process menu
	 *
	 * @param   object  $module
	 * @param   object  $element
	 *
	 * @return object
	 * @throws \Exception
	 *
	 * @since 1.0.0
	 */
	public function process(object $module, object $element): object
	{
		self::_process($module, $element->first('ul:first'));
		return $element;
	}


	/**
	 * Helper function
	 *
	 * @param   object   $module
	 * @param   object   $element
	 * @param   integer  $level
	 *
	 * @throws \Exception
	 *
	 * @since 1.0.0
	 */
	protected static function _process(object $module, object $element, int $level = 0): void
	{

		global $warp;

		// get warp config
		$config = $warp['config'];

		if ($level === 0) {
			$element->attr('class', 'uk-subnav');
		} else {
			$element->addClass('level'.($level + 1));
		}

		foreach ($element->children('li') as $li) {

			// //is active ?
 			if ($active = $li->attr('data-menu-active')) {
				$active = ' uk-active';
			}

			// //is header ?
			if ($header = $li->attr('data-menu-header')) {
				$header = ' uk-nav-header';
			}

			// //is separator ?
			if ($separator = $li->attr('data-menu-separator')) {
				$separator = ' uk-margin-small uk-nav-divider';
			}

			// is parent ?
			$ul = $li->children('ul');
			$parent = $ul->length ? ' uk-parent' : null;

			//set class in li
			$li->attr('class', sprintf('level%d'.$parent.$header.$separator, $level + 1, $li->attr('data-id')));

			// add all options that have a name starting with 'data-'
			foreach ($config->get("menus." . $li->attr('data-id'), array()) as $key => $value) {
				if (str_starts_with($key, 'data-')) {
					// add an attribute named like the option itself
					$li->attr($key, $value);
				}
			}

			// set subtitle, images, icon or modules in a/span
			foreach ($li->children('a') as $child) {
				// set subtitle && icon
				if ( ($subtitle = $li->attr('data-menu-subtitle')) && ($icon = $li->attr('data-menu-icon'))) {
					$child->html('<div><span class="uk-margin-small-right"><i class="'.$icon.'" aria-hidden="true"></i></span>'.$child->text().'<div class="uk-navbar-subtitle">'.$subtitle.'</div></div>');
				}

				// set only subtitle
				elseif ($subtitle = $li->attr('data-menu-subtitle')) {
					$child->html('<div>'.$child->text().'<div class="uk-navbar-subtitle">'.$subtitle.'</div></div>');
				}

				// load modules by id
				elseif ($moduleid = $li->attr('data-menu-moduleid')) {
					if ($moduleid > 0) {
						$jModule  = self::_loadid($moduleid);

						$mod = '<div class="uk-padding-small uk-padding-remove-horizontal">' . $jModule . '</div>';
						$child->_innerHTML($mod);
					}
				}

				// set image
				elseif ($image = $li->attr('data-menu-image')) {
					$child->_prepend('<img class="uk-responsive-height" data-src="'.$image.'" data-alt="'.$child->text().'" uk-img="" /> ');
				}

				// set icon
				elseif ($icon = $li->attr('data-menu-icon')) {
					$child->html('<span class="uk-margin-small-right"><i class="'.$icon.'" aria-hidden="true"></i></span>'.$child->text());
				}

				// set only header
				elseif ($li->attr('data-menu-header')) {
					$child->html($child->text());
				}

				// set only separator
				elseif ($li->attr('data-menu-separator')) {
					$child->parent()->removeChild($child);
				}

			}

			//process submenu
			if ($ul->length) {
				self::_process($module, $ul->item(0), $level + 1);
			} 

		}

	}

	/**
	 * @param $id
	 *
	 * @return bool|string
	 * @throws \Exception
	 *
	 * @since 1.4.3
	 */
	public static function _loadid($id): bool|string
	{
		self::$modules[$id] = '';
		$params             = array('style' => 'none');

		$db         = Factory::getContainer()->get('DatabaseDriver');
		$query		= $db->getQuery(true);
		$now		= Factory::getDate()->toSql();
		$null_date	= $db->getNullDate();

		$user			= Factory::getApplication()->getIdentity();
		$user_levels	= implode(',', $user->getAuthorisedViewLevels());

		$query->select('*');
		$query->from($db->qn('#__modules'));
		$query->where($db->qn('id').' = '.$db->q($id));
		$query->where('('.$db->qn('publish_up').' = '.$db->q($null_date).' OR '.$db->qn('publish_up').' <= '.$db->q($now).' OR '.$db->qn('publish_up').' IS NULL)');
		$query->where('('.$db->qn('publish_down').' = '.$db->q($null_date).' OR '.$db->qn('publish_down').' >= '.$db->q($now).' OR '.$db->qn('publish_down').' IS NULL)');
		$query->where($db->qn('published').' = '. $db->q(1));
		$query->where($db->qn('client_id').' = 0');
		$query->where($db->qn('access').' IN ('.$user_levels.')');

		$db->setQuery($query);
		$m = $db->loadObject();

		ob_start();

		if ($m->id > 0)
		{
			echo ModuleHelper::renderModule($m, $params);
		}

		self::$modules[$id] = ob_get_clean();

		return self::$modules[$id];
	}

}
