<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Warp/Menu/Navbar.php
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
namespace Warp\Menu;

// No direct access
defined ('_JEXEC') or die ('Restricted access');


/**
 * Navbar menu renderer.
 */
class Navbar {

	/**
	 * Process menu
	 *
	 * @param   object  $module
	 * @param   object  $element
	 *
	 * @return object
	 */
	public function process(object $module, object $element): object
	{

		$element->first('ul:first')->attr('class', 'uk-navbar-nav');

		foreach ($element->find('ul.level2') as $ul) {

			//get parent li
			$li = $ul->parent();

			//get columns
			$columns = (int) $li->attr('data-menu-columns');
			if ($columns > 1) {

				$i = 0;
				$column = -1;
				$children = $ul->children('li');

				if ($children->length > $columns) {
					$remainder = $children->length % $columns;
					$colrows = ($children->length - $remainder) / $columns;
				} else {
					$remainder = 0;
					$colrows = 1;
				}

				foreach ($children as $child) {

					if ($i-- === 0) {
						$i = $remainder-- > 0 ? $colrows : $colrows - 1;
						$column++;
					}

					if ($li->children('ul')->length === $column) {
						$li->_append('<ul class="level2"></ul>');
					}

					if ($column > 0) {
						$li->children('ul')->item($column)->_append($child);
					}
				}

				$columns = $column + 1;

			} else {
				$columns = 1;
			}

			//get width
			$width = (int) $li->attr('data-menu-columnwidth');
			$style = $width > 0 ? sprintf(' style="min-width: %spx; max-width: %spx; width:%spx;"', $columns * $width, $columns * $width, $width) : null;

			//append dropdown divs
			$dropdown_grid = '<div class="uk-navbar-dropdown uk-navbar-dropdown-width-%d" %s><div class="uk-drop-grid uk-child-width-1-%d" uk-grid=""></div></div>';

			$li->_append(sprintf($dropdown_grid, $columns, $style, $columns));
			$div = $li->first('div.uk-navbar-dropdown div.uk-drop-grid');

			foreach ($li->children('ul') as $i => $u) {
				$u->attr('uk-nav', 'multiple: true');
				$u->addClass("uk-navbar-dropdown-nav");
				$div->_append(sprintf('<div></div>', $columns))->children('div')->item($i)->_append($u);
			}

		}

		foreach($element->find("ul.level3") as $list) {
			$list->addClass("uk-nav-sub");
		}

		return $element;
	}
}
