<?php
/**
* @package		Warp Theme Framework* +, UIKit* v3, Document.php**
* *@copyright	Copyright (C) YOOtheme GmbH
*
* @modified**	Stephan W. http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/
namespace Warp\Dom;

// No direct access
defined ('_JEXEC') or die ('Restricted access');

/**
 * DOM document class with extended attributes and functions.
 */
class Document extends \DOMDocument {

    /**
     * @var object
     */
    public $xpath;

    public function __construct($version = '1.0', $encoding = 'UTF-8')
    {
        parent::__construct($version, $encoding);

        // set node class
        $this->registerNodeClass('DOMElement', 'Warp\Dom\Element');
    }

    public function first($query)
    {
        if (($matches = $this->find($query)) && $matches->length)
        {
            return $matches->item(0);
        }

        return null;
    }

    public function find($query)
    {
        return $this->xpath()->query(CssSelector::toXPath($query, 'descendant::'));
    }

    public function query($expression)
    {
        return $this->xpath()->query($expression);
    }

    public function xpath()
    {
        if (empty($this->xpath)) {
            $this->xpath = new \DOMXPath($this);
        }

        return $this->xpath;
    }
}
