<?php
/**
* @package		Warp Theme Framework* +, UIKit* v3, FilterCollection.php**
* *@copyright	Copyright (C) YOOtheme GmbH
*
* @modified**	Stephan W. http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/
namespace Warp\Asset\Filter;

// No direct access
defined ('_JEXEC') or die ('Restricted access');

/**
 * Asset filter collection.
 */
class FilterCollection implements FilterInterface, \Iterator {

    /**
     * @var object
     */
    protected $filters;

    /**
     * Constructor.
     */
    public function __construct()
    {
        $this->filters = new \SplObjectStorage();
    }

    /**
     * On load filter callback.
     * 
     * @param  object $asset
     */
    public function filterLoad($asset)
    {
        foreach ($this->filters as $filter) {
            $filter->filterLoad($asset);
        }
    }

    /**
     * On content filter callback.
     * 
     * @param  object $asset
     */
    public function filterContent($asset)
    {
        foreach ($this->filters as $filter) {
            $filter->filterContent($asset);
        }
    }

    /**
     * Add filter to collection.
     * 
     * @param object $filter
     */
    public function add($filter)
    {
        if ($filter instanceof Traversable) {
            foreach ($filter as $f) {
                $this->add($f);
            }
        } else {
            $this->filters->attach($filter);
        }
    }

    /**
     * Remove filter from collection.
     * 
     * @param  object $filter
     */
    public function remove($filter)
    {
        $this->filters->detach($filter);
    }

    /* Iterator interface implementation */

    public function current(): mixed
    {
        return $this->filters->current();
    }

    public function key(): mixed
    {
        return $this->filters->key();
    }

    public function valid(): bool
    {
        return $this->filters->valid();
    }

    public function next(): void
    {
        $this->filters->next();
    }

    public function rewind(): void
    {
        $this->filters->rewind();
    }
}
