<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Template/Layouts
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

// attributes  
$fieldid_tmp = str_replace(array("[", "]", "(", ")"), "",$name); //remove the brackets from the fieldid else it won't work later in the javascript  
$fieldid = str_replace("_", "-",$fieldid_tmp);
$attributes = array();  
$attributes['type']  = 'hidden';  
$attributes['name']  = $name;  
$attributes['id'] = $fieldid;
$attributes['class'] = 'field-media-input-'.$fieldid;
$attributes['value'] = $value;  


$imagesExt = $imagesExt = array_map(
	'trim',
	explode(
		',',
		ComponentHelper::getParams('com_media')->get(
			'image_extensions',
			'bmp,gif,jpg,jpeg,png,webp'
		)
	)
);
$audiosExt = array_map(
	'trim',
	explode(
		',',
		ComponentHelper::getParams('com_media')->get(
			'audio_extensions',
			'mp3,m4a,mp4a,ogg'
		)
	)
);
$videosExt = array_map(
	'trim',
	explode(
		',',
		ComponentHelper::getParams('com_media')->get(
			'video_extensions',
			'mp4,mp4v,mpeg,mov,webm'
		)
	)
);

// The url for the modal
/* $url = ($link ?: 'index.php?option=com_media&view=media&tmpl=component&mediatypes=' . $mediaTypes
        . '&asset=' . $asset . '&author=' . $authorId)
    . '&fieldid={field-media-id}&path=' . $folder; */

$url = 'index.php?option=com_media&amp;view=media&amp;tmpl=component&amp;mediatypes=0&amp;asset=com_templates&amp;author=&amp;fieldid={field-media-id}&amp;path=';
// Correctly route the url to ensure it's correctly using sef modes and subfolders
$url = Route::_($url);
$doc = Factory::getApplication()->getDocument();
$wam = $doc->getWebAssetManager();

$wam->useScript('webcomponent.media-select');
$doc->addScriptOptions('media-picker-api', ['apiBaseUrl' => Uri::base() . 'index.php?option=com_media&format=json']);


Text::script('JFIELD_MEDIA_LAZY_LABEL');
Text::script('JFIELD_MEDIA_ALT_LABEL');
Text::script('JFIELD_MEDIA_ALT_CHECK_LABEL');
Text::script('JFIELD_MEDIA_ALT_CHECK_DESC_LABEL');
Text::script('JFIELD_MEDIA_CLASS_LABEL');
Text::script('JFIELD_MEDIA_FIGURE_CLASS_LABEL');
Text::script('JFIELD_MEDIA_FIGURE_CAPTION_LABEL');
Text::script('JFIELD_MEDIA_LAZY_LABEL');
Text::script('JFIELD_MEDIA_SUMMARY_LABEL');
Text::script('JFIELD_MEDIA_EMBED_CHECK_DESC_LABEL');
Text::script('JFIELD_MEDIA_DOWNLOAD_CHECK_DESC_LABEL');
Text::script('JFIELD_MEDIA_DOWNLOAD_CHECK_LABEL');
Text::script('JFIELD_MEDIA_EMBED_CHECK_LABEL');
Text::script('JFIELD_MEDIA_WIDTH_LABEL');
Text::script('JFIELD_MEDIA_TITLE_LABEL');
Text::script('JFIELD_MEDIA_HEIGHT_LABEL');
Text::script('JFIELD_MEDIA_UNSUPPORTED');
Text::script('JFIELD_MEDIA_DOWNLOAD_FILE');
Text::script('JLIB_APPLICATION_ERROR_SERVER');
Text::script('JLIB_FORM_MEDIA_PREVIEW_EMPTY', true);

$modalHTML = HTMLHelper::_(
    'bootstrap.renderModal',
    'joomla-modal joomla-modal' . $fieldid,
    [
        'url'         => $url,
        'title'       => Text::_('JLIB_FORM_CHANGE_IMAGE'),
        'closeButton' => true,
        'height'      => '100%',
        'width'       => '100%',
        'modalWidth'  => '80',
        'bodyHeight'  => '60',
        'footer'      => '<button type="button" class="btn btn-success button-save-selected-'.$fieldid.'">' . Text::_('JSELECT') . '</button>'
            . '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">' . Text::_('JCANCEL') . '</button>',
    ]
);

$wam->useStyle('webcomponent.field-media')
    ->useScript('webcomponent.field-media');

if (count($doc->getScriptOptions('media-picker')) === 0) {
    $doc->addScriptOptions('media-picker', [
        'images'    => $imagesExt,
        'audios'    => $audiosExt,
        'videos'    => $videosExt,
    ]);
}

if ($value) {
	$src = Uri::root() . $value;
} else {
	$src = '';
}


?>

<joomla-field-media class="field-media-wrapper-<?php echo $fieldid; ?>" type="image" <?php // @TODO add this attribute to the field in order to use it for all media types ?> 
    base-path="<?php echo Uri::root(); ?>" 
    root-folder="<?php echo ComponentHelper::getParams('com_media')->get('file_path', 'images'); ?>" 
    url="<?php echo $url; ?>" 
    modal-container=".modal" 
    modal-width="100%" 
    modal-height="400px" 
    input=".field-media-input-<?php echo $fieldid; ?>" 
    button-select=".button-select-<?php echo $fieldid; ?>" 
    button-clear=".button-clear-<?php echo $fieldid; ?>" 
    button-save-selected=".button-save-selected-<?php echo $fieldid; ?>"
    supported-extensions="<?php echo str_replace('"', '&quot;', json_encode(['images' => $imagesExt, 'audios' => $audiosExt, 'videos' => $videosExt], JSON_THROW_ON_ERROR)); ?>
">
    <?php echo $modalHTML; ?>

    <div class="uk-button-group">
        <?php printf('<input %s />', $this['field']->attributes($attributes)); ?>
        <?php // if ($disabled != true) : ?>
            <button type="button" class="uk-button button-select-<?php echo $fieldid; ?>"><?php echo Text::_('JLIB_FORM_BUTTON_SELECT'); ?></button>

			<?php if ($value) {
				echo '<a class="uk-button" href="' . $src . '" data-lightbox-type="image" data-uk-lightbox title="' . Text::_('JLIB_FORM_MEDIA_PREVIEW_SELECTED_IMAGE') . '">
						<i class="fas fa-eye" aria-hidden="true"></i>
					</a>';
			} ?>
			
			<button type="button" class="uk-button button-clear-<?php echo $fieldid; ?>"><span class="icon-times" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('JLIB_FORM_BUTTON_CLEAR'); ?></span></button>
        <?php // endif; ?>
    </div>
</joomla-field-media>
