<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Template/Layouts
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;

 ?>

			<div class="uk-overflow-container">
				<table class="uk-table uk-table-middle tm-table uk-text-nowrap">
					<thead>
						<tr>
							<th><?php echo $node->first('rows')->attr('label') ?></th>
							<?php foreach ($node->children('field') as $field) : ?>
							<th data-uk-tooltip="{pos:'top'}" title="<?php echo $field->attr('tooltip');?>"><?php echo $field->attr('column') ?: $field->attr('label') ?></th>
							<?php endforeach ?>
						</tr>
					</thead>
					<tbody>
						<?php foreach ($node->find('rows > row') as $row) : ?>
						<?php $id = $row->text() ?>
						<tr>
							<td><?php echo $id ?></td>
							<?php foreach ($node->children('field') as $field) : ?>
							<td>
								<?php
									$fname = $field->attr('name');
									$fvalue = $value[$id][$fname] ?? $node->attr('default');

									echo $this['field']->render($field->attr('type'), "{$name}[{$id}][{$fname}]", $fvalue, $field, compact('field'));
								?>
							</td>
							<?php endforeach ?>
						</tr>
						<?php endforeach ?>
					</tbody>
				</table>
			</div>
        </div>
	</div>

