<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	Template/Layouts
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


// get theme configuration
include($this['path']->path('layouts:theme.config.php')); ?>

<!DOCTYPE HTML>
<html prefix="og: https://ogp.me/ns#" xmlns="http://www.w3.org/1999/xhtml" lang="<?php echo $this['config']->get('language'); ?>" dir="<?php echo $this['config']->get('direction'); ?>" data-config='<?php echo $this['config']->get('body_config','{}'); ?>'>

	<head>
		<?php echo $this['template']->render('head'); ?>
	</head>

	<body class="<?php echo $this['config']->get('body_classes'); ?>"<?php echo $body_bg_image; ?>>

		<?php echo $this['config']->get('boxed_layout'); ?>

			<?php echo $this['template']->render('toolbar'); ?>
			<?php echo $this['template']->render('navbar'); ?>

			<?php if ($this['widgets']->count('fullscreen')) : ?>
				<div id="fullscreen" class="tm-fullscreen uk-cover-container" uk-height-viewport="offset-top: true">
					<?php echo $this['widgets']->render('fullscreen'); ?>
				</div>
			<?php endif; ?>

			<?php echo $this['template']->render('position_top'); ?>

			<?php if ($this['config']->get('system_output', true) && $this['config']->get('breadcrumbs_output') == '0' && $this['widgets']->count('breadcrumbs')) : ?>
				<section class="tm-block-breadcrumbs uk-section<?php echo @$block_classes['breadcrumbs']; echo @$block_img_bg_classes['breadcrumbs']; ?>" <?php echo @$block_img_bg['breadcrumbs']; ?><?php echo @$block_attr['breadcrumbs']; ?>>
					<div class="<?php echo @$container_classes['breadcrumbs']; ?>" <?php echo @$container_img_bg['breadcrumbs']; ?>>
						<?php echo trim(preg_replace('/\t+/', '', $this['widgets']->render('breadcrumbs'))); ?>
					</div>
				</section>
			<?php endif; ?>

			<?php echo $this['template']->render('content'); ?>
			<?php echo $this['template']->render('position_bottom'); ?>

			<?php if ($this['config']->get('system_output', true) && $this['config']->get('breadcrumbs_output') == NULL && $this['widgets']->count('breadcrumbs')) : ?>
				<section class="tm-block-breadcrumbs uk-section<?php echo @$block_classes['breadcrumbs']; echo @$block_img_bg_classes['breadcrumbs']; ?>" <?php echo @$block_img_bg['breadcrumbs']; ?><?php echo @$block_attr['breadcrumbs']; ?>>
					<div class="<?php echo @$container_classes['breadcrumbs']; ?>" <?php echo @$container_img_bg['breadcrumbs']; ?>>
						<?php echo trim(preg_replace('/\t+/', '', $this['widgets']->render('breadcrumbs'))); ?>
					</div>
				</section>
			<?php endif; ?>

			<?php echo $this['template']->render('footer'); ?>

		<?php echo $this['config']->get('boxed_layouts') ? '</div>' : '' ?>

		<?php if ($this['widgets']->count('offcanvas')) : ?>
			<div id="offcanvas" class="uk-offcanvas"<?php echo $offcanvas_attr; ?>>
				<div class="uk-offcanvas-bar uk-flex uk-flex-column">
					<button class="uk-offcanvas-close uk-close-large" type="button" uk-close=""></button>
					<?php if ($this['widgets']->count('logo-small')) : ?>
						<a class="tm-logo-small uk-logo uk-margin-small-bottom" href="<?php echo $this['config']->get('site_url'); ?>"><?php echo $this['widgets']->render('logo-small'); ?></a>
					<?php endif; ?>
					<?php echo $this['widgets']->render('offcanvas'); ?>
				</div>
			</div>
		<?php endif; ?>

		<?php if ($this['widgets']->count('search')) : ?>
			<div id="modal-full-search" class="uk-modal-full uk-modal" uk-modal="">
				<div class="uk-modal-dialog uk-modal-body uk-flex uk-flex-center uk-flex-middle" uk-height-viewport="min-height: 350">
					<button class="uk-modal-close-full uk-close-large uk-margin-remove-adjacent" type="button" uk-close=""></button>
					<?php echo $this['widgets']->render('search'); ?>
				</div>
			</div>
		<?php endif; ?>

		<?php // login fullscreen modal with image ?>
		<?php if ($this['widgets']->count('login') && $navbar_login_img) { ?>
			<div id="modal-full-login" class="uk-modal-full uk-modal" uk-modal="">
				<div class="uk-modal-dialog">
					<button class="uk-modal-close-full uk-close-large uk-margin-remove-adjacent" type="button" uk-close=""></button>

					<div class="uk-grid-collapse" uk-grid="">
						<div class="uk-width-1-1 uk-width-3-5@m uk-background-cover"<?php echo $navbar_login_img; ?> uk-height-viewport="min-height: 350"></div>
						<div class="uk-width-1-1 uk-width-expand@m uk-flex uk-flex-middle">
							<div class="uk-flex uk-flex-center">
								<div class="uk-padding">
									<?php echo $this['widgets']->render('login'); ?>
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>
		<?php // default login fullscreen modal ?>
		<?php } else if ($this['widgets']->count('login')) { ?>
			<div id="modal-full-login" class="uk-modal-full uk-modal" uk-modal="">
				<div class="uk-modal-dialog uk-modal-body uk-flex uk-flex-center uk-flex-middle" uk-height-viewport="min-height: 350">
					<button class="uk-modal-close-full uk-close-large uk-margin-remove-adjacent" type="button" uk-close=""></button>
					<?php echo $this['widgets']->render('login'); ?>
				</div>
			</div>
		<?php } ?>

		<?php if ($this['widgets']->count('info')) : ?>
			<div class="tm-info uk-alert-primary" uk-alert="">
				<button class="uk-alert-close" type="button" uk-close=""></button>
				<?php echo $this['widgets']->render('info');?>
			</div>
		<?php endif; ?>

		<?php if ($this['widgets']->count('dotnav')) : ?>
			<?php echo $this['widgets']->render('dotnav'); ?>
		<?php endif; ?>

		<?php if ($this['widgets']->count('debug')) : ?>
			<div class="uk-section">
				<?php echo $this['widgets']->render('debug');?>
			</div>
		<?php endif; ?>

		<?php echo $this['config']->get('tracking_code'); ?>

		<?php if ($this['config']->get('totop_scroller', true)) : ?>
			<a class="tm-totop-scroller" href="#" uk-totop="" uk-scroll=""></a>
		<?php endif; ?>

	</body>
</html>