/* Copyright (C) Stephan W., http://www.gnu.org/licenses/gpl.html GNU/GPL */

function share_twitter(elem, url) {
	var html = "<div id=\"twitter_button_on\" class=\"socialbutton\" uk-tooltip=\"title:Twitter\"><div class=\"socialbutton-size\"><a class=\"twitter-share-button\" target=\"blank\" rel=\"nofollow\" href=\""+url+"\"><i class=\"fa fa-twitter\" aria-hidden=\"true\"></i></a></div></div>";
	document.getElementById(elem).innerHTML = html;
}
function share_fb(elem, url) {
	var html = "<div id=\"facebook_button_on\" class=\"socialbutton\" uk-tooltip=\"title:facebook\"><div class=\"socialbutton-size\"><a class=\"fb-share-button\" target=\"blank\" rel=\"nofollow\" href=\""+url+"\"><i class=\"fa fa-facebook\" aria-hidden=\"true\"></i></a></div></div>";
	document.getElementById(elem).innerHTML = html;
}
function share_linkedin(elem, url) {
	var html = "<div id=\"linkedin_button_on\" class=\"socialbutton\" uk-tooltip=\"title:LinkedIn\"><div class=\"socialbutton-size\"><a class=\"linkedin-share-button\" target=\"blank\" rel=\"nofollow\" href=\""+url+"\"><i class=\"fa fa-linkedin\" aria-hidden=\"true\"></i></a></div></div>";
	document.getElementById(elem).innerHTML = html;
}
function share_pinterest(elem, url) {
	var html = "<div id=\"pinterest_button_on\" class=\"socialbutton\" uk-tooltip=\"title:Pinterest\"><div class=\"socialbutton-size\"><a class=\"pinterest-share-button\" data-pin-do=\"buttonBookmark\" data-pin-tall=\"true\" data-pin-custom=\"true\" target=\"blank\" rel=\"nofollow\" href=\""+url+"\"><i class=\"fa fa-pinterest\" aria-hidden=\"true\"></i></a></div></div>";
	var scriptElm = document.createElement('script');
	scriptElm.src = 'https://assets.pinterest.com/js/pinit.js';
	document.body.appendChild(scriptElm);
	document.getElementById(elem).innerHTML = html;
}
function share_whatsapp(elem, url) {
	var html = "<div id=\"whatsapp_button_on\" class=\"socialbutton uk-hidden@s\" uk-tooltip=\"title:WhatsApp\"><div class=\"socialbutton-size\"><a class=\"whatsapp-share-button\" target=\"blank\" rel=\"nofollow\" href=\""+url+"\"><i class=\"fa fa-whatsapp\" aria-hidden=\"true\"></i></a></div></div>";
	document.getElementById(elem).innerHTML = html;
}
(function($) {
	var script = {};
	$.fn.socialButtons = function(options) {
		options = $.extend({
			wrapper: "<ul class=\"socialbuttons-3d-hobby-art uk-clearfix uk-flex uk-flex-center\">"
		}, options);
		if (!options.twitter && !options.plusone && !options.facebook && !options.linkedin && !options.pinterest && !options.whatsapp) {
			return this;
		}
		return this.each(function() {
			var link = $(this).data("permalink"),
				title = document.title,
				buttons = $(options.wrapper).appendTo(this);
			if (options.twitter) {
				buttons.append("<li id=\"twitter_button\" class=\"socialbutton-off\"><div class=\"socialbutton-size\"><b class=\"twitter-share-button\" onclick='share_twitter(\"twitter_button\", \"https://www.twitter.com/share?url=" + link + "\"); return false;' uk-tooltip=\"title:2clicks &#128521; \"><i class=\"fa fa-twitter\" aria-hidden=\"true\"></i></b></div></li>");
			}
			if (options.facebook) {
				buttons.append("<li id=\"facebook_button\" class=\"socialbutton-off\"><div class=\"socialbutton-size\"><b class=\"fb-share-button\" onclick='share_fb(\"facebook_button\", \"https://www.facebook.com/sharer.php?u=" + link + "&t=" + title + "\"); return false;' uk-tooltip=\"title:2clicks &#128521; \"><i class=\"fa fa-facebook\" aria-hidden=\"true\"></i></b></div></li>");
			}
			if (options.linkedin) {
				buttons.append("<li id=\"linkedin_button\" class=\"socialbutton-off\"><div class=\"socialbutton-size\"><b class=\"linkedin-share-button\" onclick='share_linkedin(\"linkedin_button\", \"https://www.linkedin.com/shareArticle?mini=true&url=" + link + "\"); return false;' uk-tooltip=\"title:2clicks &#128521; \"><i class=\"fa fa-linkedin\" aria-hidden=\"true\"></i></b></div></li>");
			}
			if (options.pinterest) {
				buttons.append("<li id=\"pinterest_button\" class=\"socialbutton-off\"><div class=\"socialbutton-size\"><b class=\"pinterest-share-button\" onclick='share_pinterest(\"pinterest_button\", \"https://www.pinterest.com/pin/create/button/\"); return false;' uk-tooltip=\"title:2clicks  &#128521; \"><i class=\"fa fa-pinterest\" aria-hidden=\"true\"></i></b></div></li>");
			}
			if (options.whatsapp) {
				buttons.append("<li id=\"whatsapp_button\" class=\"socialbutton-off uk-hidden@s\"><div class=\"socialbutton-size\"><b class=\"whatsapp-share-button\" onclick='share_whatsapp(\"whatsapp_button\", \"whatsapp://send?text=" + title +" " + link + "\"); return false;' uk-tooltip=\"title:2clicks  &#128521; \"><i class=\"fa fa-whatsapp\" aria-hidden=\"true\"></i></b></div></li>");
			}
		});
	};
})(jQuery);