<?php
/********************************************************************************
 * @package		Warp Theme Framework* +, UIKit* v3
 * *@copyright	Copyright (C) YOOtheme GmbH
 *********************************************************************************
 * @package		uiThemeBuilder
 * @subpackage	html/mod_tags_popular
 * @modified	Stephan W.
 * @copyright	https://www.ui-themebuilder.com/
 * @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\Tags\Site\Helper\RouteHelper;

$minsize = $params->get('minsize', 1);
$maxsize = $params->get('maxsize', 2);

?>
<div class="mod-tagspopular-cloud tagspopular tagscloud uk-grid-column-small uk-grid-row-small" uk-grid="masonry: true">
<?php
if (!count($list)) : ?>
	<div class="uk-alert-warning" uk-alert="">
		<span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
		<?php echo Text::_('MOD_TAGS_POPULAR_NO_ITEMS_FOUND'); ?>
	</div>
<?php else :
	// Find maximum and minimum count
	$mincount = null;
	$maxcount = null;
	foreach ($list as $item)
	{
		if ($mincount === null || $mincount > $item->count)
		{
			$mincount = $item->count;
		}
		if ($maxcount === null || $maxcount < $item->count)
		{
			$maxcount = $item->count;
		}
	}
	$countdiff = $maxcount - $mincount;

	foreach ($list as $item) :
		if ($countdiff === 0) :
			$fontsize = $minsize;
		else :
			$fontsize = $minsize + (($maxsize - $minsize) / $countdiff) * ($item->count - $mincount);
		endif;
?>
		<div>
			<span class="tag uk-padding-small">
				<a class="tag-name uk-link-reset" style="font-size: <?php echo $fontsize . 'em'; ?>" href="<?php echo Route::_(RouteHelper::getTagRoute($item->tag_id . ':' . $item->alias)); ?>">
					<?php echo htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8'); ?></a>
				<?php if ($display_count) : ?>
					<span class="tag-count badge bg-info"><?php echo $item->count; ?></span>
				<?php endif; ?>
			</span>
		</div>
	<?php endforeach; ?>
<?php endif; ?>
</div>
