<?php
/********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html/mod_articles_category
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

?>
<?php foreach ($items as $item) : ?>
<li<?php if(count($item->tags->itemTags)>0): ?> data-tags="<?php foreach ($item->tags->itemTags as $tag): ?><?php echo $tag->alias.' '; ?><?php endforeach; ?>"<?php endif; ?>>

	<div class="uk-card uk-card-default">

		<?php if ($item->displayHits) : ?>
			<div class="uk-card-badge uk-label"><?php echo $item->displayHits; ?></div>
		<?php endif; ?>

		<div class="uk-card-header">

			<?php if ($params->get('link_titles') == 1) : ?>
				<?php $attributes = ['class' => 'uk-card-title uk-margin-remove-bottom uk-text-decoration-none ' . $item->active]; ?>
				<?php $link = htmlspecialchars($item->link, ENT_COMPAT, 'UTF-8', false); ?>
				<?php $title = htmlspecialchars($item->title, ENT_COMPAT, 'UTF-8', false); ?>
				<?php echo HTMLHelper::_('link', $link, $title, $attributes); ?>
			<?php else : ?>
				<?php echo $item->title; ?>
			<?php endif; ?>
			<?php if ($item->displayDate || $params->get('show_author') || $item->displayCategoryTitle) : ?>
				<p class="uk-text-small uk-text-meta uk-margin-remove-top">
					<?php if ($item->displayDate) : ?>
						<time datetime="<?php echo $item->displayDate; ?>"><?php echo $item->displayDate; ?></time><?php if ($params->get('show_author') || $item->displayCategoryTitle) : ?>, <?php endif; ?>
					<?php endif; ?>
					<?php if ($params->get('show_author')) : ?>
						<span class="mod-articles-category-writtenby"><?php echo $item->displayAuthorName; ?></span><?php if ($item->displayCategoryTitle) : ?>, <?php endif; ?>
					<?php endif; ?>
					<?php if ($item->displayCategoryTitle) : ?>
						<span class="mod-articles-category-category">
							(<?php echo $item->displayCategoryTitle; ?>)
						</span>
					<?php endif; ?>
				</p>
			<?php endif; ?>
			
		</div>

		<?php if ($params->get('show_introtext') || $params->get('show_tags', 0)) : ?>
			<div class="uk-card-body">

				<?php if ($params->get('show_introtext')) : ?>
				<p class="mod-articles-category-introtext">
					<?php echo $item->displayIntrotext; ?>
				</p>
				<?php endif; ?>

				<?php if ($params->get('show_tags', 0) && $item->tags->itemTags) : ?>
					<div class="uk-flex uk-flex-right uk-text-small">
						<?php echo LayoutHelper::render('joomla.content.tags', $item->tags->itemTags); ?>
					</div>
				<?php endif; ?>
			</div>
		<?php endif; ?>

		<?php if ($params->get('show_readmore')) : ?>
			<div class="uk-card-footer">
				<a class="mod-articles-category-title <?php echo $item->active; ?>" href="<?php echo $item->link; ?>">
					<?php if ($item->params->get('access-view') == false) : ?>
						<?php echo Text::_('MOD_ARTICLES_CATEGORY_REGISTER_TO_READ_MORE'); ?>
					<?php elseif ($item->alternative_readmore) : ?>
						<?php echo $item->alternative_readmore; ?>
						<?php echo HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit')); ?>
							<?php if ($params->get('show_readmore_title', 0)) : ?>
								<?php echo HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit')); ?>
							<?php endif; ?>
					<?php elseif ($params->get('show_readmore_title', 0)) : ?>
						<?php echo Text::_('MOD_ARTICLES_CATEGORY_READ_MORE'); ?>
						<?php echo HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit')); ?>
					<?php else : ?>
						<?php echo Text::_('MOD_ARTICLES_CATEGORY_READ_MORE_TITLE'); ?>
					<?php endif; ?>
				</a>
			</div>
		<?php endif; ?>
	</div>
</li>
<?php endforeach; ?>
