<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   string   $text      The label text
 * @var   string   $for       The id of the input this label is for
 * @var   boolean  $required  True if a required field
 * @var   array    $classes   A list of classes
 */

$classes = array_filter((array) $classes);
$id      = $for . '-lbl';

if ($required)
{
	$classes[] = 'required';
}

$hide            = empty($options['hiddenLabel']) ? '' : ' sr-only uk-hidden'; ?>

<label id="<?php echo $id; ?>" uk-tooltip="<?php echo $text; ?>" for="<?php echo $for; ?>" class="uk-form-label uk-text-truncate<?php echo $hide; ?><?php if (!empty($classes)) { echo ' ' . implode(' ', $classes);} ?>">
	<?php echo $text; ?><?php if ($required) : ?><span class="star uk-text-danger" aria-hidden="true">&#160;*</span><?php endif; ?>
</label>
