<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	layout
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

$params    = $displayData['params'];
$item      = $displayData['item'];
$direction = Factory::getApplication()->getLanguage()->isRtl() ? 'chevron-double-right' : 'chevron-double-left'; ?>

<p class="readmore">
	<?php if (!$params->get('access-view')) : ?>
		<?php echo '<span uk-icon="'.$direction.'" aria-hidden="true"></span>'; ?>
		<a class="uk-button uk-button-text" href="<?php echo $displayData['link']; ?>" itemprop="url" aria-label="<?php echo Text::_('JGLOBAL_REGISTER_TO_READ_MORE') . ' ' . $this->escape($item->title); ?>">
			<?php echo Text::_('JGLOBAL_REGISTER_TO_READ_MORE'); ?>
		</a>
	<?php elseif ($readmore = $item->alternative_readmore) : ?>
		<?php echo '<span uk-icon="'.$direction.'" aria-hidden="true"></span>'; ?>
		<a class="uk-button uk-button-text" href="<?php echo $displayData['link']; ?>" itemprop="url" aria-label="<?php echo $this->escape($readmore . ' ' . $item->title); ?>">
			<?php echo $readmore; ?>
			<?php if ($params->get('show_readmore_title', 0) != 0) : ?>
				<?php echo HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit')); ?>
			<?php endif; ?>
		</a>
	<?php elseif ($params->get('show_readmore_title', 0) == 0) : ?>
		<?php echo '<span uk-icon="'.$direction.'" aria-hidden="true"></span>'; ?>
		<a class="uk-button uk-button-text" href="<?php echo $displayData['link']; ?>" itemprop="url" aria-label="<?php echo Text::sprintf('JGLOBAL_READ_MORE_TITLE', $this->escape($item->title)); ?>">
			<?php echo Text::_('JGLOBAL_READ_MORE'); ?>
		</a>
	<?php else : ?>
		<?php echo '<span uk-icon="'.$direction.'" aria-hidden="true"></span>'; ?>
		<a class="uk-button uk-button-text" href="<?php echo $displayData['link']; ?>" itemprop="url" aria-label="<?php echo Text::sprintf('JGLOBAL_READ_MORE_TITLE', $this->escape($item->title)); ?>">
			<?php echo Text::sprintf('JGLOBAL_READ_MORE_TITLE', HTMLHelper::_('string.truncate', $item->title, $params->get('readmore_limit'))); ?>
		</a>
	<?php endif; ?>
</p>
