<?php
/********************************************************************************
 * @package         Warp Theme Framework* +, UIKit* v3
 * *@copyright    Copyright (C) YOOtheme GmbH
 *********************************************************************************
 * @package         uiThemeBuilder
 * @subpackage      layout
 * @modified        Stephan W.
 * @copyright       https://www.ui-themebuilder.com/
 * @license         http://www.gnu.org/licenses/gpl.html GNU/GPL
 *********************************************************************************/
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;


/**
 * Note that this layout opens a div with the page class suffix. If you do not use the category children
 * layout you need to close this div either by overriding this file or in your main layout.
 */
$params    = $displayData->params;
$category  = $displayData->get('category');
$extension = $category->extension;
$canEdit   = $params->get('access-edit');
$className = substr($extension, 4);
$htag      = $params->get('show_page_heading') ? 'h2' : 'h1';

$app = Factory::getApplication();

$category->text = $category->description;
$app->triggerEvent('onContentPrepare', array ($extension . '.categories', &$category, &$params, 0));
$category->description = $category->text;

$results           = $app->triggerEvent('onContentAfterTitle', array ($extension . '.categories', &$category, &$params, 0));
$afterDisplayTitle = trim(implode("\n", $results));

$results              = $app->triggerEvent('onContentBeforeDisplay', array ($extension . '.categories', &$category, &$params, 0));
$beforeDisplayContent = trim(implode("\n", $results));

$results             = $app->triggerEvent('onContentAfterDisplay', array ($extension . '.categories', &$category, &$params, 0));
$afterDisplayContent = trim(implode("\n", $results));

/**
 * This will work for the core components but not necessarily for other components
 * that may have different pluralisation rules.
 */
if ( substr($className, -1) === 's' )
{
	$className = rtrim($className, 's');
}

$tagsData = $category->tags->itemTags;
?>

<?php if ( $params->def('show_description_image', 1) ) { ?>

	<div class="<?php echo $className . '-category' . $displayData->pageclass_sfx; ?>">

		<div class="uk-cover-container uk-height-medium">
			<?php echo LayoutHelper::render(
				'joomla.html.image',
				[
					'src'      => $category->getParams()->get('image'),
					'uk-img'   => '',
					'uk-cover' => ''
				]
			); ?>
			<?php if ($params->get('show_page_heading', 1) || $params->get('show_category_title', 1) || $params->get('show_description', 1)) : ?>
				<div class="uk-position-large uk-position-cover uk-overlay uk-overlay-default uk-flex uk-flex-center uk-flex-middle uk-text-center">
					<?php if ( $params->get('show_page_heading') ) : ?>
						<div>
							<h1>
								<?php echo trim($displayData->escape($params->get('page_heading'))); ?>
							</h1>
						</div>
					<?php endif; ?>

					<?php if ($params->get('show_category_title', 1)) : ?>
						<div>
							<<?php echo $htag; ?> class="uk-margin-small-bottom<?php if ( $params->get('show_page_heading', 1) ) : ?> uk-h3 uk-heading-line uk-text-center uk-text-light<?php endif; ?>">
								<?php echo HTMLHelper::_('content.prepare', trim($category->title), '', $extension . '.category.title'); ?>
							</<?php echo $htag; ?>>
							<?php if ( $category->description && $params->get('show_description') ) : ?>
								<?php echo HTMLHelper::_('content.prepare', $category->description, '', $extension . '.category.description'); ?>
							<?php endif; ?>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>

		<?php echo $afterDisplayTitle; ?>

		<?php if ( $params->get('show_cat_tags', 1) ) : ?>
			<?php echo LayoutHelper::render('joomla.content.tags', $tagsData); ?>
		<?php endif; ?>

		<?php echo $beforeDisplayContent; ?>
		<?php echo $afterDisplayContent; ?>

		<?php echo $displayData->loadTemplate($displayData->subtemplatename); ?>

		<?php if ( $displayData->maxLevel != 0 && $displayData->get('children') ) : ?>
			<div class="cat-children">
				<?php if ( $params->get('show_category_heading_title_text', 1) == 1 ) : ?>
					<h3>
						<?php echo Text::_('JGLOBAL_SUBCATEGORIES'); ?>
					</h3>
				<?php endif; ?>
				<?php echo $displayData->loadTemplate('children'); ?>
			</div>
		<?php endif; ?>
	</div>

<?php } else { ?>

	<?php if ( $params->get('show_page_heading') ) : ?>
		<div>
			<h1>
				<?php echo trim($displayData->escape($params->get('page_heading'))); ?>
			</h1>
		</div>
	<?php endif; ?>

	<?php if ( $params->get('show_category_title', 1) ) { ?>
		<div class="uk-margin-large uk-text-center">
			<<?php echo $htag; ?> class="uk-margin-small-bottom<?php if ( $params->get('show_page_heading', 1) ) : ?> uk-h3 uk-heading-line uk-text-center uk-text-light<?php endif; ?>">
				<?php echo HTMLHelper::_('content.prepare', trim($category->title), '', $extension . '.category.title'); ?>
			</<?php echo $htag; ?>>
			<?php if ( $category->description && $params->get('show_description') ) : ?>
				<?php echo HTMLHelper::_('content.prepare', $category->description, '', $extension . '.category.description'); ?>
			<?php endif; ?>
		</div>
	<?php } else if ( $category->description && $params->get('show_description') ) { ?>
		<?php echo HTMLHelper::_('content.prepare', $category->description, '', $extension . '.category.description'); ?>
	<?php } ?>

	<?php echo $afterDisplayTitle; ?>

	<?php if ( $params->get('show_cat_tags', 1) ) : ?>
		<?php echo LayoutHelper::render('joomla.content.tags', $tagsData); ?>
	<?php endif; ?>

	<?php echo $beforeDisplayContent; ?>
	<?php echo $afterDisplayContent; ?>

	<div class="<?php echo $className . '-category' . $displayData->pageclass_sfx; ?>">

		<?php echo $displayData->loadTemplate($displayData->subtemplatename); ?>

		<?php if ( $displayData->maxLevel != 0 && $displayData->get('children') ) : ?>
			<div class="cat-children">
				<?php if ( $params->get('show_category_heading_title_text', 1) == 1 ) : ?>
					<h3>
						<?php echo Text::_('JGLOBAL_SUBCATEGORIES'); ?>
					</h3>
				<?php endif; ?>
				<?php echo $displayData->loadTemplate('children'); ?>
			</div>
		<?php endif; ?>

	</div>

<?php } ?>
