<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.keepalive');
HTMLHelper::_('behavior.formvalidator');

$usersConfig = ComponentHelper::getParams('com_users'); ?>

<div class="com-users-login login">
	<?php if ($this->params->get('show_page_heading')) : ?>
	<div class="page-header">
		<h1>
			<?php echo $this->escape($this->params->get('page_heading')); ?>
		</h1>
	</div>
	<?php endif; ?>

	<?php if (($this->params->get('logindescription_show') == 1 && str_replace(' ', '', $this->params->get('login_description')) != '') || $this->params->get('login_image') != '') : ?>
	<div class="com-users-login__description login-description">
	<?php endif; ?>

		<?php if ($this->params->get('logindescription_show') == 1) : ?>
			<?php echo $this->params->get('login_description'); ?>
		<?php endif; ?>

		<?php if ($this->params->get('login_image') != '') : ?>
			<img src="<?php echo $this->escape($this->params->get('login_image')); ?>" class="com-users-login__image login-image" alt="<?php echo Text::_('COM_USERS_LOGIN_IMAGE_ALT'); ?>">
		<?php endif; ?>

	<?php if (($this->params->get('logindescription_show') == 1 && str_replace(' ', '', $this->params->get('login_description')) != '') || $this->params->get('login_image') != '') : ?>
	</div>
	<?php endif; ?>

	<form action="<?php echo Route::_('index.php?option=com_users&task=user.login'); ?>" method="post" class="com-users-login__form form-validate uk-form-horizontal" id="com-users-login__form">

		<fieldset class="uk-fieldset">
			<?php echo $this->form->renderFieldset('credentials', ['class' => 'com-users-login__input']); ?>

			<?php if ($this->tfa) : ?>
				<?php echo $this->form->renderField('secretkey', null, null, ['class' => 'com-users-login__secretkey']); ?>
			<?php endif; ?>

			<?php if (PluginHelper::isEnabled('system', 'remember')) : ?>
				<div  class="com-users-login__remember uk-margin">
						<label for="remember">
							<?php echo Text::_('COM_USERS_LOGIN_REMEMBER_ME'); ?>
						</label>
						<input id="remember" type="checkbox" name="remember" class="uk-checkbox" value="yes">
				</div>
			<?php endif; ?>

			<?php foreach ($this->extraButtons as $button):
				$dataAttributeKeys = array_filter(array_keys($button), function ($key) {
					return substr($key, 0, 5) == 'data-';
				});
				?>
				<div class="com-users-login__submit control-group">
					<div class="controls">
						<button type="button"
						        class="uk-button uk-button-primary <?php echo $button['class'] ?? '' ?>"
								<?php foreach ($dataAttributeKeys as $key): ?>
								<?php echo $key ?>="<?php echo $button[$key] ?>"
								<?php endforeach; ?>
								<?php if ($button['onclick']): ?>
						        onclick="<?php echo $button['onclick'] ?>"
								<?php endif; ?>
						        title="<?php echo Text::_($button['label']) ?>"
						        id="<?php echo $button['id'] ?>"
						>
							<?php if (!empty($button['icon'])): ?>
								<span class="<?php echo $button['icon'] ?>"></span>
							<?php elseif (!empty($button['image'])): ?>
								<?php echo HTMLHelper::_('image', $button['image'], Text::_($button['tooltip'] ?? ''), [
									'class' => 'icon',
								], true) ?>
							<?php endif; ?>
							<?php echo Text::_($button['label']) ?>
						</button>
					</div>
				</div>
			<?php endforeach; ?>

			<div class="com-users-login__submit uk-margin">
				<button type="submit" class="uk-button uk-button-primary">
					<?php echo Text::_('JLOGIN'); ?>
				</button>
			</div>

			<?php $return = $this->form->getValue('return', '', $this->params->get('login_redirect_url', $this->params->get('login_redirect_menuitem'))); ?>
			<input type="hidden" name="return" value="<?php echo base64_encode($return); ?>">
			<?php echo HTMLHelper::_('form.token'); ?>
		</fieldset>
	</form>
</div>
<div>
	<ul class="com-users-login__options list-group uk-grid-small uk-child-width-auto" uk-grid>
		<li><a class="com-users-login__reset list-group-item uk-link-reset" href="<?php echo Route::_('index.php?option=com_users&view=reset'); ?>">
			<?php echo Text::_('COM_USERS_LOGIN_RESET'); ?>
		</a></li>
		<li><a class="com-users-login__remind list-group-item uk-link-reset" href="<?php echo Route::_('index.php?option=com_users&view=remind'); ?>">
			<?php echo Text::_('COM_USERS_LOGIN_REMIND'); ?>
		</a></li>
		<?php if ($usersConfig->get('allowUserRegistration')) : ?>
			<li><a class="com-users-login__register list-group-item uk-link-reset" href="<?php echo Route::_('index.php?option=com_users&view=registration'); ?>">
				<?php echo Text::_('COM_USERS_LOGIN_REGISTER'); ?>
			</a></li>
		<?php endif; ?>
	</ul>
</div>
