<?php
/********************************************************************************
* @package		Warp Theme Framework* +, UIKit* v3
* *@copyright	Copyright (C) YOOtheme GmbH
*********************************************************************************
* @package		uiThemeBuilder
* @subpackage	html
* @modified		Stephan W.
* @copyright	https://www.ui-themebuilder.com/
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*********************************************************************************/
// No direct access
defined('_JEXEC') or die;


use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Tags\Site\Helper\RouteHelper;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('com_tags.tags-default');

if (($this->params->def('show_pagination', 2) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) :
$doc = Factory::getDocument();
$doc->setTitle( $doc->getTitle() . ' '. Text::sprintf('JLIB_HTML_PAGE_CURRENT_OF_TOTAL', $this->pagination->pagesCurrent, $this->pagination->pagesTotal) );
$doc->setDescription($doc->getMetaData('description') . ' '. Text::sprintf('JLIB_HTML_PAGE_CURRENT_OF_TOTAL', $this->pagination->pagesCurrent, $this->pagination->pagesTotal) );
endif;

// Get the user object.
$user  = Factory::getApplication()->getIdentity();

// Check if user is allowed to add/edit based on tags permissions.
$canEdit      = $user->authorise('core.edit', 'com_tags');
$canCreate    = $user->authorise('core.create', 'com_tags');
$canEditState = $user->authorise('core.edit.state', 'com_tags');

$columns = $this->params->get('tag_columns', 1);

// Avoid division by 0 and negative columns.
if ($columns < 1)
{
	$columns = 1;
}

if ($columns >= 6)
{
	$columns = 6;
}

$bsspans = floor(6 / $columns);

if ($bsspans < 1)
{
	$bsspans = 1;
}

$bscolumns = min($columns, floor(6 / $bsspans));
$n         = count($this->items); ?>

<div class="com-tags__items">
	<?php if ($this->params->get('filter_field') || $this->params->get('show_pagination_limit')) : ?>
		<form class="uk-form uk-margin-large-bottom uk-clearfix" action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post" name="adminForm" id="adminForm">
			<?php if ($this->params->get('show_pagination_limit')) : ?>
				<div class="uk-float-right uk-flex uk-flex-middle">
					<div uk-form-custom="target: > * > span:first-child">
						<?php echo $this->pagination->getLimitBox(); ?>
						<button class="uk-button uk-button-default" type="button" tabindex="-1">
							<span></span>
							<span uk-icon="icon: chevron-down"></span>
						</button>
					</div>
				</div>
			<?php endif; ?>

			<?php if ($this->params->get('filter_field')) : ?>
				<div class="com-tags-tags__filter uk-float-left">
					<input
						type="text"
						name="filter-search"
						id="filter-search"
						value="<?php echo $this->escape($this->state->get('list.filter')); ?>"
						class="uk-input uk-form-width-medium" onchange="document.adminForm.submit();"
						placeholder="<?php echo Text::_('COM_TAGS_TITLE_FILTER_LABEL'); ?>"
					>
					<span class="uk-button-group">
						<button type="submit" name="filter_submit" class="uk-button uk-button-primary"><?php echo Text::_('JGLOBAL_FILTER_BUTTON'); ?></button>
						<button type="reset" name="filter-clear-button" class="uk-button uk-button-secondary"><?php echo Text::_('JSEARCH_FILTER_CLEAR'); ?></button>
					</span>
				</div>
			<?php endif; ?>

			<input type="hidden" name="limitstart" value="">
			<input type="hidden" name="task" value="">
		</form>
	<?php endif; ?>

	<?php if ($this->items == false || $n === 0) : ?>
		<div class="uk-alert-warning" uk-alert>
			<a class="uk-alert-close" uk-close></a>
			<h3><?php echo Text::_('INFO'); ?></h3>
			<p><?php echo Text::_('COM_TAGS_NO_TAGS'); ?></p>
		</div>
	<?php else : ?>
		<?php // if ($n === 1 || $i === 0 || $bscolumns === 1 || $i % $bscolumns === 0) : ?>
			<ul class="com-tags__category category uk-child-width-1-2@s uk-child-width-1-<?php echo $bscolumns; ?>@m uk-margin-large-bottom" uk-grid="masonry: true">
		<?php // endif; ?>
			<?php foreach ($this->items as $i => $item) : ?>


			<li class="list-group-item list-group-item-action">
				<?php // withimage ?>
				<?php if ($this->params->get('all_tags_show_tag_image') && !empty($images->image_intro)) : ?>
				<div class="uk-card uk-card-default">
					<?php if ($this->params->get('all_tags_show_tag_image') && !empty($item->images)) : ?>
						<?php $images = json_decode($item->images); ?>
						<?php $imgfloat = empty($images->float_intro) ? $this->params->get('float_intro') : $images->float_intro; ?>
						<div class="uk-card-media-<?php echo htmlspecialchars($imgfloat); ?> uk-cover-container">
							<img src="<?php echo $images->image_intro; ?>" alt="" uk-cover>
							<canvas width="600" height="400"></canvas>
						</div>
					<?php endif; ?>
					<div>
						<div class="uk-card-body">
							<?php if ($this->params->get('all_tags_show_tag_hits')) : ?>
								<span class="uk-card-badge uk-label">
									<?php echo Text::sprintf('JGLOBAL_HITS_COUNT', $item->hits); ?>
								</span>
							<?php endif; ?>
							
							<?php if ((!empty($item->access)) && in_array($item->access, $this->user->getAuthorisedViewLevels())) : ?>
								<h4 class="uk-card-title">
									<a class="tm-tags" href="<?php echo Route::_(RouteHelper::getTagRoute($item->id . ':' . $item->alias)); ?>">
										<?php echo $this->escape($item->title); ?>
									</a>
								</h4>
							<?php endif; ?>
							<?php if (($this->params->get('all_tags_show_tag_description', 1) && !empty($item->description)) || $this->params->get('all_tags_show_tag_hits')) : ?>
								<div class="caption">
									<?php if ($this->params->get('all_tags_show_tag_description', 1) && !empty($item->description)) : ?>
										<span class="tag-body">
											<?php echo HTMLHelper::_('string.truncate', $item->description, $this->params->get('all_tags_tag_maximum_characters')); ?>
										</span>
									<?php endif; ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<?php // without image ?>
				<?php else : ?>
					<?php if ((!empty($item->access)) && in_array($item->access, $this->user->getAuthorisedViewLevels())) : ?>
					<div class="uk-card uk-card-default uk-card-body">
						<h3 class="uk-card-title uk-text-truncate">
							<a class="tm-tags" href="<?php echo Route::_(RouteHelper::getTagRoute($item->id . ':' . $item->alias)); ?>">
								<?php echo $this->escape($item->title); ?>
							</a>
						</h3>
					</div>
					<?php endif; ?>

					<?php if (($this->params->get('all_tags_show_tag_description', 1) && !empty($item->description)) || $this->params->get('all_tags_show_tag_hits')) : ?>
						<div class="caption">
							<?php if ($this->params->get('all_tags_show_tag_description', 1) && !empty($item->description)) : ?>
								<span class="tag-body">
									<?php echo HTMLHelper::_('string.truncate', $item->description, $this->params->get('all_tags_tag_maximum_characters')); ?>
								</span>
							<?php endif; ?>
							<?php if ($this->params->get('all_tags_show_tag_hits')) : ?>
								<span class="list-hits badge badge-info">
									<?php echo Text::sprintf('JGLOBAL_HITS_COUNT', $item->hits); ?>
								</span>
							<?php endif; ?>
						</div>
					<?php endif; ?>
				<?php endif; ?>

			</li>
			<?php endforeach; ?>
		<?php // if (($i === 0 && $n === 1) || $i === $n - 1 || $bscolumns === 1 || (($i + 1) % $bscolumns === 0)) : ?>
			</ul>
		<?php // endif; ?>
	<?php endif; ?>

	<?php // Add pagination links ?>
	<?php if (!empty($this->items)) : ?>
		<?php if (($this->params->def('show_pagination', 2) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
			<div class="com-tags__pagination w-100 uk-grid-small" uk-grid="">
				<?php if ($this->params->def('show_pagination_results', 1)) : ?>
					<div class="uk-width-1-1">
						<p class="counter float-right pt-3 pr-2">
							<?php echo $this->pagination->getPagesCounter(); ?>
						</p>
					</div>
				<?php endif; ?>
				<div class="uk-width-1-1 uk-flex uk-flex-center">
				<?php echo $this->pagination->getPagesLinks(); ?>
				</div>
			</div>
		<?php endif; ?>
	<?php endif; ?>
</div>
